/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.po;

import com.centit.framework.core.dao.DictionaryMap;
import com.centit.framework.model.basedata.IDataCatalog;
import com.centit.framework.system.po.DataDictionary;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorTime;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.HtmlUtils;

@Entity
@Table(name="F_DATACATALOG")
@ApiModel(value="\u6570\u636e\u5b57\u5178\u7c7b\u522b\u5bf9\u8c61", description="\u6570\u636e\u5b57\u5178\u7c7b\u522b\u5bf9\u8c61DataCatalog")
public class DataCatalog
implements IDataCatalog,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="CATALOG_CODE")
    @ApiModelProperty(value="\u7c7b\u522b\u4ee3\u7801", name="catalogCode", required=true)
    @ValueGenerator(strategy=GeneratorType.UUID22)
    private String catalogCode;
    @Column(name="CATALOG_NAME")
    @Length(max=64, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u7c7b\u522b\u540d\u79f0", name="catalogName", required=true)
    private @Length(max=64, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String catalogName;
    @Column(name="CATALOG_STYLE")
    @ValueGenerator(strategy=GeneratorType.CONSTANT, occasion=GeneratorTime.NEW, value="U")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}")
    @Pattern(regexp="[SUF]", message="\u5b57\u6bb5\u53ea\u80fd\u586b\u5199F,S,U")
    @ApiModelProperty(value="\u7c7b\u522b\u72b6\u6001 \u5b57\u6bb5\u53ea\u80fd\u586b\u5199F,S,U", name="catalogStyle", required=true)
    @DictionaryMap(fieldName={"catalogStyleText"}, value={"CatalogStyle"})
    private @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}") @Pattern(regexp="[SUF]", message="\u5b57\u6bb5\u53ea\u80fd\u586b\u5199F,S,U") String catalogStyle;
    @Column(name="CATALOG_TYPE")
    @ValueGenerator(strategy=GeneratorType.CONSTANT, occasion=GeneratorTime.NEW, value="L")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}")
    @Pattern(regexp="[LT]", message="\u5b57\u6bb5\u53ea\u80fd\u586b\u5199L\u6216T")
    @ApiModelProperty(value="\u5b57\u6bb5\u53ea\u80fd\u586b\u5199L(\u5217\u8868)\u6216T(\u6811)", name="catalogType", required=true)
    @DictionaryMap(fieldName={"catalogTypeText"}, value={"CatalogType"})
    private @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}") @Pattern(regexp="[LT]", message="\u5b57\u6bb5\u53ea\u80fd\u586b\u5199L\u6216T") String catalogType;
    @Column(name="CATALOG_DESC")
    @Length(max=256, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=256, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String catalogDesc;
    @Column(name="FIELD_DESC")
    @Length(max=1024, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=1024, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String fieldDesc;
    @Column(name="NEED_CACHE")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}")
    @ValueGenerator(strategy=GeneratorType.CONSTANT, occasion=GeneratorTime.NEW, value="1")
    @ApiModelProperty(value="\u662f\u5426\u9700\u8981\u7f13\u5b58\uff0c\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u53ef\u4ee5\u9ed8\u8ba4\u8bbe\u7f6e\u4e3a1", name="needCache", required=true)
    private @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}") String needCache;
    @Column(name="OPT_ID")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @DictionaryMap(fieldName={"optName"}, value={"optId"})
    @ValueGenerator(strategy=GeneratorType.CONSTANT, occasion=GeneratorTime.NEW, value="public")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String optId;
    @Column(name="CREATE_DATE", nullable=false)
    protected Date createDate;
    @Column(name="CREATOR")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String creator;
    @Column(name="UPDATOR")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String updator;
    @Column(name="UPDATE_DATE")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, occasion=GeneratorTime.NEW_UPDATE, condition=GeneratorCondition.ALWAYS, value="today()")
    private Date updateDate;
    @Transient
    private List<DataDictionary> dataDictionaries;

    public DataCatalog(String catalogcode, String catalogname, String catalogstyle, String catalogtype, String isupload) {
        this.catalogCode = catalogcode;
        this.catalogName = catalogname;
        this.catalogStyle = catalogstyle;
        this.catalogType = catalogtype;
        this.needCache = "1";
    }

    public String getCatalogCode() {
        return this.catalogCode;
    }

    public void setCatalogCode(String catalogcode) {
        this.catalogCode = catalogcode;
    }

    public String getOptId() {
        return this.optId;
    }

    public void setOptId(String dictionarytype) {
        this.optId = dictionarytype;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogname) {
        this.catalogName = catalogname;
    }

    public String getCatalogStyle() {
        return this.catalogStyle;
    }

    public void setCatalogStyle(String catalogstyle) {
        this.catalogStyle = catalogstyle;
    }

    public String getCatalogType() {
        return this.catalogType;
    }

    public void setCatalogType(String catalogtype) {
        this.catalogType = catalogtype;
    }

    public String getCatalogDesc() {
        return this.catalogDesc;
    }

    public void setCatalogDesc(String catalogdesc) {
        this.catalogDesc = catalogdesc;
    }

    public String getFieldDesc() {
        return this.fieldDesc;
    }

    public void setFieldDesc(String fielddesc) {
        if (StringUtils.isNotBlank((CharSequence)fielddesc)) {
            fielddesc = HtmlUtils.htmlUnescape((String)fielddesc);
        }
        this.fieldDesc = fielddesc;
    }

    public void setIsUpload(String isupload) {
    }

    public String getNeedCache() {
        return this.needCache;
    }

    public void setNeedCache(String needCache) {
        this.needCache = needCache;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getUpdator() {
        return this.updator;
    }

    public void setUpdator(String updator) {
        this.updator = updator;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Date getLastModifyDate() {
        return this.updateDate;
    }

    public void setLastModifyDate(Date lastModifyDate) {
        this.updateDate = lastModifyDate;
    }

    public void addAllDataPiece(List<DataDictionary> dataDictionaries) {
        this.getDataDictionaries().clear();
        if (CollectionUtils.isEmpty(dataDictionaries)) {
            return;
        }
        for (DataDictionary dataDictionary : dataDictionaries) {
            dataDictionary.setCatalogCode(this.catalogCode);
            this.getDataDictionaries().add(dataDictionary);
        }
    }

    public List<DataDictionary> getDataDictionaries() {
        if (null == this.dataDictionaries) {
            this.dataDictionaries = new ArrayList<DataDictionary>();
        }
        return this.dataDictionaries;
    }

    public void setDataDictionaries(List<DataDictionary> dataDictionaries) {
        this.dataDictionaries = dataDictionaries;
    }

    public DataCatalog() {
    }
}

