/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.po;

import com.centit.framework.core.dao.DictionaryMap;
import com.centit.framework.model.basedata.IRoleInfo;
import com.centit.framework.model.basedata.IUserRole;
import com.centit.framework.system.po.RolePower;
import com.centit.framework.system.po.UserRoleId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.validator.constraints.Length;
import org.springframework.util.CollectionUtils;

@Entity
@Table(name="F_V_USERROLES")
public class FVUserRoles
implements IUserRole,
IRoleInfo,
Serializable {
    private static final long serialVersionUID = -7725372179862779056L;
    @EmbeddedId
    private UserRoleId id;
    @Column(name="ROLE_NAME")
    private String roleName;
    @Column(name="OBTAIN_TYPE")
    private String obtainType = "D";
    @Column(name="INHERITED_FROM")
    @DictionaryMap(fieldName={"inheritedFromText"}, value={"unitCode"})
    private String inheritedFrom;
    @Column(name="IS_VALID")
    private String isValid;
    @Column(name="ROLE_DESC")
    private String roleDesc;
    @Column(name="ROLE_TYPE")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}")
    private @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}") String roleType;
    @Column(name="UNIT_CODE")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String unitCode;
    @Transient
    private List<RolePower> rolePowers;

    public FVUserRoles() {
    }

    public FVUserRoles(String userCode, String roleCode) {
        this.id = new UserRoleId(userCode, roleCode);
    }

    public UserRoleId getId() {
        return this.id;
    }

    public void setId(UserRoleId id) {
        this.id = id;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getIsValid() {
        return this.isValid;
    }

    public void setIsValid(String isvalid) {
        this.isValid = isvalid;
    }

    public String getRoleDesc() {
        return this.roleDesc;
    }

    public void setRoleDesc(String roleDesc) {
        this.roleDesc = roleDesc;
    }

    public void setUserCode(String userCode) {
        if (null == this.id) {
            this.id = new UserRoleId();
        }
        this.id.setUserCode(userCode);
    }

    public void setRoleCode(String roleCode) {
        if (null == this.id) {
            this.id = new UserRoleId();
        }
        this.id.setRoleCode(roleCode);
    }

    public String getUserCode() {
        if (null == this.id) {
            return null;
        }
        return this.id.getUserCode();
    }

    public String getRoleCode() {
        if (null == this.id) {
            return null;
        }
        return this.id.getRoleCode();
    }

    public String getObtainType() {
        return this.obtainType;
    }

    public void setObtainType(String obtainType) {
        this.obtainType = obtainType;
    }

    public String getInheritedFrom() {
        return this.inheritedFrom;
    }

    public void setInheritedFrom(String inheritedFrom) {
        this.inheritedFrom = inheritedFrom;
    }

    public String getRoleType() {
        return this.roleType;
    }

    public void setRoleType(String roleType) {
        this.roleType = roleType;
    }

    public String getUnitCode() {
        return this.unitCode;
    }

    public String getRoleOwner() {
        return this.unitCode;
    }

    public void setUnitCode(String unitCode) {
        this.unitCode = unitCode;
    }

    public List<RolePower> getRolePowers() {
        if (null == this.rolePowers) {
            this.rolePowers = new ArrayList<RolePower>();
        }
        return this.rolePowers;
    }

    public void setRolePowers(List<RolePower> rolePowers) {
        this.rolePowers = rolePowers;
    }

    public void addAllRolePowers(List<RolePower> rolePowers) {
        this.getRolePowers().clear();
        if (CollectionUtils.isEmpty(rolePowers)) {
            return;
        }
        this.getRolePowers().addAll(rolePowers);
    }
}

