/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.po;

import com.alibaba.fastjson.annotation.JSONField;
import com.centit.framework.core.dao.DictionaryMap;
import com.centit.framework.model.basedata.IUnitInfo;
import com.centit.framework.system.po.UserUnit;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorTime;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.Range;

@Entity
@Table(name="F_UNITINFO")
@ApiModel(value="\u7cfb\u7edf\u673a\u6784\u4fe1\u606f\u5bf9\u8c61", description="\u7cfb\u7edf\u673a\u6784\u4fe1\u606f\u5bf9\u8c61 UnitInfo")
public class UnitInfo
implements IUnitInfo,
Serializable {
    private static final long serialVersionUID = -2538006375160615889L;
    @Id
    @Column(name="UNIT_CODE")
    @ValueGenerator(strategy=GeneratorType.RANDOM_ID, value="7:D")
    @ApiModelProperty(value="\u673a\u6784\u4ee3\u7801", name="unitCode")
    private String unitCode;
    @Column(name="PARENT_UNIT")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @DictionaryMap(fieldName={"parentUnitName"}, value={"unitCode"})
    @ApiModelProperty(value="\u4e0a\u7ea7\u673a\u6784\u4ee3\u7801", name="parentUnit")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String parentUnit;
    @Column(name="UNIT_TYPE")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}")
    @DictionaryMap(fieldName={"unitTypeText"}, value={"UnitType"})
    @ApiModelProperty(value="\u673a\u6784\u7c7b\u522b", name="unitType")
    private @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}") String unitType;
    @Column(name="IS_VALID")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Pattern(regexp="[TFA]", message="\u5b57\u6bb5\u503c\u5fc5\u987b\u662fT\u6216F,A\u4e3a\u65b0\u5efa\u53ef\u4ee5\u5220\u9664")
    @ApiModelProperty(value="\u662f\u5426\u751f\u6548 T:\u751f\u6548 F:\u5931\u6548 A:\u65b0\u5efa\u53ef\u4ee5\u5220\u9664", name="isValid", required=true)
    private @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a") @Pattern(regexp="[TFA]", message="\u5b57\u6bb5\u503c\u5fc5\u987b\u662fT\u6216F,A\u4e3a\u65b0\u5efa\u53ef\u4ee5\u5220\u9664") String isValid;
    @Column(name="UNIT_NAME")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=300, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u673a\u6784\u540d\u79f0", name="unitName", required=true)
    private @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a") @Length(max=300, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String unitName;
    @Column(name="ENGLISH_NAME")
    @Length(max=300, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u673a\u6784\u82f1\u6587\u540d\u79f0", name="englishName", required=true)
    private @Length(max=300, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String englishName;
    @Column(name="UNIT_SHORT_NAME")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String unitShortName;
    @Column(name="UNIT_WORD")
    @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u673a\u6784\u81ea\u5b9a\u4e49\u7f16\u7801", name="unitWord")
    private @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String unitWord;
    @Column(name="UNIT_TAG")
    @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String unitTag;
    @Column(name="UNIT_DESC")
    @Length(max=256, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u673a\u6784\u63cf\u8ff0", name="unitDesc")
    private @Length(max=256, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String unitDesc;
    @Column(name="UNIT_ORDER")
    @Range(max=9999L, min=1L, message="\u6392\u5e8f\u53f7\u4e0d\u80fd\u5927\u4e8e{max}\u6216\u5c0f\u4e8e{min}")
    @OrderBy
    private @Range(max=9999L, min=1L, message="\u6392\u5e8f\u53f7\u4e0d\u80fd\u5927\u4e8e{max}\u6216\u5c0f\u4e8e{min}") Long unitOrder;
    @Column(name="UNIT_GRADE")
    @Range(max=9999L, message="\u7b49\u7ea7\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Range(max=9999L, message="\u7b49\u7ea7\u4e0d\u80fd\u5927\u4e8e{max}") Long unitGrade;
    @Column(name="DEP_NO")
    @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String depNo;
    @Column(name="UNIT_PATH")
    @Length(max=1000, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=1000, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String unitPath;
    @Transient
    private String state;
    @Column(name="UNIT_MANAGER")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String unitManager;
    @Column(name="CREATE_DATE", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @ValueGenerator(strategy=GeneratorType.FUNCTION, value="today()")
    protected Date createDate;
    @Column(name="CREATOR")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String creator;
    @Column(name="UPDATOR")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String updator;
    @Column(name="UPDATE_DATE")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, occasion=GeneratorTime.NEW_UPDATE, condition=GeneratorCondition.ALWAYS, value="today()")
    private Date updateDate;
    @Transient
    private List<UserUnit> unitUsers;
    @Transient
    private List<UnitInfo> subUnits;

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getUnitManager() {
        return this.unitManager;
    }

    public void setUnitManager(String unitManager) {
        this.unitManager = unitManager;
    }

    public UnitInfo() {
        this.unitUsers = null;
    }

    public UnitInfo(String unitcode, String unitstate, String unitname) {
        this.unitCode = unitcode;
        this.isValid = unitstate;
        this.unitName = unitname;
        this.unitUsers = null;
    }

    public UnitInfo(String unitcode, String parentunit, String unittype, String isvalid, String unitname, String unitshortname, String unitword, String unitdesc, Long grade, Long unitorder, String depno, Date createDate, Date lastModifyDate) {
        this.unitCode = unitcode;
        this.parentUnit = parentunit;
        this.unitType = unittype;
        this.isValid = isvalid;
        this.unitName = unitname;
        this.unitShortName = unitshortname;
        this.unitWord = unitword;
        this.unitDesc = unitdesc;
        this.unitGrade = grade;
        this.unitOrder = unitorder;
        this.depNo = depno;
    }

    public UnitInfo(String unitcode, String parentunit, String unittype, String unitstate, String unitname, String unitdesc, String unitshortname, String depno, String unittag, String englishname, String unitword, Long unitgrade) {
        this.unitCode = unitcode;
        this.parentUnit = parentunit;
        this.unitType = unittype;
        this.isValid = unitstate;
        this.unitName = unitname;
        this.unitDesc = unitdesc;
        this.unitShortName = unitshortname;
        this.depNo = depno;
        this.unitWord = unitword;
        this.unitGrade = unitgrade;
        this.unitTag = unittag;
        this.englishName = englishname;
        this.unitUsers = null;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public void setEnglishName(String englishName) {
        this.englishName = englishName;
    }

    public String getUnitTag() {
        return this.unitTag;
    }

    public void setUnitTag(String unitTag) {
        this.unitTag = unitTag;
    }

    public String getUnitCode() {
        return this.unitCode;
    }

    public void setUnitCode(String unitcode) {
        this.unitCode = unitcode;
    }

    public String getUnitShortName() {
        return this.unitShortName;
    }

    public void setUnitShortName(String unitshortname) {
        this.unitShortName = unitshortname;
    }

    public String getParentUnit() {
        return this.parentUnit;
    }

    public void setParentUnit(String parentunit) {
        this.parentUnit = parentunit;
    }

    public String getUnitType() {
        return this.unitType;
    }

    public void setUnitType(String unittype) {
        this.unitType = unittype;
    }

    public String getIsValid() {
        return this.isValid;
    }

    public void setIsValid(String unitstate) {
        this.isValid = unitstate;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public String toString() {
        return this.unitName;
    }

    public void setUnitName(String unitname) {
        this.unitName = unitname;
    }

    public String getUnitDesc() {
        return this.unitDesc;
    }

    public void setUnitDesc(String unitdesc) {
        this.unitDesc = unitdesc;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getLastModifyDate() {
        return this.updateDate;
    }

    public void setLastModifyDate(Date lastModifyDate) {
        this.updateDate = lastModifyDate;
    }

    public Long getUnitOrder() {
        return this.unitOrder;
    }

    public void setUnitOrder(Long unitorder) {
        this.unitOrder = unitorder;
    }

    public String getUnitWord() {
        return this.unitWord;
    }

    public void setUnitWord(String unitWord) {
        this.unitWord = unitWord;
    }

    public Long getUnitGrade() {
        return this.unitGrade;
    }

    public void setUnitGrade(Long unitGrade) {
        this.unitGrade = unitGrade;
    }

    public String getDepNo() {
        return this.depNo;
    }

    public void setDepNo(String depNo) {
        this.depNo = depNo;
    }

    @JSONField(name="children")
    public List<UnitInfo> getSubUnits() {
        if (this.subUnits == null) {
            this.subUnits = new ArrayList<UnitInfo>();
        }
        return this.subUnits;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getUpdator() {
        return this.updator;
    }

    public void setUpdator(String updator) {
        this.updator = updator;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getUnitPath() {
        return this.unitPath;
    }

    public void setUnitPath(String unitPath) {
        this.unitPath = unitPath;
    }
}

