/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.security;

import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.security.model.CentitUserDetailsService;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.framework.system.dao.UserRoleDao;
import com.centit.framework.system.dao.UserSettingDao;
import com.centit.framework.system.po.FVUserRoles;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserSetting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.transaction.annotation.Transactional;

public class DaoUserDetailsService
implements CentitUserDetailsService,
UserDetailsService,
AuthenticationUserDetailsService<Authentication> {
    @Autowired
    @NotNull
    private PlatformEnvironment platformEnvironment;
    @Autowired
    @NotNull
    private UserSettingDao userSettingDao;
    @Autowired
    @NotNull
    private UserRoleDao userRoleDao;
    @Autowired
    @NotNull
    private UserInfoDao userInfoDao;

    @Transactional
    public Collection<GrantedAuthority> loadUserAuthorities(String loginName) throws UsernameNotFoundException {
        UserInfo userinfo = this.userInfoDao.getUserByLoginName(loginName);
        if (userinfo == null) {
            return null;
        }
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>(10);
        authorities.add((GrantedAuthority)new SimpleGrantedAuthority("R_public"));
        List<FVUserRoles> userRoles = this.userRoleDao.listUserRolesByUserCode(userinfo.getUserCode());
        if (userRoles != null) {
            for (FVUserRoles userRole : userRoles) {
                authorities.add((GrantedAuthority)new SimpleGrantedAuthority("R_" + StringUtils.trim((String)userRole.getRoleCode())));
            }
        }
        Collections.sort(authorities, Comparator.comparing(GrantedAuthority::getAuthority));
        return authorities;
    }

    public CentitUserDetails loadUserByUsername(String loginname) throws UsernameNotFoundException {
        CentitUserDetails ud = this.platformEnvironment.loadUserDetailsByLoginName(loginname);
        if (ud == null) {
            throw new UsernameNotFoundException("\u767b\u5f55\u540d\u4e3a" + loginname + "\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        return ud;
    }

    public CentitUserDetails loadDetailsByLoginName(String loginname) {
        return this.loadUserByUsername(loginname);
    }

    public CentitUserDetails loadUserDetails(Authentication token) throws UsernameNotFoundException {
        return this.loadUserByUsername(token.getName());
    }

    @Transactional
    public void saveUserSetting(String userCode, String paramCode, String paramValue, String paramClass, String paramName) {
        this.userSettingDao.saveNewUserSetting(new UserSetting(userCode, paramCode, paramValue, paramClass, paramName));
    }

    @Transactional
    public CentitUserDetails loadDetailsByUserCode(String userCode) {
        return this.platformEnvironment.loadUserDetailsByUserCode(userCode);
    }

    @Transactional
    public CentitUserDetails loadDetailsByRegEmail(String regEmail) {
        return this.platformEnvironment.loadUserDetailsByRegEmail(regEmail);
    }

    @Transactional
    public CentitUserDetails loadDetailsByRegCellPhone(String regCellPhone) {
        return this.platformEnvironment.loadUserDetailsByRegCellPhone(regCellPhone);
    }
}

