/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.system.dao.OptInfoDao;
import com.centit.framework.system.dao.OptMethodDao;
import com.centit.framework.system.dao.RoleInfoDao;
import com.centit.framework.system.dao.RolePowerDao;
import com.centit.framework.system.dao.UserRoleDao;
import com.centit.framework.system.po.OptMethod;
import com.centit.framework.system.po.OptMethodUrlMap;
import com.centit.framework.system.po.RoleInfo;
import com.centit.framework.system.po.RolePower;
import com.centit.framework.system.po.RolePowerId;
import com.centit.framework.system.service.SysRoleManager;
import com.centit.framework.system.service.impl.PersistenceUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.database.utils.PageDesc;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysRoleManager")
public class SysRoleManagerImpl
implements SysRoleManager {
    public static Logger logger = LoggerFactory.getLogger(SysRoleManagerImpl.class);
    @Autowired
    @NotNull
    private OptInfoDao optInfoDao;
    @Autowired
    @NotNull
    private OptMethodDao optMethodDao;
    @Autowired
    @NotNull
    private RolePowerDao rolePowerDao;
    @Autowired
    @NotNull
    protected RoleInfoDao roleInfoDao;
    @Autowired
    @NotNull
    private UserRoleDao userRoleDao;
    @Value(value="${framework.roleinfo.id.generator:}")
    protected String roleIdFormat;

    @Override
    @Transactional
    public List<RolePower> getRolePowers(String rolecode) {
        return this.rolePowerDao.listRolePowersByRoleCode(rolecode);
    }

    @Override
    @Transactional
    public List<RolePower> getRolePowersByDefCode(String optCode) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("optCode", optCode);
        return this.rolePowerDao.listObjects(filterMap);
    }

    @Override
    @Transactional
    public Serializable saveNewRoleInfo(RoleInfo o) {
        if (StringUtils.isBlank((CharSequence)o.getRoleCode()) && !"default".equals(this.roleIdFormat)) {
            String roleCode = PersistenceUtils.makeIdByFormat(this.roleInfoDao.getNextKey(), this.roleIdFormat, "R", 8, "0");
            o.setRoleCode(roleCode);
        }
        this.roleInfoDao.saveNewObject(o);
        CodeRepositoryCache.evictCache((String)"RoleInfo");
        return o.getRoleCode();
    }

    @Override
    @Transactional
    public List<RolePower> listAllRolePowers() {
        return this.rolePowerDao.listObjectsAll();
    }

    @Override
    @Transactional
    public List<OptMethod> listAllOptMethods() {
        return this.optMethodDao.listObjectsAll();
    }

    private List<OptMethodUrlMap> listAllOptMethodUrlMap() {
        return this.optInfoDao.listAllOptMethodUrlMap();
    }

    @Override
    @Transactional
    public void updateRoleInfo(RoleInfo o) {
        this.roleInfoDao.updateRole(o);
        CodeRepositoryCache.evictCache((String)"RoleInfo");
        CodeRepositoryCache.evictCache((String)"RolePower");
    }

    @Override
    @Transactional
    public List<RolePower> updateRolePower(RoleInfo o) {
        this.roleInfoDao.updateRole(o);
        List<RolePower> newRPs = o.getRolePowers();
        List<RolePower> rps = this.rolePowerDao.listRolePowersByRoleCode(o.getRoleCode());
        if (newRPs == null || newRPs.size() < 1) {
            this.rolePowerDao.deleteRolePowersByRoleCode(o.getRoleCode());
            return rps;
        }
        for (RolePower rp : newRPs) {
            rp.setRoleCode(o.getRoleCode());
        }
        Triple forUpdate = CollectionsOpt.compareTwoList(rps, newRPs, Comparator.comparing(RolePower::getOptCode));
        if (forUpdate.getRight() != null) {
            for (RolePower rp : (List)forUpdate.getRight()) {
                this.rolePowerDao.deleteObjectById(new RolePowerId(rp.getRoleCode(), rp.getOptCode()));
                if (!rp.getRoleCode().startsWith("G$")) continue;
                String optCode = rp.getOptCode();
                String unitCode = rp.getRoleCode().substring(2);
                List roleInfos = this.roleInfoDao.listObjects(CollectionsOpt.createHashMap((Object[])new Object[]{"unitCode", unitCode, "roleType", "D"}));
                for (RoleInfo roleInfo : roleInfos) {
                    this.rolePowerDao.deleteObjectById(new RolePowerId(roleInfo.getRoleCode(), optCode));
                }
            }
        }
        if (forUpdate.getLeft() != null) {
            for (RolePower rp : (List)forUpdate.getLeft()) {
                this.rolePowerDao.saveNewRolePower(rp);
            }
        }
        if (forUpdate.getMiddle() != null) {
            for (RolePower rp : (List)forUpdate.getMiddle()) {
                RolePower oldRolePower = (RolePower)rp.getLeft();
                RolePower newRolePower = (RolePower)rp.getRight();
                if (StringUtils.equals((CharSequence)oldRolePower.getOptScopeCodes(), (CharSequence)newRolePower.getOptScopeCodes())) continue;
                this.rolePowerDao.updateObject(CollectionsOpt.createList((Object[])new String[]{"optScopeCodes", "updator", "updateDate"}), newRolePower);
            }
        }
        CodeRepositoryCache.evictCache((String)"RoleInfo");
        CodeRepositoryCache.evictCache((String)"RolePower");
        return rps;
    }

    @Override
    @Transactional
    public void deleteRoleInfo(String roleCode) {
        this.rolePowerDao.deleteRolePowersByRoleCode(roleCode);
        this.roleInfoDao.deleteObjectById(roleCode);
        CodeRepositoryCache.evictCache((String)"RoleInfo");
    }

    @Override
    @Transactional
    public RoleInfo getRoleInfo(String roleCode) {
        RoleInfo rf = this.roleInfoDao.getObjectById(roleCode);
        rf.addAllRolePowers(this.rolePowerDao.listRolePowersByRoleCode(roleCode));
        return rf;
    }

    @Override
    @Transactional
    public List<RoleInfo> listObjects(Map<String, Object> filterMap) {
        return this.roleInfoDao.listObjects(filterMap);
    }

    @Override
    @Transactional
    public List<RoleInfo> listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.roleInfoDao.listObjects(filterMap, pageDesc);
    }

    @Override
    @Transactional
    public RoleInfo getObjectById(String roleCode) {
        return this.roleInfoDao.getObjectById(roleCode);
    }

    @Override
    @Transactional
    public int countRoleUserSum(String roleCode) {
        return this.userRoleDao.countObject(CollectionsOpt.createHashMap((Object[])new Object[]{"roleCode", roleCode}));
    }

    @Override
    @Transactional
    public boolean judgeSysRoleNameCanBeUsed(String roleName, String roleCode, String unitCode) {
        HashMap<String, String> filterMap = new HashMap<String, String>(4);
        if (unitCode == null) {
            filterMap.put("NP_ALL", "true");
        } else {
            filterMap.put("NP_OWNER", "D/S");
            filterMap.put("unitCode", unitCode);
        }
        filterMap.put("roleNameEq", roleName);
        List roleInfos = this.roleInfoDao.listObjects(filterMap);
        return roleInfos == null || roleInfos.size() == 0 || StringUtils.equals((CharSequence)roleCode, (CharSequence)((RoleInfo)roleInfos.get(0)).getRoleCode());
    }
}

