/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.model.basedata.IDataDictionary;
import com.centit.framework.system.dao.RoleInfoDao;
import com.centit.framework.system.dao.UnitInfoDao;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.framework.system.dao.UserRoleDao;
import com.centit.framework.system.dao.UserUnitDao;
import com.centit.framework.system.po.FVUserRoles;
import com.centit.framework.system.po.RoleInfo;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserRole;
import com.centit.framework.system.po.UserRoleId;
import com.centit.framework.system.po.UserUnit;
import com.centit.framework.system.service.SysUserUnitManager;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.database.utils.PageDesc;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysUserUnitManager")
@Transactional
public class SysUserUnitManagerImpl
implements SysUserUnitManager {
    public static final Logger logger = LoggerFactory.getLogger(SysUserUnitManagerImpl.class);
    @Autowired
    @NotNull
    protected UserUnitDao userUnitDao;
    @Autowired
    private UnitInfoDao unitInfoDao;
    @Autowired
    @NotNull
    private UserInfoDao userInfoDao;
    @Autowired
    private UserRoleDao userRoleDao;
    @Autowired
    private RoleInfoDao roleInfoDao;

    @Override
    @Transactional(readOnly=true)
    public List<UserUnit> listObjectByUserUnit(String userCode, String unitCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userCode", userCode);
        map.put("unitCode", unitCode);
        List<UserUnit> userUnits = this.userUnitDao.listObjectByUserUnit(userCode, unitCode);
        if (userUnits != null) {
            for (UserUnit uu : userUnits) {
                IDataDictionary dd;
                if (null == uu || (dd = CodeRepositoryUtil.getDataPiece((String)"RankType", (String)uu.getUserRank())) == null || dd.getExtraCode() == null || !StringRegularOpt.isNumber((String)dd.getExtraCode())) continue;
                try {
                    uu.setXzRank(Integer.valueOf(dd.getExtraCode()));
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    uu.setXzRank(100000);
                }
            }
        }
        return userUnits;
    }

    private static boolean isMultiToMulti() {
        IDataDictionary agencyMode = CodeRepositoryUtil.getDataPiece((String)"SYSPARAM", (String)"userUnitMode");
        if (agencyMode != null) {
            return "M".equalsIgnoreCase(agencyMode.getDataValue());
        }
        return true;
    }

    private void addUserRoleWhenNotExist(String userCode, String roleCodeOrName, List<FVUserRoles> userRoles) {
        if (StringUtils.isNotBlank((CharSequence)roleCodeOrName)) {
            RoleInfo roleInfo;
            boolean hasRole = false;
            for (FVUserRoles userRole : userRoles) {
                if (!userRole.getRoleCode().equals(roleCodeOrName) && (!"G".equals(userRole.getRoleType()) && !"P".equals(userRole.getRoleType()) || !userRole.getRoleName().equals(roleCodeOrName))) continue;
                hasRole = true;
            }
            if (!hasRole && (roleInfo = this.roleInfoDao.getRoleByCodeOrName(roleCodeOrName)) != null) {
                UserRole newUserRole = new UserRole(new UserRoleId(userCode, roleInfo.getRoleCode()), DatetimeOpt.currentUtilDate(), "\u6839\u636e\u7528\u6237\u5c97\u4f4d\u81ea\u52a8\u6388\u4e88");
                this.userRoleDao.saveNewObject(newUserRole);
                FVUserRoles fvUserRoles = new FVUserRoles(userCode, roleInfo.getRoleCode());
                fvUserRoles.setRoleName(roleInfo.getRoleName());
                fvUserRoles.setRoleType(roleInfo.getRoleType());
                userRoles.add(fvUserRoles);
            }
        }
    }

    @Override
    public String saveNewUserUnit(UserUnit userunit) {
        UserUnit pUserUnit;
        if (!SysUserUnitManagerImpl.isMultiToMulti() && null != (pUserUnit = this.userUnitDao.getPrimaryUnitByUserId(userunit.getUserCode()))) {
            this.userUnitDao.deleteObjectById(pUserUnit.getUserUnitId());
        }
        if (StringBaseOpt.isNvl((String)userunit.getUserUnitId())) {
            userunit.setUserUnitId(this.userUnitDao.getNextKey());
        }
        if ("T".equals(userunit.getIsPrimary())) {
            UserInfo user;
            UserUnit origPrimUnit = this.userUnitDao.getPrimaryUnitByUserId(userunit.getUserCode());
            if (origPrimUnit != null) {
                origPrimUnit.setIsPrimary("F");
                this.userUnitDao.updateUserUnit(origPrimUnit);
            }
            if ((user = this.userInfoDao.getUserByCode(userunit.getUserCode())) != null) {
                user.setPrimaryUnit(userunit.getUnitCode());
                this.userInfoDao.updateUser(user);
            }
        }
        this.userUnitDao.saveNewObject(userunit);
        List<FVUserRoles> userRoles = this.userRoleDao.listUserRolesByUserCode(userunit.getUserCode());
        IDataDictionary dd = CodeRepositoryUtil.getDataPiece((String)"StationType", (String)userunit.getUserStation());
        this.addUserRoleWhenNotExist(userunit.getUserCode(), dd.getExtraCode2(), userRoles);
        dd = CodeRepositoryUtil.getDataPiece((String)"RankType", (String)userunit.getUserRank());
        this.addUserRoleWhenNotExist(userunit.getUserCode(), dd.getExtraCode2(), userRoles);
        CodeRepositoryCache.evictCache((String)"UserUnit");
        return userunit.getUserUnitId();
    }

    @Override
    public UserUnit getPrimaryUnitByUserCode(String userCode) {
        return this.userUnitDao.getPrimaryUnitByUserId(userCode);
    }

    @Override
    public boolean hasUserStation(String stationCode, String userCode) {
        HashMap<String, String> filterDesc = new HashMap<String, String>();
        filterDesc.put("userStation", stationCode);
        filterDesc.put("userCode", userCode);
        return this.userUnitDao.countObject(filterDesc) > 0;
    }

    @Override
    public void updateUserUnit(UserUnit userunit) {
        if ("T".equals(userunit.getIsPrimary())) {
            UserInfo user;
            UserUnit origPrimUnit = this.userUnitDao.getPrimaryUnitByUserId(userunit.getUserCode());
            if (origPrimUnit != null && !origPrimUnit.getUserUnitId().equals(userunit.getUserUnitId())) {
                origPrimUnit.setIsPrimary("F");
                userunit.setIsPrimary("T");
                this.userUnitDao.updateUserUnit(origPrimUnit);
            }
            if ((user = this.userInfoDao.getUserByCode(userunit.getUserCode())) != null) {
                user.setPrimaryUnit(userunit.getUnitCode());
                this.userInfoDao.updateUser(user);
            }
        }
        this.userUnitDao.updateUserUnit(userunit);
        CodeRepositoryCache.evictCache((String)"UserUnit");
    }

    @Override
    public UserUnit getObjectById(String userUnitId) {
        return this.userUnitDao.getObjectById(userUnitId);
    }

    @Override
    public void deleteObject(UserUnit userUnit) {
        this.userUnitDao.deleteObject(userUnit);
    }

    @Override
    public List<UserUnit> listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.userUnitDao.listObjects(filterMap, pageDesc);
    }

    @Override
    @Transactional
    public List<UserUnit> listUnitUsersByUnitCode(String unitCode) {
        return this.userUnitDao.listUnitUsersByUnitCode(unitCode);
    }

    @Override
    @Transactional
    public List<UserUnit> listUserUnitssByUserCode(String userCode) {
        return this.userUnitDao.listUserUnitsByUserCode(userCode);
    }

    @Override
    @Transactional
    public void deletePrimaryUnitByUserCode(String userCode) {
        if (this.userUnitDao.getPrimaryUnitByUserId(userCode) != null) {
            this.userUnitDao.deleteObject(this.userUnitDao.getPrimaryUnitByUserId(userCode));
        }
    }

    @Override
    @Transactional
    public List<UserUnit> listSubUsersByUnitCode(String unitCode, Map<String, Object> map, PageDesc pageDesc) {
        UnitInfo unitInfo = this.unitInfoDao.getObjectById(unitCode);
        if (unitInfo != null) {
            map.put("unitPath", unitInfo.getUnitPath());
            return this.userUnitDao.querySubUserUnits(map, pageDesc);
        }
        return null;
    }

    @Override
    public List<UserUnit> listUserUnitsUnderUnitByUserCode(String userCode, String unitCode, PageDesc pageDesc) {
        UnitInfo unitInfo = this.unitInfoDao.getObjectById(unitCode);
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("userCode", userCode);
        map.put("unitPath", unitInfo.getUnitPath());
        map.put("unitIsValid", "T");
        return this.userUnitDao.querySubUserUnits(map, pageDesc);
    }
}

