/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.staticsystem.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.dao.ExtendedQueryPool;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.staticsystem.po.DataCatalog;
import com.centit.framework.staticsystem.po.DataDictionary;
import com.centit.framework.staticsystem.po.OptInfo;
import com.centit.framework.staticsystem.po.OptMethod;
import com.centit.framework.staticsystem.po.RoleInfo;
import com.centit.framework.staticsystem.po.RolePower;
import com.centit.framework.staticsystem.po.UnitInfo;
import com.centit.framework.staticsystem.po.UserInfo;
import com.centit.framework.staticsystem.po.UserRole;
import com.centit.framework.staticsystem.po.UserUnit;
import com.centit.framework.staticsystem.service.impl.AbstractStaticPlatformEnvironment;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.DataSourceDescription;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.DbcpConnectPools;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentException;

public class JdbcPlatformEnvironment
extends AbstractStaticPlatformEnvironment
implements PlatformEnvironment {
    private DataSourceDescription dataSource;

    private Connection getConnection() throws SQLException {
        return DbcpConnectPools.getDbcpConnect((DataSourceDescription)this.dataSource);
    }

    public void setDataBaseConnectInfo(String connectURI, String username, String pswd) {
        this.dataSource = new DataSourceDescription(connectURI, username, pswd);
    }

    public void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        conn = null;
    }

    public void init() {
        this.reloadDictionary();
        this.reloadSecurityMetadata();
    }

    private <T> List<T> jsonArrayToObjectList(JSONArray jsonArray, Class<T> clazz) {
        if (jsonArray == null) {
            return new ArrayList();
        }
        return jsonArray.toJavaList(clazz);
    }

    public void loadConfigFromJdbc() throws SQLException, IOException, DocumentException {
        ExtendedQueryPool.loadResourceExtendedSqlMap((DBType)this.dataSource.getDbType());
        try (Connection conn = this.getConnection();){
            JSONArray userJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_USER"));
            this.userinfos = this.jsonArrayToObjectList(userJSONArray, UserInfo.class);
            JSONArray optInfoJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_OPTINFO"));
            this.optinfos = this.jsonArrayToObjectList(optInfoJSONArray, OptInfo.class);
            JSONArray optMethodsJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_OPTMETHOD"));
            this.optmethods = this.jsonArrayToObjectList(optMethodsJSONArray, OptMethod.class);
            JSONArray roleInfoJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_ROLEINFO"));
            this.roleinfos = this.jsonArrayToObjectList(roleInfoJSONArray, RoleInfo.class);
            JSONArray rolePowerJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_ROLEPOWER"));
            this.rolepowers = this.jsonArrayToObjectList(rolePowerJSONArray, RolePower.class);
            JSONArray userRoleJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_USERROLE"));
            this.userroles = this.jsonArrayToObjectList(userRoleJSONArray, UserRole.class);
            JSONArray UnitInfoJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_UNITINFO"));
            this.unitinfos = this.jsonArrayToObjectList(UnitInfoJSONArray, UnitInfo.class);
            JSONArray userUnitJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_USERUNIT"));
            this.userunits = this.jsonArrayToObjectList(userUnitJSONArray, UserUnit.class);
            JSONArray dataCatalogsJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_DATACATALOG"));
            this.datacatalogs = this.jsonArrayToObjectList(dataCatalogsJSONArray, DataCatalog.class);
            JSONArray dataDictionaryJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_DICTIONARY"));
            this.datadictionaies = this.jsonArrayToObjectList(dataDictionaryJSONArray, DataDictionary.class);
        }
    }

    public boolean reloadDictionary() {
        try {
            this.loadConfigFromJdbc();
        }
        catch (IOException | SQLException | DocumentException e) {
            this.userinfos = new ArrayList();
            this.optinfos = new ArrayList();
            this.optmethods = new ArrayList();
            this.roleinfos = new ArrayList();
            this.rolepowers = new ArrayList();
            this.userroles = new ArrayList();
            this.unitinfos = new ArrayList();
            this.userunits = new ArrayList();
            this.datacatalogs = new ArrayList();
            this.datadictionaies = new ArrayList();
            e.printStackTrace();
        }
        this.organizeDictionaryData();
        return true;
    }

    public void changeUserPassword(String userCode, String userPassword) {
        UserInfo ui = this.getUserInfoByUserCode(userCode);
        if (ui == null) {
            return;
        }
        String userNewPassword = this.passwordEncoder.createPassword(userPassword, (Object)userCode);
        try (Connection conn = this.getConnection();){
            DatabaseAccess.doExecuteSql((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"UPDATE_USER_PASSWORD"), (Object[])new Object[]{userNewPassword, userCode});
            conn.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

