/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.staticsystem.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.dao.ExtendedQueryPool;
import com.centit.framework.staticsystem.po.DataCatalog;
import com.centit.framework.staticsystem.po.DataDictionary;
import com.centit.framework.staticsystem.po.OptInfo;
import com.centit.framework.staticsystem.po.OptMethod;
import com.centit.framework.staticsystem.po.RoleInfo;
import com.centit.framework.staticsystem.po.RolePower;
import com.centit.framework.staticsystem.po.UnitInfo;
import com.centit.framework.staticsystem.po.UserInfo;
import com.centit.framework.staticsystem.po.UserRole;
import com.centit.framework.staticsystem.po.UserUnit;
import com.centit.framework.staticsystem.service.impl.AbstractStaticPlatformEnvironment;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.DataSourceDescription;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.DbcpConnectPools;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;

public class JdbcPlatformEnvironment
extends AbstractStaticPlatformEnvironment {
    private static Log logger = LogFactory.getLog(JdbcPlatformEnvironment.class);
    private DataSourceDescription dataSource;

    private Connection getConnection() throws SQLException {
        return DbcpConnectPools.getDbcpConnect((DataSourceDescription)this.dataSource);
    }

    public void setDataBaseConnectInfo(String connectURI, String username, String pswd) {
        this.dataSource = new DataSourceDescription(connectURI, username, pswd);
    }

    public void close(Connection conn) {
        DbcpConnectPools.closeConnect((Connection)conn);
    }

    private <T> List<T> jsonArrayToObjectList(JSONArray jsonArray, Class<T> clazz) {
        if (jsonArray == null) {
            return new ArrayList();
        }
        return jsonArray.toJavaList(clazz);
    }

    private void loadConfigFromJdbc() throws SQLException, IOException, DocumentException {
        ExtendedQueryPool.loadResourceExtendedSqlMap((DBType)this.dataSource.getDbType());
        try (Connection conn = this.getConnection();){
            JSONArray userJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_USER"));
            List<UserInfo> userinfos = this.jsonArrayToObjectList(userJSONArray, UserInfo.class);
            CodeRepositoryCache.userInfoRepo.setFreshtDate(userinfos);
            JSONArray optInfoJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_OPTINFO"));
            List<OptInfo> optinfos = this.jsonArrayToObjectList(optInfoJSONArray, OptInfo.class);
            CodeRepositoryCache.optInfoRepo.setFreshtDate(optinfos);
            JSONArray optMethodsJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_OPTMETHOD"));
            List<OptMethod> optmethods = this.jsonArrayToObjectList(optMethodsJSONArray, OptMethod.class);
            CodeRepositoryCache.optMethodRepo.setFreshtDate(optmethods);
            JSONArray roleInfoJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_ROLEINFO"));
            List<RoleInfo> roleinfos = this.jsonArrayToObjectList(roleInfoJSONArray, RoleInfo.class);
            CodeRepositoryCache.roleInfoRepo.setFreshtDate(roleinfos);
            JSONArray rolePowerJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_ROLEPOWER"));
            List<RolePower> rolepowers = this.jsonArrayToObjectList(rolePowerJSONArray, RolePower.class);
            CodeRepositoryCache.rolePowerRepo.setFreshtDate(rolepowers);
            JSONArray userRoleJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_USERROLE"));
            List<UserRole> userroles = this.jsonArrayToObjectList(userRoleJSONArray, UserRole.class);
            this.allUserRoleRepo.setFreshtDate(userroles);
            JSONArray UnitInfoJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_UNITINFO"));
            List<UnitInfo> unitinfos = this.jsonArrayToObjectList(UnitInfoJSONArray, UnitInfo.class);
            CodeRepositoryCache.unitInfoRepo.setFreshtDate(unitinfos);
            JSONArray userUnitJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_USERUNIT"));
            List<UserUnit> userunits = this.jsonArrayToObjectList(userUnitJSONArray, UserUnit.class);
            CodeRepositoryCache.userUnitRepo.setFreshtDate(userunits);
            JSONArray dataCatalogsJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_DATACATALOG"));
            List<DataCatalog> datacatalogs = this.jsonArrayToObjectList(dataCatalogsJSONArray, DataCatalog.class);
            CodeRepositoryCache.catalogRepo.setFreshtDate(datacatalogs);
            JSONArray dataDictionaryJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_DICTIONARY"));
            List<DataDictionary> datadictionaies = this.jsonArrayToObjectList(dataDictionaryJSONArray, DataDictionary.class);
            this.allDictionaryRepo.setFreshtDate(datadictionaies);
        }
    }

    protected synchronized void reloadPlatformData() {
        try {
            CodeRepositoryCache.evictAllCache();
            this.loadConfigFromJdbc();
        }
        catch (IOException | SQLException | DocumentException e) {
            logger.error((Object)e.getLocalizedMessage());
        }
        this.organizePlatformData();
    }

    public void changeUserPassword(String userCode, String userPassword) {
        UserInfo ui = (UserInfo)((Map)CodeRepositoryCache.codeToUserMap.getCachedTarget()).get(userCode);
        if (ui == null) {
            return;
        }
        String userNewPassword = this.passwordEncoder.createPassword(userPassword, (Object)userCode);
        try (Connection conn = this.getConnection();){
            DatabaseAccess.doExecuteSql((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"UPDATE_USER_PASSWORD"), (Object[])new Object[]{userNewPassword, userCode});
            conn.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

