/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.staticsystem.controller;

import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseSingleData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.model.adapter.PlatformEnvironment;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/environment"})
public class EnvironmentController
extends BaseController {
    @Resource
    protected PlatformEnvironment platformEnvironment;

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    public void test(HttpServletRequest request, HttpServletResponse response) {
        String testSessionString = new String("hello");
        request.getSession().setAttribute("test", (Object)testSessionString);
        JsonResultUtils.writeSingleDataJson((Object)"test=zouwuyang", (HttpServletResponse)response);
    }

    @RequestMapping(value={"/reload/dictionary"}, method={RequestMethod.GET})
    public void reloadDictionary(HttpServletRequest request, HttpServletResponse response) {
        if (this.platformEnvironment.reloadDictionary()) {
            JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
        } else {
            JsonResultUtils.writeErrorMessageJson((String)"reloadDictionary failed\uff01", (HttpServletResponse)response);
        }
    }

    @RequestMapping(value={"/reload/securitymetadata"}, method={RequestMethod.GET})
    public void reloadSecurityMetadata(HttpServletRequest request, HttpServletResponse response) {
        if (this.platformEnvironment.reloadSecurityMetadata()) {
            JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
        } else {
            JsonResultUtils.writeErrorMessageJson((String)"reloadSecurityMetadata failed\uff01", (HttpServletResponse)response);
        }
    }

    @RequestMapping(value={"/reload/refreshall"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseSingleData environmentRefreshAll(HttpServletRequest request, HttpServletResponse response) {
        boolean reloadDc = this.platformEnvironment.reloadDictionary();
        boolean reloadSm = this.platformEnvironment.reloadSecurityMetadata();
        if (reloadDc && reloadSm) {
            return new ResponseSingleData();
        }
        return new ResponseSingleData(500, "environmentRefreshAll failed\uff01");
    }
}

