/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.staticsystem.service.impl;

import com.centit.framework.common.SysParametersUtils;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.IUserInfo;
import com.centit.framework.security.model.CentitPasswordEncoder;
import com.centit.framework.security.model.CentitSecurityMetadata;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.security.model.OptTreeNode;
import com.centit.framework.staticsystem.po.DataCatalog;
import com.centit.framework.staticsystem.po.DataDictionary;
import com.centit.framework.staticsystem.po.OptInfo;
import com.centit.framework.staticsystem.po.OptMethod;
import com.centit.framework.staticsystem.po.RoleInfo;
import com.centit.framework.staticsystem.po.RolePower;
import com.centit.framework.staticsystem.po.UnitInfo;
import com.centit.framework.staticsystem.po.UserInfo;
import com.centit.framework.staticsystem.po.UserRole;
import com.centit.framework.staticsystem.po.UserUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.SecurityConfig;

public abstract class AbstractStaticPlatformEnvironment
implements PlatformEnvironment {
    protected List<UserInfo> userinfos;
    protected List<OptInfo> optinfos;
    protected List<OptMethod> optmethods;
    protected List<RoleInfo> roleinfos;
    protected List<RolePower> rolepowers;
    protected List<UserRole> userroles;
    protected List<UserUnit> userunits;
    protected List<DataCatalog> datacatalogs;
    protected List<DataDictionary> datadictionaies;
    protected List<UnitInfo> unitinfos;
    protected CentitPasswordEncoder passwordEncoder;

    public void setPasswordEncoder(CentitPasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    protected void organizeDictionaryData() {
        for (DataDictionary dataDictionary : this.datadictionaies) {
            DataCatalog dc = this.getDataCatalog(dataDictionary.getCatalogCode());
            if (dc == null) continue;
            dc.addDataDictionary(dataDictionary);
        }
        for (RoleInfo roleInfo : this.roleinfos) {
            for (RolePower rp : this.rolepowers) {
                if (!StringUtils.equals((CharSequence)rp.getRoleCode(), (CharSequence)roleInfo.getRoleCode())) continue;
                roleInfo.addRolePowers(rp);
            }
        }
        for (UserInfo userInfo : this.userinfos) {
            ArrayList<String> ris = new ArrayList<String>();
            HashMap<String, String> userOptList = new HashMap<String, String>();
            for (UserRole ur : this.userroles) {
                if (!StringUtils.equals((CharSequence)ur.getUserCode(), (CharSequence)userInfo.getUserCode())) continue;
                ris.add(ur.getRoleCode());
                RoleInfo ri = this.getRoleInfo(ur.getRoleCode());
                if (ri == null) continue;
                for (RolePower rp : ri.getRolePowers()) {
                    OptMethod om = this.getOptMethod(rp.getOptCode());
                    if (om == null) continue;
                    userOptList.put(om.getOptId() + "-" + om.getOptMethod(), om.getOptId());
                }
            }
            userInfo.setAuthoritiesByRoles(ris);
            userInfo.setUserOptList(userOptList);
        }
        for (UnitInfo unitInfo : this.unitinfos) {
            UnitInfo unit = this.getUnitInfoByUnitCode(unitInfo.getParentUnit());
            if (unit == null) continue;
            unit.addSubUnit(unitInfo);
        }
        for (UserUnit userUnit : this.userunits) {
            UnitInfo unit;
            UserInfo user = this.getUserInfoByUserCode(userUnit.getUserCode());
            if (user != null) {
                user.addUserUnit(userUnit);
            }
            if ((unit = this.getUnitInfoByUnitCode(userUnit.getUnitCode())) == null) continue;
            unit.addUnitUser(userUnit);
        }
    }

    protected DataCatalog getDataCatalog(String catalogCode) {
        for (DataCatalog dc : this.datacatalogs) {
            if (!StringUtils.equals((CharSequence)dc.getCatalogCode(), (CharSequence)catalogCode)) continue;
            return dc;
        }
        return null;
    }

    protected List<OptInfo> getDirectOptInfo() {
        ArrayList<OptInfo> dirOptInfos = new ArrayList<OptInfo>();
        for (OptInfo oi : this.optinfos) {
            if (!StringUtils.equals((CharSequence)oi.getOptUrl(), (CharSequence)"...")) continue;
            OptInfo soi = new OptInfo();
            soi.copy(oi);
            soi.setOptId(oi.getOptId());
            dirOptInfos.add(soi);
        }
        return dirOptInfos;
    }

    protected OptInfo getOptInfo(String optId) {
        for (OptInfo oi : this.optinfos) {
            if (!StringUtils.equals((CharSequence)oi.getOptId(), (CharSequence)optId)) continue;
            return oi;
        }
        return null;
    }

    protected OptMethod getOptMethod(String optCode) {
        for (OptMethod om : this.optmethods) {
            if (!StringUtils.equals((CharSequence)om.getOptCode(), (CharSequence)optCode)) continue;
            return om;
        }
        return null;
    }

    protected RoleInfo getRoleInfo(String roleCode) {
        for (RoleInfo ri : this.roleinfos) {
            if (!StringUtils.equals((CharSequence)ri.getRoleCode(), (CharSequence)roleCode)) continue;
            return ri;
        }
        return null;
    }

    public UnitInfo getUnitInfoByUnitCode(String unitCode) {
        for (UnitInfo ui : this.unitinfos) {
            if (!StringUtils.equals((CharSequence)ui.getUnitCode(), (CharSequence)unitCode)) continue;
            return ui;
        }
        return null;
    }

    public UserInfo getUserInfoByUserCode(String userCode) {
        for (UserInfo ui : this.userinfos) {
            if (!StringUtils.equals((CharSequence)ui.getUserCode(), (CharSequence)userCode)) continue;
            return ui;
        }
        return null;
    }

    public UserInfo getUserInfoByLoginName(String loginName) {
        for (UserInfo ui : this.userinfos) {
            if (!StringUtils.equals((CharSequence)ui.getLoginName(), (CharSequence)loginName)) continue;
            return ui;
        }
        return null;
    }

    public boolean checkUserPassword(String userCode, String userPassword) {
        UserInfo ui = this.getUserInfoByUserCode(userCode);
        if (ui == null) {
            return false;
        }
        return this.passwordEncoder.isPasswordValid(ui.getUserPin(), userPassword, (Object)userCode);
    }

    public String getSystemParameter(String paramCode) {
        return SysParametersUtils.getStringValue((String)paramCode);
    }

    public String getUserSetting(String userCode, String paramCode) {
        UserInfo ud = this.getUserInfoByUserCode(userCode);
        if (ud == null) {
            return null;
        }
        return ud.getUserSettingValue(paramCode);
    }

    public List<UserInfo> listAllUsers() {
        return this.userinfos;
    }

    public List<UnitInfo> listAllUnits() {
        return this.unitinfos;
    }

    public List<UserUnit> listAllUserUnits() {
        return this.userunits;
    }

    public Map<String, RoleInfo> getRoleRepo() {
        HashMap<String, RoleInfo> roleRepo = new HashMap<String, RoleInfo>();
        for (RoleInfo role : this.roleinfos) {
            roleRepo.put(role.getRoleCode(), role);
        }
        return roleRepo;
    }

    public Map<String, OptMethod> getOptMethodRepo() {
        HashMap<String, OptMethod> methodRepo = new HashMap<String, OptMethod>();
        for (OptMethod method : this.optmethods) {
            methodRepo.put(method.getOptCode(), method);
        }
        return methodRepo;
    }

    public List<DataCatalog> listAllDataCatalogs() {
        return this.datacatalogs;
    }

    public List<DataDictionary> listDataDictionaries(String catalogCode) {
        DataCatalog dc = this.getDataCatalog(catalogCode);
        if (dc != null) {
            return dc.getDataDictionaries();
        }
        return null;
    }

    public List<UserUnit> listUserUnits(String userCode) {
        UserInfo ui = this.getUserInfoByUserCode(userCode);
        if (ui != null) {
            return ui.getUserUnits();
        }
        return null;
    }

    public List<UserUnit> listUnitUsers(String unitCode) {
        UnitInfo ui = this.getUnitInfoByUnitCode(unitCode);
        if (ui != null) {
            return ui.getUnitUsers();
        }
        return null;
    }

    public Map<String, OptInfo> getOptInfoRepo() {
        HashMap<String, OptInfo> optRepo = new HashMap<String, OptInfo>();
        for (OptInfo opt : this.optinfos) {
            optRepo.put(opt.getOptId(), opt);
        }
        return optRepo;
    }

    private static List<OptInfo> getMenuFuncs(List<OptInfo> preOpts, List<OptInfo> ls) {
        int i;
        boolean[] isNeeds = new boolean[preOpts.size()];
        for (int i2 = 0; i2 < preOpts.size(); ++i2) {
            isNeeds[i2] = false;
        }
        ArrayList<OptInfo> opts = new ArrayList<OptInfo>();
        block1: for (OptInfo opm : ls) {
            opts.add(opm);
            for (i = 0; i < preOpts.size(); ++i) {
                if (opm.getPreOptId() == null || !opm.getPreOptId().equals(preOpts.get(i).getOptId())) continue;
                isNeeds[i] = true;
                continue block1;
            }
        }
        ArrayList<OptInfo> needAdd = new ArrayList<OptInfo>();
        for (int i3 = 0; i3 < preOpts.size(); ++i3) {
            if (!isNeeds[i3]) continue;
            needAdd.add(preOpts.get(i3));
        }
        boolean[] isNeeds2 = new boolean[preOpts.size()];
        block4: while (true) {
            int i4;
            int nestedMenu = 0;
            for (i4 = 0; i4 < preOpts.size(); ++i4) {
                isNeeds2[i4] = false;
            }
            block6: for (i4 = 0; i4 < needAdd.size(); ++i4) {
                for (int j = 0; j < preOpts.size(); ++j) {
                    if (isNeeds[j] || ((OptInfo)needAdd.get(i4)).getPreOptId() == null || !((OptInfo)needAdd.get(i4)).getPreOptId().equals(preOpts.get(j).getOptId())) continue;
                    isNeeds[j] = true;
                    isNeeds2[j] = true;
                    ++nestedMenu;
                    continue block6;
                }
            }
            if (nestedMenu == 0) break;
            needAdd.clear();
            i4 = 0;
            while (true) {
                if (i4 >= preOpts.size()) continue block4;
                if (isNeeds2[i4]) {
                    needAdd.add(preOpts.get(i4));
                }
                ++i4;
            }
            break;
        }
        for (i = 0; i < preOpts.size(); ++i) {
            if (!isNeeds[i]) continue;
            opts.add(preOpts.get(i));
        }
        return opts;
    }

    private static List<OptInfo> listObjectFormatAndFilterOptId(List<OptInfo> optInfos, String superOptId) {
        Iterator<OptInfo> menus = optInfos.iterator();
        OptInfo parentOpt = null;
        ArrayList<OptInfo> parentMenu = new ArrayList<OptInfo>();
        while (menus.hasNext()) {
            OptInfo optInfo = menus.next();
            if (superOptId != null && superOptId.equals(optInfo.getOptId())) {
                parentOpt = optInfo;
            }
            boolean getParent = false;
            for (OptInfo opt : optInfos) {
                if (!opt.getOptId().equals(optInfo.getPreOptId())) continue;
                opt.addChild(optInfo);
                getParent = true;
                break;
            }
            if (getParent) continue;
            parentMenu.add(optInfo);
        }
        if (superOptId != null && parentOpt != null) {
            return parentOpt.getChildren();
        }
        return parentMenu;
    }

    public List<OptInfo> listUserMenuOptInfos(String userCode, boolean asAdmin) {
        UserInfo ud = this.getUserInfoByUserCode(userCode);
        if (ud == null) {
            return null;
        }
        Map<String, String> userOpts = ud.getUserOptList();
        ArrayList<OptInfo> userOptinfos = new ArrayList<OptInfo>();
        for (Map.Entry<String, String> uo : userOpts.entrySet()) {
            OptInfo oi = this.getOptInfo(uo.getValue());
            if (!"Y".equals(oi.getIsInToolbar())) continue;
            OptInfo soi = new OptInfo();
            soi.copy(oi);
            soi.setOptId(oi.getOptId());
            userOptinfos.add(soi);
        }
        List<OptInfo> preOpts = this.getDirectOptInfo();
        List<OptInfo> allUserOpt = AbstractStaticPlatformEnvironment.getMenuFuncs(preOpts, userOptinfos);
        Collections.sort(allUserOpt, (o1, o2) -> o2.getOrderInd() == null && o1.getOrderInd() == null ? 0 : (o2.getOrderInd() == null ? 1 : (o1.getOrderInd() == null ? -1 : (o1.getOrderInd() > o2.getOrderInd() ? 1 : (o1.getOrderInd() < o2.getOrderInd() ? -1 : 0)))));
        return AbstractStaticPlatformEnvironment.listObjectFormatAndFilterOptId(allUserOpt, null);
    }

    public List<OptInfo> listUserMenuOptInfosUnderSuperOptId(String userCode, String superOptId, boolean asAdmin) {
        UserInfo ud = this.getUserInfoByUserCode(userCode);
        if (ud == null) {
            return null;
        }
        Map<String, String> userOpts = ud.getUserOptList();
        ArrayList<OptInfo> userOptinfos = new ArrayList<OptInfo>();
        for (Map.Entry<String, String> uo : userOpts.entrySet()) {
            OptInfo oi = this.getOptInfo(uo.getValue());
            if (!"Y".equals(oi.getIsInToolbar())) continue;
            OptInfo soi = new OptInfo();
            soi.copy(oi);
            soi.setOptId(oi.getOptId());
            userOptinfos.add(soi);
        }
        List<OptInfo> preOpts = this.getDirectOptInfo();
        List<OptInfo> allUserOpt = AbstractStaticPlatformEnvironment.getMenuFuncs(preOpts, userOptinfos);
        return AbstractStaticPlatformEnvironment.listObjectFormatAndFilterOptId(allUserOpt, superOptId);
    }

    public Map<String, UnitInfo> getUnitRepo() {
        HashMap<String, UnitInfo> unitRepo = new HashMap<String, UnitInfo>();
        for (UnitInfo unit : this.unitinfos) {
            unitRepo.put(unit.getUnitCode(), unit);
        }
        return unitRepo;
    }

    public Map<String, UserInfo> getUserRepo() {
        HashMap<String, UserInfo> userRepo = new HashMap<String, UserInfo>();
        for (UserInfo user : this.userinfos) {
            userRepo.put(user.getUserCode(), user);
        }
        return userRepo;
    }

    public Map<String, UserInfo> getLoginNameRepo() {
        HashMap<String, UserInfo> userRepo = new HashMap<String, UserInfo>();
        for (UserInfo user : this.userinfos) {
            userRepo.put(user.getLoginName(), user);
        }
        return userRepo;
    }

    public Map<String, UnitInfo> getDepNoRepo() {
        HashMap<String, UnitInfo> depnoRepo = new HashMap<String, UnitInfo>();
        for (UnitInfo unit : this.unitinfos) {
            depnoRepo.put(unit.getDepNo(), unit);
        }
        return depnoRepo;
    }

    public CentitUserDetails loadUserDetailsByLoginName(String loginName) {
        for (IUserInfo iUserInfo : this.listAllUsers()) {
            if (!StringUtils.equals((CharSequence)iUserInfo.getLoginName(), (CharSequence)loginName)) continue;
            return (CentitUserDetails)iUserInfo;
        }
        return null;
    }

    public CentitUserDetails loadUserDetailsByUserCode(String userCode) {
        for (IUserInfo iUserInfo : this.listAllUsers()) {
            if (!StringUtils.equals((CharSequence)iUserInfo.getUserCode(), (CharSequence)userCode)) continue;
            return (CentitUserDetails)iUserInfo;
        }
        return null;
    }

    public CentitUserDetails loadUserDetailsByRegEmail(String regEmail) {
        for (IUserInfo iUserInfo : this.listAllUsers()) {
            if (!StringUtils.equals((CharSequence)iUserInfo.getRegEmail(), (CharSequence)regEmail)) continue;
            return (CentitUserDetails)iUserInfo;
        }
        return null;
    }

    public CentitUserDetails loadUserDetailsByRegCellPhone(String regCellPhone) {
        for (IUserInfo iUserInfo : this.listAllUsers()) {
            if (!StringUtils.equals((CharSequence)iUserInfo.getRegCellPhone(), (CharSequence)regCellPhone)) continue;
            return (CentitUserDetails)iUserInfo;
        }
        return null;
    }

    public boolean reloadSecurityMetadata() {
        CentitSecurityMetadata.optMethodRoleMap.clear();
        if (this.rolepowers == null || this.rolepowers.size() == 0) {
            return false;
        }
        for (RolePower rp : this.rolepowers) {
            ArrayList<SecurityConfig> roles = (ArrayList<SecurityConfig>)CentitSecurityMetadata.optMethodRoleMap.get(rp.getOptCode());
            if (roles == null) {
                roles = new ArrayList<SecurityConfig>();
            }
            roles.add(new SecurityConfig("R_" + StringUtils.trim((String)rp.getRoleCode())));
            CentitSecurityMetadata.optMethodRoleMap.put(rp.getOptCode(), roles);
        }
        CentitSecurityMetadata.sortOptMethodRoleMap();
        CentitSecurityMetadata.optTreeNode.setChildList(null);
        CentitSecurityMetadata.optTreeNode.setOptCode(null);
        for (OptMethod ou : this.optmethods) {
            OptInfo oi = this.getOptInfo(ou.getOptId());
            if (oi == null) continue;
            String optDefUrl = oi.getOptUrl() + ou.getOptUrl();
            List sOpt = CentitSecurityMetadata.parseUrl((String)optDefUrl, (String)ou.getOptReq());
            for (List surls : sOpt) {
                OptTreeNode opt = CentitSecurityMetadata.optTreeNode;
                for (String surl : surls) {
                    opt = opt.setChildPath(surl);
                }
                opt.setOptCode(ou.getOptCode());
            }
        }
        return true;
    }
}

