/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.staticsystem.security;

import com.alibaba.fastjson.annotation.JSONField;
import com.centit.framework.model.basedata.IUserUnit;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.staticsystem.po.RoleInfo;
import com.centit.framework.staticsystem.po.UserInfo;
import com.centit.framework.staticsystem.po.UserUnit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class StaticCentitUserDetails
implements CentitUserDetails,
Serializable {
    private static final long serialVersionUID = 1L;
    protected UserInfo userInfo;
    private String currentStationId;
    private Map<String, String> userSettings;
    private Map<String, String> userOptList;
    private List<RoleInfo> userRoles;
    @JSONField(serialize=false)
    private List<GrantedAuthority> arrayAuths;

    public StaticCentitUserDetails() {
    }

    public StaticCentitUserDetails(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    @JSONField(serialize=false)
    public String getUserCode() {
        return this.getUserInfo().getUserCode();
    }

    public boolean isEnabled() {
        return "T".equals(this.userInfo.getIsValid());
    }

    public List<RoleInfo> getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(List<RoleInfo> userRoles) {
        this.userRoles = userRoles;
    }

    private void makeUserAuthorities() {
        this.arrayAuths = new ArrayList<GrantedAuthority>();
        if (this.userRoles.size() < 1) {
            return;
        }
        boolean havePublicRole = false;
        for (RoleInfo role : this.userRoles) {
            this.arrayAuths.add((GrantedAuthority)new SimpleGrantedAuthority("R_" + StringUtils.trim((String)role.getRoleCode())));
            if (!"public".equalsIgnoreCase(role.getRoleCode())) continue;
            havePublicRole = true;
        }
        if (!havePublicRole) {
            this.arrayAuths.add((GrantedAuthority)new SimpleGrantedAuthority("R_public"));
        }
        Collections.sort(this.arrayAuths, Comparator.comparing(GrantedAuthority::getAuthority));
    }

    public void setAuthoritiesByRoles(List<RoleInfo> roles) {
        this.setUserRoles(roles);
        this.makeUserAuthorities();
    }

    public void setLoginIp(String loginHost) {
        this.userInfo.setLoginIp(loginHost);
    }

    public void setActiveTime(Date loginTime) {
        this.userInfo.setActiveTime(loginTime);
    }

    @JSONField(serialize=false)
    public IUserUnit getCurrentStation() {
        List<UserUnit> uus = this.getUserInfo().getUserUnits();
        if (uus != null) {
            for (UserUnit uu : uus) {
                if (StringUtils.equals((CharSequence)this.currentStationId, (CharSequence)uu.getUserUnitId())) {
                    return uu;
                }
                if (!StringUtils.isBlank((CharSequence)this.currentStationId) || !"T".equals(uu.getIsPrimary())) continue;
                return uu;
            }
        }
        return null;
    }

    public void setCurrentStationId(String userUnitId) {
        this.currentStationId = userUnitId;
    }

    public String getCurrentStationId() {
        return this.currentStationId;
    }

    @JSONField(serialize=false)
    public String getCurrentUnitCode() {
        IUserUnit cs = this.getCurrentStation();
        return cs != null ? cs.getUnitCode() : this.getUserInfo().getPrimaryUnit();
    }

    @JSONField(serialize=false)
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.arrayAuths;
    }

    @JSONField(serialize=false)
    public String getPassword() {
        return this.userInfo.getUserPin();
    }

    public String getUsername() {
        return this.userInfo.getLoginName();
    }

    public boolean isAccountNonExpired() {
        return this.isEnabled();
    }

    public boolean isAccountNonLocked() {
        return this.isEnabled();
    }

    public boolean isCredentialsNonExpired() {
        return this.isEnabled();
    }

    public void setUserSettings(Map<String, String> userSettings) {
        this.userSettings = userSettings;
    }

    public Map<String, String> getUserSettings() {
        if (this.userSettings == null) {
            this.userSettings = new HashMap<String, String>(2);
        }
        return this.userSettings;
    }

    public String getUserSettingValue(String paramCode) {
        if (this.userSettings == null) {
            return null;
        }
        return this.userSettings.get(paramCode);
    }

    public void setUserSettingValue(String paramCode, String paramValue) {
        if (this.userSettings == null) {
            this.userSettings = new HashMap<String, String>(10);
        }
        this.userSettings.put(paramCode, paramValue);
    }

    public void setUserOptList(Map<String, String> userOptList) {
        this.userOptList = userOptList;
    }

    public Map<String, String> getUserOptList() {
        if (this.userOptList == null) {
            this.userOptList = new HashMap<String, String>(10);
        }
        return this.userOptList;
    }

    public boolean checkOptPower(String optId, String optMethod) {
        String s = this.userOptList.get(optId + "-" + optMethod);
        return s != null;
    }

    @JSONField(serialize=false)
    public Object getCredentials() {
        return this.userInfo.getUserPin();
    }

    @JSONField(serialize=false)
    public Object getDetails() {
        return this;
    }

    @JSONField(serialize=false)
    public Object getPrincipal() {
        return this;
    }

    public boolean isAuthenticated() {
        return true;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
    }

    public String getName() {
        return this.userInfo.getLoginName();
    }

    public boolean equals(Object other) {
        if (other instanceof CentitUserDetails) {
            return this.userInfo.getUserCode().equals(((CentitUserDetails)other).getUserInfo().getUserCode());
        }
        return false;
    }

    public int hashCode() {
        return this.userInfo.getUserCode().hashCode();
    }
}

