/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.staticsystem.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.staticsystem.po.DataCatalog;
import com.centit.framework.staticsystem.po.DataDictionary;
import com.centit.framework.staticsystem.po.OptInfo;
import com.centit.framework.staticsystem.po.OptMethod;
import com.centit.framework.staticsystem.po.RoleInfo;
import com.centit.framework.staticsystem.po.RolePower;
import com.centit.framework.staticsystem.po.UnitInfo;
import com.centit.framework.staticsystem.po.UserInfo;
import com.centit.framework.staticsystem.po.UserRole;
import com.centit.framework.staticsystem.po.UserUnit;
import com.centit.framework.staticsystem.service.impl.AbstractStaticPlatformEnvironment;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileSystemOpt;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;

public class JsonPlatformEnvironment
extends AbstractStaticPlatformEnvironment
implements PlatformEnvironment {
    private static Log logger = LogFactory.getLog(JsonPlatformEnvironment.class);
    protected String appHome;

    public void init() {
        this.reloadDictionary();
        this.reloadSecurityMetadata();
    }

    public void setAppHome(String appHome) {
        this.appHome = appHome;
    }

    public void loadConfigFromJSONString(String jsonStr) {
        JSONObject json = JSON.parseObject((String)jsonStr);
        this.userinfos = JSON.parseArray((String)json.getString("userInfos"), UserInfo.class);
        this.optinfos = JSON.parseArray((String)json.getString("optInfos"), OptInfo.class);
        this.optmethods = JSON.parseArray((String)json.getString("optMethods"), OptMethod.class);
        this.roleinfos = JSON.parseArray((String)json.getString("roleInfos"), RoleInfo.class);
        this.rolepowers = JSON.parseArray((String)json.getString("rolePowers"), RolePower.class);
        this.userroles = JSON.parseArray((String)json.getString("userRoles"), UserRole.class);
        this.unitinfos = JSON.parseArray((String)json.getString("unitInfos"), UnitInfo.class);
        this.userunits = JSON.parseArray((String)json.getString("userUnits"), UserUnit.class);
        this.datacatalogs = JSON.parseArray((String)json.getString("dataCatalogs"), DataCatalog.class);
        this.datadictionaies = JSON.parseArray((String)json.getString("dataDictionaries"), DataDictionary.class);
    }

    public String loadJsonStringFormConfigFile(String fileName) throws IOException {
        String jsonFile = this.appHome + "/config" + fileName;
        if (FileSystemOpt.existFile((String)jsonFile)) {
            return FileIOOpt.readStringFromFile((String)jsonFile, (String)"UTF-8");
        }
        return FileIOOpt.readStringFromInputStream((InputStream)new ClassPathResource(fileName).getInputStream(), (String)"UTF-8");
    }

    public boolean reloadDictionary() {
        try {
            String jsonstr = this.loadJsonStringFormConfigFile("/static_system_config.json");
            this.loadConfigFromJSONString(jsonstr);
        }
        catch (IOException e) {
            this.userinfos = new ArrayList();
            this.optinfos = new ArrayList();
            this.optmethods = new ArrayList();
            this.roleinfos = new ArrayList();
            this.rolepowers = new ArrayList();
            this.userroles = new ArrayList();
            this.unitinfos = new ArrayList();
            this.userunits = new ArrayList();
            this.datacatalogs = new ArrayList();
            this.datadictionaies = new ArrayList();
            e.printStackTrace();
        }
        this.organizeDictionaryData();
        try {
            String jsonStr = this.loadJsonStringFormConfigFile("/static_system_user_pwd.json");
            JSONObject json = JSON.parseObject((String)jsonStr);
            for (UserInfo u : this.userinfos) {
                String spwd = json.getString(u.getUserCode());
                if (!StringUtils.isNotBlank((CharSequence)spwd)) continue;
                u.setUserPin(spwd);
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public void changeUserPassword(String userCode, String userPassword) {
        UserInfo ui = this.getUserInfoByUserCode(userCode);
        if (ui == null) {
            return;
        }
        JSONObject json = null;
        String jsonFile = "/static_system_user_pwd.json";
        try {
            String jsonstr = this.loadJsonStringFormConfigFile(jsonFile);
            json = JSON.parseObject((String)jsonstr);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (json == null) {
            json = new JSONObject();
        }
        try {
            ui.setUserPin(this.passwordEncoder.createPassword(userPassword, (Object)userCode));
            json.put(userCode, (Object)ui.getUserPin());
            FileIOOpt.writeStringToFile((String)json.toJSONString(), (String)(this.appHome + "/config" + jsonFile));
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

