/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.staticsystem.po;

import com.centit.framework.model.basedata.IDataCatalog;
import com.centit.framework.staticsystem.po.DataDictionary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.util.HtmlUtils;

public class DataCatalog
implements IDataCatalog,
Serializable {
    private static final long serialVersionUID = 1L;
    private String catalogCode;
    private String catalogName;
    private String catalogStyle;
    private String catalogType;
    private String catalogDesc;
    private String fieldDesc;
    private String needCache;
    private String optId;
    private List<DataDictionary> dataDictionaries;

    public DataCatalog(String catalogcode, String catalogname, String catalogstyle, String catalogtype, String isupload) {
        this.catalogCode = catalogcode;
        this.catalogName = catalogname;
        this.catalogStyle = catalogstyle;
        this.catalogType = catalogtype;
        this.needCache = "1";
    }

    public DataCatalog(String catalogcode, String catalogname, String catalogstyle, String catalogtype, String catalogdesc, String isupload, String needCache, String fielddesc) {
        this.catalogCode = catalogcode;
        this.catalogName = catalogname;
        this.catalogStyle = catalogstyle;
        this.catalogType = catalogtype;
        this.catalogDesc = catalogdesc;
        this.fieldDesc = fielddesc;
        this.needCache = needCache;
    }

    public String getCatalogCode() {
        return this.catalogCode;
    }

    public void setCatalogCode(String catalogcode) {
        this.catalogCode = catalogcode;
    }

    public String getOptId() {
        return this.optId;
    }

    public void setOptId(String dictionarytype) {
        this.optId = dictionarytype;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogname) {
        this.catalogName = catalogname;
    }

    public String getCatalogStyle() {
        return this.catalogStyle;
    }

    public void setCatalogStyle(String catalogstyle) {
        this.catalogStyle = catalogstyle;
    }

    public String getCatalogType() {
        return this.catalogType;
    }

    public void setCatalogType(String catalogtype) {
        this.catalogType = catalogtype;
    }

    public String getCatalogDesc() {
        return this.catalogDesc;
    }

    public void setCatalogDesc(String catalogdesc) {
        this.catalogDesc = catalogdesc;
    }

    public String getFieldDesc() {
        return this.fieldDesc;
    }

    public void setFieldDesc(String fielddesc) {
        if (StringUtils.isNotBlank((CharSequence)fielddesc)) {
            fielddesc = HtmlUtils.htmlUnescape((String)fielddesc);
        }
        this.fieldDesc = fielddesc;
    }

    public void setIsUpload(String isupload) {
    }

    public String getNeedCache() {
        return this.needCache;
    }

    public void setNeedCache(String needCache) {
        this.needCache = needCache;
    }

    public void copy(DataCatalog other) {
        this.catalogName = other.getCatalogName();
        this.catalogStyle = other.getCatalogStyle();
        this.catalogType = other.getCatalogType();
        this.catalogDesc = other.getCatalogDesc();
        this.fieldDesc = other.getFieldDesc();
        this.optId = other.getOptId();
        this.needCache = other.getNeedCache();
    }

    public void copyNotNullProperty(DataCatalog other) {
        if (other.getCatalogName() != null) {
            this.catalogName = other.getCatalogName();
        }
        if (other.getCatalogStyle() != null) {
            this.catalogStyle = other.getCatalogStyle();
        }
        if (other.getCatalogType() != null) {
            this.catalogType = other.getCatalogType();
        }
        if (other.getCatalogDesc() != null) {
            this.catalogDesc = other.getCatalogDesc();
        }
        if (other.getFieldDesc() != null) {
            this.fieldDesc = other.getFieldDesc();
        }
        if (other.getOptId() != null) {
            this.optId = other.getOptId();
            this.needCache = other.getOptId() == null ? "1" : other.getNeedCache();
        }
    }

    public void addAllDataPiece(List<DataDictionary> dataDictionaries) {
        this.getDataDictionaries().clear();
        if (dataDictionaries == null || dataDictionaries.size() == 0) {
            return;
        }
        for (DataDictionary dataDictionary : dataDictionaries) {
            dataDictionary.setCatalogCode(this.catalogCode);
            this.getDataDictionaries().add(dataDictionary);
        }
    }

    public DataCatalog addDataDictionary(DataDictionary dd) {
        this.getDataDictionaries().add(dd);
        return this;
    }

    public List<DataDictionary> getDataDictionaries() {
        if (null == this.dataDictionaries) {
            this.dataDictionaries = new ArrayList<DataDictionary>();
        }
        return this.dataDictionaries;
    }

    public void setDataDictionaries(List<DataDictionary> dataDictionaries) {
        this.dataDictionaries = dataDictionaries;
    }

    public DataCatalog() {
    }
}

