/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.staticsystem.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.model.basedata.IUserInfo;
import com.centit.framework.staticsystem.po.DataCatalog;
import com.centit.framework.staticsystem.po.DataDictionary;
import com.centit.framework.staticsystem.po.OptInfo;
import com.centit.framework.staticsystem.po.OptMethod;
import com.centit.framework.staticsystem.po.RoleInfo;
import com.centit.framework.staticsystem.po.RolePower;
import com.centit.framework.staticsystem.po.UnitInfo;
import com.centit.framework.staticsystem.po.UserInfo;
import com.centit.framework.staticsystem.po.UserRole;
import com.centit.framework.staticsystem.po.UserUnit;
import com.centit.framework.staticsystem.service.impl.AbstractStaticPlatformEnvironment;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileSystemOpt;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;

public class JsonPlatformEnvironment
extends AbstractStaticPlatformEnvironment {
    private static Log logger = LogFactory.getLog(JsonPlatformEnvironment.class);
    protected String appHome;

    public void setAppHome(String appHome) {
        this.appHome = appHome;
    }

    private void loadConfigFromJSONString(String jsonStr) {
        JSONObject json = JSON.parseObject((String)jsonStr);
        List userinfos = JSON.parseArray((String)json.getString("userInfos"), UserInfo.class);
        CodeRepositoryCache.userInfoRepo.setFreshtDate((Object)userinfos);
        List optinfos = JSON.parseArray((String)json.getString("optInfos"), OptInfo.class);
        CodeRepositoryCache.optInfoRepo.setFreshtDate((Object)optinfos);
        List optmethods = JSON.parseArray((String)json.getString("optMethods"), OptMethod.class);
        CodeRepositoryCache.optMethodRepo.setFreshtDate((Object)optmethods);
        List roleinfos = JSON.parseArray((String)json.getString("roleInfos"), RoleInfo.class);
        CodeRepositoryCache.roleInfoRepo.setFreshtDate((Object)roleinfos);
        List rolepowers = JSON.parseArray((String)json.getString("rolePowers"), RolePower.class);
        CodeRepositoryCache.rolePowerRepo.setFreshtDate((Object)rolepowers);
        List userroles = JSON.parseArray((String)json.getString("userRoles"), UserRole.class);
        this.allUserRoleRepo.setFreshtDate((Object)userroles);
        List unitinfos = JSON.parseArray((String)json.getString("unitInfos"), UnitInfo.class);
        CodeRepositoryCache.unitInfoRepo.setFreshtDate((Object)unitinfos);
        List userunits = JSON.parseArray((String)json.getString("userUnits"), UserUnit.class);
        CodeRepositoryCache.userUnitRepo.setFreshtDate((Object)userunits);
        List datacatalogs = JSON.parseArray((String)json.getString("dataCatalogs"), DataCatalog.class);
        CodeRepositoryCache.catalogRepo.setFreshtDate((Object)datacatalogs);
        List datadictionaies = JSON.parseArray((String)json.getString("dataDictionaries"), DataDictionary.class);
        this.allDictionaryRepo.setFreshtDate((Object)datadictionaies);
    }

    public String loadJsonStringFormConfigFile(String fileName) throws IOException {
        String jsonFile = this.appHome + "/config" + fileName;
        if (FileSystemOpt.existFile((String)jsonFile)) {
            return FileIOOpt.readStringFromFile((String)jsonFile, (String)"UTF-8");
        }
        return FileIOOpt.readStringFromInputStream((InputStream)new ClassPathResource(fileName).getInputStream(), (String)"UTF-8");
    }

    @Override
    protected synchronized void reloadPlatformData() {
        try {
            String jsonstr = this.loadJsonStringFormConfigFile("/static_system_config.json");
            this.loadConfigFromJSONString(jsonstr);
        }
        catch (IOException e) {
            logger.error((Object)e.getLocalizedMessage());
        }
        this.organizePlatformData();
        try {
            String jsonStr = this.loadJsonStringFormConfigFile("/static_system_user_pwd.json");
            JSONObject json = JSON.parseObject((String)jsonStr);
            for (IUserInfo u : (List)CodeRepositoryCache.userInfoRepo.getCachedTarget()) {
                String spwd = json.getString(u.getUserCode());
                if (!StringUtils.isNotBlank((CharSequence)spwd)) continue;
                ((UserInfo)u).setUserPin(spwd);
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void changeUserPassword(String userCode, String userPassword) {
        UserInfo ui = (UserInfo)((Map)CodeRepositoryCache.codeToUserMap.getCachedTarget()).get(userCode);
        if (ui == null) {
            return;
        }
        JSONObject json = null;
        String jsonFile = "/static_system_user_pwd.json";
        try {
            String jsonstr = this.loadJsonStringFormConfigFile(jsonFile);
            json = JSON.parseObject((String)jsonstr);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (json == null) {
            json = new JSONObject();
        }
        try {
            ui.setUserPin(this.passwordEncoder.createPassword(userPassword, (Object)userCode));
            json.put(userCode, (Object)ui.getUserPin());
            FileIOOpt.writeStringToFile((String)json.toJSONString(), (String)(this.appHome + "/config" + jsonFile));
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

