/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.staticsystem.service.impl;

import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.DataCatalog;
import com.centit.framework.model.basedata.DataDictionary;
import com.centit.framework.model.basedata.OptDataScope;
import com.centit.framework.model.basedata.OptInfo;
import com.centit.framework.model.basedata.OptMethod;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.framework.model.basedata.RoleInfo;
import com.centit.framework.model.basedata.RolePower;
import com.centit.framework.model.basedata.UnitInfo;
import com.centit.framework.model.basedata.UnitRole;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.framework.model.basedata.UserRole;
import com.centit.framework.model.basedata.UserRoleId;
import com.centit.framework.model.basedata.UserSetting;
import com.centit.framework.model.basedata.UserUnit;
import com.centit.framework.model.basedata.WorkGroup;
import com.centit.framework.model.security.CentitPasswordEncoder;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.framework.model.security.OptTreeNode;
import com.centit.framework.security.SecurityContextUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.common.CachedObject;
import com.centit.support.common.ListAppendMap;
import com.centit.support.database.utils.PageDesc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.ConfigAttribute;

public abstract class AbstractStaticPlatformEnvironment
implements PlatformEnvironment {
    public CachedObject<List<OptDataScope>> optDataScopes = new CachedObject(this::loadOptDataScope, 86400L);
    public CachedObject<List<DataCatalog>> catalogRepo = new CachedObject(this::loadAllDataCatalog, 86400L);
    public CachedObject<List<RolePower>> allRolePower = new CachedObject(this::loadAllRolePower, 86400L);
    public CachedObject<List<OptMethod>> allOptMethod = new CachedObject(this::loadAllOptMethod, 86400L);
    public CachedObject<List<UserRole>> allUserRoleRepo = new CachedObject(this::loadAllUserRole, 86400L);
    public CachedObject<List<UserUnit>> allUserUnitRepo = new CachedObject(this::loadAllUserUnit, 86400L);
    public CachedObject<List<CentitUserDetails>> allUserDetailsRepo = new CachedObject(() -> {
        this.reloadPlatformData();
        return null;
    }, 86400L);
    protected CentitPasswordEncoder passwordEncoder;

    public void setPasswordEncoder(CentitPasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    protected abstract void reloadPlatformData();

    protected void organizePlatformData() {
        for (RoleInfo ri : (List)CodeRepositoryCache.roleInfoRepo.getCachedValue((Object)"all")) {
            for (RolePower rp : (List)((Map)CodeRepositoryCache.rolePowerMap.getCachedValue((Object)"all")).get(ri.getRoleCode())) {
                ri.addRolePower(rp);
            }
        }
        List userinfos = ((ListAppendMap)CodeRepositoryCache.userInfoRepo.getCachedValue((Object)"all")).getListData();
        ArrayList<CentitUserDetails> userDetails = new ArrayList<CentitUserDetails>(userinfos.size());
        List uus = (List)this.allUserUnitRepo.getCachedTarget();
        Map codeToRoleMap = CollectionsOpt.createHashMap((List)((List)CodeRepositoryCache.roleInfoRepo.getCachedValue((Object)"all")), RoleInfo::getRoleCode);
        for (UserInfo ui : userinfos) {
            ArrayList<RoleInfo> roles = new ArrayList<RoleInfo>();
            HashMap<String, String> userOptList = new HashMap<String, String>();
            for (UserRole ur : (List)this.allUserRoleRepo.getCachedTarget()) {
                RoleInfo ri;
                if (!StringUtils.equals((CharSequence)ur.getUserCode(), (CharSequence)ui.getUserCode()) || (ri = (RoleInfo)codeToRoleMap.get(ur.getRoleCode())) == null) continue;
                roles.add(ri);
                for (RolePower rp : ri.getRolePowers()) {
                    OptMethod om = (OptMethod)((ListAppendMap)CodeRepositoryCache.optMethodRepo.getCachedValue((Object)"all")).getAppendMap().get(rp.getOptCode());
                    if (om == null || !StringUtils.isNotBlank((CharSequence)om.getOptMethod())) continue;
                    userOptList.put(om.getOptId() + "-" + om.getOptMethod(), om.getOptCode());
                }
            }
            CentitUserDetails ud = new CentitUserDetails();
            ud.setUserInfo(ui);
            ud.mapAuthoritiesByRoles(roles);
            ud.setUserOptList(userOptList);
            ArrayList<UserUnit> uulist = new ArrayList<UserUnit>(10);
            for (UserUnit uu : uus) {
                if (!StringUtils.equals((CharSequence)uu.getUserCode(), (CharSequence)ui.getUserCode())) continue;
                uulist.add(uu);
            }
            ud.setUserUnits(uulist);
            userDetails.add(ud);
        }
        this.allUserDetailsRepo.setFreshData(userDetails);
    }

    public boolean checkUserPassword(String userCode, String userPassword) {
        UserInfo ui = (UserInfo)((ListAppendMap)CodeRepositoryCache.userInfoRepo.getCachedValue((Object)"all")).getAppendMap().get(userCode);
        if (ui == null) {
            return false;
        }
        return this.passwordEncoder.isPasswordValid(ui.getUserPin(), userPassword, (Object)userCode);
    }

    private static List<OptInfo> getMenuFuncs(List<OptInfo> preOpts, List<OptInfo> ls) {
        int i;
        boolean[] isNeeds = new boolean[preOpts.size()];
        for (int i2 = 0; i2 < preOpts.size(); ++i2) {
            isNeeds[i2] = false;
        }
        ArrayList<OptInfo> opts = new ArrayList<OptInfo>();
        block1: for (OptInfo opm : ls) {
            opts.add(opm);
            for (i = 0; i < preOpts.size(); ++i) {
                if (opm.getPreOptId() == null || !opm.getPreOptId().equals(preOpts.get(i).getOptId())) continue;
                isNeeds[i] = true;
                continue block1;
            }
        }
        ArrayList<OptInfo> needAdd = new ArrayList<OptInfo>();
        for (int i3 = 0; i3 < preOpts.size(); ++i3) {
            if (!isNeeds[i3]) continue;
            needAdd.add(preOpts.get(i3));
        }
        boolean[] isNeeds2 = new boolean[preOpts.size()];
        block4: while (true) {
            int i4;
            int nestedMenu = 0;
            for (i4 = 0; i4 < preOpts.size(); ++i4) {
                isNeeds2[i4] = false;
            }
            block6: for (i4 = 0; i4 < needAdd.size(); ++i4) {
                for (int j = 0; j < preOpts.size(); ++j) {
                    if (isNeeds[j] || ((OptInfo)needAdd.get(i4)).getPreOptId() == null || !((OptInfo)needAdd.get(i4)).getPreOptId().equals(preOpts.get(j).getOptId())) continue;
                    isNeeds[j] = true;
                    isNeeds2[j] = true;
                    ++nestedMenu;
                    continue block6;
                }
            }
            if (nestedMenu == 0) break;
            needAdd.clear();
            i4 = 0;
            while (true) {
                if (i4 >= preOpts.size()) continue block4;
                if (isNeeds2[i4]) {
                    needAdd.add(preOpts.get(i4));
                }
                ++i4;
            }
            break;
        }
        for (i = 0; i < preOpts.size(); ++i) {
            if (!isNeeds[i]) continue;
            opts.add(preOpts.get(i));
        }
        return opts;
    }

    private List<OptInfo> formatMenuTree(List<OptInfo> optInfos) {
        Iterator<OptInfo> menus = optInfos.iterator();
        ArrayList<OptInfo> parentMenu = new ArrayList<OptInfo>();
        while (menus.hasNext()) {
            OptInfo optInfo = menus.next();
            boolean getParent = false;
            for (OptInfo opt : optInfos) {
                if (!opt.getOptId().equals(optInfo.getPreOptId())) continue;
                opt.addChild(optInfo);
                getParent = true;
                break;
            }
            if (getParent) continue;
            parentMenu.add(optInfo);
        }
        return parentMenu;
    }

    private List<OptInfo> formatMenuTree(List<OptInfo> optInfos, String superOptId) {
        if (StringUtils.isEmpty((CharSequence)superOptId)) {
            return Collections.emptyList();
        }
        Iterator<OptInfo> menus = optInfos.iterator();
        OptInfo parentOpt = null;
        while (menus.hasNext()) {
            OptInfo optInfo = menus.next();
            if (StringUtils.equals((CharSequence)superOptId, (CharSequence)optInfo.getOptId())) {
                parentOpt = optInfo;
            }
            for (OptInfo opt : optInfos) {
                if (!opt.getOptId().equals(optInfo.getPreOptId())) continue;
                opt.addChild(optInfo);
            }
        }
        if (parentOpt != null) {
            return parentOpt.getChildren();
        }
        return Collections.emptyList();
    }

    private List<OptInfo> listUserOptInfos(String userCode) {
        ArrayList<OptInfo> userOptinfos = new ArrayList<OptInfo>();
        HashSet<String> optIds = new HashSet<String>(20);
        List<UserRole> userRoles = this.listUserRoles("all", userCode);
        userRoles.add(new UserRole(new UserRoleId(userCode, SecurityContextUtils.PUBLIC_ROLE_CODE)));
        Map codeToRoleMap = CollectionsOpt.createHashMap((List)((List)CodeRepositoryCache.roleInfoRepo.getCachedValue((Object)"all")), RoleInfo::getRoleCode);
        Map codeToOptMap = CollectionsOpt.createHashMap((List)((List)CodeRepositoryCache.optInfoRepo.getCachedValue((Object)"all")), OptInfo::getOptId);
        for (UserRole ur : userRoles) {
            RoleInfo ri = (RoleInfo)codeToRoleMap.get(ur.getRoleCode());
            if (ri == null) continue;
            for (RolePower rp : ri.getRolePowers()) {
                OptMethod om = (OptMethod)((ListAppendMap)CodeRepositoryCache.optMethodRepo.getCachedValue((Object)"all")).getAppendMap().get(rp.getOptCode());
                if (om == null) continue;
                optIds.add(om.getOptId());
            }
        }
        for (String optId : optIds) {
            OptInfo oi = (OptInfo)codeToOptMap.get(optId);
            if (!"Y".equals(oi.getIsInToolbar())) continue;
            OptInfo soi = new OptInfo();
            soi.copy(oi);
            soi.setOptId(oi.getOptId());
            userOptinfos.add(soi);
        }
        return userOptinfos;
    }

    protected List<OptInfo> getDirectOptInfo() {
        ArrayList<OptInfo> dirOptInfos = new ArrayList<OptInfo>();
        for (OptInfo oi : (List)CodeRepositoryCache.optInfoRepo.getCachedValue((Object)"all")) {
            if (!StringUtils.equals((CharSequence)oi.getOptUrl(), (CharSequence)"...")) continue;
            OptInfo soi = new OptInfo();
            soi.copy(oi);
            soi.setOptId(oi.getOptId());
            dirOptInfos.add(soi);
        }
        return dirOptInfos;
    }

    public List<OptInfo> listUserMenuOptInfosUnderSuperOptId(String userCode, String superOptId, boolean asAdmin) {
        List<OptInfo> userOptinfos = this.listUserOptInfos(userCode);
        List<OptInfo> preOpts = this.getDirectOptInfo();
        List<OptInfo> allUserOpt = AbstractStaticPlatformEnvironment.getMenuFuncs(preOpts, userOptinfos);
        Collections.sort(allUserOpt, (o1, o2) -> o2.getOrderInd() == null && o1.getOrderInd() == null ? 0 : (o2.getOrderInd() == null ? 1 : (o1.getOrderInd() == null ? -1 : (o1.getOrderInd() > o2.getOrderInd() ? 1 : (o1.getOrderInd() < o2.getOrderInd() ? -1 : 0)))));
        return this.formatMenuTree(allUserOpt, superOptId);
    }

    public List<OptInfo> listMenuOptInfosUnderOsId(String osId) {
        return Collections.emptyList();
    }

    public OptInfo addOptInfo(OptInfo optInfo) {
        return optInfo;
    }

    public OptInfo updateOptInfo(OptInfo optInfo) {
        return optInfo;
    }

    public List<DataDictionary> listDataDictionaries(String catalogCode) {
        for (DataCatalog data : (List)this.catalogRepo.getCachedTarget()) {
            if (!StringUtils.equals((CharSequence)catalogCode, (CharSequence)data.getCatalogCode())) continue;
            return data.getDataDictionaries();
        }
        return null;
    }

    public void deleteDataDictionary(String catalogCode) {
    }

    public int[] updateOptIdByOptCodes(String optId, List<String> optCodes) {
        return new int[0];
    }

    public boolean deleteOptInfoByOptId(String optId) {
        return false;
    }

    public List<WorkGroup> listWorkGroup(Map<String, Object> filterMap, PageDesc pageDesc) {
        return Collections.emptyList();
    }

    public void batchWorkGroup(List<WorkGroup> workGroups) {
    }

    public boolean loginUserIsExistWorkGroup(String osId, String userCode) {
        return false;
    }

    public List<UserUnit> listUserUnits(String topUnit, String userCode) {
        ArrayList<UserUnit> userUnits = new ArrayList<UserUnit>(10);
        for (UserUnit uu : (List)this.allUserUnitRepo.getCachedTarget()) {
            if (!StringUtils.equals((CharSequence)userCode, (CharSequence)uu.getUserCode())) continue;
            userUnits.add(uu);
        }
        return userUnits;
    }

    public List<UserUnit> listUnitUsers(String unitCode) {
        ArrayList<UserUnit> unitUsers = new ArrayList<UserUnit>(10);
        for (UserUnit uu : (List)this.allUserUnitRepo.getCachedTarget()) {
            if (!StringUtils.equals((CharSequence)unitCode, (CharSequence)uu.getUnitCode())) continue;
            unitUsers.add(uu);
        }
        return unitUsers;
    }

    public List<UserRole> listUserRoles(String topUnit, String userCode) {
        ArrayList<UserRole> roles = new ArrayList<UserRole>();
        for (UserRole ur : (List)this.allUserRoleRepo.getCachedTarget()) {
            if (!StringUtils.equals((CharSequence)ur.getUserCode(), (CharSequence)userCode)) continue;
            roles.add(ur);
        }
        return roles;
    }

    public List<UserRole> listRoleUsers(String topUnit, String roleCode) {
        ArrayList<UserRole> users = new ArrayList<UserRole>();
        for (UserRole ur : (List)this.allUserRoleRepo.getCachedTarget()) {
            if (!StringUtils.equals((CharSequence)ur.getRoleCode(), (CharSequence)roleCode)) continue;
            users.add(ur);
        }
        return users;
    }

    public CentitUserDetails loadUserDetailsByLoginName(String loginName) {
        for (CentitUserDetails ud : (List)this.allUserDetailsRepo.getCachedTarget()) {
            if (!StringUtils.equals((CharSequence)ud.getUserInfo().getLoginName(), (CharSequence)loginName)) continue;
            return ud;
        }
        return null;
    }

    public CentitUserDetails loadUserDetailsByUserCode(String userCode) {
        for (CentitUserDetails ud : (List)this.allUserDetailsRepo.getCachedTarget()) {
            if (!StringUtils.equals((CharSequence)ud.getUserInfo().getUserCode(), (CharSequence)userCode)) continue;
            return ud;
        }
        return null;
    }

    public CentitUserDetails loadUserDetailsByRegEmail(String regEmail) {
        for (CentitUserDetails ud : (List)this.allUserDetailsRepo.getCachedTarget()) {
            if (!StringUtils.equals((CharSequence)ud.getUserInfo().getRegEmail(), (CharSequence)regEmail)) continue;
            return ud;
        }
        return null;
    }

    public CentitUserDetails loadUserDetailsByRegCellPhone(String regCellPhone) {
        for (CentitUserDetails ud : (List)this.allUserDetailsRepo.getCachedTarget()) {
            if (!StringUtils.equals((CharSequence)ud.getUserInfo().getRegCellPhone(), (CharSequence)regCellPhone)) continue;
            return ud;
        }
        return null;
    }

    public UnitInfo loadUnitInfo(String unitCode) {
        ListAppendMap us = (ListAppendMap)CodeRepositoryCache.unitInfoRepo.getCachedValue((Object)"all");
        if (us == null) {
            return null;
        }
        for (UnitInfo ud : us.getListData()) {
            if (!StringUtils.equals((CharSequence)ud.getUnitCode(), (CharSequence)unitCode)) continue;
            return ud;
        }
        return null;
    }

    public UserSetting getUserSetting(String userCode, String paramCode) {
        CentitUserDetails ud = this.loadUserDetailsByUserCode(userCode);
        if (ud == null) {
            return null;
        }
        return new UserSetting(ud.getUserCode(), paramCode, ud.getUserSettingValue(paramCode), "\u7528\u6237\u53c2\u6570");
    }

    public List<UserSetting> listUserSettings(String userCode) {
        CentitUserDetails ud = this.loadUserDetailsByUserCode(userCode);
        if (ud == null) {
            return null;
        }
        Map settingMap = ud.getUserSettings();
        if (settingMap == null) {
            return null;
        }
        ArrayList<UserSetting> userSettings = new ArrayList<UserSetting>(settingMap.size() + 1);
        for (Map.Entry ent : ud.getUserSettings().entrySet()) {
            userSettings.add(new UserSetting(ud.getUserCode(), (String)ent.getKey(), (String)ent.getValue(), "\u7528\u6237\u53c2\u6570"));
        }
        return userSettings;
    }

    public void updateUserInfo(UserInfo userInfo) {
        UserInfo ui = (UserInfo)((ListAppendMap)CodeRepositoryCache.userInfoRepo.getCachedValue((Object)"all")).getAppendMap().get(userInfo.getUserCode());
        if (ui == null) {
            return;
        }
        ui.copyFromUserInfo(userInfo);
    }

    public void saveUserSetting(UserSetting userSetting) {
        CentitUserDetails ud = this.loadUserDetailsByUserCode(userSetting.getUserCode());
        if (ud == null) {
            return;
        }
        ud.setUserSettingValue(userSetting.getParamCode(), userSetting.getParamValue());
    }

    public List<UserInfo> listAllUsers(String topUnit) {
        this.reloadPlatformData();
        return ((ListAppendMap)CodeRepositoryCache.userInfoRepo.getCachedValue((Object)"all")).getListData();
    }

    public List<OsInfo> listOsInfos(String topUnit) {
        this.reloadPlatformData();
        return (List)CodeRepositoryCache.osInfoCache.getCachedValue((Object)"all");
    }

    public OsInfo getOsInfo(String osId) {
        return null;
    }

    public OsInfo deleteOsInfo(String osId) {
        return null;
    }

    public OsInfo updateOsInfo(OsInfo osInfo) {
        return null;
    }

    public OsInfo addOsInfo(OsInfo osInfo) {
        return null;
    }

    public List<UnitInfo> listAllUnits(String topUnit) {
        this.reloadPlatformData();
        return ((ListAppendMap)CodeRepositoryCache.unitInfoRepo.getCachedValue((Object)"all")).getListData();
    }

    public List<UserUnit> listAllUserUnits(String topUnit) {
        this.reloadPlatformData();
        return (List)this.allUserUnitRepo.getCachedTarget();
    }

    public List<DataCatalog> listAllDataCatalogs(String topUnit) {
        this.reloadPlatformData();
        return (List)this.catalogRepo.getCachedTarget();
    }

    public List<RoleInfo> listAllRoleInfo(String topUnit) {
        this.reloadPlatformData();
        return (List)CodeRepositoryCache.roleInfoRepo.getCachedValue((Object)"all");
    }

    public List<OptInfo> listAllOptInfo(String topUnit) {
        this.reloadPlatformData();
        return (List)CodeRepositoryCache.optInfoRepo.getCachedValue((Object)"all");
    }

    public List<OptInfo> listOptInfoByRole(String roleCode) {
        return null;
    }

    public List<RolePower> listAllRolePower(String topUnit) {
        return (List)this.allRolePower.getCachedTarget();
    }

    protected List<RolePower> loadAllRolePower() {
        this.reloadPlatformData();
        return (List)this.allRolePower.getCachedTarget();
    }

    protected List<DataCatalog> loadAllDataCatalog() {
        this.reloadPlatformData();
        return (List)this.catalogRepo.getCachedTarget();
    }

    protected List<UserRole> loadAllUserRole() {
        this.reloadPlatformData();
        return (List)this.allUserRoleRepo.getCachedTarget();
    }

    protected List<UserUnit> loadAllUserUnit() {
        this.reloadPlatformData();
        return (List)this.allUserUnitRepo.getCachedTarget();
    }

    protected List<OptMethod> loadAllOptMethod() {
        this.reloadPlatformData();
        return (List)this.allOptMethod.getCachedTarget();
    }

    protected List<OptDataScope> loadOptDataScope() {
        this.reloadPlatformData();
        return (List)this.optDataScopes.getCachedTarget();
    }

    public List<OptMethod> listAllOptMethod(String topUnit) {
        return (List)this.allOptMethod.getCachedTarget();
    }

    public OptTreeNode getSysOptTree() {
        return null;
    }

    public List<OptMethod> listOptMethodByRoleCode(String roleCode) {
        return null;
    }

    public OptMethod addOptMethod(OptMethod optMethod) {
        return optMethod;
    }

    public OptMethod mergeOptMethod(OptMethod optMethod) {
        return optMethod;
    }

    public void deleteOptMethod(String optCode) {
    }

    public List<ConfigAttribute> getRolesWithApiId(String apiId) {
        return Collections.emptyList();
    }

    public List<OptDataScope> listAllOptDataScope(String superOptId) {
        return (List)this.optDataScopes.getCachedTarget();
    }

    public List<UnitInfo> listUserTopUnits(String userCode) {
        return CollectionsOpt.createList((Object[])new UnitInfo[]{new UnitInfo("all", "T", "\u4e0d\u652f\u6301\u79df\u6237\u65f6\u7684\u9ed8\u8ba4\u9876\u7ea7\u673a\u6784")});
    }

    public List<UnitRole> listUnitRoles(String unitCode) {
        return Collections.emptyList();
    }

    public List<UnitRole> listRoleUnits(String roleCode) {
        return Collections.emptyList();
    }

    public JSONObject getTenantInfoByTopUnit(String topUnit) {
        return null;
    }

    public JSONObject fetchUserTenantGroupInfo(String userCode, String topUnit) {
        return null;
    }
}

