/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.system.po.InnerMsg;
import com.centit.framework.system.po.InnerMsgRecipient;
import com.centit.framework.system.service.InnerMsgManager;
import com.centit.framework.system.service.InnerMsgRecipientManager;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.json.JsonPropertyUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/innermsg"})
public class InnerMsgController
extends BaseController {
    @Resource
    public InnerMsgRecipientManager innerMsgRecipientManager;
    @Resource(name="innerMessageManager")
    @NotNull
    public InnerMsgManager innerMsgManager;

    public String getOptId() {
        return "InnerMsg";
    }

    @RequestMapping(value={"/inbox"}, method={RequestMethod.GET})
    public void listInbox(PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        String receive = (String)searchColumn.get("receive");
        if (StringUtils.isBlank((CharSequence)receive)) {
            searchColumn.put("receive", WebOptUtils.getLoginUser((HttpServletRequest)request).getUserInfo().getUserCode());
        }
        List listObjects = this.innerMsgRecipientManager.listObjectsCascade(searchColumn, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)DictionaryMapUtils.objectsToJSONArray((Collection)listObjects));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/unreadMsgCount"}, method={RequestMethod.GET})
    public void unreadMsgCount(HttpServletRequest request, HttpServletResponse response) {
        String currUser = WebOptUtils.getLoginUser((HttpServletRequest)request).getUserInfo().getUserCode();
        long unreadMsg = this.innerMsgRecipientManager.getUnreadMessageCount(currUser);
        JsonResultUtils.writeSingleDataJson((Object)unreadMsg, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/outbox"}, method={RequestMethod.GET})
    public void listOutbox(PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        String sender = (String)searchColumn.get("sender");
        if (StringUtils.isBlank((CharSequence)sender)) {
            searchColumn.put("sender", WebOptUtils.getLoginUser((HttpServletRequest)request).getUserInfo().getUserCode());
        }
        List listObjects = this.innerMsgManager.listObjects(searchColumn, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)DictionaryMapUtils.objectsToJSONArray((Collection)listObjects));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/cangivenotify"}, method={RequestMethod.GET})
    public void cangivenotify(HttpServletResponse response) {
        boolean s = CodeRepositoryUtil.checkUserOptPower((String)"MSGMAG", (String)"givenotify");
        JsonResultUtils.writeSingleDataJson((Object)s, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{msgCode}"}, method={RequestMethod.GET})
    public void getInnerMsg(@PathVariable String msgCode, HttpServletResponse response) {
        InnerMsgRecipient msgCopy = this.innerMsgRecipientManager.getObjectById(msgCode);
        JsonResultUtils.writeSingleDataJson((Object)msgCopy, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/notice"}, method={RequestMethod.GET})
    public void listnotify(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        searchColumn.put("msgType", "A");
        List listObjects = this.innerMsgManager.listObjects(searchColumn, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)DictionaryMapUtils.objectsToJSONArray((Collection)listObjects));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getIncludePropPreFilter(InnerMsg.class, (String[])field));
    }

    @RequestMapping(value={"/notify/{unitCode}"}, method={RequestMethod.POST})
    public void noticeByUnit(@PathVariable String unitCode, @Valid InnerMsg innerMsg, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!StringUtils.isNotBlank((CharSequence)innerMsg.getSender())) {
            innerMsg.setSender(WebOptUtils.getLoginUser((HttpServletRequest)request).getUserInfo().getUserCode());
        }
        if (null == innerMsg.getSendDate()) {
            innerMsg.setSendDate(new Date());
        }
        this.innerMsgRecipientManager.noticeByUnitCode(unitCode, innerMsg);
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/sendMsg"}, method={RequestMethod.POST})
    public void sendMsg(@Valid InnerMsgRecipient recipient, HttpServletRequest request, HttpServletResponse response) {
        this.innerMsgRecipientManager.sendMsg(recipient, this.getLoginUser(request).getUserInfo().getUserCode());
        JsonResultUtils.writeSingleDataJson((Object)recipient, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/loginuser"}, method={RequestMethod.GET})
    public void getLoginUserCode(HttpServletResponse response, HttpServletRequest request) {
        String userCode = this.getLoginUser(request).getUserInfo().getUserCode();
        JsonResultUtils.writeSingleDataJson((Object)userCode, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{msgCode}"}, method={RequestMethod.PUT})
    public void mergInnerMsg(@Valid InnerMsg msg, @PathVariable String msgCode, HttpServletResponse response) {
        InnerMsg msgCopy = this.innerMsgManager.getObjectById(msgCode);
        if (null == msgCopy) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u673a\u6784\u4e2d\u65e0\u6b64\u4fe1\u606f", (HttpServletResponse)response);
            return;
        }
        this.innerMsgManager.updateInnerMsg(msg);
        JsonResultUtils.writeSingleDataJson((Object)msg, (HttpServletResponse)response);
    }

    @RequestMapping(value={"recipient/{id}"}, method={RequestMethod.PUT})
    public void mergInnerMsgRecipient(@Valid InnerMsgRecipient recipient, @PathVariable String id, HttpServletResponse response) {
        InnerMsgRecipient recipientCopy = this.innerMsgRecipientManager.getObjectById(id);
        if (null == recipientCopy) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u673a\u6784\u4e2d\u65e0\u6b64\u4fe1\u606f", (HttpServletResponse)response);
            return;
        }
        this.innerMsgRecipientManager.updateRecipient(recipient);
        JsonResultUtils.writeSingleDataJson((Object)recipient, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{msgCode}"}, method={RequestMethod.DELETE})
    public void deleteMsg(@PathVariable String msgCode, HttpServletResponse response) {
        this.innerMsgManager.deleteMsgById(msgCode);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/recipient/{id}"}, method={RequestMethod.DELETE})
    public void deleteRecipient(@PathVariable String id, HttpServletRequest request, HttpServletResponse response) {
        this.innerMsgRecipientManager.deleteOneRecipientById(id);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logDeleteObject((HttpServletRequest)request, (String)"recipient", (String)id, (String)"delete", (String)"\u5220\u9664\u63a5\u6536\u8fd9\u4fe1\u606f", (Object)"");
    }

    @RequestMapping(value={"/{sender}/{receiver}"}, method={RequestMethod.GET})
    public void getMsgExchanges(@PathVariable String sender, @PathVariable String receiver, HttpServletResponse response) {
        List recipientlist = this.innerMsgRecipientManager.getExchangeMsgs(sender, receiver);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)recipientlist);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }
}

