/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.ViewDataTransform;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.system.po.OptInfo;
import com.centit.framework.system.po.OptMethod;
import com.centit.framework.system.service.OptInfoManager;
import com.centit.framework.system.service.OptMethodManager;
import com.centit.framework.system.service.SysRoleManager;
import com.centit.support.json.JsonPropertyUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/optinfo"})
public class OptInfoController
extends BaseController {
    @Resource
    private OptInfoManager optInfoManager;
    @Resource
    private OptMethodManager optMethodManager;
    @Resource
    @NotNull
    private SysRoleManager sysRoleManager;
    @Resource
    private PlatformEnvironment platformEnvironment;

    public String getOptId() {
        return "OPTINFO";
    }

    @RequestMapping(value={"/sub"}, method={RequestMethod.GET})
    public void listFromParent(String id, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            searchColumn.put("preOptId", id);
        } else {
            searchColumn.put("NP_TOPOPT", "true");
        }
        List listObjects = this.optInfoManager.listObjects(searchColumn);
        Iterator iterator = listObjects.iterator();
        while (iterator.hasNext()) {
            OptInfo opt;
            opt.setState(this.optInfoManager.hasChildren((opt = (OptInfo)iterator.next()).getOptId()) ? "closed" : "open");
        }
        JsonResultUtils.writeSingleDataJson((Object)this.makeMenuFuncsJson(listObjects), (HttpServletResponse)response);
    }

    private JSONArray makeMenuFuncsJson(List<OptInfo> menuFunsByUser) {
        return ViewDataTransform.makeTreeViewJson(menuFunsByUser, (Map)ViewDataTransform.createStringHashMap((String[])new String[]{"id", "optId", "optId", "optId", "optCode", "optId", "pid", "preOptId", "text", "optName", "url", "optRoute", "icon", "icon", "children", "children", "isInToolbar", "isInToolbar", "state", "state", "optMethods", "optMethods"}), (jsonObject, obj) -> jsonObject.put("external", (Object)(!"D".equals(obj.getPageType()) ? 1 : 0)));
    }

    @RequestMapping(method={RequestMethod.GET})
    public void listAll(String[] field, boolean struct, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        List listObjects = this.optInfoManager.listObjects(searchColumn);
        if (struct) {
            listObjects = this.optInfoManager.listObjectFormatTree(listObjects, false);
        }
        if (ArrayUtils.isNotEmpty((Object[])field)) {
            JsonResultUtils.writeSingleDataJson((Object)listObjects, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getIncludePropPreFilter(OptInfo.class, (String[])field));
        } else {
            JsonResultUtils.writeSingleDataJson((Object)listObjects, (HttpServletResponse)response);
        }
    }

    @RequestMapping(value={"/poweropts"}, method={RequestMethod.GET})
    public void listPowerOpts(HttpServletResponse response) {
        List listObjects = this.optInfoManager.listSysAndOptPowerOpts();
        listObjects = this.optInfoManager.listObjectFormatTree(listObjects, true);
        JsonResultUtils.writeSingleDataJson((Object)this.makeMenuFuncsJson(listObjects), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/itempoweropts"}, method={RequestMethod.GET})
    public void listItemPowerOpts(String[] field, HttpServletResponse response) {
        List listObjects = this.optInfoManager.listItemPowerOpts();
        listObjects = this.optInfoManager.listObjectFormatTree(listObjects, true);
        if (ArrayUtils.isNotEmpty((Object[])field)) {
            JsonResultUtils.writeSingleDataJson((Object)listObjects, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getIncludePropPreFilter(OptInfo.class, (String[])field));
        } else {
            JsonResultUtils.writeSingleDataJson((Object)listObjects, (HttpServletResponse)response);
        }
    }

    @RequestMapping(value={"/unitpoweropts/{unitCode}"}, method={RequestMethod.GET})
    public void listUnitPowerOpts(@PathVariable String unitCode, String[] field, HttpServletResponse response) {
        List listObjects = this.optInfoManager.listOptWithPowerUnderUnit(unitCode);
        listObjects = this.optInfoManager.listObjectFormatTree(listObjects, false);
        JsonResultUtils.writeSingleDataJson((Object)this.makeMenuFuncsJson(listObjects), (HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST})
    @RecordOperationLog(content="\u65b0\u589e\u83dc\u5355")
    public void createOptInfo(@Valid OptInfo optInfo, HttpServletRequest request, HttpServletResponse response) {
        OptInfo parentOpt;
        if (StringUtils.isBlank((CharSequence)optInfo.getOptRoute())) {
            optInfo.setOptRoute("...");
        }
        if (StringUtils.isBlank((CharSequence)optInfo.getOptUrl()) || "...".equals(optInfo.getOptUrl())) {
            optInfo.setOptUrl(optInfo.getOptRoute());
        }
        if ((parentOpt = this.optInfoManager.getOptInfoById(optInfo.getPreOptId())) == null) {
            optInfo.setPreOptId("0");
        }
        this.optInfoManager.saveNewOptInfo(optInfo);
        this.sysRoleManager.loadRoleSecurityMetadata();
        JsonResultUtils.writeSingleDataJson((Object)optInfo, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/notexists/{optId}"}, method={RequestMethod.GET})
    public void isNotExists(@PathVariable String optId, HttpServletResponse response) throws IOException {
        OptInfo optInfo = this.optInfoManager.getObjectById(optId);
        JsonResultUtils.writeOriginalObject((Object)(null == optInfo ? 1 : 0), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{optId}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u66f4\u65b0\u83dc\u5355")
    public void edit(@PathVariable String optId, @Valid OptInfo optInfo, HttpServletRequest request, HttpServletResponse response) {
        OptInfo parentOpt;
        OptInfo dbOptInfo = this.optInfoManager.getObjectById(optId);
        if (null == dbOptInfo) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        if (!StringUtils.equals((CharSequence)dbOptInfo.getPreOptId(), (CharSequence)optInfo.getPreOptId()) && (parentOpt = this.optInfoManager.getOptInfoById(optInfo.getPreOptId())) == null) {
            optInfo.setPreOptId(dbOptInfo.getPreOptId());
        }
        if (!this.optInfoManager.hasChildren(optId) && (StringUtils.isBlank((CharSequence)optInfo.getOptUrl()) || "...".equals(optInfo.getOptUrl()))) {
            optInfo.setOptUrl(optInfo.getOptRoute());
        }
        BeanUtils.copyProperties((Object)optInfo, (Object)dbOptInfo, (String[])new String[]{"optMethods", "dataScopes"});
        this.optInfoManager.updateOptInfo(dbOptInfo);
        JsonResultUtils.writeSingleDataJson((Object)dbOptInfo, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/editpower{optId}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u66f4\u65b0\u64cd\u4f5c\u6743\u9650")
    public void editPower(@PathVariable String optId, @Valid OptInfo optInfo, HttpServletRequest request, HttpServletResponse response) {
        OptInfo parentOpt;
        OptInfo dbOptInfo = this.optInfoManager.getObjectById(optId);
        if (null == dbOptInfo) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        if (!StringUtils.equals((CharSequence)dbOptInfo.getPreOptId(), (CharSequence)optInfo.getPreOptId()) && (parentOpt = this.optInfoManager.getOptInfoById(optInfo.getPreOptId())) == null) {
            optInfo.setPreOptId(dbOptInfo.getPreOptId());
        }
        for (OptMethod optDef : optInfo.getOptMethods()) {
            if (!StringUtils.isBlank((CharSequence)optDef.getOptCode())) continue;
            optDef.setOptCode(this.optMethodManager.getNextOptCode());
        }
        BeanUtils.copyProperties((Object)optInfo, (Object)dbOptInfo, (String[])new String[]{"optMethods", "dataScopes"});
        dbOptInfo.addAllOptMethods(optInfo.getOptMethods());
        dbOptInfo.addAllDataScopes(optInfo.getDataScopes());
        this.optInfoManager.updateOperationPower(dbOptInfo);
        this.sysRoleManager.loadRoleSecurityMetadata();
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/{optId}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u5220\u9664\u83dc\u5355")
    public void delete(@PathVariable String optId, HttpServletRequest request, HttpServletResponse response) {
        OptInfo dboptInfo = this.optInfoManager.getObjectById(optId);
        this.optInfoManager.deleteOptInfo(dboptInfo);
        this.sysRoleManager.loadRoleSecurityMetadata();
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/{optId}"}, method={RequestMethod.GET})
    public void getOptInfoById(@PathVariable String optId, HttpServletResponse response) {
        OptInfo dbOptInfo = this.optInfoManager.getOptInfoById(optId);
        JsonResultUtils.writeSingleDataJson((Object)dbOptInfo, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/nextOptCode"}, method={RequestMethod.GET})
    public void getNextOptCode(HttpServletResponse response) {
        String optCode = this.optMethodManager.getNextOptCode();
        ResponseMapData responseData = new ResponseMapData();
        responseData.addResponseData("optCode", (Object)optCode);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)responseData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{optId}/{optCode}"}, method={RequestMethod.POST, RequestMethod.PUT})
    public void optDefEdit(@PathVariable String optId, @PathVariable String optCode, @Valid OptMethod optDef, HttpServletResponse response) {
        OptInfo optInfo = this.optInfoManager.getObjectById(optId);
        if (null == optInfo) {
            JsonResultUtils.writeSingleErrorDataJson((int)500, (String)"\u6570\u636e\u5e93\u4e0d\u5339\u914d", (Object)("\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728optId\u4e3a" + optId + "\u7684\u4e1a\u52a1\u4fe1\u606f\u3002"), (HttpServletResponse)response);
            return;
        }
        OptMethod dbOptDef = this.optMethodManager.getObjectById(optCode);
        if (null == dbOptDef) {
            optDef.setOptId(optId);
            this.optMethodManager.updateOptMethod(optDef);
        } else {
            BeanUtils.copyProperties((Object)optInfo, (Object)dbOptDef, (String[])new String[]{"optInfo"});
            this.optMethodManager.updateOptMethod(dbOptDef);
        }
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/allOptInfo"}, method={RequestMethod.GET})
    public void loadAllOptInfo(HttpServletResponse response) {
        List optInfos = this.optInfoManager.listObjects();
        JsonResultUtils.writeSingleDataJson((Object)optInfos, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/allOptMethod"}, method={RequestMethod.GET})
    public void loadAllOptMethod(HttpServletResponse response) {
        List optDefs = this.optMethodManager.listObjects();
        JsonResultUtils.writeSingleDataJson((Object)optDefs, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/userpoweropts/{userCode}"}, method={RequestMethod.GET})
    public void listUserOpts(@PathVariable String userCode, HttpServletResponse response) {
        List optInfos = this.optInfoManager.listUserAllPower(userCode, false);
        optInfos = this.optInfoManager.listObjectFormatTree(optInfos, true);
        JsonResultUtils.writeSingleDataJson((Object)this.makeMenuFuncsJson(optInfos), (HttpServletResponse)response);
    }
}

