/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.system.po.OptLog;
import com.centit.framework.system.service.OptLogManager;
import com.centit.support.database.utils.PageDesc;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/optlog"})
public class OptLogController
extends BaseController {
    @Resource
    @NotNull
    private OptLogManager optLogManager;

    public String getOptId() {
        return "OPTLOG";
    }

    @RequestMapping
    public void list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        JSONArray jsonArray = this.optLogManager.listObjectsAsJson(field, searchColumn, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)jsonArray);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        resData.addResponseData("ORDER_BY", searchColumn.get("ORDER_BY"));
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{logId}"}, method={RequestMethod.GET})
    public void getOptLogById(@PathVariable Long logId, HttpServletResponse response) {
        OptLog dbOptLog = this.optLogManager.getObjectById(logId);
        if (null == dbOptLog) {
            JsonResultUtils.writeErrorMessageJson((String)"\u65e5\u5fd7\u4fe1\u606f\u4e0d\u5b58\u5728", (HttpServletResponse)response);
        }
        JsonResultUtils.writeSingleDataJson((Object)dbOptLog, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{logId}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u5220\u9664\u65e5\u5fd7")
    public void deleteOne(@PathVariable Long logId, HttpServletRequest request, HttpServletResponse response) {
        OptLog optLog = this.optLogManager.getObjectById(logId);
        this.optLogManager.deleteObjectById(logId);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/deleteMany"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u5220\u9664\u65e5\u5fd7")
    public void deleteMany(Long[] logIds, HttpServletRequest request, HttpServletResponse response) {
        this.optLogManager.deleteMany(logIds);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u5220\u9664\u65e5\u5fd7")
    public void deleteByTime(Date begin, Date end, HttpServletResponse response) {
        this.optLogManager.delete(begin, end);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }
}

