/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.system.po.RoleInfo;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.po.UserRole;
import com.centit.framework.system.po.UserRoleId;
import com.centit.framework.system.service.SysRoleManager;
import com.centit.framework.system.service.SysUnitManager;
import com.centit.framework.system.service.SysUserRoleManager;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.json.JsonPropertyUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/userrole"})
public class UserRoleController
extends BaseController {
    @Resource
    @NotNull
    private SysRoleManager sysRoleManager;
    @Resource
    @NotNull
    private SysUserRoleManager sysUserRoleManager;
    @Resource
    private SysUnitManager sysUnitManager;

    public String getOptId() {
        return "USERROLE";
    }

    @RequestMapping(value={"/roleusersinherited/{roleCode}"}, method={RequestMethod.GET})
    public void listUserRoleSInherited(@PathVariable String roleCode, PageDesc pageDesc, HttpServletResponse response) {
        HashMap<String, String> filterMap = new HashMap<String, String>(8);
        filterMap.put("roleCode", roleCode);
        filterMap.put("obtainType", "I");
        JSONArray listObjects = this.sysUserRoleManager.pageQueryUserRole(filterMap, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/userrolesinherited/{userCode}"}, method={RequestMethod.GET})
    public void listRoleUsersInherited(@PathVariable String userCode, PageDesc pageDesc, HttpServletResponse response) {
        HashMap<String, String> filterMap = new HashMap<String, String>(8);
        filterMap.put("userCode", userCode);
        filterMap.put("obtainType", "I");
        JSONArray listObjects = this.sysUserRoleManager.pageQueryUserRole(filterMap, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/userrolesall/{userCode}"}, method={RequestMethod.GET})
    public void listRoleUsersAll(@PathVariable String userCode, PageDesc pageDesc, HttpServletResponse response) {
        HashMap<String, String> filterMap = new HashMap<String, String>(8);
        filterMap.put("userCode", userCode);
        JSONArray listObjects = this.sysUserRoleManager.pageQueryUserRole(filterMap, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    protected void listObject(Map<String, Object> filterMap, PageDesc pageDesc, HttpServletResponse response) {
        JSONArray listObjects = this.sysUserRoleManager.listObjects(filterMap, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        HashMap<Class<RoleInfo>, String[]> excludes = new HashMap<Class<RoleInfo>, String[]>();
        excludes.put(RoleInfo.class, new String[]{"rolePowers"});
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getExcludePropPreFilter(excludes));
    }

    @RequestMapping(value={"/userroles/{userCode}"}, method={RequestMethod.GET})
    public void listRolesByUser(@PathVariable String userCode, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map filterMap = BaseController.convertSearchColumn((HttpServletRequest)request);
        filterMap.put("userCode", userCode);
        filterMap.put("roleValid", "T");
        this.listObject(filterMap, pageDesc, response);
    }

    @RequestMapping(value={"/roleusers/{roleCode}"}, method={RequestMethod.GET})
    public void listUsersByRole(@PathVariable String roleCode, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map filterMap = BaseController.convertSearchColumn((HttpServletRequest)request);
        filterMap.put("roleCode", roleCode);
        filterMap.put("userValid", "T");
        this.listObject(filterMap, pageDesc, response);
    }

    @RequestMapping(value={"/rolecurrentusers/{roleCode}"}, method={RequestMethod.GET})
    public void listCurrentUsersByRole(@PathVariable String roleCode, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        String currentUnitCode = WebOptUtils.getLoginUser().getCurrentUnitCode();
        UnitInfo currentUnitInfo = this.sysUnitManager.getObjectById(currentUnitCode);
        Map filterMap = BaseController.convertSearchColumn((HttpServletRequest)request);
        filterMap.put("roleCode", roleCode);
        filterMap.put("unitPath", currentUnitInfo.getUnitPath());
        filterMap.put("userValid", "T");
        this.listObject(filterMap, pageDesc, response);
    }

    @RequestMapping(value={"/usercurrentroles/{userCode}"}, method={RequestMethod.GET})
    public void listUserUnitRoles(@PathVariable String userCode, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map filterMap = BaseController.convertSearchColumn((HttpServletRequest)request);
        String currentUnitCode = WebOptUtils.getLoginUser().getCurrentUnitCode();
        filterMap.put("userCode", userCode);
        filterMap.put("roleUnitCode", currentUnitCode);
        filterMap.put("roleValid", "T");
        this.listObject(filterMap, pageDesc, response);
    }

    @RequestMapping(value={"/unitroleusers/{unitCode}/{roleCode}"}, method={RequestMethod.GET})
    public void listUnitRoleUsers(@PathVariable String unitCode, @PathVariable String roleCode, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        RoleInfo role = this.sysRoleManager.getObjectById(roleCode);
        Map filterMap = BaseController.convertSearchColumn((HttpServletRequest)request);
        filterMap.put("roleCode", roleCode);
        if (role != null && "P".equals(role.getRoleType())) {
            filterMap.put("unitCode", unitCode);
        }
        this.listObject(filterMap, pageDesc, response);
    }

    @RequestMapping(value={"/{roleCode}/{userCode}"}, method={RequestMethod.GET})
    public void getUserRole(@PathVariable String roleCode, @PathVariable String userCode, HttpServletResponse response) {
        UserRole userRole = this.sysUserRoleManager.getObjectById(new UserRoleId(userCode, roleCode));
        if (null == userRole) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u89d2\u8272\u4e2d\u65e0\u6b64\u7528\u6237", (HttpServletResponse)response);
            return;
        }
        HashMap<Class<RoleInfo>, String[]> excludes = new HashMap<Class<RoleInfo>, String[]>();
        excludes.put(RoleInfo.class, new String[]{"rolePowers"});
        JsonResultUtils.writeSingleDataJson((Object)userRole, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getExcludePropPreFilter(excludes));
    }

    @RequestMapping(method={RequestMethod.POST})
    @RecordOperationLog(content="\u65b0\u589e\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f")
    public void create(@Valid UserRole userRole, @Valid String[] userCode, HttpServletRequest request, HttpServletResponse response) {
        userRole.setCreateDate(new Date());
        if (userCode != null && userCode.length > 0) {
            for (String u : userCode) {
                UserRole ur = new UserRole();
                ur.copy(userRole);
                ur.setUserCode(u);
                this.sysUserRoleManager.mergeObject(ur);
            }
        } else {
            this.sysUserRoleManager.mergeObject(userRole);
        }
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/{roleCode}/{userCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u66f4\u65b0\u7528\u6237\u89d2\u8272\u4fe1\u606f")
    public void edit(@PathVariable String roleCode, @PathVariable String userCode, @Valid UserRole userRole, HttpServletRequest request, HttpServletResponse response) {
        UserRole dbUserRole = this.sysUserRoleManager.getObjectById(new UserRoleId(userCode, roleCode));
        if (null == userRole) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u89d2\u8272\u4e2d\u65e0\u6b64\u7528\u6237", (HttpServletResponse)response);
            return;
        }
        this.sysUserRoleManager.mergeObject(dbUserRole, userRole);
        JsonResultUtils.writeSingleDataJson((Object)userRole, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{roleCode}/{userCodes}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u5220\u9664\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f")
    public void delete(@PathVariable String roleCode, @PathVariable String userCodes, HttpServletRequest request, HttpServletResponse response) {
        String[] userCodeArray;
        for (String userCode : userCodeArray = userCodes.split(",")) {
            UserRoleId userRoleId = new UserRoleId(userCode, roleCode);
            UserRole userRole = this.sysUserRoleManager.getObjectById(userRoleId);
            this.sysUserRoleManager.deleteObjectById(userRoleId);
        }
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/ban/{roleCode}/{userCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u5220\u9664\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f")
    public void ban(@PathVariable String roleCode, @PathVariable String userCode, HttpServletRequest request, HttpServletResponse response) {
        UserRoleId a = new UserRoleId(userCode, roleCode);
        UserRole userRole = this.sysUserRoleManager.getObjectById(a);
        this.sysUserRoleManager.deleteObjectById(a);
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }
}

