/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.system.po.QueryFilterCondition;
import com.centit.framework.system.service.QueryFilterConditionManager;
import com.centit.support.database.utils.PageDesc;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/queryfiltercondition"})
public class QueryFilterConditionController
extends BaseController {
    @Resource
    private QueryFilterConditionManager queryFilterConditionMag;

    public String getOptId() {
        return "QueryFilter";
    }

    @RequestMapping(method={RequestMethod.GET})
    public void list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        JSONArray listObjects = this.queryFilterConditionMag.listQueryFilterConditionsAsJson(field, searchColumn, pageDesc);
        if (null == pageDesc) {
            JsonResultUtils.writeSingleDataJson((Object)listObjects, (HttpServletResponse)response);
            return;
        }
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{conditionNo}"}, method={RequestMethod.GET})
    public void getQueryFilterCondition(@PathVariable Long conditionNo, HttpServletResponse response) {
        QueryFilterCondition queryFilterCondition = this.queryFilterConditionMag.getObjectById(conditionNo);
        JsonResultUtils.writeSingleDataJson((Object)queryFilterCondition, (HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST})
    public void createQueryFilterCondition(@Valid QueryFilterCondition queryFilterCondition, HttpServletResponse response) {
        Long pk = this.queryFilterConditionMag.saveNewObject(queryFilterCondition);
        JsonResultUtils.writeSingleDataJson((Object)pk, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{conditionNo}"}, method={RequestMethod.DELETE})
    public void deleteQueryFilterCondition(@PathVariable Long conditionNo, HttpServletResponse response) {
        this.queryFilterConditionMag.deleteObjectById(conditionNo);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/{conditionNo}"}, method={RequestMethod.PUT})
    public void updateQueryFilterCondition(@PathVariable Long conditionNo, @Valid QueryFilterCondition queryFilterCondition, HttpServletResponse response) {
        QueryFilterCondition dbQueryFilterCondition = this.queryFilterConditionMag.getObjectById(conditionNo);
        if (null == queryFilterCondition) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        dbQueryFilterCondition.copy(queryFilterCondition);
        this.queryFilterConditionMag.mergeObject(dbQueryFilterCondition);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }
}

