/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.IUserUnit;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.system.po.OptMethod;
import com.centit.framework.system.po.RoleInfo;
import com.centit.framework.system.po.RolePower;
import com.centit.framework.system.po.RolePowerId;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.service.OptMethodManager;
import com.centit.framework.system.service.SysRoleManager;
import com.centit.framework.system.service.SysUnitRoleManager;
import com.centit.framework.system.service.SysUserRoleManager;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.json.JsonPropertyUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/roleinfo"})
public class RoleInfoController
extends BaseController {
    @Resource
    @NotNull
    private SysRoleManager sysRoleManager;
    @Resource
    protected PlatformEnvironment platformEnvironment;
    @Resource
    @NotNull
    private OptMethodManager optMethodManager;
    @Resource
    private SysUserRoleManager sysUserRoleManager;
    @Resource
    private SysUnitRoleManager sysUnitRoleManager;

    public String getOptId() {
        return "ROLEMAG";
    }

    private void writeRoleListToResponse(List<RoleInfo> roleInfos, String[] field, PageDesc pageDesc, HttpServletResponse response) {
        ResponseMapData respData = new ResponseMapData();
        respData.addResponseData("objList", roleInfos);
        respData.addResponseData("pageDesc", (Object)pageDesc);
        if (ArrayUtils.isNotEmpty((Object[])field)) {
            JsonResultUtils.writeResponseDataAsJson((ResponseData)respData, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getIncludePropPreFilter(RoleInfo.class, (String[])field));
        } else {
            JsonResultUtils.writeResponseDataAsJson((ResponseData)respData, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getExcludePropPreFilter(RoleInfo.class, (String[])new String[]{"rolePowers", "userRoles"}));
        }
    }

    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    public void listAllRole(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map filterMap = BaseController.convertSearchColumn((HttpServletRequest)request);
        filterMap.put("NP_ALL", "true");
        List roleInfos = this.sysRoleManager.listObjects(filterMap, pageDesc);
        this.writeRoleListToResponse(roleInfos, field, pageDesc, response);
    }

    @RequestMapping(value={"/global"}, method={RequestMethod.GET})
    public void listGlobalAndPublicRole(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map filterMap = BaseController.convertSearchColumn((HttpServletRequest)request);
        filterMap.put("NP_GLOBAL", "true");
        filterMap.put("isValid", "T");
        List roleInfos = this.sysRoleManager.listObjects(filterMap, pageDesc);
        this.writeRoleListToResponse(roleInfos, field, pageDesc, response);
    }

    @GetMapping(value={"/currentunit"})
    public void listUnitAndPublicRole(PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        String currentUnit = WebOptUtils.getLoginUser().getCurrentUnitCode();
        Map filterMap = BaseController.convertSearchColumn((HttpServletRequest)request);
        filterMap.put("publicUnitRole", currentUnit);
        List roleInfos = this.sysRoleManager.listObjects(filterMap, pageDesc);
        ResponseMapData respData = new ResponseMapData();
        respData.addResponseData("objList", (Object)roleInfos);
        respData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)respData, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getExcludePropPreFilter(RoleInfo.class, (String[])new String[]{"rolePowers", "userRoles"}));
    }

    @RequestMapping(value={"/item"}, method={RequestMethod.GET})
    public void listItemRole(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map filterMap = BaseController.convertSearchColumn((HttpServletRequest)request);
        filterMap.put("ROLETYPE", "I");
        List roleInfos = this.sysRoleManager.listObjects(filterMap, pageDesc);
        ResponseMapData respData = new ResponseMapData();
        respData.addResponseData("objList", (Object)roleInfos);
        respData.addResponseData("pageDesc", (Object)pageDesc);
        if (ArrayUtils.isNotEmpty((Object[])field)) {
            JsonResultUtils.writeResponseDataAsJson((ResponseData)respData, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getIncludePropPreFilter(RoleInfo.class, (String[])field));
        } else {
            JsonResultUtils.writeResponseDataAsJson((ResponseData)respData, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getExcludePropPreFilter(RoleInfo.class, (String[])new String[]{"rolePowers", "userRoles"}));
        }
    }

    @RequestMapping(value={"/power/role/{roleCode}"}, method={RequestMethod.GET})
    public void getRolePowerByRoleCode(@PathVariable String roleCode, HttpServletResponse response) {
        List rolePowers = this.sysRoleManager.getRolePowers(roleCode);
        JsonResultUtils.writeSingleDataJson((Object)rolePowers, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/power/defCode/{defCode}"}, method={RequestMethod.GET})
    public void getRolePowerByOptCode(@PathVariable String defCode, HttpServletResponse response) {
        List rolePowers = this.sysRoleManager.getRolePowersByDefCode(defCode);
        JsonResultUtils.writeSingleDataJson((Object)rolePowers, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/power/optCode/{optId}"}, method={RequestMethod.GET})
    public void getRolePowerByOptId(@PathVariable String optId, HttpServletResponse response) {
        ArrayList result = new ArrayList();
        List optDefs = this.optMethodManager.listOptMethodByOptID(optId);
        for (OptMethod def : optDefs) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            List rolePowers = this.sysRoleManager.getRolePowersByDefCode(def.getOptCode());
            temp.put("optDef", def);
            temp.put("rolePowers", rolePowers);
            result.add(temp);
        }
        JsonResultUtils.writeSingleDataJson(result, (HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST})
    @RecordOperationLog(content="\u65b0\u589e\u89d2\u8272")
    public void createGlobalRole(@Valid RoleInfo roleInfo, HttpServletRequest request, HttpServletResponse response) {
        String roleType = roleInfo.getRoleType();
        if (StringUtils.isBlank((CharSequence)roleType)) {
            JsonResultUtils.writeErrorMessageJson((String)"\u65b0\u5efa\u89d2\u8272\u5fc5\u987b\u6307\u5b9a\u89d2\u8272\u7c7b\u522b\u3002", (HttpServletResponse)response);
            return;
        }
        if ("D".equals(roleType) && StringUtils.isBlank((CharSequence)roleInfo.getUnitCode())) {
            roleInfo.setUnitCode(super.getLoginUser(request).getCurrentUnitCode());
        }
        roleInfo.setCreator(WebOptUtils.getLoginUserName((HttpServletRequest)request));
        roleInfo.setCreateDate(new Date());
        this.sysRoleManager.saveNewRoleInfo(roleInfo);
        this.platformEnvironment.reloadSecurityMetadata();
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/addopt/{roleCode}/{optCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u7ed9\u89d2\u8272\u6dfb\u52a0\u6743\u9650")
    public void addOptToRole(@PathVariable String roleCode, @PathVariable String optCode, HttpServletRequest request, HttpServletResponse response) {
        RoleInfo dbRoleInfo = this.sysRoleManager.getObjectById(roleCode);
        if (null == dbRoleInfo) {
            JsonResultUtils.writeErrorMessageJson((String)"\u89d2\u8272\u4fe1\u606f\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        RolePower rolePower = new RolePower(new RolePowerId(roleCode, optCode));
        if (dbRoleInfo.getRolePowers().contains(rolePower)) {
            JsonResultUtils.writeBlankJson((HttpServletResponse)response);
            return;
        }
        dbRoleInfo.getRolePowers().add(rolePower);
        this.sysRoleManager.updateRoleInfo(dbRoleInfo);
        this.platformEnvironment.reloadSecurityMetadata();
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/delopt/{roleCode}/{optCode}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u5220\u9664\u89d2\u8272\u6743\u9650")
    public void deleteOptFormRole(@PathVariable String roleCode, @PathVariable String optCode, HttpServletRequest request, HttpServletResponse response) {
        RoleInfo dbRoleInfo = this.sysRoleManager.getObjectById(roleCode);
        if (null == dbRoleInfo) {
            JsonResultUtils.writeErrorMessageJson((String)"\u89d2\u8272\u4fe1\u606f\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        RolePower rolePower = new RolePower(new RolePowerId(roleCode, optCode));
        if (!dbRoleInfo.getRolePowers().contains(rolePower)) {
            JsonResultUtils.writeBlankJson((HttpServletResponse)response);
            return;
        }
        dbRoleInfo.getRolePowers().remove(rolePower);
        this.sysRoleManager.updateRoleInfo(dbRoleInfo);
        this.platformEnvironment.reloadSecurityMetadata();
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/{roleCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u66f4\u65b0\u89d2\u8272")
    public void edit(@PathVariable String roleCode, @Valid RoleInfo roleInfo, HttpServletRequest request, HttpServletResponse response) {
        RoleInfo dbRoleInfo = this.sysRoleManager.getObjectById(roleCode);
        if (null == dbRoleInfo) {
            JsonResultUtils.writeErrorMessageJson((String)"\u89d2\u8272\u4fe1\u606f\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        RoleInfo oldValue = new RoleInfo();
        oldValue.copy(dbRoleInfo);
        this.sysRoleManager.updateRoleInfo(roleInfo);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/power/{roleCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u66f4\u65b0\u89d2\u8272\u6743\u9650")
    public void updateRolePower(@PathVariable String roleCode, RoleInfo roleInfo, HttpServletRequest request, HttpServletResponse response) {
        RoleInfo dbRoleInfo = this.sysRoleManager.getObjectById(roleCode);
        if (null == dbRoleInfo) {
            JsonResultUtils.writeErrorMessageJson((String)"\u89d2\u8272\u4fe1\u606f\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        RoleInfo oldRoleInfo = new RoleInfo();
        oldRoleInfo.copy(dbRoleInfo);
        dbRoleInfo.setRolePowers(roleInfo.getRolePowers());
        List oldRolePowers = this.sysRoleManager.updateRolePower(dbRoleInfo);
        oldRoleInfo.setRolePowers(oldRolePowers);
        this.platformEnvironment.reloadSecurityMetadata();
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @GetMapping(value={"/issysroleunique/{roleName}"})
    public void isSysRoleNotExist(@PathVariable String roleName, HttpServletResponse response) {
        JsonResultUtils.writeOriginalObject((Object)this.sysRoleManager.judgeSysRoleNameExist(roleName, null, null), (HttpServletResponse)response);
    }

    @GetMapping(value={"/issysroleunique/{roleName}/{roleCode}"})
    public void isSysRoleUnique(@PathVariable String roleName, @PathVariable String roleCode, HttpServletResponse response) {
        JsonResultUtils.writeOriginalObject((Object)this.sysRoleManager.judgeSysRoleNameExist(roleName, roleCode, null), (HttpServletResponse)response);
    }

    @GetMapping(value={"/isunitroleunique/{unitCode}/{roleName}"})
    public void isUnitRoleNotExist(@PathVariable String unitCode, @PathVariable String roleName, HttpServletResponse response) {
        JsonResultUtils.writeOriginalObject((Object)this.sysRoleManager.judgeSysRoleNameExist(roleName, null, unitCode), (HttpServletResponse)response);
    }

    @GetMapping(value={"/isunitroleunique/{unitCode}/{roleName}/{roleCode}"})
    public void isUnitRoleUnique(@PathVariable String unitCode, @PathVariable String roleName, @PathVariable String roleCode, HttpServletResponse response) {
        JsonResultUtils.writeOriginalObject((Object)this.sysRoleManager.judgeSysRoleNameExist(roleName, roleCode, unitCode), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{roleCode}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u5220\u9664\u89d2\u8272")
    public void deleteRole(@PathVariable String roleCode, HttpServletResponse response) {
        if (StringUtils.equalsAny((CharSequence)roleCode, (CharSequence[])new CharSequence[]{"public", "anonymous", "forbidden"})) {
            JsonResultUtils.writeErrorMessageJson((String)"\u7cfb\u7edf\u5185\u7f6e\u89d2\u8272\u4e0d\u80fd\u5220\u9664\u3002", (HttpServletResponse)response);
            return;
        }
        List users = this.sysUserRoleManager.listUsersByRole(roleCode);
        boolean isValid = true;
        for (UserInfo u : users) {
            if ("T".equals(u.getIsValid())) {
                JsonResultUtils.writeErrorMessageJson((String)"\u6709\u7528\u6237\u5f15\u7528\u8fd9\u4e2a\u89d2\u8272\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (HttpServletResponse)response);
                return;
            }
            isValid = false;
        }
        if (!isValid) {
            JsonResultUtils.writeErrorMessageJson((String)"\u6709\u7981\u7528\u7528\u6237\u5f15\u7528\u8fd9\u4e2a\u89d2\u8272\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (HttpServletResponse)response);
            return;
        }
        JSONArray roleUnts = this.sysUnitRoleManager.listRoleUnits(roleCode, new PageDesc(1, 2));
        if (roleUnts != null && roleUnts.size() > 0) {
            JsonResultUtils.writeErrorMessageJson((String)"\u6709\u673a\u6784\u5f15\u7528\u8fd9\u4e2a\u89d2\u8272\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (HttpServletResponse)response);
            return;
        }
        this.sysRoleManager.deleteRoleInfo(roleCode);
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/{roleCode}"}, method={RequestMethod.GET})
    public void findRoleInfo(@PathVariable String roleCode, HttpServletResponse response) {
        RoleInfo roleInfo = this.sysRoleManager.getRoleInfo(roleCode);
        if (null == roleInfo) {
            JsonResultUtils.writeErrorMessageJson((String)"\u89d2\u8272\u4fe1\u606f\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        JsonResultUtils.writeSingleDataJson((Object)roleInfo, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/power/unit/{unitCode}"}, method={RequestMethod.GET})
    public void getUnitInfoPower(@PathVariable String unitCode, HttpServletResponse response) {
        List rolePowers = this.sysRoleManager.getRolePowers("G$" + unitCode);
        JsonResultUtils.writeSingleDataJson((Object)rolePowers, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/listRoles/{type}"}, method={RequestMethod.GET})
    public void listRoles(@PathVariable String type, String[] field, HttpServletRequest request, HttpServletResponse response) {
        if (ArrayUtils.isEmpty((Object[])field)) {
            field = new String[]{"roleCode", "roleName"};
        }
        Map filterMap = BaseController.convertSearchColumn((HttpServletRequest)request);
        filterMap.put("isValid", "T");
        if ("S".equals(type)) {
            filterMap.put("NP_unitCode", true);
        } else if ("D".equals(type)) {
            IUserUnit unit = CodeRepositoryUtil.getUserPrimaryUnit((String)super.getLoginUserCode(request));
            if (unit != null) {
                filterMap.put("publicUnitRole", unit.getUnitCode());
            } else {
                return;
            }
        }
        List listObjects = this.sysRoleManager.listObjects(filterMap);
        JsonResultUtils.writeSingleDataJson((Object)listObjects, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getIncludePropPreFilter(RoleInfo.class, (String[])field));
    }
}

