/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.RoleInfo;
import com.centit.framework.system.po.RolePower;
import com.centit.framework.system.po.RolePowerId;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.po.UnitRole;
import com.centit.framework.system.po.UserUnit;
import com.centit.framework.system.service.SysRoleManager;
import com.centit.framework.system.service.SysUnitManager;
import com.centit.framework.system.service.SysUnitRoleManager;
import com.centit.framework.system.service.SysUserManager;
import com.centit.framework.system.service.SysUserUnitManager;
import com.centit.support.algorithm.ListOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.json.JsonPropertyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/unitinfo"})
public class UnitInfoController
extends BaseController {
    @Resource
    @NotNull
    private SysUnitManager sysUnitManager;
    @Resource
    @NotNull
    private SysUserManager sysUserMag;
    @Resource
    @NotNull
    private SysUserUnitManager sysUserUnitManager;
    @Resource
    @NotNull
    private SysRoleManager sysRoleManager;
    @Resource
    @NotNull
    private SysUnitRoleManager sysUnitRoleManager;
    @Resource
    private PlatformEnvironment platformEnvironment;

    public String getOptId() {
        return "UNITMAG";
    }

    @RequestMapping(method={RequestMethod.GET})
    public void list(boolean struct, String id, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        String unitName = (String)searchColumn.get("unitName");
        if (StringUtils.isNotBlank((CharSequence)unitName) && StringUtils.isBlank((CharSequence)id)) {
            List listObjects = this.sysUnitManager.listObjects(searchColumn);
            JSONArray ja = DictionaryMapUtils.objectsToJSONArray((Collection)listObjects);
            if (struct) {
                ja = ListOpt.srotAsTreeAndToJSON((List)ja, (p, c) -> StringUtils.equals((CharSequence)((JSONObject)p).getString("unitCode"), (CharSequence)((JSONObject)c).getString("parentUnit")), (String)"children");
            }
            JsonResultUtils.writeSingleDataJson((Object)ja, (HttpServletResponse)response);
        } else {
            HashMap<String, String> filterMap = new HashMap<String, String>(2);
            if (StringUtils.isNotBlank((CharSequence)id)) {
                filterMap.put("parentUnit", id);
            } else {
                filterMap.put("NP_TOPUnit", "true");
            }
            List listObjects = this.sysUnitManager.listObjects(filterMap);
            this.sysUnitManager.checkState(listObjects);
            JSONArray ja = DictionaryMapUtils.objectsToJSONArray((Collection)listObjects);
            JsonResultUtils.writeSingleDataJson((Object)ja, (HttpServletResponse)response, null);
        }
    }

    @RequestMapping(value={"/subunits"}, method={RequestMethod.GET})
    public void listSub(String id, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        String currentUnitCode = WebOptUtils.getLoginUser().getCurrentUnitCode();
        String unitName = StringBaseOpt.castObjectToString(searchColumn.get("unitName"));
        if (StringUtils.isNotBlank((CharSequence)unitName) && StringUtils.isBlank((CharSequence)id)) {
            List listObjects = this.sysUnitManager.listObjects(searchColumn);
            JSONArray ja = DictionaryMapUtils.objectsToJSONArray((Collection)listObjects);
            JsonResultUtils.writeSingleDataJson((Object)ja, (HttpServletResponse)response);
        } else {
            HashMap<String, String> filterMap = new HashMap<String, String>(2);
            if (StringUtils.isNotBlank((CharSequence)id)) {
                filterMap.put("parentUnit", id);
            } else {
                filterMap.put("parentUnit", StringUtils.isNotBlank((CharSequence)id) ? id : currentUnitCode);
            }
            List listObjects = this.sysUnitManager.listAllSubUnits(currentUnitCode);
            JSONArray ja = DictionaryMapUtils.objectsToJSONArray((Collection)listObjects);
            for (Object o : ja) {
                ((JSONObject)o).put("state", (Object)"open");
                ((JSONObject)o).put("id", (Object)((JSONObject)o).getString("unitCode"));
                ((JSONObject)o).put("text", (Object)((JSONObject)o).getString("unitName"));
            }
            ja = ListOpt.srotAsTreeAndToJSON((List)ja, (p, c) -> StringUtils.equals((CharSequence)((JSONObject)p).getString("unitCode"), (CharSequence)((JSONObject)c).getString("parentUnit")), (String)"children");
            JsonResultUtils.writeSingleDataJson((Object)ja, (HttpServletResponse)response, null);
        }
    }

    @RequestMapping(value={"/validsubunits"}, method={RequestMethod.GET})
    public void listValidSubUnit(HttpServletRequest request, HttpServletResponse response) {
        String currentUnitCode = WebOptUtils.getLoginUser().getCurrentUnitCode();
        List listObjects = this.sysUnitManager.listValidSubUnits(currentUnitCode);
        JSONArray ja = DictionaryMapUtils.objectsToJSONArray((Collection)listObjects);
        for (Object o : ja) {
            ((JSONObject)o).put("state", (Object)"open");
            ((JSONObject)o).put("id", (Object)((JSONObject)o).getString("unitCode"));
            ((JSONObject)o).put("text", (Object)((JSONObject)o).getString("unitName"));
        }
        ja = ListOpt.srotAsTreeAndToJSON((List)ja, (p, c) -> StringUtils.equals((CharSequence)((JSONObject)p).getString("unitCode"), (CharSequence)((JSONObject)c).getString("parentUnit")), (String)"children");
        JsonResultUtils.writeSingleDataJson((Object)ja, (HttpServletResponse)response, null);
    }

    @RequestMapping(value={"/{unitCode}"}, method={RequestMethod.GET})
    public void getUnitInfo(@PathVariable String unitCode, HttpServletResponse response) {
        UnitInfo unitInfo = this.sysUnitManager.getObjectById(unitCode);
        JsonResultUtils.writeSingleDataJson((Object)unitInfo, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{unitCode}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u5220\u9664\u673a\u6784")
    public void delete(@PathVariable String unitCode, HttpServletRequest request, HttpServletResponse response) {
        UnitInfo unitInfo = this.sysUnitManager.getObjectById(unitCode);
        if (unitInfo == null) {
            JsonResultUtils.writeErrorMessageJson((String)"The object not found!", (HttpServletResponse)response);
            return;
        }
        List userUnits = this.sysUserUnitManager.listUnitUsersByUnitCode(unitCode);
        if (userUnits != null && userUnits.size() != 0) {
            JsonResultUtils.writeErrorMessageJson((String)"\u8be5\u673a\u6784\u5b58\u5728\u5173\u8054\u7528\u6237\uff0c\u4e0d\u80fd\u5220\u9664\uff01", (HttpServletResponse)response);
            return;
        }
        this.sysUnitManager.deleteUnitInfo(unitInfo);
        JSONArray unitRoles = this.sysUnitRoleManager.listUnitRoles(unitCode, new PageDesc());
        if (unitRoles != null && unitRoles.size() > 0) {
            for (Object obj : unitRoles) {
                this.sysUnitRoleManager.deleteUnitRole(unitCode, ((UnitRole)JSONObject.toJavaObject((JSON)((JSON)DictionaryMapUtils.objectToJSON(obj)), UnitRole.class)).getRoleCode());
            }
        }
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST})
    @RecordOperationLog(content="\u65b0\u589e\u673a\u6784")
    public void create(@Valid UnitInfo unitInfo, HttpServletRequest request, HttpServletResponse response) {
        if (!this.sysUnitManager.isUniqueName(unitInfo)) {
            JsonResultUtils.writeErrorMessageJson((int)702, (String)("\u673a\u6784\u540d" + unitInfo.getUnitName() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01"), (HttpServletResponse)response);
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("unitWord", unitInfo.getUnitWord());
        List unitInfos = this.sysUnitManager.listObjects(map);
        if (unitInfos != null && unitInfos.size() > 0) {
            JsonResultUtils.writeErrorMessageJson((int)702, (String)("\u673a\u6784\u7f16\u7801" + unitInfo.getUnitWord() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01"), (HttpServletResponse)response);
            return;
        }
        while (!this.sysUnitManager.isUniqueOrder(unitInfo)) {
            unitInfo.setUnitOrder(Long.valueOf(unitInfo.getUnitOrder() + 1L));
        }
        this.sysUnitManager.saveNewUnitInfo(unitInfo);
        JsonResultUtils.writeSingleDataJson((Object)unitInfo, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{unitCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u66f4\u65b0\u673a\u6784")
    public void edit(@PathVariable String unitCode, @Valid UnitInfo unitInfo, HttpServletRequest request, HttpServletResponse response) {
        UnitInfo dbUnitInfo = this.sysUnitManager.getObjectById(unitCode);
        if (null == dbUnitInfo) {
            JsonResultUtils.writeErrorMessageJson((String)"\u673a\u6784\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        if (!this.sysUnitManager.isUniqueName(unitInfo)) {
            JsonResultUtils.writeErrorMessageJson((int)702, (String)("\u673a\u6784\u540d" + unitInfo.getUnitName() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01"), (HttpServletResponse)response);
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("unitWord", unitInfo.getUnitWord());
        List unitInfos = this.sysUnitManager.listObjects(map);
        if (unitInfos != null && unitInfos.size() > 0 && !unitCode.equals(((UnitInfo)unitInfos.get(0)).getUnitCode())) {
            JsonResultUtils.writeErrorMessageJson((int)702, (String)("\u673a\u6784\u7f16\u7801" + unitInfo.getUnitWord() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01"), (HttpServletResponse)response);
            return;
        }
        if ("F".equals(unitInfo.getIsValid())) {
            List units = this.sysUnitManager.listValidSubUnit(unitCode);
            if (units != null && units.size() != 0) {
                JsonResultUtils.writeErrorMessageJson((String)"\u8be5\u673a\u6784\u5305\u542b\u4e0b\u7ea7\u673a\u6784\uff0c\u4e0d\u80fd\u8bbe\u4e3a\u7981\u7528\uff01", (HttpServletResponse)response);
                return;
            }
            List userUnits = this.sysUserUnitManager.listUnitUsersByUnitCode(unitCode);
            if (userUnits != null && userUnits.size() != 0) {
                JsonResultUtils.writeErrorMessageJson((String)"\u8be5\u673a\u6784\u5b58\u5728\u5173\u8054\u7528\u6237\uff0c\u4e0d\u80fd\u8bbe\u4e3a\u7981\u7528\uff01", (HttpServletResponse)response);
                return;
            }
        }
        UnitInfo oldValue = new UnitInfo();
        oldValue.copy(dbUnitInfo);
        this.sysUnitManager.updateUnitInfo(unitInfo);
        JsonResultUtils.writeSingleDataJson((Object)unitInfo, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{unitCode}/status/{statusValue}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u66f4\u65b0\u673a\u6784\u72b6\u6001")
    public void changeStatus(@PathVariable String unitCode, @PathVariable String statusValue, HttpServletRequest request, HttpServletResponse response) {
        UnitInfo dbUnitInfo = this.sysUnitManager.getObjectById(unitCode);
        if (null == dbUnitInfo) {
            JsonResultUtils.writeErrorMessageJson((String)"\u673a\u6784\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        if (!"T".equals(statusValue) && !"F".equals(statusValue)) {
            JsonResultUtils.writeErrorMessageJson((String)"\u673a\u6784\u72b6\u6001\u4e0d\u6b63\u786e", (HttpServletResponse)response);
            return;
        }
        this.sysUnitManager.changeStatus(unitCode, statusValue);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/{unitCode}/children"}, method={RequestMethod.GET})
    public void listChildren(@PathVariable String unitCode, String[] field, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        searchColumn.put("parentUnit", unitCode);
        List listObjects = this.sysUnitManager.listObjects(searchColumn);
        JsonResultUtils.writeSingleDataJson((Object)listObjects, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getIncludePropPreFilter(UnitInfo.class, (String[])field));
    }

    @RequestMapping(value={"/currentunit/users"}, method={RequestMethod.GET})
    public void listUnitUsers(PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        String currentUnitCode = WebOptUtils.getLoginUser().getCurrentUnitCode();
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        searchColumn.put("unitCode", currentUnitCode);
        List listObjects = this.sysUserMag.listObjects(searchColumn, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{unitCode}/validusers"}, method={RequestMethod.GET})
    public void listUnitAllUsers(@PathVariable String unitCode, HttpServletResponse response) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("unitCode", unitCode);
        filterMap.put("isValid", "T");
        List listObjects = this.sysUserMag.listObjects(filterMap);
        JsonResultUtils.writeSingleDataJson((Object)listObjects, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/currentusers/{state}"}, method={RequestMethod.GET})
    public void listAllUsersByCurrentUser(@PathVariable String state, HttpServletRequest request, HttpServletResponse response) {
        CentitUserDetails userInfo = this.getLoginUser(request);
        String unitCode = userInfo.getCurrentUnitCode();
        UnitInfo currentUnitInfo = this.sysUnitManager.getObjectById(unitCode);
        HashMap<String, String> filterMap = new HashMap<String, String>(4);
        filterMap.put("unitPath", currentUnitInfo.getUnitPath());
        filterMap.put("isValid", state);
        List listObjects = this.sysUserMag.listObjects(filterMap);
        JsonResultUtils.writeSingleDataJson((Object)listObjects, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/unitusers/{userunitid}"}, method={RequestMethod.GET})
    public void getUnitUser(@PathVariable String userunitid, HttpServletResponse response) {
        UserUnit userUnit = this.sysUserUnitManager.getObjectById(userunitid);
        if (null == userUnit) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u673a\u6784\u4e2d\u65e0\u6b64\u7528\u6237", (HttpServletResponse)response);
            return;
        }
        JsonResultUtils.writeSingleDataJson((Object)userUnit, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/unit/saveopts/{unitCode}"}, method={RequestMethod.POST})
    @RecordOperationLog(content="\u66f4\u65b0\u673a\u6784\u6743\u9650")
    public void setUnitPowers(@PathVariable String unitCode, String optCodes, HttpServletRequest request, HttpServletResponse response) {
        Object[] optCodesArray = optCodes.split(",");
        RoleInfo roleInfo = this.sysRoleManager.getObjectById("G$" + unitCode);
        if (roleInfo == null) {
            roleInfo = new RoleInfo();
            roleInfo.setIsValid("T");
            roleInfo.setRoleCode("G$" + unitCode);
            roleInfo.setRoleName("\u8d4b\u7ed9\u90e8\u95e8" + unitCode + "\u7684\u6743\u9650");
            roleInfo.setRoleDesc(roleInfo.getRoleName());
            roleInfo.setRoleType("H");
            roleInfo.setUnitCode(unitCode);
            roleInfo.setCreateDate(new Date());
            this.sysRoleManager.saveNewRoleInfo(roleInfo);
        }
        ArrayList<RolePower> rolePowers = new ArrayList<RolePower>();
        if (ArrayUtils.isNotEmpty((Object[])optCodesArray)) {
            for (Object optCode : optCodesArray) {
                if (!StringUtils.isNotBlank((CharSequence)optCode)) continue;
                rolePowers.add(new RolePower(new RolePowerId(roleInfo.getRoleCode(), (String)optCode)));
            }
        }
        roleInfo.addAllRolePowers(rolePowers);
        this.sysRoleManager.updateRolePower(roleInfo);
        this.platformEnvironment.reloadSecurityMetadata();
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @GetMapping(value={"/validroles"})
    public void listUnitAndPublicRole(HttpServletRequest request, HttpServletResponse response) {
        String currentUnitCode = WebOptUtils.getLoginUser().getCurrentUnitCode();
        HashMap<String, String> filterMap = new HashMap<String, String>(4);
        filterMap.put("publicUnitRole", currentUnitCode);
        filterMap.put("isValid", "T");
        List roleInfos = this.sysRoleManager.listObjects(filterMap);
        JsonResultUtils.writeSingleDataJson((Object)roleInfos, (HttpServletResponse)response);
    }
}

