/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.po.UnitRole;
import com.centit.framework.system.service.SysUnitManager;
import com.centit.framework.system.service.SysUnitRoleManager;
import com.centit.support.database.utils.PageDesc;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/unitrole"})
public class UnitRoleController
extends BaseController {
    @Resource
    @NotNull
    private SysUnitRoleManager sysUnitRoleManager;
    @Resource
    private SysUnitManager sysUnitManager;

    public String getOptId() {
        return "UNITROLE";
    }

    @RequestMapping(value={"/roleunits/{roleCode}"}, method={RequestMethod.GET})
    public void listUsersByRole(@PathVariable String roleCode, PageDesc pageDesc, HttpServletResponse response) {
        HashMap<String, String> filterMap = new HashMap<String, String>(5);
        filterMap.put("roleCode", roleCode);
        filterMap.put("unitValid", "T");
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)this.sysUnitRoleManager.listObjects(filterMap, pageDesc));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/rolesubunits/{roleCode}"}, method={RequestMethod.GET})
    public void listSubUnitByRole(@PathVariable String roleCode, PageDesc pageDesc, HttpServletResponse response) {
        String currentUnitCode = WebOptUtils.getLoginUser().getCurrentUnitCode();
        UnitInfo currentUnit = this.sysUnitManager.getObjectById(currentUnitCode);
        String unitPathPrefix = currentUnit.getUnitPath();
        HashMap<String, String> filterMap = new HashMap<String, String>(4);
        filterMap.put("roleCode", roleCode);
        filterMap.put("unitPathPrefix", unitPathPrefix);
        filterMap.put("unitValid", "T");
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)this.sysUnitRoleManager.listObjects(filterMap, pageDesc));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/unitroles/{unitCode}"}, method={RequestMethod.GET})
    public void listRolesByUser(@PathVariable String unitCode, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("unitCode", unitCode);
        filterMap.put("roleValid", "T");
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)this.sysUnitRoleManager.listObjects(filterMap, pageDesc));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/currentunitroles/{unitCode}"}, method={RequestMethod.GET})
    public void listCurrentUnitRole(@PathVariable String unitCode, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> filterMap = new HashMap<String, String>(4);
        filterMap.put("unitCode", unitCode);
        filterMap.put("roleValid", "T");
        JSONArray ja = this.sysUnitRoleManager.listObjects(filterMap, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)ja);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST})
    @RecordOperationLog(content="\u7528\u6237{userInfo.userCode}\u7ed9\u673a\u6784{arg1}\u8d4b\u4e88\u6743\u9650{arg0.roleCode}")
    public void create(@Valid UnitRole unitRole, @Valid String[] unitCode, HttpServletResponse response) {
        if (this.sysUnitRoleManager.getUnitRoleById(unitRole.getUnitCode(), unitRole.getRoleCode()) != null) {
            JsonResultUtils.writeErrorMessageJson((String)"\u8be5\u89d2\u8272\u5df2\u7ecf\u5173\u8054\u6b64\u673a\u6784", (HttpServletResponse)response);
            return;
        }
        unitRole.setCreateDate(new Date());
        if (unitCode != null && unitCode.length > 0) {
            for (String u : unitCode) {
                UnitRole ur = new UnitRole();
                ur.copy(unitRole);
                ur.setUnitCode(u);
                this.sysUnitRoleManager.saveNewUnitRole(ur);
            }
        } else {
            this.sysUnitRoleManager.mergeUnitRole(unitRole);
        }
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/{roleCode}/{unitCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u4fee\u6539\u673a\u6784\u89d2\u8272\u5173\u8054\u4fe1\u606f")
    public void edit(@PathVariable String roleCode, @PathVariable String unitCode, @Valid UnitRole unitRole, HttpServletRequest request, HttpServletResponse response) {
        UnitRole dbUnitRole = this.sysUnitRoleManager.getUnitRoleById(unitCode, roleCode);
        if (null == dbUnitRole) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u89d2\u8272\u4e2d\u65e0\u6b64\u7528\u6237", (HttpServletResponse)response);
            return;
        }
        dbUnitRole.copyNotNullProperty(unitRole);
        this.sysUnitRoleManager.updateUnitRole(dbUnitRole);
        JsonResultUtils.writeSingleDataJson((Object)dbUnitRole, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{roleCode}/{unitCodes}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u7528\u6237{userInfo.userCode}\u5220\u9664\u673a\u6784{arg1}\u89d2\u8272{arg0.roleCode}")
    public void delete(@PathVariable String roleCode, @PathVariable String unitCodes, HttpServletRequest request, HttpServletResponse response) {
        String[] unitCodeArray;
        for (String unitCode : unitCodeArray = unitCodes.split(",")) {
            UnitRole dbUnitRole = this.sysUnitRoleManager.getUnitRoleById(unitCode, roleCode);
            if (dbUnitRole == null) continue;
            this.sysUnitRoleManager.deleteUnitRole(unitCode, roleCode);
        }
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }
}

