/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserRole;
import com.centit.framework.system.po.UserUnit;
import com.centit.framework.system.service.SysUserManager;
import com.centit.framework.system.service.SysUserUnitManager;
import com.centit.framework.system.service.UserSettingManager;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.json.JsonPropertyUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/userinfo"})
public class UserInfoController
extends BaseController {
    @Resource
    @NotNull
    private SysUserManager sysUserManager;
    @Resource
    @NotNull
    private SysUserUnitManager sysUserUnitManager;
    @Resource
    @NotNull
    private UserSettingManager userSettingManager;

    public String getOptId() {
        return "USERMAG";
    }

    @RequestMapping(method={RequestMethod.GET})
    public void list(String[] field, PageDesc pageDesc, String _search, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        if (searchColumn.get("userName") != null) {
            searchColumn.put("likeUserOrLoginName", StringEscapeUtils.escapeHtml4((String)searchColumn.get("userName").toString()));
            searchColumn.remove("userName");
        }
        List listObjects = null;
        if (Boolean.parseBoolean(_search)) {
            listObjects = this.sysUserManager.listObjects(searchColumn);
            pageDesc = null;
        } else {
            listObjects = this.sysUserManager.listObjects(searchColumn, pageDesc);
        }
        SimplePropertyPreFilter simplePropertyPreFilter = null;
        if (ArrayUtils.isNotEmpty((Object[])field)) {
            simplePropertyPreFilter = new SimplePropertyPreFilter(UserInfo.class, field);
        }
        if (null == pageDesc) {
            JsonResultUtils.writeSingleDataJson((Object)listObjects, (HttpServletResponse)response, (PropertyPreFilter)simplePropertyPreFilter);
            return;
        }
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response, (PropertyPreFilter)simplePropertyPreFilter);
    }

    @RequestMapping(method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{userInfo.loginIp},\u7528\u6237{userInfo.userName}\u65b0\u589e\u7528\u6237")
    public void create(@Valid UserInfo userInfo, UserUnit userUnit, HttpServletRequest request, HttpServletResponse response) {
        UserInfo dbuserinfo = this.sysUserManager.loadUserByLoginname(userInfo.getLoginName());
        if (null != dbuserinfo) {
            JsonResultUtils.writeErrorMessageJson((int)702, (String)("\u767b\u5f55\u540d" + userInfo.getLoginName() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01"), (HttpServletResponse)response);
            return;
        }
        if (null != userInfo.getUserRoles()) {
            for (UserRole ur : userInfo.getUserRoles()) {
                ur.setUserCode(userInfo.getUserCode());
            }
        }
        userUnit.setCreator(this.getLoginUserCode(request));
        userUnit.setUserCode(userInfo.getUserCode());
        this.sysUserManager.saveNewUserInfo(userInfo, userUnit);
        JsonResultUtils.writeSingleDataJson((Object)userInfo, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{userCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{userInfo.loginIp},\u7528\u6237{userInfo.userName}\u66f4\u65b0\u7528\u6237\u4fe1\u606f")
    public void edit(@PathVariable String userCode, @Valid UserInfo userInfo, UserUnit userUnit, HttpServletRequest request, HttpServletResponse response) {
        UserInfo dbUserInfo = this.sysUserManager.getObjectById(userCode);
        if (null == dbUserInfo) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        this.sysUserUnitManager.deletePrimaryUnitByUserCode(userCode);
        userUnit.setUserCode(userInfo.getUserCode());
        userUnit.setUnitCode(userInfo.getPrimaryUnit());
        userUnit.setIsPrimary("T");
        userUnit.setCreator(this.getLoginUserCode(request));
        this.sysUserUnitManager.saveNewUserUnit(userUnit);
        UserInfo oldValue = new UserInfo();
        oldValue.copy(dbUserInfo);
        if (oldValue.getUserRoles().size() == 0) {
            oldValue.setUserRoles(null);
        }
        if (StringUtils.isBlank((CharSequence)userInfo.getUserPin())) {
            userInfo.setUserPin(dbUserInfo.getUserPin());
        }
        this.sysUserManager.updateUserInfo(userInfo);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/current"}, method={RequestMethod.GET})
    public void getCurrentUserInfo(HttpServletRequest request, HttpServletResponse response) {
        CentitUserDetails userDetails = super.getLoginUser(request);
        UserInfo userinfo = this.sysUserManager.getObjectById(userDetails.getUserInfo().getUserCode());
        JsonResultUtils.writeSingleDataJson((Object)userinfo, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{userCode}"}, method={RequestMethod.GET})
    public void getUserInfo(@PathVariable String userCode, HttpServletResponse response) {
        UserInfo userInfo = this.sysUserManager.getObjectById(userCode);
        UserUnit userUnit = this.sysUserUnitManager.getPrimaryUnitByUserCode(userCode);
        userInfo.setUserCode(StringEscapeUtils.unescapeHtml4((String)userInfo.getUserCode()));
        userInfo.setLoginName(StringEscapeUtils.unescapeHtml4((String)userInfo.getLoginName()));
        userInfo.setUserWord(StringEscapeUtils.unescapeHtml4((String)userInfo.getUserWord()));
        userInfo.setEnglishName(StringEscapeUtils.unescapeHtml4((String)userInfo.getEnglishName()));
        userInfo.setUserName(StringEscapeUtils.unescapeHtml4((String)userInfo.getUserName()));
        userInfo.setUserDesc(StringEscapeUtils.unescapeHtml4((String)userInfo.getUserDesc()));
        ResponseMapData responseData = new ResponseMapData();
        responseData.addResponseData("userInfo", (Object)userInfo);
        responseData.addResponseData("userUnit", (Object)userUnit);
        HashMap<Class, String[]> excludes = new HashMap<Class, String[]>();
        excludes.put(UserUnit.class, new String[]{"userInfo"});
        excludes.put(UserRole.class, new String[]{"userInfo"});
        JsonResultUtils.writeResponseDataAsJson((ResponseData)responseData, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getExcludePropPreFilter(excludes));
    }

    @RequestMapping(value={"/exists"}, method={RequestMethod.GET})
    public void isAnyExist(HttpServletRequest request, HttpServletResponse response) {
        String userCode = request.getParameter("userCode");
        String loginName = request.getParameter("loginName");
        String regPhone = request.getParameter("regPhone");
        String regEmail = request.getParameter("regEmail");
        JsonResultUtils.writeOriginalObject((Object)this.sysUserManager.isAnyOneExist(userCode, loginName, regPhone, regEmail), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/exists/{loginName}"}, method={RequestMethod.GET})
    public void isExists(@PathVariable String loginName, HttpServletRequest request, HttpServletResponse response) throws IOException {
        UserInfo userInfo = this.sysUserManager.loadUserByLoginname(loginName);
        JsonResultUtils.writeOriginalObject((Object)(null != userInfo ? 1 : 0), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/change/{userCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{userInfo.loginIp},\u7528\u6237{userInfo.userName}\u66f4\u65b0\u7528\u6237\u5bc6\u7801")
    public void changePwd(@PathVariable String userCode, String password, String newPassword, HttpServletRequest request, HttpServletResponse response) {
        this.sysUserManager.setNewPassword(userCode, password, newPassword);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/changePwd/{userCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{userInfo.loginIp},\u7528\u6237{userInfo.userName}\u5f3a\u5236\u66f4\u65b0\u7528\u6237\u5bc6\u7801")
    public void forceChangePwd(@PathVariable String userCode, HttpServletRequest request, HttpServletResponse response) {
        String newPassword = request.getParameter("newPassword");
        if (StringUtils.isBlank((CharSequence)newPassword)) {
            this.sysUserManager.resetPwd(userCode);
        } else {
            this.sysUserManager.forceSetPassword(userCode, newPassword);
        }
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/canchange/{userCode}/{oldPassword}"}, method={RequestMethod.GET})
    public void canChangePwd(@PathVariable String userCode, @PathVariable String oldPassword, HttpServletRequest request, HttpServletResponse response) {
        boolean bo = true;
        bo = this.sysUserManager.checkUserPassword(userCode, oldPassword);
        JsonResultUtils.writeSingleDataJson((Object)bo, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/reset"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{userInfo.loginIp},\u7528\u6237{userInfo.userName}\u91cd\u7f6e\u7528\u6237\u5bc6\u7801")
    public void resetBatchPwd(String[] userCodes, HttpServletResponse response) {
        if (ArrayUtils.isEmpty((Object[])userCodes)) {
            JsonResultUtils.writeErrorMessageJson((String)"\u7528\u6237\u4ee3\u7801\u96c6\u5408\u4e3a\u7a7a", (HttpServletResponse)response);
            return;
        }
        this.sysUserManager.resetPwd(userCodes);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/{userCodes}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{userInfo.loginIp},\u7528\u6237{userInfo.userName}\u5220\u9664\u7528\u6237")
    public void deleteUser(@PathVariable String[] userCodes, HttpServletRequest request, HttpServletResponse response) {
        for (String userCode : userCodes) {
            UserInfo userInfo = this.sysUserManager.getObjectById(userCode);
            if (null == userInfo) {
                JsonResultUtils.writeErrorMessageJson((String)"\u8be5\u7528\u6237\u4e0d\u5b58\u5728", (HttpServletResponse)response);
                return;
            }
            this.sysUserManager.deleteUserInfo(userCode);
        }
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }
}

