/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserSetting;
import com.centit.framework.system.po.UserSettingId;
import com.centit.framework.system.service.UserSettingManager;
import com.centit.support.database.utils.PageDesc;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.HtmlUtils;

@Controller
@RequestMapping(value={"/usersetting"})
public class UserSettingController
extends BaseController {
    @Resource
    private UserSettingManager userSettingManager;

    public String getOptId() {
        return "userSetting";
    }

    @RequestMapping
    public void list(PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        UserInfo userInfo = (UserInfo)this.getLoginUser(request).getUserInfo();
        searchColumn.put("userCode", userInfo.getUserCode());
        JSONArray listObjects = this.userSettingManager.listObjects(searchColumn, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @GetMapping(value={"/list/{userCode}"})
    public void listUserSetting(@PathVariable String userCode, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        searchColumn.put("userCode", userCode);
        JSONArray listObjects = this.userSettingManager.listObjects(searchColumn, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @GetMapping(value={"/listdefault"})
    @ResponseBody
    public ResponseData listUserDefaultSetting(PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        List listObjects = this.userSettingManager.listDefaultSettings(searchColumn, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    @RequestMapping(value={"/listall"}, method={RequestMethod.GET})
    public void listAll(String[] field, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> searchColumn = new HashMap<String, String>();
        UserInfo userInfo = (UserInfo)this.getLoginUser(request);
        searchColumn.put("userCode", userInfo.getUserCode());
        List listObjects = this.userSettingManager.listObjects(searchColumn);
        SimplePropertyPreFilter simplePropertyPreFilter = null;
        if (ArrayUtils.isNotEmpty((Object[])field)) {
            simplePropertyPreFilter = new SimplePropertyPreFilter(UserSetting.class, field);
        }
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response, (PropertyPreFilter)simplePropertyPreFilter);
    }

    @RequestMapping(value={"/{paramCode}"}, method={RequestMethod.GET})
    public void getUserSetting(@PathVariable String paramCode, HttpServletRequest request, HttpServletResponse response) {
        UserSettingId id = new UserSettingId(super.getLoginUserCode(request), paramCode);
        UserSetting userSetting = this.userSettingManager.getObjectById(id);
        if (null != userSetting) {
            userSetting.setParamValue(HtmlUtils.htmlUnescape((String)userSetting.getParamValue()));
        }
        JsonResultUtils.writeSingleDataJson((Object)userSetting, (HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{userInfo.loginIp},\u7528\u6237{userInfo.userName}\u66f4\u65b0\u7528\u6237\u8bbe\u7f6e\u53c2\u6570")
    public void editUserSetting(@Valid UserSetting userSetting, HttpServletResponse response) {
        boolean isDefaultValue = userSetting.isDefaultValue();
        if (isDefaultValue) {
            this.userSettingManager.saveNewUserSetting(userSetting);
        } else {
            this.userSettingManager.updateUserSetting(userSetting);
        }
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"updatedefault"}, method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{userInfo.loginIp},\u7528\u6237{userInfo.userName}\u66f4\u65b0\u5f53\u524d\u7528\u6237\u8bbe\u7f6e\u53c2\u6570")
    public void editDefaultSetting(@Valid UserSetting userSetting, HttpServletResponse response) {
        UserSetting dbSetting = this.userSettingManager.getUserSetting(userSetting.getUserCode(), userSetting.getParamCode());
        if (dbSetting == null) {
            userSetting.setUserCode("default");
            this.userSettingManager.saveNewUserSetting(userSetting);
        } else {
            this.userSettingManager.updateUserSetting(userSetting);
        }
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/{paramCode}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{userInfo.loginIp},\u7528\u6237{userInfo.userName}\u5220\u9664\u7528\u6237\u8bbe\u7f6e\u53c2\u6570")
    public void deleteUserSetting(@PathVariable String paramCode, HttpServletRequest request, HttpServletResponse response) {
        UserSetting dbUserSetting = this.userSettingManager.getObjectById(new UserSettingId(super.getLoginUserCode(request), paramCode));
        this.userSettingManager.deleteObject(dbUserSetting);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/{userCode}/{paramCode}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{userInfo.loginIp},\u7528\u6237{userInfo.userName}\u5220\u9664\u7528\u6237\u8bbe\u7f6e\u53c2\u6570")
    public void delete(@PathVariable String userCode, @PathVariable String paramCode, HttpServletResponse response) {
        UserSetting userSetting = this.userSettingManager.getUserSetting(userCode, paramCode);
        if (userSetting != null) {
            if ("default".equals(userSetting.getUserCode())) {
                JsonResultUtils.writeErrorMessageJson((String)"\u9ed8\u8ba4\u8bbe\u7f6e\u4e0d\u80fd\u5220\u9664\uff01", (HttpServletResponse)response);
                return;
            }
            this.userSettingManager.deleteObject(userSetting);
        }
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/deletedefault/{paramCode}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{userInfo.loginIp},\u7528\u6237{userInfo.userName}\u5220\u9664\u7528\u6237\u8bbe\u7f6e\u53c2\u6570")
    public void deleteDefault(@PathVariable String paramCode, HttpServletResponse response) {
        UserSetting userSetting = this.userSettingManager.getUserSetting("default", paramCode);
        if (userSetting != null) {
            this.userSettingManager.deleteObject(userSetting);
        } else {
            JsonResultUtils.writeErrorMessageJson((String)"\u503c\u5df2\u4e3anull\uff01", (HttpServletResponse)response);
        }
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }
}

