/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ObjectException;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.system.po.DataCatalog;
import com.centit.framework.system.po.DataDictionary;
import com.centit.framework.system.po.DataDictionaryId;
import com.centit.framework.system.service.DataDictionaryManager;
import com.centit.support.database.utils.PageDesc;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/dictionary"})
public class DataDictionaryController
extends BaseController {
    public static final String F = "F";
    public static final String S = "S";
    public static final String U = "U";
    public static final String T = "T";
    @Value(value="${app.local.multiLang:false}")
    private boolean multiLang;
    @Resource
    private DataDictionaryManager dataDictionaryManager;

    public String getOptId() {
        return "DICTSET";
    }

    @RequestMapping(method={RequestMethod.GET})
    public void list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        List listObjects = this.dataDictionaryManager.listObjects(searchColumn, pageDesc);
        SimplePropertyPreFilter simplePropertyPreFilter = null;
        if (ArrayUtils.isNotEmpty((Object[])field)) {
            simplePropertyPreFilter = new SimplePropertyPreFilter(DataCatalog.class, field);
        }
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)DictionaryMapUtils.objectsToJSONArray((Collection)listObjects));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response, (PropertyPreFilter)simplePropertyPreFilter);
    }

    @RequestMapping(value={"/{catalogCode}"}, method={RequestMethod.GET})
    public void getCatalog(@PathVariable String catalogCode, HttpServletResponse response) {
        DataCatalog dbDataCatalog = this.dataDictionaryManager.getCatalogIncludeDataPiece(catalogCode);
        JsonResultUtils.writeSingleDataJson((Object)dbDataCatalog, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/notexists/{catalogCode}"}, method={RequestMethod.GET})
    public void isNotExistsCatalogCode(@PathVariable String catalogCode, HttpServletResponse response) {
        DataCatalog dbDataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        JsonResultUtils.writeOriginalObject((Object)(null == dbDataCatalog ? 1 : 0), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/existcatalogname/{catalogName}"}, method={RequestMethod.GET})
    public void isExistsCatalogName(@PathVariable String catalogName, HttpServletResponse response) {
        int count = this.dataDictionaryManager.existCatalogName(catalogName);
        JsonResultUtils.writeOriginalObject((Object)count, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/notexists/dictionary/{catalogCode}/{dataCode}"}, method={RequestMethod.GET})
    public void isNotExistsDataCode(@PathVariable String catalogCode, @PathVariable String dataCode, HttpServletResponse response) {
        DataDictionary dbDataDictionary = this.dataDictionaryManager.getDataDictionaryPiece(new DataDictionaryId(catalogCode, dataCode));
        JsonResultUtils.writeOriginalObject((Object)(null == dbDataDictionary ? 1 : 0), (HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{userInfo.loginIp},\u7528\u6237{userInfo.userName}\u65b0\u589e\u5b57\u5178\u7c7b\u522b")
    public void createCatalog(@Valid DataCatalog dataCatalog, HttpServletRequest request, HttpServletResponse response) {
        if (this.isLoginAsAdmin(request)) {
            dataCatalog.setCatalogStyle(S);
        } else {
            dataCatalog.setCatalogStyle(U);
        }
        this.dataDictionaryManager.saveNewObject(dataCatalog);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/{catalogCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{userInfo.loginIp},\u7528\u6237{userInfo.userName}\u66f4\u65b0\u5b57\u5178\u7c7b\u522b")
    public void updateCatalog(@PathVariable String catalogCode, @Valid DataCatalog dataCatalog, HttpServletRequest request, HttpServletResponse response) {
        DataCatalog dbDataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        if (null == dbDataCatalog) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        DataCatalog oldValue = new DataCatalog();
        BeanUtils.copyProperties((Object)dbDataCatalog, (Object)oldValue);
        BeanUtils.copyProperties((Object)dataCatalog, (Object)dbDataCatalog, (String[])new String[]{"catalogStyle", "catalogCode", "dataDictionaries"});
        this.dataDictionaryManager.updateCatalog(dbDataCatalog);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    private boolean isLoginAsAdmin(HttpServletRequest request) {
        Object obj = request.getSession().getAttribute("ENTRANCE_TYPE");
        return obj != null && "DEPLOY".equals(obj.toString());
    }

    @RequestMapping(value={"update/{catalogCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{userInfo.loginIp},\u7528\u6237{userInfo.userName}\u66f4\u65b0\u5b57\u5178\u76ee\u5f55\u660e\u7ec6")
    public void updateDictionary(@PathVariable String catalogCode, @Valid DataCatalog dataCatalog, HttpServletRequest request, HttpServletResponse response) {
        DataCatalog dbDataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        if (null == dbDataCatalog) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        DataCatalog oldValue = new DataCatalog();
        BeanUtils.copyProperties((Object)dbDataCatalog, (Object)oldValue);
        boolean isAdmin = this.isLoginAsAdmin(request);
        String datastyle = isAdmin ? S : U;
        for (DataDictionary d : dataCatalog.getDataDictionaries()) {
            if (!StringUtils.isBlank((CharSequence)d.getDataStyle())) continue;
            d.setDataStyle(datastyle);
        }
        dbDataCatalog.addAllDataPiece(dataCatalog.getDataDictionaries());
        List oldDictionaries = this.dataDictionaryManager.saveCatalogIncludeDataPiece(dbDataCatalog, isAdmin);
        oldValue.setDataDictionaries(oldDictionaries);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/dictionary/{catalogCode}/{dataCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{userInfo.loginIp},\u7528\u6237{userInfo.userName}\u65b0\u589e\u6570\u636e\u5b57\u5178")
    public void createDictionary(@PathVariable String catalogCode, @PathVariable String dataCode, @Valid DataDictionary dataDictionary, HttpServletRequest request, HttpServletResponse response) {
        DataDictionary dbDataDictionary = this.dataDictionaryManager.getDataDictionaryPiece(new DataDictionaryId(catalogCode, dataCode));
        DataDictionary oldValue = new DataDictionary();
        oldValue.copy(dbDataDictionary);
        DataCatalog dbDataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        this.dictionaryPreHandler(dbDataCatalog, dataDictionary);
        this.dictionaryPreInsertHandler(dbDataCatalog, dataDictionary, request);
        this.dataDictionaryManager.saveDataDictionaryPiece(dataDictionary);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/dictionary/{catalogCode}/{dataCode}"}, method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{userInfo.loginIp},\u7528\u6237{userInfo.userName}\u66f4\u65b0\u6570\u636e\u5b57\u5178")
    public void editDictionary(@PathVariable String catalogCode, @PathVariable String dataCode, @Valid DataDictionary dataDictionary, HttpServletRequest request, HttpServletResponse response) {
        DataDictionary dbDataDictionary = this.dataDictionaryManager.getDataDictionaryPiece(new DataDictionaryId(catalogCode, dataCode));
        DataDictionary oldValue = new DataDictionary();
        oldValue.copy(dbDataDictionary);
        DataCatalog dbDataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        this.dictionaryPreHandler(dbDataCatalog, dataDictionary);
        this.dictionaryPreUpdateHandler(dbDataCatalog, dbDataDictionary, request);
        BeanUtils.copyProperties((Object)dataDictionary, (Object)dbDataDictionary, (String[])new String[]{"id", "dataStyle"});
        this.dictionaryPreUpdateHandler(dbDataCatalog, dbDataDictionary, request);
        this.dataDictionaryManager.saveDataDictionaryPiece(dbDataDictionary);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    protected void dictionaryPreHandler(DataCatalog dataCatalog, DataDictionary dataDictionary) {
        if (T.equalsIgnoreCase(dataCatalog.getCatalogType())) {
            String extraCode = dataDictionary.getExtraCode();
            if (StringUtils.isBlank((CharSequence)extraCode)) {
                throw new ObjectException("extraCode \u5b57\u6bb5\u4e0d\u53ef\u4e3a\u7a7a");
            }
            if (extraCode.equals(dataDictionary.getDataCode())) {
                throw new ObjectException("extraCode \u4e0e dataCode \u4e0d\u80fd\u4e00\u81f4");
            }
            DataDictionary dd = this.dataDictionaryManager.getDataDictionaryPiece(new DataDictionaryId(dataDictionary.getCatalogCode(), extraCode));
            if (null == dd) {
                throw new ObjectException("\u5f53\u524d\u7236\u8282\u70b9\u4e0d\u5b58\u5728");
            }
        }
    }

    protected void dictionaryPreInsertHandler(DataCatalog dataCatalog, DataDictionary dataDictionary, HttpServletRequest request) {
        if (this.isLoginAsAdmin(request)) {
            dataDictionary.setDataStyle(S);
        } else {
            if (!S.equalsIgnoreCase(dataCatalog.getCatalogStyle()) && !U.equalsIgnoreCase(dataCatalog.getCatalogStyle())) {
                throw new ObjectException("catalogStyle \u5b57\u6bb5\u53ea\u53ef\u586b\u5199 S \u6216 U");
            }
            dataDictionary.setDataStyle(U);
            if (!U.equalsIgnoreCase(dataDictionary.getDataStyle())) {
                throw new ObjectException("dataStyle \u5b57\u6bb5\u53ea\u53ef\u586b\u5199 U");
            }
        }
    }

    protected void dictionaryPreDeleteHandler(DataCatalog dataCatalog, DataDictionary dataDictionary, HttpServletRequest request) {
        if (this.isLoginAsAdmin(request)) {
            if (!S.equalsIgnoreCase(dataDictionary.getDataStyle()) && !U.equalsIgnoreCase(dataDictionary.getDataStyle())) {
                throw new ObjectException("\u53ea\u80fd\u5220\u9664 catalogStyle\u4e3a S \u6216 U \u7684\u5b57\u5178\u76ee\u5f55");
            }
        } else if (!U.equalsIgnoreCase(dataDictionary.getDataStyle())) {
            throw new ObjectException("dataStyle \u5b57\u6bb5\u53ea\u53ef\u586b\u5199 U");
        }
    }

    protected void dictionaryPreUpdateHandler(DataCatalog dataCatalog, DataDictionary dataDictionary, HttpServletRequest request) {
        if (this.isLoginAsAdmin(request)) {
            if (F.equalsIgnoreCase(dataDictionary.getDataStyle())) {
                throw new ObjectException("dataStyle \u4e3a F \u7c7b\u578b\u7684\u6570\u636e\u5b57\u5178\uff0c\u4efb\u4f55\u5730\u65b9\u90fd\u4e0d\u5141\u8bb8\u7f16\u8f91\uff0c\u53ea\u80fd\u6709\u5f00\u53d1\u4eba\u5458\u7ed9\u51fa\u66f4\u65b0\u811a\u672c\u6dfb\u52a0\u3001\u66f4\u6539\u548c\u5220\u9664");
            }
            if (F.equalsIgnoreCase(dataCatalog.getCatalogStyle()) && !S.equalsIgnoreCase(dataDictionary.getDataStyle())) {
                throw new ObjectException("\u53ea\u80fd\u4fee\u6539 dataStyle \u4e3a S \u7684\u6570\u636e\u5b57\u5178");
            }
            if (!S.equalsIgnoreCase(dataCatalog.getCatalogStyle()) && !U.equalsIgnoreCase(dataCatalog.getCatalogStyle())) {
                throw new ObjectException("catalogStyle \u5b57\u6bb5\u53ea\u53ef\u586b\u5199 S \u6216 U");
            }
            if (!S.equalsIgnoreCase(dataDictionary.getDataStyle()) && !U.equalsIgnoreCase(dataDictionary.getDataStyle())) {
                throw new ObjectException("dataStyle \u5b57\u6bb5\u53ea\u53ef\u586b\u5199 S \u6216 U");
            }
        } else if (!U.equalsIgnoreCase(dataDictionary.getDataStyle())) {
            throw new ObjectException("dataStyle \u5b57\u6bb5\u53ea\u53ef\u586b\u5199 U");
        }
    }

    protected void catalogPrDeleteHandler(DataCatalog dataCatalog, HttpServletRequest request) {
        if (this.isLoginAsAdmin(request)) {
            if (!S.equalsIgnoreCase(dataCatalog.getCatalogStyle()) && !U.equalsIgnoreCase(dataCatalog.getCatalogStyle())) {
                throw new ObjectException("\u53ea\u80fd\u5220\u9664 catalogStyle\u4e3a S \u6216 U \u7684\u5b57\u5178\u76ee\u5f55");
            }
        } else if (!U.equalsIgnoreCase(dataCatalog.getCatalogStyle())) {
            throw new ObjectException("\u53ea\u53ef\u5220\u9664 catalogStyle \u4e3a U \u7684\u5b57\u5178\u76ee\u5f55");
        }
    }

    @RequestMapping(value={"/{catalogCode}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{userInfo.loginIp},\u7528\u6237{userInfo.userName}\u5220\u9664\u5b57\u5178\u76ee\u5f55")
    public void deleteCatalog(@PathVariable String catalogCode, HttpServletRequest request, HttpServletResponse response) {
        DataCatalog dataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        this.catalogPrDeleteHandler(dataCatalog, request);
        this.dataDictionaryManager.deleteDataDictionary(catalogCode);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/dictionary/{catalogCode}/{dataCode}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{userInfo.loginIp},\u7528\u6237{userInfo.userName}\u5220\u9664\u6570\u636e\u5b57\u5178")
    public void deleteDictionary(@PathVariable String catalogCode, @PathVariable String dataCode, HttpServletRequest request, HttpServletResponse response) {
        DataCatalog dataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        DataDictionary dataDictionary = this.dataDictionaryManager.getDataDictionaryPiece(new DataDictionaryId(catalogCode, dataCode));
        this.dictionaryPreDeleteHandler(dataCatalog, dataDictionary, request);
        this.dataDictionaryManager.deleteDataDictionaryPiece(dataDictionary.getId());
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/dictionaryPiece/{catalogCode}"}, method={RequestMethod.GET})
    public void getDataDictionary(@PathVariable String catalogCode, HttpServletResponse response) {
        List datas = this.dataDictionaryManager.getDataDictionary(catalogCode);
        JsonResultUtils.writeSingleDataJson((Object)datas, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/editDictionary/{catalogCode}"}, method={RequestMethod.GET})
    public void getDataDictionaryDetail(@PathVariable String catalogCode, HttpServletResponse response) {
        List datas = this.dataDictionaryManager.getDataDictionary(catalogCode);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("dataDictionary", (Object)datas);
        resData.addResponseData("multiLang", (Object)this.multiLang);
        resData.addResponseData("langs", (Object)CodeRepositoryUtil.getLabelValueMap((String)"SUPPORT_LANG"));
        JsonResultUtils.writeSingleDataJson((Object)datas, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/allCatalog"}, method={RequestMethod.GET})
    public void getAllCatalog(HttpServletResponse response) {
        List catalogs = this.dataDictionaryManager.listAllDataCatalog();
        JsonResultUtils.writeSingleDataJson((Object)catalogs, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/wholeDictionary"}, method={RequestMethod.GET})
    public void getWholeDictionary(HttpServletResponse response) {
        List catalogs = this.dataDictionaryManager.listAllDataCatalog();
        List dictionarys = this.dataDictionaryManager.getWholeDictionary();
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("catalog", (Object)catalogs);
        resData.addResponseData("dictionary", (Object)dictionarys);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/dictionaryprop"})
    public ResponseEntity<byte[]> downloadProperties() throws IOException {
        List dictionarys = this.dataDictionaryManager.getWholeDictionary();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write("#dictionaryprop_zh_CN.Properties\r\n".getBytes());
        for (DataDictionary dict : dictionarys) {
            out.write((dict.getCatalogCode() + "." + dict.getDataCode() + "=" + dict.getDataValue() + "\r\n").getBytes());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentDispositionFormData("attachment", "dictionaryprop_zh_CN.Properties");
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        return new ResponseEntity((Object)out.toByteArray(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

