/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.model.basedata.IUnitInfo;
import com.centit.framework.model.basedata.IUserInfo;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserUnit;
import com.centit.framework.system.service.SysUserManager;
import com.centit.framework.system.service.SysUserUnitManager;
import com.centit.support.database.utils.PageDesc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/userunit"})
public class UserUnitController
extends BaseController {
    @Resource
    @NotNull
    private SysUserUnitManager sysUserUnitManager;
    @Resource
    @NotNull
    private SysUserManager sysUserManager;

    public String getOptId() {
        return "USERUNIT";
    }

    @RequestMapping(method={RequestMethod.GET})
    public void list(String state, HttpServletResponse response) {
        HashMap<String, String> object;
        ArrayList listObjects = new ArrayList();
        if (StringUtils.isBlank((CharSequence)state)) {
            state = "A";
        }
        List users = CodeRepositoryUtil.getAllUsers((String)state);
        List units = CodeRepositoryUtil.getAllUnits((String)state);
        for (IUnitInfo unit : units) {
            object = new HashMap<String, String>();
            object.put("id", unit.getUnitCode());
            object.put("name", unit.getUnitName());
            object.put("pId", unit.getParentUnit());
            listObjects.add(object);
        }
        for (IUserInfo user : users) {
            object = new HashMap();
            object.put("id", user.getUserCode());
            object.put("name", user.getUserName());
            object.put("pId", user.getPrimaryUnit());
            listObjects.add(object);
        }
        JsonResultUtils.writeSingleDataJson(listObjects, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/unitusers/{unitCode}"}, method={RequestMethod.GET})
    public void listUsersByUnit(@PathVariable String unitCode, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map filterMap = BaseController.convertSearchColumn((HttpServletRequest)request);
        List listObjects = this.sysUserUnitManager.listSubUsersByUnitCode(unitCode, filterMap, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)DictionaryMapUtils.objectsToJSONArray((Collection)listObjects));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/userunits/{userCode}"}, method={RequestMethod.GET})
    public void listUnitsByUser(@PathVariable String userCode, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        UserInfo user = this.sysUserManager.getObjectById(this.getLoginUserCode(request));
        Map filterMap = BaseController.convertSearchColumn((HttpServletRequest)request);
        filterMap.put("userCode", userCode);
        List listObjects = this.sysUserUnitManager.listObjects(filterMap, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)DictionaryMapUtils.objectsToJSONArray((Collection)listObjects));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    protected void listObject(Map<String, Object> filterMap, PageDesc pageDesc, HttpServletResponse response) {
        List listObjects = this.sysUserUnitManager.listObjects(filterMap, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)DictionaryMapUtils.objectsToJSONArray((Collection)listObjects));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{userunitid}"}, method={RequestMethod.GET})
    public void getUserUnitById(@PathVariable String userunitid, HttpServletResponse response) {
        UserUnit userUnit = this.sysUserUnitManager.getObjectById(userunitid);
        if (null == userUnit) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u673a\u6784\u4e2d\u65e0\u6b64\u7528\u6237", (HttpServletResponse)response);
            return;
        }
        JsonResultUtils.writeSingleDataJson((Object)DictionaryMapUtils.objectToJSON((Object)userUnit), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{unitCode}/{userCode}"}, method={RequestMethod.GET})
    public void getUserUnit(@PathVariable String unitCode, @PathVariable String userCode, HttpServletResponse response) {
        List userUnits = this.sysUserUnitManager.listObjectByUserUnit(userCode, unitCode);
        if (null == userUnits || userUnits.size() == 0) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u673a\u6784\u4e2d\u65e0\u6b64\u7528\u6237", (HttpServletResponse)response);
            return;
        }
        JsonResultUtils.writeSingleDataJson((Object)DictionaryMapUtils.objectsToJSONArray((Collection)userUnits), (HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{userInfo.loginIp},\u7528\u6237{userInfo.userName}\u65b0\u589e\u7528\u6237\u673a\u6784\u5173\u8054\u4fe1\u606f")
    public void create(@Valid UserUnit userUnit, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("unitCode", userUnit.getUnitCode());
        map.put("userRank", userUnit.getUserRank());
        map.put("userStation", userUnit.getUserStation());
        map.put("userCode", userUnit.getUserCode());
        List list = this.sysUserUnitManager.listObjects(map, new PageDesc());
        if (list != null && list.size() > 0) {
            JsonResultUtils.writeErrorMessageJson((String)"\u8be5\u7528\u6237\u5df2\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        userUnit.setCreator(this.getLoginUserCode(request));
        this.sysUserUnitManager.saveNewUserUnit(userUnit);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/{userunitid}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{userInfo.loginIp},\u7528\u6237{userInfo.userName}\u66f4\u65b0\u7528\u6237\u673a\u6784\u5173\u8054\u4fe1\u606f")
    public void edit(@PathVariable String userunitid, @Valid UserUnit userUnit, HttpServletRequest request, HttpServletResponse response) {
        userUnit.setUpdator(this.getLoginUserCode(request));
        UserUnit dbUserUnit = this.sysUserUnitManager.getObjectById(userunitid);
        if (null == dbUserUnit) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u673a\u6784\u4e2d\u65e0\u6b64\u7528\u6237", (HttpServletResponse)response);
            return;
        }
        UserUnit oldValue = new UserUnit();
        oldValue.copy(dbUserUnit);
        dbUserUnit.copy(userUnit);
        this.sysUserUnitManager.updateUserUnit(dbUserUnit);
        JsonResultUtils.writeSingleDataJson((Object)userUnit, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{userunitid}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{userInfo.loginIp},\u7528\u6237{userInfo.userName}\u5220\u9664\u7528\u6237\u673a\u6784\u5173\u8054\u4fe1\u606f")
    public void delete(@PathVariable String userunitid, HttpServletRequest request, HttpServletResponse response) {
        UserUnit dbUserUnit = this.sysUserUnitManager.getObjectById(userunitid);
        if ("T".equals(dbUserUnit.getIsPrimary())) {
            JsonResultUtils.writeErrorMessageJson((String)"\u4e3b\u673a\u6784\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u80fd\u5220\u9664\uff01", (HttpServletResponse)response);
            return;
        }
        this.sysUserUnitManager.deleteObject(dbUserUnit);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }
}

