/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.system.po.InnerMsg;
import com.centit.framework.system.po.InnerMsgRecipient;
import com.centit.framework.system.service.InnerMessageManager;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.json.JsonPropertyUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/innermsg"})
@Api(tags={"\u5185\u90e8\u6d88\u606f\u3001\u516c\u544a\u64cd\u4f5c\u63a5\u53e3"}, value="\u5185\u90e8\u6d88\u606f\u3001\u516c\u544a\u63a5\u53e3\u7ef4\u62a4")
public class InnerMsgController
extends BaseController {
    @Resource
    @NotNull
    public InnerMessageManager innerMessageManager;

    public String getOptId() {
        return "InnerMsg";
    }

    @ApiOperation(value="\u67e5\u8be2\u6536\u4ef6\u7bb1", notes="\u67e5\u8be2\u6536\u4ef6\u7bb1\u3002")
    @ApiImplicitParam(name="pageDesc", value="\u5206\u9875\u5bf9\u8c61", paramType="body", dataTypeClass=PageDesc.class)
    @RequestMapping(value={"/inbox"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listInbox(PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        String receive = (String)searchColumn.get("receive");
        if (StringUtils.isBlank((CharSequence)receive)) {
            searchColumn.put("receive", WebOptUtils.getLoginUser((HttpServletRequest)request).getUserCode());
        }
        List listObjects = this.innerMessageManager.listMsgRecipientsCascade(searchColumn, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)DictionaryMapUtils.objectsToJSONArray((Collection)listObjects));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    @ApiOperation(value="\u672a\u8bfb\u6d88\u606f\u6570\u91cf", notes="\u672a\u8bfb\u6d88\u606f\u6570\u91cf\u3002")
    @RequestMapping(value={"/unreadMsgCount"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData unreadMsgCount(HttpServletRequest request) {
        String currUser = WebOptUtils.getLoginUser((HttpServletRequest)request).getUserCode();
        long unreadMsg = this.innerMessageManager.getUnreadMessageCount(currUser);
        return ResponseData.makeResponseData((Object)unreadMsg);
    }

    @ApiOperation(value="\u67e5\u8be2\u53d1\u4ef6\u7bb1", notes="\u67e5\u8be2\u53d1\u4ef6\u7bb1\u3002")
    @ApiImplicitParam(name="pageDesc", value="\u5206\u9875\u5bf9\u8c61", paramType="body", dataTypeClass=PageDesc.class)
    @RequestMapping(value={"/outbox"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listOutbox(PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        String sender = (String)searchColumn.get("sender");
        if (StringUtils.isBlank((CharSequence)sender)) {
            searchColumn.put("sender", WebOptUtils.getLoginUser((HttpServletRequest)request).getUserCode());
        }
        List listObjects = this.innerMessageManager.listInnerMsgs(searchColumn, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)DictionaryMapUtils.objectsToJSONArray((Collection)listObjects));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    @ApiOperation(value="\u662f\u5426\u6709\u53d1\u516c\u544a\u6743\u9650", notes="\u662f\u5426\u6709\u53d1\u516c\u544a\u6743\u9650\u3002")
    @RequestMapping(value={"/cangivenotify"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData cangivenotify() {
        boolean s = CodeRepositoryUtil.checkUserOptPower((String)"MSGMAG", (String)"givenotify");
        return ResponseData.makeResponseData((Object)s);
    }

    @ApiOperation(value="\u662f\u5426\u6709\u53d1\u516c\u544a\u6743\u9650", notes="\u662f\u5426\u6709\u53d1\u516c\u544a\u6743\u9650\u3002")
    @ApiImplicitParam(name="msgCode", value="\u6d88\u606f\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{msgCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getInnerMsg(@PathVariable String msgCode, HttpServletResponse response) {
        InnerMsgRecipient msgCopy = this.innerMessageManager.getMsgRecipientById(msgCode);
        return ResponseData.makeResponseData((Object)msgCopy);
    }

    @ApiOperation(value="\u516c\u544a\u5217\u8868", notes="\u516c\u544a\u5217\u8868\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="field", value="\u663e\u793a\u7ed3\u679c\u4e2d\u53ea\u9700\u8981\u663e\u793a\u7684\u5b57\u6bb5", allowMultiple=true, paramType="query", dataType="array"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\uff0c\u5206\u9875\u5bf9\u8c61", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(value={"/notice"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listnotify(String[] field, PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        searchColumn.put("msgType", "A");
        List listObjects = this.innerMessageManager.listInnerMsgs(searchColumn, pageDesc);
        PropertyPreFilter includePropPreFilter = JsonPropertyUtils.getIncludePropPreFilter(InnerMsg.class, (String[])field);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)DictionaryMapUtils.objectsToJSONArray((Collection)listObjects));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        resData.toJSONString(includePropPreFilter);
        return resData;
    }

    @ApiOperation(value="\u7fa4\u53d1\u6d88\u606f", notes="\u6309\u90e8\u95e8\u53d1\u516c\u544a\uff0c\u4f1a\u5339\u914d\u8be5\u90e8\u95e8\u4ee5\u53ca\u6240\u6709\u5b50\u90e8\u95e8\u7684\u7528\u6237\uff0c\u7fa4\u53d1\u6d88\u606f\u3002")
    @ApiImplicitParam(name="unitCode", value="\u673a\u6784\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @ApiParam(name="innerMsg", value="\u7fa4\u53d1\u7684\u5bf9\u8c61\u4fe1\u606f", required=true)
    @RequestMapping(value={"/notify/{unitCode}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData noticeByUnit(@PathVariable String unitCode, @Valid InnerMsg innerMsg, HttpServletRequest request) throws Exception {
        if (!StringUtils.isNotBlank((CharSequence)innerMsg.getSender())) {
            innerMsg.setSender(WebOptUtils.getLoginUser((HttpServletRequest)request).getUserCode());
        }
        if (null == innerMsg.getSendDate()) {
            innerMsg.setSendDate(new Date());
        }
        this.innerMessageManager.noticeByUnitCode(unitCode, innerMsg);
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u53d1\u9001\u6216\u7fa4\u53d1\u6d88\u606f", notes="\u53d1\u9001\u6216\u7fa4\u53d1\u6d88\u606f\u3002")
    @ApiParam(name="recipient", value="\u63a5\u6536\u7684\u6d88\u606f\u5bf9\u8c61", required=true)
    @RequestMapping(value={"/sendMsg"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData sendMsg(@Valid InnerMsgRecipient recipient, HttpServletRequest request) {
        this.innerMessageManager.sendInnerMsg(recipient, this.getLoginUser(request).getUserCode());
        return ResponseData.makeResponseData((Object)recipient);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237", notes="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u3002")
    @RequestMapping(value={"/loginuser"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public String getLoginUserCode(HttpServletRequest request) {
        return this.getLoginUser(request).getUserCode();
    }

    @ApiOperation(value="\u66f4\u65b0\u6d88\u606f\u5185\u5bb9", notes="\u66f4\u65b0\u6d88\u606f\u5185\u5bb9\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="msgCode", value="\u6d88\u606f\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="msg", value="json\u683c\u5f0f\uff0c\u66f4\u65b0\u7684\u6d88\u606f\u5bf9\u8c61", required=true, paramType="body", dataTypeClass=InnerMsg.class)})
    @RequestMapping(value={"/{msgCode}"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public ResponseData mergInnerMsg(@Valid InnerMsg msg, @PathVariable String msgCode) {
        InnerMsg msgCopy = this.innerMessageManager.getInnerMsgById(msgCode);
        if (null == msgCopy) {
            return ResponseData.makeErrorMessage((String)"\u5f53\u524d\u673a\u6784\u4e2d\u65e0\u6b64\u4fe1\u606f");
        }
        this.innerMessageManager.updateInnerMsg(msg);
        return ResponseData.makeResponseData((Object)msg);
    }

    @ApiOperation(value="\u66f4\u65b0\u63a5\u53d7\u8005\u4fe1\u606f", notes="\u66f4\u65b0\u63a5\u53d7\u8005\u4fe1\u606f\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u63a5\u6536\u8005\u4fe1\u606f\u7f16\u53f7", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="recipient", value="json\u683c\u5f0f\uff0c\u66f4\u65b0\u7684\u63a5\u53d7\u8005\u4fe1\u606f\u5bf9\u8c61", required=true, paramType="body", dataTypeClass=InnerMsgRecipient.class)})
    @RequestMapping(value={"recipient/{id}"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public ResponseData mergInnerMsgRecipient(@Valid InnerMsgRecipient recipient, @PathVariable String id) {
        InnerMsgRecipient recipientCopy = this.innerMessageManager.getMsgRecipientById(id);
        if (null == recipientCopy) {
            return ResponseData.makeErrorMessage((String)"\u5f53\u524d\u673a\u6784\u4e2d\u65e0\u6b64\u4fe1\u606f");
        }
        this.innerMessageManager.updateRecipient(recipient);
        return ResponseData.makeResponseData((Object)recipient);
    }

    @ApiOperation(value="\u5220\u9664\u6d88\u606f", notes="\u5220\u9664\u6d88\u606f,\u5e76\u6ca1\u6709\u5220\u9664\u8be5\u6761\u8bb0\u5f55\uff0c\u800c\u662f\u628amsgState\u5b57\u6bb5\u6807\u8bb0\u4e3aD\u3002")
    @ApiImplicitParam(name="msgCode", value="\u4fe1\u606f\u7f16\u53f7", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{msgCode}"}, method={RequestMethod.DELETE})
    @WrapUpResponseBody
    public ResponseData deleteMsg(@PathVariable String msgCode, HttpServletResponse response) {
        this.innerMessageManager.deleteInnerMsgById(msgCode);
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u5220\u9664\u63a5\u53d7\u8005\u4fe1\u606f", notes="\u5220\u9664\u63a5\u53d7\u8005\u4fe1\u606f,\u5e76\u6ca1\u6709\u5220\u9664\u8be5\u6761\u8bb0\u5f55\uff0c\u800c\u662f\u628amsgState\u5b57\u6bb5\u6807\u8bb0\u4e3aD\u3002")
    @ApiImplicitParam(name="id", value="\u63a5\u53d7\u8005\u4fe1\u606f\u7f16\u53f7", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/recipient/{id}"}, method={RequestMethod.DELETE})
    @WrapUpResponseBody
    public ResponseData deleteRecipient(@PathVariable String id, HttpServletRequest request, HttpServletResponse response) {
        this.innerMessageManager.deleteMsgRecipientById(id);
        OperationLogCenter.logDeleteObject((HttpServletRequest)request, (String)"recipient", (String)id, (String)"delete", (String)"\u5220\u9664\u63a5\u6536\u8fd9\u4fe1\u606f", (Object)"");
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u5f80\u6765\u6d88\u606f\u5217\u8868", notes="\u83b7\u53d6\u53d1\u9001\u8005\u548c\u63a5\u53d7\u8005\u5f80\u6765\u6d88\u606f\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sender", value="\u53d1\u9001\u8005id", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="receiver", value="\u63a5\u6536\u8005id", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/{sender}/{receiver}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getMsgExchanges(@PathVariable String sender, @PathVariable String receiver) {
        List recipientlist = this.innerMessageManager.getExchangeMsgRecipients(sender, receiver);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)recipientlist);
        return resData;
    }
}

