/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.RoleInfo;
import com.centit.framework.system.po.RolePower;
import com.centit.framework.system.po.RolePowerId;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.po.UnitRole;
import com.centit.framework.system.po.UserUnit;
import com.centit.framework.system.service.SysRoleManager;
import com.centit.framework.system.service.SysUnitManager;
import com.centit.framework.system.service.SysUnitRoleManager;
import com.centit.framework.system.service.SysUserManager;
import com.centit.framework.system.service.SysUserUnitManager;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.json.JsonPropertyUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/unitinfo"})
@Api(value="\u7cfb\u7edf\u673a\u6784\u7ba1\u7406\u64cd\u4f5c\u63a5\u53e3", tags={"\u7cfb\u7edf\u673a\u6784\u7ba1\u7406\u64cd\u4f5c\u63a5\u53e3"})
public class UnitInfoController
extends BaseController {
    @Resource
    @NotNull
    private SysUnitManager sysUnitManager;
    @Resource
    @NotNull
    private SysUserManager sysUserMag;
    @Resource
    @NotNull
    private SysUserUnitManager sysUserUnitManager;
    @Resource
    @NotNull
    private SysRoleManager sysRoleManager;
    @Resource
    @NotNull
    private SysUnitRoleManager sysUnitRoleManager;
    @Resource
    private PlatformEnvironment platformEnvironment;

    public String getOptId() {
        return "UNITMAG";
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u673a\u6784\u4fe1\u606f", notes="\u67e5\u8be2\u6240\u6709\u673a\u6784\u4fe1\u606f\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="struct", value="\u6307\u9700\u8981\u663e\u793a\u7684\u5c5e\u6027\u540d", paramType="query", dataType="Boolean"), @ApiImplicitParam(name="id", value="\u7236\u673a\u6784ID", paramType="query", dataType="String")})
    @RequestMapping(method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData list(boolean struct, String id, HttpServletRequest request) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        String unitName = (String)searchColumn.get("unitName");
        if (StringUtils.isNotBlank((CharSequence)unitName) && StringUtils.isBlank((CharSequence)id)) {
            List listObjects = this.sysUnitManager.listObjects(searchColumn);
            JSONArray ja = DictionaryMapUtils.objectsToJSONArray((Collection)listObjects);
            if (struct) {
                ja = CollectionsOpt.srotAsTreeAndToJSON((List)ja, (p, c) -> StringUtils.equals((CharSequence)((JSONObject)p).getString("unitCode"), (CharSequence)((JSONObject)c).getString("parentUnit")), (String)"children");
            }
            return ResponseData.makeResponseData((Object)ja);
        }
        HashMap<String, String> filterMap = new HashMap<String, String>(2);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            filterMap.put("parentUnit", id);
        } else {
            filterMap.put("NP_TOPUnit", "true");
        }
        List listObjects = this.sysUnitManager.listObjects(filterMap);
        this.sysUnitManager.checkState(listObjects);
        JSONArray ja = DictionaryMapUtils.objectsToJSONArray((Collection)listObjects);
        return ResponseData.makeResponseData((Object)ja);
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5b50\u673a\u6784\u4fe1\u606f", notes="\u67e5\u8be2\u6240\u6709\u5b50\u673a\u6784\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="id", value="\u7236\u673a\u6784ID", paramType="query", dataType="String")
    @RequestMapping(value={"/subunits"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listSub(String id, HttpServletRequest request) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        String currentUnitCode = WebOptUtils.getLoginUser((HttpServletRequest)request).getCurrentUnitCode();
        String unitName = StringBaseOpt.castObjectToString(searchColumn.get("unitName"));
        if (StringUtils.isNotBlank((CharSequence)unitName) && StringUtils.isBlank((CharSequence)id)) {
            List listObjects = this.sysUnitManager.listObjects(searchColumn);
            JSONArray ja = DictionaryMapUtils.objectsToJSONArray((Collection)listObjects);
            return ResponseData.makeResponseData((Object)ja);
        }
        HashMap<String, String> filterMap = new HashMap<String, String>(2);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            filterMap.put("parentUnit", id);
        } else {
            filterMap.put("parentUnit", StringUtils.isNotBlank((CharSequence)id) ? id : currentUnitCode);
        }
        List listObjects = this.sysUnitManager.listAllSubUnits(currentUnitCode);
        JSONArray ja = DictionaryMapUtils.objectsToJSONArray((Collection)listObjects);
        for (Object o : ja) {
            ((JSONObject)o).put("state", (Object)"open");
            ((JSONObject)o).put("id", (Object)((JSONObject)o).getString("unitCode"));
            ((JSONObject)o).put("text", (Object)((JSONObject)o).getString("unitName"));
        }
        ja = CollectionsOpt.srotAsTreeAndToJSON((List)ja, (p, c) -> StringUtils.equals((CharSequence)((JSONObject)p).getString("unitCode"), (CharSequence)((JSONObject)c).getString("parentUnit")), (String)"children");
        return ResponseData.makeResponseData((Object)ja);
    }

    @ApiOperation(value="\u67e5\u8be2 \u5f53\u524d\u673a\u6784 \u5b50\u673a\u6784", notes="\u67e5\u8be2 \u5f53\u524d\u673a\u6784 \u5b50\u673a\u6784\u3002")
    @RequestMapping(value={"/validsubunits"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listValidSubUnit(HttpServletRequest request) {
        String currentUnitCode = WebOptUtils.getLoginUser((HttpServletRequest)request).getCurrentUnitCode();
        List listObjects = this.sysUnitManager.listValidSubUnits(currentUnitCode);
        JSONArray ja = DictionaryMapUtils.objectsToJSONArray((Collection)listObjects);
        for (Object o : ja) {
            ((JSONObject)o).put("state", (Object)"open");
            ((JSONObject)o).put("id", (Object)((JSONObject)o).getString("unitCode"));
            ((JSONObject)o).put("text", (Object)((JSONObject)o).getString("unitName"));
        }
        ja = CollectionsOpt.srotAsTreeAndToJSON((List)ja, (p, c) -> StringUtils.equals((CharSequence)((JSONObject)p).getString("unitCode"), (CharSequence)((JSONObject)c).getString("parentUnit")), (String)"children");
        return ResponseData.makeResponseData((Object)ja);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u673a\u6784\u4fe1\u606f", notes="\u6839\u636e\u673a\u6784ID\u67e5\u8be2\u5355\u4e2a\u673a\u6784\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="unitCode", value="\u673a\u6784ID", paramType="query", dataType="String")
    @RequestMapping(value={"/{unitCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public UnitInfo getUnitInfo(@PathVariable String unitCode) {
        return this.sysUnitManager.getObjectById(unitCode);
    }

    @ApiOperation(value="\u5220\u9664\u673a\u6784\u4fe1\u606f", notes="\u6839\u636e\u673a\u6784ID\u5220\u9664\u673a\u6784\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="unitCode", value="\u673a\u6784ID", paramType="query", dataType="String")
    @RequestMapping(value={"/{unitCode}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u673a\u6784")
    @WrapUpResponseBody
    public ResponseData delete(@PathVariable String unitCode) {
        UnitInfo unitInfo = this.sysUnitManager.getObjectById(unitCode);
        if (unitInfo == null) {
            return ResponseData.makeErrorMessage((String)"The object not found!");
        }
        List userUnits = this.sysUserUnitManager.listUnitUsersByUnitCode(unitCode);
        if (userUnits != null && userUnits.size() != 0) {
            return ResponseData.makeErrorMessage((String)"\u8be5\u673a\u6784\u5b58\u5728\u5173\u8054\u7528\u6237\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
        }
        this.sysUnitManager.deleteUnitInfo(unitInfo);
        JSONArray unitRoles = this.sysUnitRoleManager.listUnitRoles(unitCode, new PageDesc());
        if (unitRoles != null && unitRoles.size() > 0) {
            for (Object obj : unitRoles) {
                this.sysUnitRoleManager.deleteUnitRole(unitCode, ((UnitRole)JSONObject.toJavaObject((JSON)((JSON)DictionaryMapUtils.objectToJSON(obj)), UnitRole.class)).getRoleCode());
            }
        }
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u65b0\u5efa\u673a\u6784", notes="\u65b0\u5efa\u4e00\u4e2a\u673a\u6784\u3002")
    @ApiImplicitParam(name="unitInfo", value="json\u683c\u5f0f\uff0c\u673a\u6784\u4fe1\u606f\u5bf9\u8c61", paramType="body", dataTypeClass=UnitInfo.class)
    @RequestMapping(method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u65b0\u589e\u673a\u6784")
    @WrapUpResponseBody
    public ResponseData create(@Valid UnitInfo unitInfo) {
        if (!this.sysUnitManager.isUniqueName(unitInfo)) {
            return ResponseData.makeErrorMessage((int)702, (String)("\u673a\u6784\u540d" + unitInfo.getUnitName() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01"));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("unitWord", unitInfo.getUnitWord());
        List unitInfos = this.sysUnitManager.listObjects(map);
        if (unitInfos != null && unitInfos.size() > 0) {
            return ResponseData.makeErrorMessage((int)702, (String)("\u673a\u6784\u7f16\u7801" + unitInfo.getUnitName() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01"));
        }
        while (!this.sysUnitManager.isUniqueOrder(unitInfo)) {
            unitInfo.setUnitOrder(Long.valueOf(unitInfo.getUnitOrder() + 1L));
        }
        this.sysUnitManager.saveNewUnitInfo(unitInfo);
        return ResponseData.makeResponseData((Object)unitInfo);
    }

    @ApiOperation(value="\u66f4\u65b0\u673a\u6784\u4fe1\u606f", notes="\u66f4\u65b0\u673a\u6784\u4fe1\u606f\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="unitCode", value="\u673a\u6784\u4ee3\u7801", paramType="path", dataType="String"), @ApiImplicitParam(name="unitInfo", value="json\u683c\u5f0f\uff0c\u673a\u6784\u4fe1\u606f\u5bf9\u8c61", paramType="body", dataTypeClass=UnitInfo.class)})
    @RequestMapping(value={"/{unitCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u673a\u6784")
    @WrapUpResponseBody
    public ResponseData edit(@PathVariable String unitCode, @Valid UnitInfo unitInfo) {
        UnitInfo dbUnitInfo = this.sysUnitManager.getObjectById(unitCode);
        if (null == dbUnitInfo) {
            return ResponseData.makeErrorMessage((String)"\u673a\u6784\u4e0d\u5b58\u5728");
        }
        if (!this.sysUnitManager.isUniqueName(unitInfo)) {
            return ResponseData.makeErrorMessage((int)702, (String)("\u673a\u6784\u540d" + unitInfo.getUnitName() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01"));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("unitWord", unitInfo.getUnitWord());
        List unitInfos = this.sysUnitManager.listObjects(map);
        if (unitInfos != null && unitInfos.size() > 0 && !unitCode.equals(((UnitInfo)unitInfos.get(0)).getUnitCode())) {
            return ResponseData.makeErrorMessage((int)702, (String)("\u673a\u6784\u7f16\u7801" + unitInfo.getUnitWord() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01"));
        }
        if ("F".equals(unitInfo.getIsValid())) {
            List units = this.sysUnitManager.listValidSubUnit(unitCode);
            if (units != null && units.size() != 0) {
                return ResponseData.makeErrorMessage((String)"\u8be5\u673a\u6784\u5305\u542b\u4e0b\u7ea7\u673a\u6784\uff0c\u4e0d\u80fd\u8bbe\u4e3a\u7981\u7528\uff01");
            }
            List userUnits = this.sysUserUnitManager.listUnitUsersByUnitCode(unitCode);
            if (userUnits != null && userUnits.size() != 0) {
                return ResponseData.makeErrorMessage((String)"\u8be5\u673a\u6784\u5b58\u5728\u5173\u8054\u7528\u6237\uff0c\u4e0d\u80fd\u8bbe\u4e3a\u7981\u7528\uff01");
            }
        }
        UnitInfo oldValue = new UnitInfo();
        oldValue.copy(dbUnitInfo);
        this.sysUnitManager.updateUnitInfo(unitInfo);
        return ResponseData.makeResponseData((Object)unitInfo);
    }

    @ApiOperation(value="\u66f4\u65b0\u673a\u6784\u53ca\u5b50\u673a\u6784\u7684\u72b6\u6001", notes="\u66f4\u65b0\u673a\u6784\u53ca\u5b50\u673a\u6784\u7684\u72b6\u6001\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="unitCode", value="\u673a\u6784\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="statusValue", value="\u72b6\u6001\u7801 T:\u53ef\u7528 \u6216 F:\u7981\u7528", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/{unitCode}/status/{statusValue}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u673a\u6784\u72b6\u6001")
    @WrapUpResponseBody
    public ResponseData changeStatus(@PathVariable String unitCode, @PathVariable String statusValue) {
        UnitInfo dbUnitInfo = this.sysUnitManager.getObjectById(unitCode);
        if (null == dbUnitInfo) {
            return ResponseData.makeErrorMessage((String)"\u673a\u6784\u4e0d\u5b58\u5728");
        }
        if (!"T".equals(statusValue) && !"F".equals(statusValue)) {
            return ResponseData.makeErrorMessage((String)"\u673a\u6784\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        this.sysUnitManager.changeStatus(unitCode, statusValue);
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u83b7\u53d6\u5355\u4e2a\u673a\u6784\u4e0b\u5c5e\u5b50\u673a\u6784", notes="\u83b7\u53d6\u5355\u4e2a\u673a\u6784\u4e0b\u5c5e\u5b50\u673a\u6784\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="unitCode", value="\u673a\u6784\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="field", value="\u9700\u8981\u663e\u793a\u7684\u5b57\u6bb5", allowMultiple=true, paramType="query", dataType="String")})
    @RequestMapping(value={"/{unitCode}/children"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listChildren(@PathVariable String unitCode, String[] field, HttpServletRequest request) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        searchColumn.put("parentUnit", unitCode);
        List listObjects = this.sysUnitManager.listObjects(searchColumn);
        ResponseMapData respData = new ResponseMapData();
        respData.addResponseData("objList", (Object)listObjects);
        respData.toJSONString(JsonPropertyUtils.getIncludePropPreFilter(UnitInfo.class, (String[])field));
        return ResponseData.makeResponseData((Object)respData.getResponseData("objList"));
    }

    @ApiOperation(value="\u5f53\u524d\u673a\u6784\u4e0b\u6240\u6709\u7528\u6237", notes="\u5f53\u524d\u673a\u6784\u4e0b\u6240\u6709\u7528\u6237\u3002")
    @RequestMapping(value={"/currentunit/users"}, method={RequestMethod.GET})
    @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\uff0c\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)
    @WrapUpResponseBody
    public ResponseData listUnitUsers(PageDesc pageDesc, HttpServletRequest request) {
        String currentUnitCode = WebOptUtils.getLoginUser((HttpServletRequest)request).getCurrentUnitCode();
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        searchColumn.put("unitCode", currentUnitCode);
        if (searchColumn.get("userName") != null) {
            searchColumn.put("likeUserOrLoginName", StringEscapeUtils.escapeHtml4((String)searchColumn.get("userName").toString()));
            searchColumn.remove("userName");
        }
        List listObjects = this.sysUserMag.listObjects(searchColumn, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    @ApiOperation(value="\u83b7\u53d6\u673a\u6784\u4e0b\u6240\u6709\u53ef\u7528\u7684\u7528\u6237", notes="\u83b7\u53d6\u673a\u6784\u4e0b\u6240\u6709\u53ef\u7528\u7684\u7528\u6237\u3002")
    @ApiImplicitParam(name="unitCode", value="\u673a\u6784\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{unitCode}/validusers"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listUnitAllUsers(@PathVariable String unitCode) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("unitCode", unitCode);
        filterMap.put("isValid", "T");
        List listObjects = this.sysUserMag.listObjects(filterMap);
        return ResponseData.makeResponseData((Object)listObjects);
    }

    @ApiOperation(value="\u83b7\u53d6\u673a\u6784\u4e0b\u6240\u6709\u53ef\u7528\u7684\u7528\u6237", notes="\u83b7\u53d6\u673a\u6784\u4e0b\u6240\u6709\u53ef\u7528\u7684\u7528\u6237\u3002")
    @ApiImplicitParam(name="state", value="\u662f\u5426\u542f\u7528 T:\u542f\u7528 | F:\u7981\u7528", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/currentusers/{state}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listAllUsersByCurrentUser(@PathVariable String state, HttpServletRequest request) {
        CentitUserDetails userInfo = this.getLoginUser(request);
        String unitCode = userInfo.getCurrentUnitCode();
        UnitInfo currentUnitInfo = this.sysUnitManager.getObjectById(unitCode);
        HashMap<String, String> filterMap = new HashMap<String, String>(4);
        filterMap.put("unitPath", currentUnitInfo.getUnitPath());
        filterMap.put("isValid", state);
        List listObjects = this.sysUserMag.listObjects(filterMap);
        return ResponseData.makeResponseData((Object)listObjects);
    }

    @ApiOperation(value="\u5f53\u524d\u673a\u6784\u4e0b\u7528\u6237", notes="\u5f53\u524d\u673a\u6784\u4e0b\u7528\u6237\u3002")
    @ApiImplicitParam(name="userunitid", value="\u7528\u6237\u673a\u6784\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/unitusers/{userunitid}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getUnitUser(@PathVariable String userunitid) {
        UserUnit userUnit = this.sysUserUnitManager.getObjectById(userunitid);
        if (null == userUnit) {
            return ResponseData.makeErrorMessage((String)"\u5f53\u524d\u673a\u6784\u4e2d\u65e0\u6b64\u7528\u6237");
        }
        return ResponseData.makeResponseData((Object)userUnit);
    }

    @ApiOperation(value="\u5c06\u6743\u9650\u8d4b\u7ed9\u90e8\u95e8", notes="\u5c06\u6743\u9650\u8d4b\u7ed9\u90e8\u95e8\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="unitCode", value="\u673a\u6784\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="optCodes", value="\u64cd\u4f5c\u6743\u9650\u4ee3\u7801 \u4ee5\uff0c\u9694\u5f00", required=true, paramType="query", dataType="String")})
    @RequestMapping(value={"/unit/saveopts/{unitCode}"}, method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u673a\u6784\u6743\u9650")
    @WrapUpResponseBody
    public ResponseData setUnitPowers(@PathVariable String unitCode, String optCodes) {
        Object[] optCodesArray = optCodes.split(",");
        RoleInfo roleInfo = this.sysRoleManager.getObjectById("G$" + unitCode);
        if (roleInfo == null) {
            roleInfo = new RoleInfo();
            roleInfo.setIsValid("T");
            roleInfo.setRoleCode("G$" + unitCode);
            roleInfo.setRoleName("\u8d4b\u7ed9\u90e8\u95e8" + unitCode + "\u7684\u6743\u9650");
            roleInfo.setRoleDesc(roleInfo.getRoleName());
            roleInfo.setRoleType("H");
            roleInfo.setUnitCode(unitCode);
            roleInfo.setCreateDate(new Date());
            this.sysRoleManager.saveNewRoleInfo(roleInfo);
        }
        ArrayList<RolePower> rolePowers = new ArrayList<RolePower>();
        if (ArrayUtils.isNotEmpty((Object[])optCodesArray)) {
            for (Object optCode : optCodesArray) {
                if (!StringUtils.isNotBlank((CharSequence)optCode)) continue;
                rolePowers.add(new RolePower(new RolePowerId(roleInfo.getRoleCode(), (String)optCode)));
            }
        }
        roleInfo.addAllRolePowers(rolePowers);
        this.sysRoleManager.updateRolePower(roleInfo);
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u5f53\u524d\u673a\u6784\u4e0b\u6240\u6709\u53ef\u7528\u7684\u89d2\u8272", notes="\u5f53\u524d\u673a\u6784\u4e0b\u6240\u6709\u53ef\u7528\u7684\u89d2\u8272\u3002")
    @GetMapping(value={"/validroles"})
    @WrapUpResponseBody
    public ResponseData listUnitAndPublicRole(HttpServletRequest request) {
        String currentUnitCode = WebOptUtils.getLoginUser((HttpServletRequest)request).getCurrentUnitCode();
        HashMap<String, String> filterMap = new HashMap<String, String>(4);
        filterMap.put("publicUnitRole", currentUnitCode);
        filterMap.put("isValid", "T");
        List roleInfos = this.sysRoleManager.listObjects(filterMap);
        return ResponseData.makeResponseData((Object)roleInfos);
    }

    @ApiOperation(value="\u9a8c\u8bc1\u90e8\u95e8\u7f16\u7801\u53ef\u7528\u6027-\u65b0\u589e", notes="true-\u53ef\u7528\uff08\u552f\u4e00\uff09\uff1bfalse-\u4e0d\u53ef\u7528\uff08\u5df2\u5b58\u5728\u540c\u540d\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="depNo", value="\u90e8\u95e8\u7f16\u7801", required=true)})
    @GetMapping(value={"/depNo_usability"})
    @WrapUpResponseBody
    public boolean isDepNoUnique(String depNo) {
        return this.sysUnitManager.isDepNoUnique(depNo, null);
    }

    @ApiOperation(value="\u9a8c\u8bc1\u90e8\u95e8\u7f16\u7801\u53ef\u7528\u6027-\u7f16\u8f91", notes="true-\u53ef\u7528\uff08\u552f\u4e00\uff09\uff1bfalse-\u4e0d\u53ef\u7528\uff08\u5df2\u5b58\u5728\u540c\u540d\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="depNo", value="\u90e8\u95e8\u7f16\u7801", required=true), @ApiImplicitParam(name="unitCode", value="\u90e8\u95e8Code(\u4e3b\u952e)", required=true)})
    @GetMapping(value={"/{unitCode}/depNo_usability"})
    @WrapUpResponseBody
    public boolean isDepNoUnique(@PathVariable String unitCode, String depNo) {
        return this.sysUnitManager.isDepNoUnique(depNo, unitCode);
    }

    @ApiOperation(value="\u9a8c\u8bc1\u90e8\u95e8\u81ea\u5b9a\u4e49\u7f16\u7801\u53ef\u7528\u6027-\u65b0\u589e", notes="true-\u53ef\u7528\uff08\u552f\u4e00\uff09\uff1bfalse-\u4e0d\u53ef\u7528\uff08\u5df2\u5b58\u5728\u540c\u540d\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="unitWord", value="\u90e8\u95e8\u81ea\u5b9a\u4e49\u7f16\u7801", required=true)})
    @GetMapping(value={"/unitWord_usability"})
    @WrapUpResponseBody
    public boolean isUnitWordUnique(String unitWord) {
        return this.sysUnitManager.isUnitWordUnique(unitWord, null);
    }

    @ApiOperation(value="\u9a8c\u8bc1\u90e8\u95e8\u81ea\u5b9a\u4e49\u7f16\u7801\u53ef\u7528\u6027-\u7f16\u8f91", notes="true-\u53ef\u7528\uff08\u552f\u4e00\uff09\uff1bfalse-\u4e0d\u53ef\u7528\uff08\u5df2\u5b58\u5728\u540c\u540d\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="unitWord", value="\u90e8\u95e8\u81ea\u5b9a\u4e49\u7f16\u7801", required=true), @ApiImplicitParam(name="unitCode", value="\u90e8\u95e8Code(\u4e3b\u952e)", required=true)})
    @GetMapping(value={"/{unitCode}/unitWord_usability"})
    @WrapUpResponseBody
    public boolean isUnitWordUnique(@PathVariable String unitCode, String unitWord) {
        return this.sysUnitManager.isUnitWordUnique(unitWord, unitCode);
    }

    @ApiOperation(value="\u66f4\u65b0\u90e8\u95e8\u6743\u9650", notes="\u66f4\u65b0\u90e8\u95e8\u6743\u9650")
    @ApiImplicitParams(value={@ApiImplicitParam(name="unitCode", value="\u673a\u6784\u4ee3\u7801", required=true, dataType="String"), @ApiImplicitParam(name="authorities", value="\u64cd\u4f5c\u4ee3\u7801(json\u6570\u7ec4\u5b57\u7b26\u4e32\uff0c\u683c\u5f0f\uff1a[{'optCode':'xxx','optDataScopes':'xxx,xxx'}])", required=true)})
    @PostMapping(value={"/{unitCode}/authorities"})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u90e8\u95e8\u6743\u9650")
    @WrapUpResponseBody
    public ResponseData updateAuthorities(@PathVariable String unitCode, String authorities) {
        JSONArray authArr;
        RoleInfo roleInfo = this.sysRoleManager.getObjectById("G$" + unitCode);
        if (roleInfo == null) {
            roleInfo = new RoleInfo();
            roleInfo.setIsValid("T");
            roleInfo.setRoleCode("G$" + unitCode);
            roleInfo.setRoleName("\u8d4b\u7ed9\u90e8\u95e8" + unitCode + "\u7684\u6743\u9650");
            roleInfo.setRoleDesc(roleInfo.getRoleName());
            roleInfo.setRoleType("H");
            roleInfo.setUnitCode(unitCode);
            roleInfo.setCreateDate(new Date());
            this.sysRoleManager.saveNewRoleInfo(roleInfo);
        }
        ArrayList<RolePower> rolePowers = new ArrayList<RolePower>();
        authorities = authorities.replaceAll("&#39;", "'");
        authorities = authorities.replaceAll("&quot;", "\"");
        try {
            authArr = JSON.parseArray((String)authorities);
        }
        catch (Exception e) {
            return ResponseData.makeErrorMessage((String)"\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        for (Object auth : authArr) {
            String optCode = ((JSONObject)auth).getString("optCode");
            String scopes = ((JSONObject)auth).getString("optDataScopes");
            rolePowers.add(new RolePower(new RolePowerId(roleInfo.getRoleCode(), optCode), scopes));
        }
        roleInfo.addAllRolePowers(rolePowers);
        this.sysRoleManager.updateRolePower(roleInfo);
        return ResponseData.makeSuccessResponse();
    }
}

