/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.po.UnitRole;
import com.centit.framework.system.service.SysUnitManager;
import com.centit.framework.system.service.SysUnitRoleManager;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/unitrole"})
@Api(value="\u7cfb\u7edf\u673a\u6784\u89d2\u8272\u64cd\u4f5c\u63a5\u53e3", tags={"\u7cfb\u7edf\u673a\u6784\u89d2\u8272\u64cd\u4f5c\u63a5\u53e3"})
public class UnitRoleController
extends BaseController {
    @Resource
    @NotNull
    private SysUnitRoleManager sysUnitRoleManager;
    @Resource
    private SysUnitManager sysUnitManager;

    public String getOptId() {
        return "UNITROLE";
    }

    @ApiOperation(value="\u901a\u8fc7\u89d2\u8272\u4ee3\u7801\u83b7\u53d6\u673a\u6784", notes="\u901a\u8fc7\u89d2\u8272\u4ee3\u7801\u83b7\u53d6\u673a\u6784\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", paramType="path", dataType="String"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\uff0c\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(value={"/roleunits/{roleCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listUsersByRole(@PathVariable String roleCode, PageDesc pageDesc) {
        HashMap<String, String> filterMap = new HashMap<String, String>(5);
        filterMap.put("roleCode", roleCode);
        filterMap.put("unitValid", "T");
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)this.sysUnitRoleManager.listObjects(filterMap, pageDesc));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    @ApiOperation(value="\u901a\u8fc7\u89d2\u8272\u4ee3\u7801\u83b7\u53d6\u5f53\u524d\u767b\u9646\u8005\u6240\u5728\u673a\u6784\u4e0b\u7684\u6240\u6709\u5b50\u673a\u6784", notes="\u901a\u8fc7\u89d2\u8272\u4ee3\u7801\u83b7\u53d6\u5f53\u524d\u767b\u9646\u8005\u6240\u5728\u673a\u6784\u4e0b\u7684\u6240\u6709\u5b50\u673a\u6784\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", paramType="path", dataType="String"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\uff0c\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(value={"/rolesubunits/{roleCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listSubUnitByRole(@PathVariable String roleCode, PageDesc pageDesc, HttpServletRequest request) {
        String currentUnitCode = WebOptUtils.getLoginUser((HttpServletRequest)request).getCurrentUnitCode();
        UnitInfo currentUnit = this.sysUnitManager.getObjectById(currentUnitCode);
        String unitPathPrefix = currentUnit.getUnitPath();
        HashMap<String, String> filterMap = new HashMap<String, String>(4);
        filterMap.put("roleCode", roleCode);
        filterMap.put("unitPathPrefix", unitPathPrefix);
        filterMap.put("unitValid", "T");
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)this.sysUnitRoleManager.listObjects(filterMap, pageDesc));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    @ApiOperation(value="\u901a\u8fc7\u673a\u6784\u4ee3\u7801\u83b7\u53d6\u89d2\u8272", notes="\u901a\u8fc7\u673a\u6784\u4ee3\u7801\u83b7\u53d6\u89d2\u8272\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="unitCode", value="\u673a\u6784\u4ee3\u7801", paramType="path", dataType="String"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\uff0c\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(value={"/unitroles/{unitCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listRolesByUser(@PathVariable String unitCode, PageDesc pageDesc) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("unitCode", unitCode);
        filterMap.put("roleValid", "T");
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)this.sysUnitRoleManager.listObjects(filterMap, pageDesc));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    @ApiOperation(value="\u901a\u8fc7\u673a\u6784\u4ee3\u7801\u83b7\u53d6\u672c\u673a\u6784\u89d2\u8272", notes="\u901a\u8fc7\u673a\u6784\u4ee3\u7801\u83b7\u53d6\u672c\u673a\u6784\u89d2\u8272\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="unitCode", value="\u673a\u6784\u4ee3\u7801", paramType="path", dataType="String"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\uff0c\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(value={"/currentunitroles/{unitCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listCurrentUnitRole(@PathVariable String unitCode, PageDesc pageDesc) {
        HashMap<String, String> filterMap = new HashMap<String, String>(4);
        filterMap.put("unitCode", unitCode);
        filterMap.put("roleValid", "T");
        JSONArray ja = this.sysUnitRoleManager.listObjects(filterMap, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)ja);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    @ApiOperation(value="\u521b\u5efa\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f", notes="\u521b\u5efa\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="unitRole", value="json\u683c\u5f0f\uff0c\u673a\u6784\u89d2\u8272\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=UnitRole.class), @ApiImplicitParam(name="unitCode", value="\u673a\u6784\u4ee3\u7801\uff08\u6570\u7ec4\uff09", allowMultiple=true, paramType="query", dataType="String")})
    @RequestMapping(method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u7ed9\u673a\u6784{arg1}\u8d4b\u4e88\u6743\u9650{arg0.roleCode}")
    @WrapUpResponseBody
    public ResponseData create(@Valid UnitRole unitRole, @Valid String[] unitCode) {
        if (this.sysUnitRoleManager.getUnitRoleById(unitRole.getUnitCode(), unitRole.getRoleCode()) != null) {
            return ResponseData.makeErrorMessage((String)"\u8be5\u89d2\u8272\u5df2\u7ecf\u5173\u8054\u6b64\u673a\u6784");
        }
        unitRole.setCreateDate(new Date());
        if (unitCode != null && unitCode.length > 0) {
            for (String u : unitCode) {
                UnitRole ur = new UnitRole();
                ur.copy(unitRole);
                ur.setUnitCode(u);
                this.sysUnitRoleManager.saveNewUnitRole(ur);
            }
        } else {
            this.sysUnitRoleManager.mergeUnitRole(unitRole);
        }
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u66f4\u65b0\u673a\u6784\u89d2\u8272\u5173\u8054\u4fe1\u606f", notes="\u66f4\u65b0\u673a\u6784\u89d2\u8272\u5173\u8054\u4fe1\u606f\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="unitCode", value="\u673a\u6784\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="unitRole", value="json\u683c\u5f0f\uff0c\u673a\u6784\u89d2\u8272\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=UnitRole.class)})
    @RequestMapping(value={"/{roleCode}/{unitCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u4fee\u6539\u673a\u6784\u89d2\u8272\u5173\u8054\u4fe1\u606f")
    @WrapUpResponseBody
    public ResponseData edit(@PathVariable String roleCode, @PathVariable String unitCode, @Valid UnitRole unitRole) {
        UnitRole dbUnitRole = this.sysUnitRoleManager.getUnitRoleById(unitCode, roleCode);
        if (null == dbUnitRole) {
            return ResponseData.makeErrorMessage((String)"\u5f53\u524d\u89d2\u8272\u4e2d\u65e0\u6b64\u7528\u6237");
        }
        dbUnitRole.copyNotNullProperty(unitRole);
        this.sysUnitRoleManager.updateUnitRole(dbUnitRole);
        return ResponseData.makeResponseData((Object)dbUnitRole);
    }

    @ApiOperation(value="\u5220\u9664\u673a\u6784\u89d2\u8272\u5173\u8054\u4fe1\u606f", notes="\u6839\u636e\u89d2\u8272\u4ee3\u7801\u548c\u673a\u6784\u4ee3\u7801\uff08\u673a\u6784\u4ee3\u7801\u53ef\u4ee5\u662f\u591a\u4e2a\uff09\u5220\u9664\u673a\u6784\u89d2\u8272\u5173\u8054\u4fe1\u606f\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="unitCodes", value="\u673a\u6784\u4ee3\u7801\uff08\u6570\u7ec4\uff09", allowMultiple=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/{roleCode}/{unitCodes}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u673a\u6784{arg1}\u89d2\u8272{arg0.roleCode}")
    @WrapUpResponseBody
    public ResponseData delete(@PathVariable String roleCode, @PathVariable String unitCodes) {
        String[] unitCodeArray;
        for (String unitCode : unitCodeArray = unitCodes.split(",")) {
            UnitRole dbUnitRole = this.sysUnitRoleManager.getUnitRoleById(unitCode, roleCode);
            if (dbUnitRole == null) continue;
            this.sysUnitRoleManager.deleteUnitRole(unitCode, roleCode);
        }
        return ResponseData.makeSuccessResponse();
    }
}

