/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserRole;
import com.centit.framework.system.po.UserUnit;
import com.centit.framework.system.service.SysUserManager;
import com.centit.framework.system.service.SysUserUnitManager;
import com.centit.framework.system.service.UserSettingManager;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.json.JsonPropertyUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value="\u6846\u67b6\u4e2d\u7528\u6237\u7ba1\u7406\u63a5\u53e3\uff0c\u5305\u62ec\u7528\u6237\u7684\u589e\u5220\u6539\u67e5", tags={"\u7528\u6237\u7ba1\u7406\u64cd\u4f5c\u63a5\u53e3"})
@Controller
@RequestMapping(value={"/userinfo"})
public class UserInfoController
extends BaseController {
    @Resource
    @NotNull
    private SysUserManager sysUserManager;
    @Resource
    @NotNull
    private SysUserUnitManager sysUserUnitManager;
    @Resource
    @NotNull
    private UserSettingManager userSettingManager;

    public String getOptId() {
        return "USERMAG";
    }

    @ApiOperation(value="\u7528\u6237\u4fe1\u606f\u5206\u9875\u67e5\u8be2", notes="\u67e5\u8be2\u7528\u6237\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="filterMap", value="\u8fc7\u6ee4\u6761\u4ef6", paramType="query", dataType="Map"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\u7684\u5206\u9875\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class), @ApiImplicitParam(name="_search", value="\u5f3a\u5236\u5173\u95ed\u5206\u9875\u67e5\u8be2", paramType="query", dataType="Boolean"), @ApiImplicitParam(name="field", value="\u8fc7\u6ee4\u8fd4\u56de\u7684\u5b57\u6bb5\u4fe1\u606f", allowMultiple=true, paramType="query", dataType="String")})
    @RequestMapping(method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData list(String[] field, PageDesc pageDesc, String _search, HttpServletRequest request) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        if (searchColumn.get("userName") != null) {
            searchColumn.put("likeUserOrLoginName", StringEscapeUtils.escapeHtml4((String)searchColumn.get("userName").toString()));
            searchColumn.remove("userName");
        }
        List listObjects = null;
        if (Boolean.parseBoolean(_search)) {
            listObjects = this.sysUserManager.listObjects(searchColumn);
            pageDesc = null;
        } else {
            listObjects = this.sysUserManager.listObjects(searchColumn, pageDesc);
        }
        JSONArray jsonArr = DictionaryMapUtils.objectsToJSONArray((Collection)listObjects);
        SimplePropertyPreFilter simplePropertyPreFilter = null;
        if (ArrayUtils.isNotEmpty((Object[])field)) {
            simplePropertyPreFilter = new SimplePropertyPreFilter(UserInfo.class, field);
        }
        ResponseMapData resData = new ResponseMapData();
        if (null == pageDesc) {
            resData.addResponseData("objList", (Object)listObjects);
            resData.toJSONString((PropertyPreFilter)simplePropertyPreFilter);
            return ResponseData.makeResponseData((Object)resData.getResponseData("objList"));
        }
        resData.addResponseData("objList", (Object)jsonArr);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        resData.toJSONString((PropertyPreFilter)simplePropertyPreFilter);
        return resData;
    }

    @ApiOperation(value="\u65b0\u589e\u7528\u6237", notes="\u65b0\u589e\u7528\u6237\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userInfo", value="json\u683c\u5f0f\uff0c\u7528\u6237\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=UserInfo.class), @ApiImplicitParam(name="userUnit", value="json\u683c\u5f0f\uff0c\u7528\u6237\u673a\u6784\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=UserUnit.class)})
    @RequestMapping(method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u65b0\u589e\u7528\u6237")
    @WrapUpResponseBody
    public ResponseData create(@Valid UserInfo userInfo, UserUnit userUnit, HttpServletRequest request) {
        UserInfo dbuserinfo = this.sysUserManager.loadUserByLoginname(userInfo.getLoginName());
        if (null != dbuserinfo) {
            return ResponseData.makeErrorMessage((int)702, (String)("\u767b\u5f55\u540d" + userInfo.getLoginName() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01"));
        }
        if (null != userInfo.getUserRoles()) {
            for (UserRole ur : userInfo.getUserRoles()) {
                ur.setUserCode(userInfo.getUserCode());
            }
        }
        userUnit.setCreator(this.getLoginUserCode(request));
        userUnit.setUserCode(userInfo.getUserCode());
        this.sysUserManager.saveNewUserInfo(userInfo, userUnit);
        return ResponseData.makeResponseData((Object)userInfo);
    }

    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u4fe1\u606f", notes="\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="userInfo", value="json\u683c\u5f0f\uff0c\u7528\u6237\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=UserInfo.class), @ApiImplicitParam(name="userUnit", value="json\u683c\u5f0f\uff0c\u7528\u6237\u673a\u6784\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=UserUnit.class)})
    @RequestMapping(value={"/{userCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u7528\u6237\u4fe1\u606f")
    @WrapUpResponseBody
    public ResponseData edit(@PathVariable String userCode, @Valid UserInfo userInfo, UserUnit userUnit, HttpServletRequest request) {
        UserInfo dbUserInfo = this.sysUserManager.getObjectById(userCode);
        if (null == dbUserInfo) {
            return ResponseData.makeErrorMessage((String)"\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728");
        }
        this.sysUserUnitManager.deletePrimaryUnitByUserCode(userCode);
        userUnit.setUserCode(userInfo.getUserCode());
        userUnit.setUnitCode(userInfo.getPrimaryUnit());
        userUnit.setIsPrimary("T");
        userUnit.setCreator(this.getLoginUserCode(request));
        this.sysUserUnitManager.saveNewUserUnit(userUnit);
        if (StringUtils.isBlank((CharSequence)userInfo.getUserPin())) {
            userInfo.setUserPin(dbUserInfo.getUserPin());
        }
        this.sysUserManager.updateUserInfo(userInfo);
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f", notes="\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\u3002")
    @RequestMapping(value={"/current"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getCurrentUserInfo(HttpServletRequest request) {
        CentitUserDetails userDetails = super.getLoginUser(request);
        UserInfo userinfo = this.sysUserManager.getObjectById(userDetails.getUserCode());
        return ResponseData.makeResponseData((Object)userinfo);
    }

    @ApiOperation(value="\u83b7\u53d6\u5355\u4e2a\u7528\u6237\u4fe1\u606f", notes="\u6839\u636e\u7528\u6237\u4ee3\u7801\u83b7\u53d6\u5355\u4e2a\u7528\u6237\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", paramType="path", dataType="String")
    @RequestMapping(value={"/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseMapData getUserInfo(@PathVariable String userCode) {
        UserInfo userInfo = this.sysUserManager.getObjectById(userCode);
        UserUnit userUnit = this.sysUserUnitManager.getPrimaryUnitByUserCode(userCode);
        userInfo.setUserCode(StringEscapeUtils.unescapeHtml4((String)userInfo.getUserCode()));
        userInfo.setLoginName(StringEscapeUtils.unescapeHtml4((String)userInfo.getLoginName()));
        userInfo.setUserWord(StringEscapeUtils.unescapeHtml4((String)userInfo.getUserWord()));
        userInfo.setEnglishName(StringEscapeUtils.unescapeHtml4((String)userInfo.getEnglishName()));
        userInfo.setUserName(StringEscapeUtils.unescapeHtml4((String)userInfo.getUserName()));
        userInfo.setUserDesc(StringEscapeUtils.unescapeHtml4((String)userInfo.getUserDesc()));
        Object userJson = DictionaryMapUtils.objectToJSON((Object)userInfo);
        Object userUnitJson = DictionaryMapUtils.objectToJSON((Object)userUnit);
        ResponseMapData responseData = new ResponseMapData();
        responseData.addResponseData("userInfo", userJson);
        responseData.addResponseData("userUnit", userUnitJson);
        HashMap<Class, String[]> excludes = new HashMap<Class, String[]>();
        excludes.put(UserUnit.class, new String[]{"userInfo"});
        excludes.put(UserRole.class, new String[]{"userInfo"});
        responseData.toJSONString(JsonPropertyUtils.getExcludePropPreFilter(excludes));
        return responseData;
    }

    @ApiOperation(value="\u5f53\u524d\u767b\u5f55\u540d\u662f\u5426\u5df2\u5b58\u5728", notes="\u5f53\u524d\u767b\u5f55\u540d\u662f\u5426\u5df2\u5b58\u5728\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="loginName", value="\u767b\u5f55\u540d", paramType="query", dataType="String"), @ApiImplicitParam(name="regPhone", value="\u624b\u673a\u53f7", paramType="query", dataType="String"), @ApiImplicitParam(name="regEmail", value="\u90ae\u7bb1", paramType="query", dataType="String")})
    @RequestMapping(value={"/exists"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    public boolean isAnyExist(HttpServletRequest request) {
        String userCode = request.getParameter("userCode");
        String loginName = request.getParameter("loginName");
        String regPhone = request.getParameter("regPhone");
        String regEmail = request.getParameter("regEmail");
        return this.sysUserManager.isAnyOneExist(userCode, loginName, regPhone, regEmail);
    }

    @ApiOperation(value="\u5f53\u524d\u767b\u5f55\u540d\u662f\u5426\u5df2\u5b58\u5728", notes="\u5f53\u524d\u767b\u5f55\u540d\u662f\u5426\u5df2\u5b58\u5728\u3002")
    @ApiImplicitParam(name="loginName", value="\u767b\u5f55\u540d", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/exists/{loginName}"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    public boolean isExists(@PathVariable String loginName) throws IOException {
        UserInfo userInfo = this.sysUserManager.loadUserByLoginname(loginName);
        return null != userInfo;
    }

    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u5bc6\u7801", notes="\u66f4\u65b0\u7528\u6237\u5bc6\u7801\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="password", value="\u65e7\u5bc6\u7801", required=true, paramType="query", dataType="String"), @ApiImplicitParam(name="newPassword", value="\u65b0\u5bc6\u7801", required=true, paramType="query", dataType="String")})
    @RequestMapping(value={"/change/{userCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u7528\u6237\u5bc6\u7801")
    @WrapUpResponseBody
    public ResponseData changePwd(@PathVariable String userCode, String password, String newPassword) {
        this.sysUserManager.setNewPassword(userCode, password, newPassword);
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u5f3a\u5236\u66f4\u65b0\u7528\u6237\u5bc6\u7801", notes="\u5f3a\u5236\u66f4\u65b0\u7528\u6237\u5bc6\u7801\u3002")
    @ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/changePwd/{userCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5f3a\u5236\u66f4\u65b0\u7528\u6237\u5bc6\u7801")
    @WrapUpResponseBody
    public ResponseData forceChangePwd(@PathVariable String userCode, HttpServletRequest request) {
        String newPassword = request.getParameter("newPassword");
        if (StringUtils.isBlank((CharSequence)newPassword)) {
            this.sysUserManager.resetPwd(userCode);
        } else {
            this.sysUserManager.forceSetPassword(userCode, newPassword);
        }
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u68c0\u67e5\u7528\u6237\u5bc6\u7801\u662f\u5426\u53ef\u4ee5\u4fee\u6539", notes="\u68c0\u67e5\u7528\u6237\u5bc6\u7801\u662f\u5426\u53ef\u4ee5\u4fee\u6539\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="oldPassword", value="\u65e7\u5bc6\u7801", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/canchange/{userCode}/{oldPassword}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData canChangePwd(@PathVariable String userCode, @PathVariable String oldPassword) {
        boolean bo = true;
        bo = this.sysUserManager.checkUserPassword(userCode, oldPassword);
        return ResponseData.makeResponseData((Object)bo);
    }

    @ApiOperation(value="\u6279\u91cf\u91cd\u7f6e\u5bc6\u7801", notes="\u6279\u91cf\u91cd\u7f6e\u5bc6\u7801\u3002")
    @ApiImplicitParam(name="userCodes", value="\u7528\u6237\u4ee3\u7801\u96c6\u5408(\u6570\u7ec4)", allowMultiple=true, paramType="path", dataType="String")
    @RequestMapping(value={"/reset"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u91cd\u7f6e\u7528\u6237\u5bc6\u7801")
    @WrapUpResponseBody
    public ResponseData resetBatchPwd(String[] userCodes) {
        if (ArrayUtils.isEmpty((Object[])userCodes)) {
            return ResponseData.makeErrorMessage((String)"\u7528\u6237\u4ee3\u7801\u96c6\u5408\u4e3a\u7a7a");
        }
        this.sysUserManager.resetPwd(userCodes);
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7528\u6237", notes="\u6279\u91cf\u5220\u9664\u7528\u6237\u3002")
    @ApiImplicitParam(name="userCodes", value="\u7528\u6237\u4ee3\u7801\u96c6\u5408(\u6570\u7ec4)", allowMultiple=true, required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{userCodes}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u7528\u6237")
    @WrapUpResponseBody
    public ResponseData deleteUser(@PathVariable String[] userCodes) {
        for (String userCode : userCodes) {
            UserInfo userInfo = this.sysUserManager.getObjectById(userCode);
            if (null == userInfo) {
                return ResponseData.makeErrorMessage((String)"\u8be5\u7528\u6237\u4e0d\u5b58\u5728");
            }
            this.sysUserManager.deleteUserInfo(userCode);
        }
        return ResponseData.makeSuccessResponse();
    }
}

