/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.system.po.UserQueryFilter;
import com.centit.framework.system.service.UserQueryFilterManager;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/userqueryfilter"})
@Api(value="\u7528\u6237\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u6761\u4ef6\u64cd\u4f5c\u3002", tags={"\u7528\u6237\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u6761\u4ef6\u64cd\u4f5c\u63a5\u53e3"})
public class UserQueryFilterController
extends BaseController {
    @Resource
    private UserQueryFilterManager userQueryFilterMag;

    public String getOptId() {
        return "UserQueryFilter";
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709 \u7528\u6237\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u6761\u4ef6", notes="\u67e5\u8be2\u6240\u6709 \u7528\u6237\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u6761\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="field", value="\u8fc7\u6ee4\u8fd4\u56de\u7684\u5b57\u6bb5\u4fe1\u606f", allowMultiple=true, paramType="query", dataType="String"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\u7684\u5206\u9875\u4fe1\u606f", required=true, paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData list(String[] field, PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        List listObjects = this.userQueryFilterMag.listObjects(searchColumn, pageDesc);
        SimplePropertyPreFilter simplePropertyPreFilter = null;
        if (ArrayUtils.isNotEmpty((Object[])field)) {
            simplePropertyPreFilter = new SimplePropertyPreFilter(UserQueryFilter.class, field);
        }
        ResponseMapData resData = new ResponseMapData();
        if (null == pageDesc) {
            resData.addResponseData("objList", (Object)listObjects);
            resData.toJSONString((PropertyPreFilter)simplePropertyPreFilter);
            return ResponseData.makeResponseData((Object)resData.getResponseData("objList"));
        }
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    @ApiOperation(value="\u67e5\u627e\u7528\u6237\u67d0\u4e2a\u6a21\u5757\u7684\u6240\u6709\u8fc7\u6ee4\u5668", notes="\u67e5\u627e\u7528\u6237\u67d0\u4e2a\u6a21\u5757\u7684\u6240\u6709\u8fc7\u6ee4\u5668")
    @ApiImplicitParam(name="modelCode", value="\u6a21\u5757\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/list/{modelCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listUserQueryFilter(@PathVariable String modelCode, HttpServletRequest request) {
        List userFilters = this.userQueryFilterMag.listUserQueryFilterByModle(super.getLoginUserCode(request), modelCode);
        return ResponseData.makeResponseData((Object)userFilters);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u7528\u6237\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u6761\u4ef6", notes="\u67e5\u8be2\u5355\u4e2a\u7528\u6237\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u6761\u4ef6")
    @ApiImplicitParam(name="filterNo", value="\u8fc7\u6ee4\u6761\u4ef6\u5e8f\u53f7", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{filterNo}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getUserQueryFilter(@PathVariable Long filterNo) {
        UserQueryFilter userQueryFilter = this.userQueryFilterMag.getUserQueryFilter(filterNo);
        return ResponseData.makeResponseData((Object)userQueryFilter);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u7528\u6237\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u6761\u4ef6\u65b0\u589e \u7528\u6237\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u6761\u4ef6", notes="\u65b0\u589e \u7528\u6237\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u6761\u4ef6")
    @ApiImplicitParam(name="userQueryFilter", value="json\u683c\u5f0f\u7684\u8fc7\u6ee4\u6761\u4ef6\u5bf9\u8c61", required=true, paramType="body", dataTypeClass=UserQueryFilter.class)
    @RequestMapping(method={RequestMethod.POST})
    public ResponseData createUserQueryFilter(@Valid UserQueryFilter userQueryFilter, HttpServletRequest request) {
        userQueryFilter.setFilterNo(this.userQueryFilterMag.getNextFilterKey());
        userQueryFilter.setCreateDate(DatetimeOpt.currentUtilDate());
        userQueryFilter.setIsDefault("F");
        if (StringBaseOpt.isNvl((String)userQueryFilter.getUserCode())) {
            userQueryFilter.setUserCode(super.getLoginUserCode(request));
        }
        this.userQueryFilterMag.saveNewObject(userQueryFilter);
        return ResponseData.makeResponseData((Object)userQueryFilter);
    }

    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237\u6700\u65b0\u67e5\u770b\u7b5b\u9009\u5668", notes="\u4fdd\u5b58\u7528\u6237\u6700\u65b0\u67e5\u770b\u7b5b\u9009\u5668")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelCode", value="\u6240\u5c5e\u6a21\u5757\u7f16\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="userQueryFilter", value="json\u683c\u5f0f\u7684\u8fc7\u6ee4\u6761\u4ef6\u5bf9\u8c61", required=true, paramType="body", dataTypeClass=UserQueryFilter.class)})
    @RequestMapping(value={"/default/{modelCode}"}, method={RequestMethod.POST, RequestMethod.PUT})
    @WrapUpResponseBody
    public ResponseData createUserDefaultFilter(@PathVariable String modelCode, @Valid UserQueryFilter userQueryFilter, HttpServletRequest request) {
        userQueryFilter.setCreateDate(DatetimeOpt.currentUtilDate());
        userQueryFilter.setIsDefault("T");
        userQueryFilter.setModleCode(modelCode);
        if (StringBaseOpt.isNvl((String)userQueryFilter.getUserCode())) {
            userQueryFilter.setUserCode(super.getLoginUserCode(request));
        }
        Long pk = this.userQueryFilterMag.saveUserDefaultFilter(userQueryFilter);
        return ResponseData.makeResponseData((Object)pk);
    }

    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237\u6700\u65b0\u67e5\u770b\u7b5b\u9009\u5668", notes="\u4fdd\u5b58\u7528\u6237\u6700\u65b0\u67e5\u770b\u7b5b\u9009\u5668")
    @ApiImplicitParam(name="modelCode", value="\u6240\u5c5e\u6a21\u5757\u7f16\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/default/{modelCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getUserDefaultFilter(@PathVariable String modelCode, HttpServletRequest request) {
        UserQueryFilter userQueryFilter = this.userQueryFilterMag.getUserDefaultFilter(super.getLoginUserCode(request), modelCode);
        return ResponseData.makeResponseData((Object)userQueryFilter);
    }

    @ApiOperation(value="\u5220\u9664\u5355\u4e2a \u7528\u6237\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u6761\u4ef6\u8868", notes="\u5220\u9664\u5355\u4e2a \u7528\u6237\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u6761\u4ef6\u8868")
    @ApiImplicitParam(name="filterNo", value="\u8fc7\u6ee4\u6761\u4ef6\u5e8f\u53f7", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{filterNo}"}, method={RequestMethod.DELETE})
    @WrapUpResponseBody
    public ResponseData deleteUserQueryFilter(@PathVariable Long filterNo) {
        boolean b = this.userQueryFilterMag.deleteUserQueryFilter(filterNo);
        if (b) {
            return ResponseData.makeSuccessResponse();
        }
        return ResponseData.makeErrorMessage((String)"\u4e0d\u80fd\u5220\u9664\u9ed8\u8ba4\u8fc7\u6ee4\u6761\u4ef6\uff01");
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fdd\u5b58 \u7528\u6237\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u6761\u4ef6\u8868", notes="\u65b0\u589e\u6216\u4fdd\u5b58 \u7528\u6237\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u6761\u4ef6\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="filterNo", value="\u8fc7\u6ee4\u6761\u4ef6\u5e8f\u53f7", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="userQueryFilter", value="json\u683c\u5f0f\u7684\u8fc7\u6ee4\u6761\u4ef6\u5bf9\u8c61", required=true, paramType="body", dataTypeClass=UserQueryFilter.class)})
    @RequestMapping(value={"/{filterNo}"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public ResponseData updateUserQueryFilter(@PathVariable Long filterNo, @Valid UserQueryFilter userQueryFilter) {
        UserQueryFilter dbUserQueryFilter = this.userQueryFilterMag.getUserQueryFilter(filterNo);
        if (null == userQueryFilter) {
            return ResponseData.makeErrorMessage((String)"\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        dbUserQueryFilter.copy(userQueryFilter);
        dbUserQueryFilter.setCreateDate(DatetimeOpt.currentUtilDate());
        this.userQueryFilterMag.mergeObject(dbUserQueryFilter);
        return ResponseData.makeSuccessResponse();
    }
}

