/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.system.po.FVUserRoles;
import com.centit.framework.system.po.RoleInfo;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.po.UserRole;
import com.centit.framework.system.po.UserRoleId;
import com.centit.framework.system.service.SysRoleManager;
import com.centit.framework.system.service.SysUnitManager;
import com.centit.framework.system.service.SysUserRoleManager;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.json.JsonPropertyUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/userrole"})
@Api(value="\u7528\u6237\u89d2\u8272\u5173\u8054\u64cd\u4f5c\uff0c\u6b64\u64cd\u4f5c\u662f\u53cc\u5411\u64cd\u4f5c\u3002", tags={"\u7528\u6237\u89d2\u8272\u5173\u8054\u64cd\u4f5c\u63a5\u53e3"})
public class UserRoleController
extends BaseController {
    @Resource
    @NotNull
    private SysRoleManager sysRoleManager;
    @Resource
    @NotNull
    private SysUserRoleManager sysUserRoleManager;
    @Resource
    private SysUnitManager sysUnitManager;

    public String getOptId() {
        return "USERROLE";
    }

    @ApiOperation(value="\u901a\u8fc7\u7ee7\u627f\u5f97\u5230\u7684\u7528\u6237", notes="\u901a\u8fc7\u7ee7\u627f\u5f97\u5230\u7684\u7528\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\u7684\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(value={"/roleusersinherited/{roleCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<FVUserRoles> listUserRoleSInherited(@PathVariable String roleCode, PageDesc pageDesc) {
        HashMap<String, String> filterMap = new HashMap<String, String>(8);
        filterMap.put("roleCode", roleCode);
        filterMap.put("obtainType", "I");
        List listObjects = this.sysUserRoleManager.pageQueryUserRole(filterMap, pageDesc);
        return PageQueryResult.createResultMapDict((Collection)listObjects, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u901a\u8fc7\u7ee7\u627f\u5f97\u5230\u7684\u89d2\u8272", notes="\u901a\u8fc7\u7ee7\u627f\u5f97\u5230\u7684\u89d2\u8272\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\u7684\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(value={"/userrolesinherited/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<FVUserRoles> listRoleUsersInherited(@PathVariable String userCode, PageDesc pageDesc) {
        HashMap<String, String> filterMap = new HashMap<String, String>(8);
        filterMap.put("userCode", userCode);
        filterMap.put("obtainType", "I");
        List listObjects = this.sysUserRoleManager.pageQueryUserRole(filterMap, pageDesc);
        return PageQueryResult.createResultMapDict((Collection)listObjects, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7684\u6240\u6709\u89d2\u8272\u4fe1\u606f", notes="\u83b7\u53d6\u7528\u6237\u7684\u6240\u6709\u89d2\u8272\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\u7684\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(value={"/userrolesall/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<FVUserRoles> listRoleUsersAll(@PathVariable String userCode, PageDesc pageDesc) {
        HashMap<String, String> filterMap = new HashMap<String, String>(8);
        filterMap.put("userCode", userCode);
        List listObjects = this.sysUserRoleManager.pageQueryUserRole(filterMap, pageDesc);
        return PageQueryResult.createResultMapDict((Collection)listObjects, (PageDesc)pageDesc);
    }

    protected ResponseData listObject(Map<String, Object> filterMap, PageDesc pageDesc) {
        JSONArray listObjects = this.sysUserRoleManager.listObjects(filterMap, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        HashMap<Class<RoleInfo>, String[]> excludes = new HashMap<Class<RoleInfo>, String[]>();
        excludes.put(RoleInfo.class, new String[]{"rolePowers"});
        resData.toJSONString(JsonPropertyUtils.getExcludePropPreFilter(excludes));
        return resData;
    }

    @ApiOperation(value="\u901a\u8fc7\u7528\u6237\u4ee3\u7801\u83b7\u53d6\u53ef\u7528\u7684\u6240\u6709\u7528\u6237\u89d2\u8272", notes="\u901a\u8fc7\u7528\u6237\u4ee3\u7801\u83b7\u53d6\u53ef\u7528\u7684\u6240\u6709\u7528\u6237\u89d2\u8272")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\u7684\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(value={"/userroles/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listRolesByUser(@PathVariable String userCode, PageDesc pageDesc, HttpServletRequest request) {
        Map filterMap = BaseController.convertSearchColumn((HttpServletRequest)request);
        filterMap.put("userCode", userCode);
        filterMap.put("roleValid", "T");
        return this.listObject(filterMap, pageDesc);
    }

    @ApiOperation(value="\u901a\u8fc7\u89d2\u8272\u4ee3\u7801\u83b7\u53d6\u7528\u6237", notes="\u901a\u8fc7\u89d2\u8272\u4ee3\u7801\u83b7\u53d6\u53ef\u7528\u7684\u7528\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\u7684\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(value={"/roleusers/{roleCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listUsersByRole(@PathVariable String roleCode, PageDesc pageDesc, HttpServletRequest request) {
        Map filterMap = BaseController.convertSearchColumn((HttpServletRequest)request);
        if (filterMap.get("userName") != null) {
            filterMap.put("userName", StringEscapeUtils.escapeHtml4((String)filterMap.get("userName").toString()));
        }
        filterMap.put("roleCode", roleCode);
        filterMap.put("userValid", "T");
        return this.listObject(filterMap, pageDesc);
    }

    @ApiOperation(value="\u901a\u8fc7\u89d2\u8272\u4ee3\u7801\u83b7\u53d6\u5f53\u524d\u673a\u6784\u4e0b\u7684\u6240\u6709\u53ef\u7528\u7684\u7528\u6237", notes="\u901a\u8fc7\u89d2\u8272\u4ee3\u7801\u83b7\u53d6\u5f53\u524d\u673a\u6784\u4e0b\u7684\u6240\u6709\u53ef\u7528\u7684\u7528\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\u7684\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(value={"/rolecurrentusers/{roleCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listCurrentUsersByRole(@PathVariable String roleCode, PageDesc pageDesc, HttpServletRequest request) {
        String currentUnitCode = WebOptUtils.getLoginUser((HttpServletRequest)request).getCurrentUnitCode();
        UnitInfo currentUnitInfo = this.sysUnitManager.getObjectById(currentUnitCode);
        Map filterMap = BaseController.convertSearchColumn((HttpServletRequest)request);
        filterMap.put("roleCode", roleCode);
        filterMap.put("unitPath", currentUnitInfo.getUnitPath());
        filterMap.put("userValid", "T");
        return this.listObject(filterMap, pageDesc);
    }

    @ApiOperation(value="\u901a\u8fc7\u7528\u6237\u4ee3\u7801\u83b7\u53d6\u5f53\u524d\u673a\u6784\u4e0b\u7684\u6240\u6709\u53ef\u7528\u7684\u89d2\u8272", notes="\u901a\u8fc7\u7528\u6237\u4ee3\u7801\u83b7\u53d6\u5f53\u524d\u673a\u6784\u4e0b\u7684\u6240\u6709\u53ef\u7528\u7684\u89d2\u8272")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\u7684\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(value={"/usercurrentroles/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listUserUnitRoles(@PathVariable String userCode, PageDesc pageDesc, HttpServletRequest request) {
        Map filterMap = BaseController.convertSearchColumn((HttpServletRequest)request);
        String currentUnitCode = WebOptUtils.getLoginUser((HttpServletRequest)request).getCurrentUnitCode();
        filterMap.put("userCode", userCode);
        filterMap.put("roleUnitCode", currentUnitCode);
        filterMap.put("roleValid", "T");
        return this.listObject(filterMap, pageDesc);
    }

    @ApiOperation(value="\u6839\u636e\u673a\u6784\u4ee3\u7801\u548c\u89d2\u8272\u4ee3\u7801\u83b7\u53d6\u7528\u6237", notes="\u6839\u636e\u673a\u6784\u4ee3\u7801\u548c\u89d2\u8272\u4ee3\u7801\u83b7\u53d6\u7528\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="unitCode", value="\u673a\u6784\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\u7684\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(value={"/unitroleusers/{unitCode}/{roleCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listUnitRoleUsers(@PathVariable String unitCode, @PathVariable String roleCode, PageDesc pageDesc, HttpServletRequest request) {
        RoleInfo role = this.sysRoleManager.getObjectById(roleCode);
        Map filterMap = BaseController.convertSearchColumn((HttpServletRequest)request);
        filterMap.put("roleCode", roleCode);
        if (role != null && "P".equals(role.getRoleType())) {
            filterMap.put("unitCode", unitCode);
        }
        return this.listObject(filterMap, pageDesc);
    }

    @ApiOperation(value="\u8fd4\u56de\u4e00\u6761\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f", notes="\u6839\u636e\u7528\u6237\u4ee3\u7801\u548c\u89d2\u8272\u4ee3\u7801\u83b7\u53d6\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/{roleCode}/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getUserRole(@PathVariable String roleCode, @PathVariable String userCode) {
        UserRole userRole = this.sysUserRoleManager.getObjectById(new UserRoleId(userCode, roleCode));
        if (null == userRole) {
            return ResponseData.makeErrorMessage((String)"\u5f53\u524d\u89d2\u8272\u4e2d\u65e0\u6b64\u7528\u6237");
        }
        HashMap<Class<RoleInfo>, String[]> excludes = new HashMap<Class<RoleInfo>, String[]>();
        excludes.put(RoleInfo.class, new String[]{"rolePowers"});
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)userRole);
        resData.toJSONString(JsonPropertyUtils.getExcludePropPreFilter(excludes));
        return ResponseData.makeResponseData((Object)resData.getResponseData("objList"));
    }

    @ApiOperation(value="\u521b\u5efa\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f", notes="\u521b\u5efa\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userRole", value="json\u683c\u5f0f\u7684\u7528\u6237\u89d2\u8272\u5bf9\u8c61\u4fe1\u606f", required=true, paramType="body", dataTypeClass=UserRole.class), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801\u96c6\u5408\uff08\u6570\u7ec4\uff09", allowMultiple=true, paramType="query", dataType="String")})
    @RequestMapping(method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u65b0\u589e\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f")
    @WrapUpResponseBody
    public ResponseData create(@Valid UserRole userRole, @Valid String[] userCode) {
        userRole.setCreateDate(new Date());
        if (userCode != null && userCode.length > 0) {
            for (String u : userCode) {
                UserRole ur = new UserRole();
                ur.copy(userRole);
                ur.setUserCode(u);
                this.sysUserRoleManager.mergeObject(ur);
            }
        } else {
            this.sysUserRoleManager.mergeObject(userRole);
        }
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f", notes="\u66f4\u65b0\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="userRole", value="json\u683c\u5f0f\u7684\u7528\u6237\u89d2\u8272\u5bf9\u8c61\u4fe1\u606f", required=true, paramType="body", dataTypeClass=UserRole.class)})
    @RequestMapping(value={"/{roleCode}/{userCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u7528\u6237\u89d2\u8272\u4fe1\u606f")
    @WrapUpResponseBody
    public ResponseData edit(@PathVariable String roleCode, @PathVariable String userCode, @Valid UserRole userRole) {
        UserRole dbUserRole = this.sysUserRoleManager.getObjectById(new UserRoleId(userCode, roleCode));
        if (null == userRole) {
            return ResponseData.makeErrorMessage((String)"\u5f53\u524d\u89d2\u8272\u4e2d\u65e0\u6b64\u7528\u6237");
        }
        this.sysUserRoleManager.mergeObject(dbUserRole, userRole);
        return ResponseData.makeResponseData((Object)userRole);
    }

    @ApiOperation(value="\u5220\u9664\u591a\u4e2a\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f", notes="\u5220\u9664\u591a\u4e2a\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="userCodes", value="\u7528\u6237\u4ee3\u7801,\u591a\u4e2a\u7528\u6237\u4f7f\u7528\u9017\u53f7\u5206\u9694", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/{roleCode}/{userCodes}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f")
    @WrapUpResponseBody
    public ResponseData delete(@PathVariable String roleCode, @PathVariable String userCodes) {
        String[] userCodeArray;
        for (String userCode : userCodeArray = userCodes.split(",")) {
            UserRoleId userRoleId = new UserRoleId(userCode, roleCode);
            UserRole userRole = this.sysUserRoleManager.getObjectById(userRoleId);
            this.sysUserRoleManager.deleteObjectById(userRoleId);
        }
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f", notes="\u5220\u9664\u5355\u4e2a\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/ban/{roleCode}/{userCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f")
    @WrapUpResponseBody
    public ResponseData ban(@PathVariable String roleCode, @PathVariable String userCode) {
        UserRoleId a = new UserRoleId(userCode, roleCode);
        this.sysUserRoleManager.deleteObjectById(a);
        return ResponseData.makeSuccessResponse();
    }
}

