/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.security.model.CentitPasswordEncoder;
import com.centit.framework.system.po.OsInfo;
import com.centit.framework.system.service.OsInfoManager;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.json.JsonPropertyUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/osinfo"})
@Api(tags={"\u4e1a\u52a1\u7cfb\u7edf\u62a4\u63a5\u53e3"}, value="\u4e1a\u52a1\u7cfb\u7edf\u62a4\u63a5\u53e3")
public class OsInfoController
extends BaseController {
    @Autowired
    private OsInfoManager osInfoMag;
    @Autowired
    private CentitPasswordEncoder passwordEncoder;
    private String optId = "OS";

    @ApiOperation(value="\u5237\u65b0\u5355\u4e2a\u7cfb\u7edf\u6570\u636e", notes="\u5237\u65b0\u5355\u4e2a\u7cfb\u7edf\u6570\u636e\u3002")
    @ApiImplicitParam(name="osInfo", value="json\u683c\u5f0f\uff0c\u4e1a\u52a1\u7cfb\u7edf\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=OsInfo.class)
    @RequestMapping(value={"/data/refresh/single"}, method={RequestMethod.POST})
    public void refreshSingle(@RequestBody OsInfo osInfo, HttpServletResponse response) {
        if (osInfo == null) {
            return;
        }
        boolean flag = this.osInfoMag.refreshSingle(osInfo);
        JsonResultUtils.writeSingleDataJson((Object)flag, (HttpServletResponse)response);
    }

    @ApiOperation(value="\u5237\u65b0\u6240\u6709\u7cfb\u7edf\u7684\u6570\u636e", notes="\u5237\u65b0\u67e5\u8be2\u7684\u6240\u6709\u7cfb\u7edf\u7684\u6570\u636e\u3002")
    @RequestMapping(value={"/data/refresh/all"}, method={RequestMethod.GET})
    public void refreshAll(HttpServletResponse response) {
        boolean flag = this.osInfoMag.refreshAll();
        JsonResultUtils.writeSingleDataJson((Object)flag, (HttpServletResponse)response);
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7684\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f", notes="\u67e5\u8be2\u6240\u6709\u7684\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u3002")
    @RequestMapping(method={RequestMethod.GET})
    @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\uff0c\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)
    @WrapUpResponseBody
    public PageQueryResult<Object> list(PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        JSONArray listObjects = this.osInfoMag.listOsInfoAsJson(searchColumn, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)listObjects, (PageDesc)pageDesc, (Class[])new Class[]{OsInfo.class});
    }

    @ApiOperation(value="\u6dfb\u52a0\u4e1a\u52a1\u7cfb\u7edf", notes="\u6dfb\u52a0\u4e1a\u52a1\u7cfb\u7edf\u3002")
    @ApiImplicitParam(name="osInfo", value="json\u683c\u5f0f\uff0c\u4e1a\u52a1\u7cfb\u7edf\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=OsInfo.class)
    @RequestMapping(method={RequestMethod.POST})
    public void saveOsInfo(@Valid OsInfo osinfo, HttpServletRequest request, HttpServletResponse response) {
        if (osinfo == null) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (HttpServletResponse)response);
            return;
        }
        if (this.osInfoMag.getObjectById((Serializable)((Object)osinfo.getOsId())) != null) {
            JsonResultUtils.writeErrorMessageJson((String)"\u4e1a\u52a1\u7cfb\u7edfID\u5df2\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        osinfo.setCreated(WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        osinfo.setCreateTime(new Date());
        if (osinfo.getOauthPassword() != null && !this.passwordEncoder.isCorrectPasswordFormat(osinfo.getOauthPassword())) {
            osinfo.setOauthPassword(this.passwordEncoder.createPassword(osinfo.getOauthPassword(), (Object)osinfo.getOsId()));
        }
        this.osInfoMag.saveNewObject((Serializable)osinfo);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logNewObject((HttpServletRequest)request, (String)this.optId, (String)osinfo.getOsId(), (String)"create", (String)"\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf", (Object)osinfo);
    }

    @RequestMapping(value={"/{osId}"}, method={RequestMethod.PUT})
    @ApiOperation(value="\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f", notes="\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="osId", value="\u4e1a\u52a1\u7cfb\u7edfid", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="osinfo", value="json\u683c\u5f0f\uff0c\u4e1a\u52a1\u7cfb\u7edf\u5bf9\u8c61\u4fe1\u606f", required=true, paramType="body", dataTypeClass=OsInfo.class)})
    public void updateOsInfo(@PathVariable String osId, @Valid OsInfo osinfo, HttpServletRequest request, HttpServletResponse response) {
        OsInfo dbOsInfo = (OsInfo)this.osInfoMag.getObjectById((Serializable)((Object)osId));
        OsInfo oldValue = new OsInfo();
        BeanUtils.copyProperties((Object)dbOsInfo, (Object)oldValue);
        osinfo.setLastModifyDate(new Date());
        if (!this.passwordEncoder.isCorrectPasswordFormat(osinfo.getOauthPassword())) {
            osinfo.setOauthPassword(this.passwordEncoder.createPassword(osinfo.getOauthPassword(), (Object)osinfo.getOsId()));
        }
        this.osInfoMag.mergeObject((Serializable)osinfo);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logUpdateObject((HttpServletRequest)request, (String)this.optId, (String)osId, (String)"update", (String)"\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f", (Object)osinfo, (Object)oldValue);
    }

    @RequestMapping(value={"/{osId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5355\u4e2a\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f", notes="\u6839\u636eID\u67e5\u8be2\u5355\u4e2a\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="osId", value="\u4e1a\u52a1\u7cfb\u7edfid", required=true, paramType="path", dataType="String")
    public void getOsInhfo(@PathVariable String osId, HttpServletResponse response) {
        OsInfo osInfo = (OsInfo)this.osInfoMag.getObjectById((Serializable)((Object)osId));
        JsonResultUtils.writeSingleDataJson((Object)osInfo, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getExcludePropPreFilter(OsInfo.class, (String[])new String[]{"osInfo"}));
    }

    @RequestMapping(value={"/{osId}"}, method={RequestMethod.DELETE})
    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u5355\u4e2a\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f", notes="\u6839\u636eID\u5220\u9664\u5355\u4e2a\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="osId", value="\u4e1a\u52a1\u7cfb\u7edfid", required=true, paramType="path", dataType="String")
    public void deleteOsInfo(@PathVariable String osId, HttpServletRequest request, HttpServletResponse response) {
        this.osInfoMag.deleteObjectById((Serializable)((Object)osId));
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OsInfo dbOsInfo = (OsInfo)this.osInfoMag.getObjectById((Serializable)((Object)osId));
        OperationLogCenter.logDeleteObject((HttpServletRequest)request, (String)this.optId, (String)osId, (String)"delete", (String)"\u5220\u9664\u4e1a\u52a1\u7cfb\u7edf", (Object)dbOsInfo);
    }
}

