/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.system.po.UserSetting;
import com.centit.framework.system.po.UserSettingId;
import com.centit.framework.system.service.UserSettingManager;
import com.centit.support.common.ParamName;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.HtmlUtils;

@Controller
@RequestMapping(value={"/usersetting"})
@Api(value="\u7528\u6237\u8bbe\u7f6e\u64cd\u4f5c\u7ef4\u62a4\u63a5\u53e3\u3002", tags={"\u7528\u6237\u8bbe\u7f6e\u64cd\u4f5c\u63a5\u53e3"})
public class UserSettingController
extends BaseController {
    @Autowired
    private UserSettingManager userSettingManager;

    public String getOptId() {
        return "userSetting";
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u6240\u6709\u7684\u7528\u6237\u53c2\u6570\u8bbe\u7f6e\u4fe1\u606f", notes="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u6240\u6709\u7684\u7528\u6237\u53c2\u6570\u8bbe\u7f6e\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\u7684\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)
    @GetMapping
    @WrapUpResponseBody
    public PageQueryResult<Object> list(PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        searchColumn.put("userCode", WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        JSONArray listObjects = this.userSettingManager.listObjects(searchColumn, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)listObjects, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u4e2a\u4eba\u8bbe\u7f6e\u5217\u8868", notes="\u67e5\u8be2\u7528\u6237\u4e2a\u4eba\u8bbe\u7f6e\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\u7684\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)})
    @GetMapping(value={"/list/{userCode}"})
    @WrapUpResponseBody
    public PageQueryResult<Object> listUserSetting(@PathVariable String userCode, PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        searchColumn.put("userCode", userCode);
        JSONArray listObjects = this.userSettingManager.listObjects(searchColumn, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)listObjects, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u4e2a\u4eba\u9ed8\u8ba4\u8bbe\u7f6e\u5217\u8868", notes="\u67e5\u8be2\u7528\u6237\u4e2a\u4eba\u9ed8\u8ba4\u8bbe\u7f6e\u5217\u8868\u3002")
    @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\u7684\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)
    @GetMapping(value={"/listdefault"})
    @ResponseBody
    public PageQueryResult<UserSetting> listUserDefaultSetting(PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        List listObjects = this.userSettingManager.listDefaultSettings(searchColumn, pageDesc);
        return PageQueryResult.createResult((Collection)listObjects, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u6240\u6709\u4e2a\u4eba\u8bbe\u7f6e \u4e0d\u5206\u9875", notes="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u6240\u6709\u4e2a\u4eba\u8bbe\u7f6e \u4e0d\u5206\u9875\u3002")
    @ApiImplicitParam(name="field", value="\u9700\u8981\u8fd4\u56de\u7684\u5b57\u6bb5", allowMultiple=true, paramType="query", dataType="String")
    @RequestMapping(value={"/listall"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<UserSetting> listAll(String[] field, HttpServletRequest request) {
        HashMap<String, String> searchColumn = new HashMap<String, String>();
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        searchColumn.put("userCode", userCode);
        List listObjects = this.userSettingManager.listObjects(searchColumn);
        return PageQueryResult.createResultMapDict((Collection)listObjects, null, (String[])field);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u8bbe\u7f6e\u7684\u53c2\u6570", notes="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u8bbe\u7f6e\u7684\u53c2\u6570\u3002")
    @ApiImplicitParam(name="paramCode", value="\u53c2\u6570\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{paramCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getUserSetting(@PathVariable String paramCode, HttpServletRequest request) {
        UserSettingId id = new UserSettingId(WebOptUtils.getCurrentUserCode((HttpServletRequest)request), paramCode);
        UserSetting userSetting = this.userSettingManager.getObjectById(id);
        if (null != userSetting) {
            userSetting.setParamValue(HtmlUtils.htmlUnescape((String)userSetting.getParamValue()));
        }
        return ResponseData.makeResponseData((Object)userSetting);
    }

    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u8bbe\u7f6e\u53c2\u6570", notes="\u66f4\u65b0\u7528\u6237\u8bbe\u7f6e\u53c2\u6570\u3002")
    @ApiImplicitParam(name="userSetting", value="json\u683c\u5f0f\u7684\u7528\u6237\u8bbe\u7f6e\u53c2\u6570\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=UserSetting.class)
    @RequestMapping(method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u7528\u6237\u8bbe\u7f6e\u53c2\u6570", tag="{loginUser.userCode}:{us.paramCode}")
    @WrapUpResponseBody
    public ResponseData editUserSetting(@ParamName(value="us") @Valid UserSetting userSetting) {
        boolean isDefaultValue = userSetting.isDefaultValue();
        if (isDefaultValue) {
            this.userSettingManager.saveNewUserSetting(userSetting);
        } else {
            this.userSettingManager.updateUserSetting(userSetting);
        }
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u9ed8\u8ba4\u8bbe\u7f6e\u53c2\u6570", notes="\u66f4\u65b0\u7528\u6237\u9ed8\u8ba4\u8bbe\u7f6e\u53c2\u6570\u3002")
    @ApiImplicitParam(name="userSetting", value="json\u683c\u5f0f\u7684\u7528\u6237\u8bbe\u7f6e\u53c2\u6570\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=UserSetting.class)
    @RequestMapping(value={"updatedefault"}, method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u5f53\u524d\u7528\u6237\u8bbe\u7f6e\u53c2\u6570", tag="{loginUser.userCode}:{us.paramCode}")
    @WrapUpResponseBody
    public ResponseData editDefaultSetting(@ParamName(value="us") @Valid UserSetting userSetting) {
        UserSetting dbSetting = this.userSettingManager.getUserSetting(userSetting.getUserCode(), userSetting.getParamCode());
        if (dbSetting == null) {
            userSetting.setUserCode("default");
            this.userSettingManager.saveNewUserSetting(userSetting);
        } else {
            this.userSettingManager.updateUserSetting(userSetting);
        }
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u5220\u9664\u5f53\u524d\u7528\u6237\u8bbe\u7f6e\u53c2\u6570", notes="\u5220\u9664\u5f53\u524d\u7528\u6237\u8bbe\u7f6e\u53c2\u6570\u3002")
    @ApiImplicitParam(name="paramCode", value="\u7528\u6237\u8bbe\u7f6e\u53c2\u6570\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{paramCode}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u7528\u6237\u8bbe\u7f6e\u53c2\u6570", tag="{loginUser.userCode}:{paramCode}")
    @WrapUpResponseBody
    public ResponseData deleteUserSetting(@ParamName(value="paramCode") @PathVariable String paramCode, HttpServletRequest request) {
        UserSetting dbUserSetting = this.userSettingManager.getObjectById(new UserSettingId(WebOptUtils.getCurrentUserCode((HttpServletRequest)request), paramCode));
        this.userSettingManager.deleteObject(dbUserSetting);
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237\u8bbe\u7f6e\u53c2\u6570", notes="\u6839\u636e\u7528\u6237\u4ee3\u7801\u548c\u53c2\u6570\u4ee3\u7801\u5220\u9664\u7528\u6237\u8bbe\u7f6e\u53c2\u6570\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="paramCode", value="\u8bbe\u7f6e\u7f16\u7801", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/{userCode}/{paramCode}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u7528\u6237\u8bbe\u7f6e\u53c2\u6570", tag="{userCode}:{paramCode}")
    @WrapUpResponseBody
    public ResponseData delete(@ParamName(value="userCode") @PathVariable String userCode, @ParamName(value="paramCode") @PathVariable String paramCode) {
        UserSetting userSetting = this.userSettingManager.getUserSetting(userCode, paramCode);
        if (userSetting != null) {
            if ("default".equals(userSetting.getUserCode())) {
                return ResponseData.makeErrorMessage((String)"\u9ed8\u8ba4\u8bbe\u7f6e\u4e0d\u80fd\u5220\u9664\uff01");
            }
            this.userSettingManager.deleteObject(userSetting);
        }
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237\u9ed8\u8ba4\u8bbe\u7f6e", notes="\u5220\u9664\u7528\u6237\u9ed8\u8ba4\u8bbe\u7f6e\u3002")
    @ApiImplicitParam(name="paramCode", value="\u7528\u6237\u8bbe\u7f6e\u53c2\u6570\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/deletedefault/{paramCode}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u7528\u6237\u8bbe\u7f6e\u53c2\u6570", tag="{paramCode}")
    @WrapUpResponseBody
    public ResponseData deleteDefault(@ParamName(value="paramCode") @PathVariable String paramCode) {
        UserSetting userSetting = this.userSettingManager.getUserSetting("default", paramCode);
        if (userSetting == null) {
            return ResponseData.makeErrorMessage((String)"\u503c\u5df2\u4e3anull\uff01");
        }
        this.userSettingManager.deleteObject(userSetting);
        return ResponseData.successResponse;
    }
}

