/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson2.JSONArray;
import com.centit.fileserver.utils.UploadDownloadUtils;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.basedata.DataCatalog;
import com.centit.framework.model.basedata.DataDictionary;
import com.centit.framework.model.basedata.DataDictionaryId;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.system.service.DataDictionaryManager;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.JavaBeanMetaData;
import com.centit.support.common.ObjectException;
import com.centit.support.common.ParamName;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.report.ExcelImportUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/dictionary"})
@Api(tags={"\u6846\u67b6\u6570\u636e\u5b57\u5178\u64cd\u4f5c\u63a5\u53e3"}, value="\u6846\u67b6\u6570\u636e\u5b57\u5178\u63a5\u53e3")
public class DataDictionaryController
extends BaseController {
    public static final String F = "F";
    public static final String S = "S";
    public static final String U = "U";
    public static final String T = "T";
    @Value(value="${app.local.multiLang:false}")
    private boolean multiLang;
    @Autowired
    private DataDictionaryManager dataDictionaryManager;

    public String getOptId() {
        return "DICTSET";
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5b57\u5178\u76ee\u5f55\u5217\u8868", notes="\u67e5\u8be2\u6240\u6709\u5b57\u5178\u76ee\u5f55\u5217\u8868\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="field", value="\u6307\u9700\u8981\u663e\u793a\u7684\u5c5e\u6027\u540d", allowMultiple=true, paramType="query", dataType="array"), @ApiImplicitParam(name="pageDesc", value="\u5206\u9875\u5bf9\u8c61", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<Object> list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        if (WebOptUtils.isTenantTopUnit((HttpServletRequest)request)) {
            searchColumn.put("topUnit", WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        }
        List listObjects = this.dataDictionaryManager.listObjects(searchColumn, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)this.dataDictionaryManager.appendRelativeOsInfo(listObjects), (PageDesc)pageDesc, (String[])field);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u5b57\u5178\u76ee\u5f55", notes="\u6839\u636e\u6570\u636e\u5b57\u5178\u7c7b\u522b\u4ee3\u7801\u67e5\u8be2\u5355\u4e2a\u5b57\u5178\u76ee\u5f55\u3002")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{catalogCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public DataCatalog getCatalog(@PathVariable String catalogCode) {
        return this.dataDictionaryManager.getCatalogIncludeDataPiece(catalogCode);
    }

    @ApiOperation(value="\u6839\u636e\u6570\u636e\u5b57\u5178\u7c7b\u522b\u4ee3\u7801\u67e5\u8be2\u5b57\u5178\u662f\u5426\u4e0d\u5b58\u5728", notes="\u6839\u636e\u6570\u636e\u5b57\u5178\u7c7b\u522b\u4ee3\u7801\u67e5\u8be2\u5b57\u5178\u662f\u5426\u4e0d\u5b58\u5728\u3002")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/notexists/{catalogCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    public boolean isNotExistsCatalogCode(@PathVariable String catalogCode) {
        DataCatalog dbDataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        return null == dbDataCatalog;
    }

    @ApiOperation(value="\u6839\u636e\u6570\u636e\u5b57\u5178\u540d\u5b57\u4ee3\u7801\u67e5\u8be2\u5b57\u5178\u662f\u5426\u5b58\u5728", notes="\u6839\u636e\u6570\u636e\u5b57\u5178\u540d\u5b57\u4ee3\u7801\u67e5\u8be2\u5b57\u5178\u662f\u5426\u5b58\u5728\u3002")
    @ApiImplicitParam(name="catalogName", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u540d\u5b57", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/existcatalogname/{catalogName}"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    public int isExistsCatalogName(@PathVariable String catalogName) {
        return this.dataDictionaryManager.existCatalogName(catalogName);
    }

    @ApiOperation(value="\u6821\u9a8c\u6570\u636e\u4ee3\u7801\u662f\u5426\u5b58\u5728", notes="\u6839\u636e\u6570\u636e\u5b57\u5178\u7c7b\u522b\u4ee3\u7801\u548c\u6570\u636e\u4ee3\u7801\u5224\u65ad\u5b57\u5178\u662f\u5426\u5b58\u5728")
    @ApiImplicitParams(value={@ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="dataCode", value="\u6570\u636e\u5b57\u5178\u7684\u6570\u636e\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/notexists/dictionary/{catalogCode}/{dataCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    public boolean isNotExistsDataCode(@PathVariable String catalogCode, @PathVariable String dataCode) {
        DataDictionary dbDataDictionary = this.dataDictionaryManager.getDataDictionaryPiece(new DataDictionaryId(catalogCode, dataCode));
        return null == dbDataDictionary;
    }

    @ApiOperation(value="\u65b0\u589e\u5b57\u5178\u7c7b\u522b", notes="\u65b0\u589e\u5b57\u5178\u7c7b\u522b")
    @ApiParam(name="dataCatalog", value="\u65b0\u589e\u5b57\u5178\u7c7b\u522b,\u8f93\u5165\u6846\u6709\u63d0\u793a\u7684\u90fd\u662f\u5fc5\u586b\u9879", required=true)
    @RequestMapping(method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u65b0\u589e\u5b57\u5178\u7c7b\u522b", tag="{loginUser.userCode}")
    @WrapUpResponseBody
    public void createCatalog(@Valid DataCatalog dataCatalog, HttpServletRequest request, HttpServletResponse response) {
        boolean isAdmin = this.isLoginAsAdmin(request);
        if (isAdmin) {
            dataCatalog.setCatalogStyle(S);
        } else {
            dataCatalog.setCatalogStyle(U);
        }
        this.dataDictionaryManager.saveNewObject(dataCatalog);
        if (dataCatalog.getDataDictionaries() != null && dataCatalog.getDataDictionaries().size() > 0) {
            for (DataDictionary d : dataCatalog.getDataDictionaries()) {
                d.setDataValue(StringEscapeUtils.unescapeHtml4((String)d.getDataValue()));
                if (StringUtils.isBlank((CharSequence)d.getDataStyle())) {
                    d.setDataStyle(isAdmin ? S : U);
                }
                d.setCatalogCode(dataCatalog.getCatalogCode());
            }
            this.dataDictionaryManager.saveCatalogIncludeDataPiece(dataCatalog);
        }
        JsonResultUtils.writeSingleDataJson((Object)dataCatalog.getCatalogCode(), (HttpServletResponse)response);
    }

    @ApiOperation(value="\u66f4\u65b0\u5b57\u5178\u7c7b\u522b", notes="\u66f4\u65b0\u5b57\u5178\u7c7b\u522b\u4fe1\u606f")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @ApiParam(name="dataCatalog", value="\u66f4\u65b0\u5b57\u5178\u7c7b\u522b\u65b0\u7684\u5bf9\u8c61\u4fe1\u606f", required=true)
    @RequestMapping(value={"/{catalogCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u5b57\u5178\u7c7b\u522b", tag="{catalogCode}")
    @WrapUpResponseBody
    public ResponseData updateCatalog(@ParamName(value="catalogCode") @PathVariable String catalogCode, @Valid DataCatalog dataCatalog) {
        DataCatalog dbDataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        if (null == dbDataCatalog) {
            return ResponseData.makeErrorMessage((String)"\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        DataCatalog oldValue = new DataCatalog();
        BeanUtils.copyProperties((Object)dbDataCatalog, (Object)oldValue);
        BeanUtils.copyProperties((Object)dataCatalog, (Object)dbDataCatalog, (String[])new String[]{"catalogStyle", "catalogCode", "dataDictionaries"});
        this.dataDictionaryManager.updateCatalog(dbDataCatalog);
        return ResponseData.successResponse;
    }

    private boolean isLoginAsAdmin(HttpServletRequest request) {
        return WebOptUtils.getCurrentTopUnit((HttpServletRequest)request).equals("system");
    }

    @ApiOperation(value="\u66f4\u65b0\u5b57\u5178\u76ee\u5f55\u660e\u7ec6", notes="\u66f4\u65b0\u5b57\u5178\u76ee\u5f55\u660e\u7ec6\uff0c\u76ee\u5f55\u660e\u663e\u5bf9\u8c61\u5c31\u662fdataDictionaries[]\u91cc\u9762\u7684\u5c5e\u6027\u7ec4\u6210")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @ApiParam(name="dataCatalog", value="\u66f4\u65b0\u5b57\u5178\u7c7b\u522b\u65b0\u7684\u5bf9\u8c61\u4fe1\u606f", required=true)
    @RequestMapping(value={"/update/{catalogCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u5b57\u5178\u76ee\u5f55\u660e\u7ec6", tag="{catalogCode}")
    @WrapUpResponseBody
    public ResponseData updateDictionary(@ParamName(value="catalogCode") @PathVariable String catalogCode, @Valid DataCatalog dataCatalog, HttpServletRequest request) {
        DataCatalog dbDataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        if (null == dbDataCatalog) {
            return ResponseData.makeErrorMessage((String)"\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        boolean isAdmin = this.isLoginAsAdmin(request);
        String dataStyle = isAdmin ? S : U;
        for (DataDictionary d : dataCatalog.getDataDictionaries()) {
            d.setDataValue(StringEscapeUtils.unescapeHtml4((String)d.getDataValue()));
            if (!StringUtils.isBlank((CharSequence)d.getDataStyle())) continue;
            d.setDataStyle(dataStyle);
        }
        dbDataCatalog.addAllDataPiece(dataCatalog.getDataDictionaries());
        this.dataDictionaryManager.updateCatalog(dataCatalog);
        this.dataDictionaryManager.saveCatalogIncludeDataPiece(dbDataCatalog);
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u65b0\u589e\u67d0\u4e2a\u5b57\u5178\u76ee\u5f55\u91cc\u7684\u5b57\u5178\u660e\u7ec6", notes="\u65b0\u589e\u67d0\u4e2a\u5b57\u5178\u76ee\u5f55\u91cc\u7684\u5b57\u5178\u660e\u7ec6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="dataCode", value="\u6570\u636e\u5b57\u5178\u7684\u660e\u7ec6\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @ApiParam(name="dataDictionary", value="\u5b57\u5178\u660e\u7ec6\u7684\u5bf9\u8c61\u4fe1\u606f", required=true)
    @RequestMapping(value={"/dictionaryPiece/{catalogCode}/{dataCode}"}, method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u65b0\u589e\u6570\u636e\u5b57\u5178", tag="{catalogCode}:{dataCode}")
    @WrapUpResponseBody
    public DataDictionary createDictionary(@ParamName(value="catalogCode") @PathVariable String catalogCode, @PathVariable String dataCode, @Valid DataDictionary dataDictionary, HttpServletRequest request) {
        DataCatalog dbDataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        dataDictionary.setCatalogCode(catalogCode);
        dataDictionary.setDataCode(dataCode);
        dataDictionary.setDataValue(StringEscapeUtils.unescapeHtml4((String)dataDictionary.getDataValue()));
        this.dictionaryPreHandler(dbDataCatalog, dataDictionary);
        this.dictionaryPreInsertHandler(dbDataCatalog, dataDictionary, request);
        this.dataDictionaryManager.saveDataDictionaryPiece(dataDictionary);
        return dataDictionary;
    }

    @ApiOperation(value="\u66f4\u65b0\u67d0\u4e2a\u5b57\u5178\u76ee\u5f55\u91cc\u7684\u5b57\u5178\u660e\u7ec6", notes="\u66f4\u65b0\u67d0\u4e2a\u5b57\u5178\u76ee\u5f55\u91cc\u7684\u5b57\u5178\u660e\u7ec6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="dataCode", value="\u6570\u636e\u5b57\u5178\u7684\u660e\u7ec6\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @ApiParam(name="dataDictionary", value="\u5b57\u5178\u660e\u7ec6\u7684\u5bf9\u8c61\u4fe1\u606f", required=true)
    @RequestMapping(value={"/dictionaryPiece/{catalogCode}/{dataCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u6570\u636e\u5b57\u5178", tag="{catalogCode}:{dataCode}")
    @WrapUpResponseBody
    public DataDictionary editDictionary(@ParamName(value="catalogCode") @PathVariable String catalogCode, @PathVariable String dataCode, @Valid DataDictionary dataDictionary, HttpServletRequest request) {
        DataDictionary dbDataDictionary = this.dataDictionaryManager.getDataDictionaryPiece(new DataDictionaryId(catalogCode, dataCode));
        DataCatalog dbDataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        dataDictionary.setDataCode(dataCode);
        dataDictionary.setCatalogCode(catalogCode);
        dataDictionary.setDataValue(StringEscapeUtils.unescapeHtml4((String)dataDictionary.getDataValue()));
        this.dictionaryPreHandler(dbDataCatalog, dataDictionary);
        this.dictionaryPreUpdateHandler(dbDataCatalog, dbDataDictionary, request);
        BeanUtils.copyProperties((Object)dataDictionary, (Object)dbDataDictionary, (String[])new String[]{"id", "dataStyle"});
        this.dictionaryPreUpdateHandler(dbDataCatalog, dbDataDictionary, request);
        this.dataDictionaryManager.saveDataDictionaryPiece(dbDataDictionary);
        return dbDataDictionary;
    }

    private void dictionaryPreHandler(DataCatalog dataCatalog, DataDictionary dataDictionary) {
        if (T.equalsIgnoreCase(dataCatalog.getCatalogType()) && !StringBaseOpt.isNvl((String)dataDictionary.getExtraCode())) {
            String extraCode = dataDictionary.getExtraCode();
            if (extraCode.equals(dataDictionary.getDataCode())) {
                throw new ObjectException("extraCode \u4e0e dataCode \u4e0d\u80fd\u4e00\u81f4");
            }
            DataDictionary dd = this.dataDictionaryManager.getDataDictionaryPiece(new DataDictionaryId(dataDictionary.getCatalogCode(), extraCode));
            if (null == dd) {
                throw new ObjectException("\u5f53\u524d\u7236\u8282\u70b9\u4e0d\u5b58\u5728");
            }
        }
    }

    private void dictionaryPreInsertHandler(DataCatalog dataCatalog, DataDictionary dataDictionary, HttpServletRequest request) {
        if (this.isLoginAsAdmin(request)) {
            dataDictionary.setDataStyle(S);
        } else {
            if (!S.equalsIgnoreCase(dataCatalog.getCatalogStyle()) && !U.equalsIgnoreCase(dataCatalog.getCatalogStyle())) {
                throw new ObjectException("catalogStyle \u5b57\u6bb5\u53ea\u53ef\u586b\u5199 S \u6216 U");
            }
            dataDictionary.setDataStyle(U);
            if (!U.equalsIgnoreCase(dataDictionary.getDataStyle())) {
                throw new ObjectException("dataStyle \u5b57\u6bb5\u53ea\u53ef\u586b\u5199 U");
            }
        }
    }

    private void dictionaryPreDeleteHandler(DataDictionary dataDictionary, HttpServletRequest request) {
        if (this.isLoginAsAdmin(request)) {
            if (!S.equalsIgnoreCase(dataDictionary.getDataStyle()) && !U.equalsIgnoreCase(dataDictionary.getDataStyle())) {
                throw new ObjectException("\u53ea\u80fd\u5220\u9664 catalogStyle\u4e3a S \u6216 U \u7684\u5b57\u5178\u76ee\u5f55");
            }
        } else if (!U.equalsIgnoreCase(dataDictionary.getDataStyle())) {
            throw new ObjectException("dataStyle \u5b57\u6bb5\u53ea\u53ef\u586b\u5199 U");
        }
    }

    protected void dictionaryPreUpdateHandler(DataCatalog dataCatalog, DataDictionary dataDictionary, HttpServletRequest request) {
        if (this.isLoginAsAdmin(request)) {
            if (F.equalsIgnoreCase(dataDictionary.getDataStyle())) {
                throw new ObjectException("dataStyle \u4e3a F \u7c7b\u578b\u7684\u6570\u636e\u5b57\u5178\uff0c\u4efb\u4f55\u5730\u65b9\u90fd\u4e0d\u5141\u8bb8\u7f16\u8f91\uff0c\u53ea\u80fd\u6709\u5f00\u53d1\u4eba\u5458\u7ed9\u51fa\u66f4\u65b0\u811a\u672c\u6dfb\u52a0\u3001\u66f4\u6539\u548c\u5220\u9664");
            }
            if (F.equalsIgnoreCase(dataCatalog.getCatalogStyle()) && !S.equalsIgnoreCase(dataDictionary.getDataStyle())) {
                throw new ObjectException("\u53ea\u80fd\u4fee\u6539 dataStyle \u4e3a S \u7684\u6570\u636e\u5b57\u5178");
            }
            if (!S.equalsIgnoreCase(dataCatalog.getCatalogStyle()) && !U.equalsIgnoreCase(dataCatalog.getCatalogStyle())) {
                throw new ObjectException("catalogStyle \u5b57\u6bb5\u53ea\u53ef\u586b\u5199 S \u6216 U");
            }
            if (!S.equalsIgnoreCase(dataDictionary.getDataStyle()) && !U.equalsIgnoreCase(dataDictionary.getDataStyle())) {
                throw new ObjectException("dataStyle \u5b57\u6bb5\u53ea\u53ef\u586b\u5199 S \u6216 U");
            }
        } else if (!U.equalsIgnoreCase(dataDictionary.getDataStyle())) {
            throw new ObjectException("dataStyle \u5b57\u6bb5\u53ea\u53ef\u586b\u5199 U");
        }
    }

    private void catalogPrDeleteHandler(DataCatalog dataCatalog, HttpServletRequest request) {
        if (this.isLoginAsAdmin(request)) {
            if (!S.equalsIgnoreCase(dataCatalog.getCatalogStyle()) && !U.equalsIgnoreCase(dataCatalog.getCatalogStyle())) {
                throw new ObjectException("\u53ea\u80fd\u5220\u9664 catalogStyle\u4e3a S \u6216 U \u7684\u5b57\u5178\u76ee\u5f55");
            }
        } else if (!U.equalsIgnoreCase(dataCatalog.getCatalogStyle())) {
            throw new ObjectException("\u53ea\u53ef\u5220\u9664 catalogStyle \u4e3a U \u7684\u5b57\u5178\u76ee\u5f55");
        }
    }

    @ApiOperation(value="\u6839\u636e\u6570\u636e\u5b57\u5178\u76ee\u5f55\u4ee3\u7801\u5220\u9664\u5b57\u5178\u76ee\u5f55", notes="\u6839\u636e\u6570\u636e\u5b57\u5178\u76ee\u5f55\u4ee3\u7801\u5220\u9664\u5b57\u5178\u76ee\u5f55\u3002")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u76ee\u5f55\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{catalogCode}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u5b57\u5178\u76ee\u5f55", tag="{catalogCode}")
    @WrapUpResponseBody
    public ResponseData deleteCatalog(@ParamName(value="catalogCode") @PathVariable String catalogCode, HttpServletRequest request) {
        DataCatalog dataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        this.catalogPrDeleteHandler(dataCatalog, request);
        this.dataDictionaryManager.deleteDataDictionary(catalogCode);
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u5220\u9664\u5b57\u5178\u660e\u7ec6", notes="\u6839\u636e\u5b57\u5178\u7c7b\u522b\u548c\u5b57\u5178\u660e\u7ec6\u4ee3\u7801\u5220\u9664\u5b57\u5178\u660e\u7ec6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="dataCode", value="\u6570\u636e\u5b57\u5178\u7684\u660e\u7ec6\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/dictionaryPiece/{catalogCode}/{dataCode}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u6570\u636e\u5b57\u5178", tag="{catalogCode}:{dataCode}")
    @WrapUpResponseBody
    public ResponseData deleteDictionary(@ParamName(value="catalogCode") @PathVariable String catalogCode, @ParamName(value="dataCode") @PathVariable String dataCode, HttpServletRequest request) {
        DataDictionary dataDictionary = this.dataDictionaryManager.getDataDictionaryPiece(new DataDictionaryId(catalogCode, dataCode));
        this.dictionaryPreDeleteHandler(dataDictionary, request);
        this.dataDictionaryManager.deleteDataDictionaryPiece(dataDictionary.getId());
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178\u7684\u6240\u6709\u660e\u7ec6\u4fe1\u606f", notes="\u6839\u636e\u5b57\u5178\u7c7b\u522b\u4ee3\u7801\u83b7\u53d6\u5b57\u5178\u7684\u6240\u6709\u660e\u7ec6\u4fe1\u606f")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/dictionaryPiece/{catalogCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getDataDictionary(@PathVariable String catalogCode) {
        List datas = this.dataDictionaryManager.getDataDictionary(catalogCode);
        return ResponseData.makeResponseData((Object)datas);
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178\u7684\u8be6\u7ec6\u4fe1\u606f", notes="\u6839\u636e\u5b57\u5178\u7c7b\u522b\u4ee3\u7801\u83b7\u53d6\u5b57\u5178\u7684\u8be6\u7ec6\u4fe1\u606f")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/editDictionary/{catalogCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getDataDictionaryDetail(@PathVariable String catalogCode, HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        searchColumn.put("catalogCode", catalogCode);
        List datas = this.dataDictionaryManager.listDataDictionarys(searchColumn);
        DataCatalog catalog = this.dataDictionaryManager.getObjectById(catalogCode);
        if (T.equals(catalog.getCatalogType())) {
            CollectionsOpt.sortAsTree((List)datas, (p, c) -> StringUtils.equals((CharSequence)p.getDataCode(), (CharSequence)c.getExtraCode()));
        }
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("dataDictionary", (Object)datas);
        resData.addResponseData("multiLang", (Object)this.multiLang);
        resData.addResponseData("langs", (Object)CodeRepositoryUtil.getLabelValueMap((String)"SUPPORT_LANG"));
        return resData;
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178\u7684\u8be6\u7ec6\u4fe1\u606f", notes="\u6839\u636e\u5b57\u5178\u7c7b\u522b\u4ee3\u7801\u83b7\u53d6\u5b57\u5178\u7684\u8be6\u7ec6\u4fe1\u606f")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/dictionarys"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getDataDictionarys(HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        List datas = this.dataDictionaryManager.listDataDictionarys(searchColumn);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("dataDictionary", (Object)datas);
        resData.addResponseData("multiLang", (Object)this.multiLang);
        resData.addResponseData("langs", (Object)CodeRepositoryUtil.getLabelValueMap((String)"SUPPORT_LANG"));
        return resData;
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u5b57\u5178\u76ee\u5f55\u4fe1\u606f", notes="\u83b7\u53d6\u6240\u6709\u5b57\u5178\u76ee\u5f55\u4fe1\u606f")
    @RequestMapping(value={"/allCatalog"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getAllCatalog(HttpServletRequest request) {
        HashMap<String, String> searchColumn = new HashMap<String, String>();
        if (WebOptUtils.isTenantTopUnit((HttpServletRequest)request)) {
            searchColumn.put("topUnit", WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        }
        List catalogs = this.dataDictionaryManager.listAllDataCatalog(searchColumn);
        return ResponseData.makeResponseData((Object)catalogs);
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u5b57\u5178\u76ee\u5f55\u4fe1\u606f\u53ca\u5bf9\u5e94\u7684\u6240\u6709\u5b57\u5178\u660e\u7ec6\u4fe1\u606f", notes="\u83b7\u53d6\u6240\u6709\u5b57\u5178\u76ee\u5f55\u4fe1\u606f\u53ca\u5bf9\u5e94\u7684\u6240\u6709\u5b57\u5178\u660e\u7ec6\u4fe1\u606f")
    @RequestMapping(value={"/wholeDictionary"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getWholeDictionary(HttpServletRequest request) {
        HashMap<String, String> searchColumn = new HashMap<String, String>();
        if (WebOptUtils.isTenantTopUnit((HttpServletRequest)request)) {
            searchColumn.put("topUnit", WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        }
        List catalogs = this.dataDictionaryManager.listAllDataCatalog(searchColumn);
        ArrayList catalogCodes = new ArrayList();
        catalogs.forEach(ca -> catalogCodes.add(ca.getCatalogCode()));
        List dictionarys = this.dataDictionaryManager.getWholeDictionary(catalogCodes);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("catalog", (Object)catalogs);
        resData.addResponseData("dictionary", (Object)dictionarys);
        return resData;
    }

    @ApiOperation(value="\u5c06\u5b57\u5178\u660e\u7ec6\u4fe1\u606f\u5bfc\u5165\u5230Properties\u6587\u4ef6", notes="\u5c06\u5b57\u5178\u660e\u7ec6\u4fe1\u606f\u5bfc\u5165\u5230Properties\u6587\u4ef6")
    @GetMapping(value={"/dictionaryprop"})
    @ResponseBody
    public ResponseEntity<byte[]> downloadProperties(HttpServletRequest request) throws IOException {
        HashMap<String, String> searchColumn = new HashMap<String, String>();
        if (WebOptUtils.isTenantTopUnit((HttpServletRequest)request)) {
            searchColumn.put("topUnit", WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        }
        List catalogs = this.dataDictionaryManager.listAllDataCatalog(searchColumn);
        ArrayList catalogCodes = new ArrayList();
        catalogs.forEach(ca -> catalogCodes.add(ca.getCatalogCode()));
        List dictionarys = this.dataDictionaryManager.getWholeDictionary(catalogCodes);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write("#dictionaryprop_zh_CN.Properties\r\n".getBytes());
        for (DataDictionary dict : dictionarys) {
            out.write((dict.getCatalogCode() + "." + dict.getDataCode() + "=" + dict.getDataValue() + "\r\n").getBytes());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentDispositionFormData("attachment", "dictionaryprop_zh_CN.Properties");
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        return new ResponseEntity((Object)out.toByteArray(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @ApiOperation(value="\u5bfc\u5165excel\u5230\u6570\u636e\u5b57\u5178\u660e\u7ec6")
    @CrossOrigin(origins={"*"}, allowCredentials="true", maxAge=86400L, methods={RequestMethod.POST})
    @RequestMapping(value={"/excelData/{catalogCode}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public DataCatalog importDataFromExcel(@PathVariable String catalogCode, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            InputStream fileInfo = (InputStream)UploadDownloadUtils.fetchInputStreamFromMultipartResolver((HttpServletRequest)request).getRight();
            List excelList = ExcelImportUtil.loadMapFromExcelSheet((InputStream)fileInfo, (int)0);
            ArrayList<DataDictionary> object = new ArrayList<DataDictionary>();
            JavaBeanMetaData javaBeanMetaData = JavaBeanMetaData.createBeanMetaDataFromType(DataDictionary.class);
            for (Map map : excelList) {
                DataDictionary dataDictionary = (DataDictionary)javaBeanMetaData.createBeanObjectFromMap(map);
                dataDictionary.setCatalogCode(catalogCode);
                dataDictionary.setDataStyle(U);
                dataDictionary.setDataTag(T);
                dataDictionary.setCreateDate(new Date());
                object.add(dataDictionary);
            }
            DataCatalog dataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
            if (dataCatalog == null) {
                return null;
            }
            dataCatalog.getDataDictionaries().addAll(object);
            this.dataDictionaryManager.saveCatalogIncludeDataPiece(dataCatalog);
            return dataCatalog;
        }
        catch (ObjectException | IllegalAccessException | InstantiationException e) {
            JsonResultUtils.writeMessageJson((String)e.getMessage(), (HttpServletResponse)response);
            return null;
        }
    }
}

