/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.appclient.HttpReceiveJSON;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.filter.RequestThreadLocal;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.framework.model.basedata.WorkGroup;
import com.centit.framework.model.basedata.WorkGroupParames;
import com.centit.framework.model.basedata.WorkGroupParameter;
import com.centit.framework.system.dao.OsInfoDao;
import com.centit.framework.system.service.WorkGroupManager;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.network.HttpExecutor;
import com.centit.support.network.HttpExecutorContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/workGroup"})
@Api(value="APPLICATION_TEAM_USER", tags={"\u5de5\u4f5c\u7ec4\u7ba1\u7406\u63a5\u53e3"})
public class WorkGroupController
extends BaseController {
    @Autowired
    WorkGroupManager workGroupManager;
    @Autowired
    OsInfoDao osInfoDao;
    @Value(value="${tio.url:}")
    private String tioServer;

    @RequestMapping(method={RequestMethod.GET})
    @ApiOperation(value="\u67e5\u8be2\u5168\u90e8\u5de5\u4f5c\u7ec4")
    @WrapUpResponseBody
    public PageQueryResult<Object> list(HttpServletRequest request, PageDesc pageDesc) {
        List list = this.workGroupManager.listWorkGroup(BaseController.collectRequestParameters((HttpServletRequest)request), pageDesc);
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        JSONArray jsonArray = new JSONArray();
        for (WorkGroup workGroup : list) {
            JSONObject jsonObject = JSONObject.from((Object)workGroup);
            String userName = CodeRepositoryUtil.getUserName((String)topUnit, (String)workGroup.getWorkGroupParameter().getUserCode());
            jsonObject.put((Object)"userName", (Object)userName);
            jsonArray.add((Object)jsonObject);
        }
        return PageQueryResult.createResult((Collection)jsonArray, (PageDesc)pageDesc);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/tenantAdminList"})
    @ApiOperation(value="\u67e5\u8be2\u79df\u6237\u4e2d\u7ba1\u7406\u5458")
    @WrapUpResponseBody
    public PageQueryResult tenantAdminList(HttpServletRequest request, PageDesc pageDesc) {
        if (StringUtils.isBlank((CharSequence)WebOptUtils.getCurrentUserCode((HttpServletRequest)request))) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55!");
        }
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            throw new ObjectException(500, "\u60a8\u8fd8\u672a\u52a0\u5165\u79df\u6237!");
        }
        Map parameters = BaseController.collectRequestParameters((HttpServletRequest)request);
        parameters.put("groupId", topUnit);
        parameters.put("roleCode", "ZHGLY");
        List list = this.workGroupManager.listWorkGroup(parameters, pageDesc);
        if (CollectionUtils.sizeIsEmpty((Object)list)) {
            return PageQueryResult.createResult((Collection)list, (PageDesc)pageDesc);
        }
        JSONArray jsonArray = new JSONArray();
        for (WorkGroup workGroup : list) {
            HashMap<String, String> map = new HashMap<String, String>(32);
            WorkGroupParameter workGroupParameter = workGroup.getWorkGroupParameter();
            UserInfo UserInfo2 = CodeRepositoryUtil.getUserInfoByCode((String)topUnit, (String)workGroupParameter.getUserCode());
            if (null == UserInfo2) {
                CodeRepositoryCache.evictCache((String)"UserInfo");
                UserInfo2 = CodeRepositoryUtil.getUserInfoByCode((String)topUnit, (String)workGroupParameter.getUserCode());
            }
            if (null != UserInfo2) {
                JSONObject userInfoMap = JSONObject.from((Object)UserInfo2);
                map.putAll((Map<String, String>)userInfoMap);
            }
            JSONObject workGroupMap = JSONObject.from((Object)workGroup);
            JSONObject workGroupParameterMap = JSONObject.from((Object)workGroup.getWorkGroupParameter());
            map.putAll((Map<String, String>)workGroupMap);
            map.putAll((Map<String, String>)workGroupParameterMap);
            if ("ZHGLY".equals(workGroupParameter.getRoleCode())) {
                map.put("roleName", "\u7ba1\u7406\u5458");
            } else {
                map.put("roleName", "\u7ec4\u5458");
            }
            jsonArray.add(map);
        }
        return PageQueryResult.createResult((Collection)jsonArray, (PageDesc)pageDesc);
    }

    @RequestMapping(value={"/{groupId}/{userCode}/{roleCode}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u5de5\u4f5c\u7ec4\u6210\u5458")
    @WrapUpResponseBody
    public WorkGroup getWorkGroup(@PathVariable String groupId, @PathVariable String userCode, @PathVariable String roleCode) {
        return this.workGroupManager.getWorkGroup(groupId, userCode, roleCode);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ApiOperation(value="\u65b0\u589e\u5355\u4e2a\u5de5\u4f5c\u7ec4\u6210\u5458")
    @WrapUpResponseBody
    public void createTeamUser(@RequestBody WorkGroup workGroup, HttpServletRequest request, HttpServletResponse response) {
        this.loginUserPermissionCheck(workGroup.getWorkGroupParameter().getGroupId());
        String currentUserCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isNotBlank((CharSequence)currentUserCode)) {
            workGroup.setCreator(currentUserCode);
        }
        workGroup.getWorkGroupParameter().setRoleCode("\u7ec4\u5458");
        this.workGroupManager.createWorkGroup(workGroup);
        JsonResultUtils.writeSingleDataJson((Object)workGroup, (HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/batchAdd"})
    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u5de5\u4f5c\u7ec4\u6210\u5458")
    @WrapUpResponseBody
    public void batchCreateTeamUser(@RequestBody List<WorkGroup> workGroups, HttpServletRequest request, HttpServletResponse response) {
        if (workGroups == null || workGroups.size() == 0) {
            throw new ObjectException(500, "workGroup\u53c2\u6570\u5fc5\u4f20\uff01");
        }
        for (WorkGroup workGroup : workGroups) {
            this.loginUserPermissionCheck(workGroup.getWorkGroupParameter().getGroupId());
        }
        String currentUserCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        for (WorkGroup workGroup : workGroups) {
            workGroup.getWorkGroupParameter().setRoleCode("\u7ec4\u5458");
            workGroup.setCreator(currentUserCode);
        }
        this.workGroupManager.batchWorkGroup(workGroups);
        JsonResultUtils.writeSingleDataJson(workGroups, (HttpServletResponse)response);
        if (!StringBaseOpt.isNvl((String)this.tioServer)) {
            try (CloseableHttpClient closeableHttpClient = HttpExecutor.createHttpClient();){
                OsInfo osInfo = (OsInfo)this.osInfoDao.getObjectById((Object)workGroups.get(0).getGroupId());
                HashMap<String, Object> requestParams = new HashMap<String, Object>(10);
                if (osInfo != null) {
                    if (osInfo.getGroupId() == null) {
                        PageDesc pageDesc = new PageDesc();
                        pageDesc.setPageSize(-1);
                        List allWorkGroup = this.workGroupManager.listWorkGroup(CollectionsOpt.createHashMap((Object[])new Object[]{"groupId", workGroups.get(0).getGroupId()}), pageDesc);
                        StringBuilder users = new StringBuilder();
                        StringBuilder allUsers = new StringBuilder();
                        for (WorkGroup workGroup : allWorkGroup) {
                            if (workGroup.getRoleCode().equals("\u7ec4\u957f")) {
                                if (allUsers.length() > 0) {
                                    allUsers.append(",");
                                }
                                allUsers.append(workGroup.getUserCode());
                                continue;
                            }
                            if (users.length() > 0) {
                                users.append(",");
                            }
                            users.append(workGroup.getUserCode());
                        }
                        allUsers.append(",").append((CharSequence)users);
                        requestParams.put("uidList", allUsers.toString());
                        requestParams.put("name", osInfo.getOsName());
                        HttpExecutorContext httpExecutorContext = HttpExecutorContext.create((CloseableHttpClient)closeableHttpClient);
                        HttpReceiveJSON valueOfJson = HttpReceiveJSON.valueOfJson((String)HttpExecutor.simpleGet((HttpExecutorContext)httpExecutorContext, (String)(this.tioServer + "/chat/createGroup.tio_x"), requestParams));
                        this.logger.info(valueOfJson.getDataAsString());
                        if (valueOfJson.getJSONObject("data") != null && valueOfJson.getJSONObject("data").get("id") != null) {
                            osInfo.setGroupId(valueOfJson.getJSONObject("data").getLong("id"));
                            this.osInfoDao.updateObject(new String[]{"groupId"}, (Serializable)osInfo);
                        }
                    } else {
                        StringBuilder users = new StringBuilder();
                        for (WorkGroup workGroup : workGroups) {
                            if (users.length() > 0) {
                                users.append(",");
                            }
                            users.append(workGroup.getUserCode());
                        }
                        requestParams.put("uids", users.toString());
                        requestParams.put("groupid", osInfo.getGroupId());
                        List leaderWorkGroup = this.workGroupManager.listWorkGroup(CollectionsOpt.createHashMap((Object[])new Object[]{"groupId", workGroups.get(0).getGroupId(), "roleCode", "\u7ec4\u957f"}), null);
                        if (leaderWorkGroup != null) {
                            requestParams.put("applyuid", ((WorkGroup)leaderWorkGroup.get(0)).getUserCode());
                        }
                        HttpReceiveJSON valueOfJson = HttpReceiveJSON.valueOfJson((String)HttpExecutor.simpleGet((HttpExecutorContext)HttpExecutorContext.create((CloseableHttpClient)closeableHttpClient), (String)(this.tioServer + "/chat/joinGroup.tio_x"), requestParams));
                        this.logger.info(valueOfJson.getDataAsString());
                    }
                }
            }
            catch (Exception exception) {
                this.logger.info(exception.getMessage());
            }
        }
    }

    @RequestMapping(value={"/{groupId}/{userCode}"}, method={RequestMethod.DELETE})
    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u5de5\u4f5c\u7ec4\u6210\u5458")
    @WrapUpResponseBody
    public void deleteTeamUser(@PathVariable String groupId, @PathVariable String userCode) {
        String loginUser = WebOptUtils.getCurrentUserCode((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest());
        if (StringBaseOpt.isNvl((String)loginUser)) {
            loginUser = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest(), (String[])new String[]{"userCode"});
        }
        if (StringUtils.isBlank((CharSequence)loginUser)) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55\uff0c\u8bf7\u5148\u767b\u5f55\uff01");
        }
        WorkGroup workGroup = this.workGroupManager.getWorkGroup(groupId, loginUser, "\u7ec4\u957f");
        if (workGroup == null || !"\u7ec4\u957f".equals(workGroup.getWorkGroupParameter().getRoleCode())) {
            throw new ObjectException(500, "\u4f60\u975e\u7ec4\u957f\u4e0d\u80fd\u5220\u9664\u6210\u5458\uff01");
        }
        if (loginUser.equals(userCode)) {
            throw new ObjectException(500, "\u7ec4\u957f\u4e0d\u80fd\u5220\u9664\u7ec4\u957f\uff01");
        }
        this.workGroupManager.deleteWorkGroup(groupId, userCode, "\u7ec4\u5458");
    }

    @RequestMapping(method={RequestMethod.PUT})
    @ApiOperation(value="\u66f4\u65b0\u5355\u4e2a\u5de5\u4f5c\u7ec4\u6210\u5458")
    @WrapUpResponseBody
    public void updateTeamUser(@RequestBody WorkGroup workGroup, HttpServletRequest request) {
        this.loginUserPermissionCheck(workGroup.getWorkGroupParameter().getGroupId());
        String currentUserCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isNotBlank((CharSequence)currentUserCode)) {
            workGroup.setUpdator(currentUserCode);
        }
        workGroup.getWorkGroupParameter().setRoleCode("\u7ec4\u5458");
        this.workGroupManager.updateWorkGroup(workGroup);
    }

    @RequestMapping(value={"hand-over"}, method={RequestMethod.PUT})
    @ApiOperation(value="\u79fb\u4ea4\u7ec4\u957f")
    @WrapUpResponseBody
    @Transactional(rollbackFor={Exception.class})
    public void leaderHandOver(@RequestBody WorkGroupParames workGroupParames, HttpServletRequest request) {
        this.leaderHandOverPermissionCheck(workGroupParames.getGroupId(), request);
        this.workGroupManager.leaderHandOver(workGroupParames);
    }

    private void leaderHandOverPermissionCheck(String workGroupId, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)workGroupId)) {
            throw new ObjectException("groupId\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String loginUser = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringBaseOpt.isNvl((String)loginUser)) {
            loginUser = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"userCode"});
        }
        if (StringUtils.isBlank((CharSequence)loginUser)) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55\uff0c\u8bf7\u5148\u767b\u5f55\uff01");
        }
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            throw new ObjectException(401, "\u60a8\u6ca1\u6709\u64cd\u4f5c\u6743\u9650!");
        }
        Map filterMap = CollectionsOpt.createHashMap((Object[])new Object[]{"groupId_in", new Object[]{workGroupId, topUnit}, "userCode", loginUser, "roleCode_in", new Object[]{"ZHGLY", "\u7ec4\u957f"}});
        if (this.workGroupManager.countWorkGroup(filterMap) < 1) {
            throw new ObjectException(401, "\u60a8\u6ca1\u6709\u64cd\u4f5c\u6743\u9650!");
        }
    }

    private void loginUserPermissionCheck(String osId) {
        String loginUser = WebOptUtils.getCurrentUserCode((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest());
        if (StringBaseOpt.isNvl((String)loginUser)) {
            loginUser = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest(), (String[])new String[]{"userCode"});
        }
        if (StringUtils.isBlank((CharSequence)loginUser)) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55\uff0c\u8bf7\u5148\u767b\u5f55\uff01");
        }
        if (!this.workGroupManager.loginUserIsExistWorkGroup(osId, loginUser)) {
            throw new ObjectException(203, "\u60a8\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
    }
}

