define(function(require) {
	var Mustache = require('plugins/mustache.min');
	var Template = require('text!modules/components/icons/icons-template.html');

	var Icons = {
		EasyUI: {
			Mini: ["icon-mini-add", "icon-mini-edit", "icon-mini-refresh"],
			Normal: [
			         "icon-add", "icon-edit", "icon-clear", "icon-remove", "icon-save",
			         "icon-cut", "icon-ok", "icon-no", "icon-cancel", "icon-reload",
			         "icon-search", "icon-print", "icon-help", "icon-undo", "icon-redo",
			         "icon-back", "icon-sum", "icon-tip", "icon-man", "icon-filter",
			         "icon-lock", "icon-more"
			],
			Large: ["icon-large-picture", "icon-large-clipart", "icon-large-shapes", "icon-large-smartart", "icon-large-chart"]
		},
		
		FontAwesome: {
			New: ["bed","buysellads","cart-arrow-down","cart-plus","connectdevelop","dashcube","diamond","facebook-official","forumbee","heartbeat","hotel","leanpub","mars","mars-double","mars-stroke","mars-stroke-h","mars-stroke-v","medium","mercury","motorcycle","neuter","pinterest-p","sellsy","server","ship","shirtsinbulk","simplybuilt","skyatlas","street-view","subway","train","transgender","transgender-alt","user-plus","user-secret","user-times","venus","venus-double","venus-mars","viacoin","whatsapp"],
			WebApplicationIcons: ["fa-adjust","fa-anchor","fa-archive","fa-area-chart","fa-arrows","fa-arrows-h","fa-arrows-v","fa-asterisk","fa-at","fa-automobile","fa-ban","fa-bank","fa-bar-chart","fa-bar-chart-o","fa-barcode","fa-bars","fa-bed","fa-beer","fa-bell","fa-bell-o","fa-bell-slash","fa-bell-slash-o","fa-bicycle","fa-binoculars","fa-birthday-cake","fa-bolt","fa-bomb","fa-book","fa-bookmark","fa-bookmark-o","fa-briefcase","fa-bug","fa-building","fa-building-o","fa-bullhorn","fa-bullseye","fa-bus","fa-cab","fa-calculator","fa-calendar","fa-calendar-o","fa-camera","fa-camera-retro","fa-car","fa-caret-square-o-down","fa-caret-square-o-left","fa-caret-square-o-right","fa-caret-square-o-up","fa-cart-arrow-down","fa-cart-plus","fa-cc","fa-certificate","fa-check","fa-check-circle","fa-check-circle-o","fa-check-square","fa-check-square-o","fa-child","fa-circle","fa-circle-o","fa-circle-o-notch","fa-circle-thin","fa-clock-o","fa-close","fa-cloud","fa-cloud-download","fa-cloud-upload","fa-code","fa-code-fork","fa-coffee","fa-cog","fa-cogs","fa-comment","fa-comment-o","fa-comments","fa-comments-o","fa-compass","fa-copyright","fa-credit-card","fa-crop","fa-crosshairs","fa-cube","fa-cubes","fa-cutlery","fa-dashboard","fa-database","fa-desktop","fa-diamond","fa-dot-circle-o","fa-download","fa-edit","fa-ellipsis-h","fa-ellipsis-v","fa-envelope","fa-envelope-o","fa-envelope-square","fa-eraser","fa-exchange","fa-exclamation","fa-exclamation-circle","fa-exclamation-triangle","fa-external-link","fa-external-link-square","fa-eye","fa-eye-slash","fa-eyedropper","fa-fax","fa-female","fa-fighter-jet","fa-file-archive-o","fa-file-audio-o","fa-file-code-o","fa-file-excel-o","fa-file-image-o","fa-file-movie-o","fa-file-pdf-o","fa-file-photo-o","fa-file-picture-o","fa-file-powerpoint-o","fa-file-sound-o","fa-file-video-o","fa-file-word-o","fa-file-zip-o","fa-film","fa-filter","fa-fire","fa-fire-extinguisher","fa-flag","fa-flag-checkered","fa-flag-o","fa-flash","fa-flask","fa-folder","fa-folder-o","fa-folder-open","fa-folder-open-o","fa-frown-o","fa-futbol-o","fa-gamepad","fa-gavel","fa-gear","fa-gears","fa-genderless","fa-gift","fa-glass","fa-globe","fa-graduation-cap","fa-group","fa-hdd-o","fa-headphones","fa-heart","fa-heart-o","fa-heartbeat","fa-history","fa-home","fa-hotel","fa-image","fa-inbox","fa-info","fa-info-circle","fa-institution","fa-key","fa-keyboard-o","fa-language","fa-laptop","fa-leaf","fa-legal","fa-lemon-o","fa-level-down","fa-level-up","fa-life-bouy","fa-life-buoy","fa-life-ring","fa-life-saver","fa-lightbulb-o","fa-line-chart","fa-location-arrow","fa-lock","fa-magic","fa-magnet","fa-mail-forward","fa-mail-reply","fa-mail-reply-all","fa-male","fa-map-marker","fa-meh-o","fa-microphone","fa-microphone-slash","fa-minus","fa-minus-circle","fa-minus-square","fa-minus-square-o","fa-mobile","fa-mobile-phone","fa-money","fa-moon-o","fa-mortar-board","fa-motorcycle","fa-music","fa-navicon","fa-newspaper-o","fa-paint-brush","fa-paper-plane","fa-paper-plane-o","fa-paw","fa-pencil","fa-pencil-square","fa-pencil-square-o","fa-phone","fa-phone-square","fa-photo","fa-picture-o","fa-pie-chart","fa-plane","fa-plug","fa-plus","fa-plus-circle","fa-plus-square","fa-plus-square-o","fa-power-off","fa-print","fa-puzzle-piece","fa-qrcode","fa-question","fa-question-circle","fa-quote-left","fa-quote-right","fa-random","fa-recycle","fa-refresh","fa-remove","fa-reorder","fa-reply","fa-reply-all","fa-retweet","fa-road","fa-rocket","fa-rss","fa-rss-square","fa-search","fa-search-minus","fa-search-plus","fa-send","fa-send-o","fa-server","fa-share","fa-share-alt","fa-share-alt-square","fa-share-square","fa-share-square-o","fa-shield","fa-ship","fa-shopping-cart","fa-sign-in","fa-sign-out","fa-signal","fa-sitemap","fa-sliders","fa-smile-o","fa-soccer-ball-o","fa-sort","fa-sort-alpha-asc","fa-sort-alpha-desc","fa-sort-amount-asc","fa-sort-amount-desc","fa-sort-asc","fa-sort-desc","fa-sort-down","fa-sort-numeric-asc","fa-sort-numeric-desc","fa-sort-up","fa-space-shuttle","fa-spinner","fa-spoon","fa-square","fa-square-o","fa-star","fa-star-half","fa-star-half-empty","fa-star-half-full","fa-star-half-o","fa-star-o","fa-street-view","fa-suitcase","fa-sun-o","fa-support","fa-tablet","fa-tachometer","fa-tag","fa-tags","fa-tasks","fa-taxi","fa-terminal","fa-thumb-tack","fa-thumbs-down","fa-thumbs-o-down","fa-thumbs-o-up","fa-thumbs-up","fa-ticket","fa-times","fa-times-circle","fa-times-circle-o","fa-tint","fa-toggle-down","fa-toggle-left","fa-toggle-off","fa-toggle-on","fa-toggle-right","fa-toggle-up","fa-trash","fa-trash-o","fa-tree","fa-trophy","fa-truck","fa-tty","fa-umbrella","fa-university","fa-unlock","fa-unlock-alt","fa-unsorted","fa-upload","fa-user","fa-user-plus","fa-user-secret","fa-user-times","fa-users","fa-video-camera","fa-volume-down","fa-volume-off","fa-volume-up","fa-warning","fa-wheelchair","fa-wifi","fa-wrench"],
			TransportationIcons: ["fa-ambulance","fa-automobile","fa-bicycle","fa-bus","fa-cab","fa-car","fa-fighter-jet","fa-motorcycle","fa-plane","fa-rocket","fa-ship","fa-space-shuttle","fa-subway","fa-taxi","fa-train","fa-truck","fa-Wheelchair"],
			GenderIcons: ["fa-circle-thin","fa-genderless","fa-mars","fa-mars-double","fa-mars-stroke","fa-mars-stroke-h","fa-mars-stroke-v","fa-mercury","fa-neuter","fa-transgender","fa-transgender-alt","fa-venus","fa-venus-double","fa-venus-mars"],
			FileTypeIcons: ["fa-file","fa-file-archive-o","fa-file-audio-o","fa-file-code-o","fa-file-excel-o","fa-file-image-o","fa-file-movie-o","fa-file-o","fa-file-pdf-o","fa-file-photo-o","fa-file-picture-o","fa-file-powerpoint-o","fa-file-sound-o","fa-file-text","fa-file-text-o","fa-file-video-o","fa-file-word-o","fa-file-zip-o"],
			SpinnerIcons: ["fa-circle-o-notch","fa-cog","fa-gear","fa-refresh","fa-Spinner"],
			FormControlIcons: ["fa-check-square","fa-check-square-o","fa-circle","fa-circle-o","fa-dot-circle-o","fa-minus-square","fa-minus-square-o","fa-plus-square","fa-plus-square-o","fa-square","fa-square-o"],
			PaymentIcons: ["fa-cc-amex","fa-cc-discover","fa-cc-mastercard","fa-cc-paypal","fa-cc-stripe","fa-cc-visa","fa-credit-card","fa-google-wallet","fa-paypal"],
			ChartIcons: ["fa-area-chart","fa-bar-chart","fa-bar-chart-o","fa-line-chart","fa-pie-chart"],
			CurrencyIcons: ["fa-bitcoin","fa-btc","fa-cny","fa-dollar","fa-eur","fa-euro","fa-gbp","fa-ils","fa-inr","fa-jpy","fa-krw","fa-money","fa-rmb","fa-rouble","fa-rub","fa-ruble","fa-rupee","fa-shekel","fa-sheqel","fa-try","fa-turkish-lira","fa-usd","fa-won","fa-yen"],
			TextEditorIcons: ["fa-align-center","fa-align-justify","fa-align-left","fa-align-right","fa-bold","fa-chain","fa-chain-broken","fa-clipboard","fa-columns","fa-copy","fa-cut","fa-dedent","fa-eraser","fa-file","fa-file-o","fa-file-text","fa-file-text-o","fa-files-o","fa-floppy-o","fa-font","fa-header","fa-indent","fa-italic","fa-link","fa-list","fa-list-alt","fa-list-ol","fa-list-ul","fa-outdent","fa-paperclip","fa-paragraph","fa-paste","fa-repeat","fa-rotate-left","fa-rotate-right","fa-save","fa-scissors","fa-strikethrough","fa-subscript","fa-superscript","fa-table","fa-text-height","fa-text-width","fa-th","fa-th-large","fa-th-list","fa-underline","fa-undo","fa-unlink"],
			DirectionalIcons: ["fa-angle-double-down","fa-angle-double-left","fa-angle-double-right","fa-angle-double-up","fa-angle-down","fa-angle-left","fa-angle-right","fa-angle-up","fa-arrow-circle-down","fa-arrow-circle-left","fa-arrow-circle-o-down","fa-arrow-circle-o-left","fa-arrow-circle-o-right","fa-arrow-circle-o-up","fa-arrow-circle-right","fa-arrow-circle-up","fa-arrow-down","fa-arrow-left","fa-arrow-right","fa-arrow-up","fa-arrows","fa-arrows-alt","fa-arrows-h","fa-arrows-v","fa-caret-down","fa-caret-left","fa-caret-right","fa-caret-square-o-down","fa-caret-square-o-left","fa-caret-square-o-right","fa-caret-square-o-up","fa-caret-up","fa-chevron-circle-down","fa-chevron-circle-left","fa-chevron-circle-right","fa-chevron-circle-up","fa-chevron-down","fa-chevron-left","fa-chevron-right","fa-chevron-up","fa-hand-o-down","fa-hand-o-left","fa-hand-o-right","fa-hand-o-up","fa-long-arrow-down","fa-long-arrow-left","fa-long-arrow-right","fa-long-arrow-up","fa-toggle-down","fa-toggle-left","fa-toggle-right","fa-toggle-up"],
			VideoPlayerIcons: ["fa-arrows-alt","fa-backward","fa-compress","fa-eject","fa-expand","fa-fast-backward","fa-fast-forward","fa-forward","fa-pause","fa-play","fa-play-circle","fa-play-circle-o","fa-step-backward","fa-step-forward","fa-stop","fa-youtube-play"],
			BrandIcons: ["fa-adn","fa-android","fa-angellist","fa-apple","fa-behance","fa-behance-square","fa-bitbucket","fa-bitbucket-square","fa-bitcoin","fa-btc","fa-buysellads","fa-cc-amex","fa-cc-discover","fa-cc-mastercard","fa-cc-paypal","fa-cc-stripe","fa-cc-visa","fa-codepen","fa-connectdevelop","fa-css3","fa-dashcube","fa-delicious","fa-deviantart","fa-digg","fa-dribbble","fa-dropbox","fa-drupal","fa-empire","fa-facebook","fa-facebook-f","fa-facebook-official","fa-facebook-square","fa-flickr","fa-forumbee","fa-foursquare","fa-ge","fa-git","fa-git-square","fa-github","fa-github-alt","fa-github-square","fa-gittip","fa-google","fa-google-plus","fa-google-plus-square","fa-google-wallet","fa-gratipay","fa-hacker-news","fa-html5","fa-instagram","fa-ioxhost","fa-joomla","fa-jsfiddle","fa-lastfm","fa-lastfm-square","fa-leanpub","fa-linkedin","fa-linkedin-square","fa-linux","fa-maxcdn","fa-meanpath","fa-medium","fa-openid","fa-pagelines","fa-paypal","fa-pied-piper","fa-pied-piper-alt","fa-pinterest","fa-pinterest-p","fa-pinterest-square","fa-qq","fa-ra","fa-rebel","fa-reddit","fa-reddit-square","fa-renren","fa-sellsy","fa-share-alt","fa-share-alt-square","fa-shirtsinbulk","fa-simplybuilt","fa-skyatlas","fa-skype","fa-slack","fa-slideshare","fa-soundcloud","fa-spotify","fa-stack-exchange","fa-stack-overflow","fa-steam","fa-steam-square","fa-stumbleupon","fa-stumbleupon-circle","fa-tencent-weibo","fa-trello","fa-tumblr","fa-tumblr-square","fa-twitch","fa-twitter","fa-twitter-square","fa-viacoin","fa-vimeo-square","fa-vine","fa-vk","fa-wechat","fa-weibo","fa-weixin","fa-whatsapp","fa-windows","fa-wordpress","fa-xing","fa-xing-square","fa-yahoo","fa-yelp","fa-youtube","fa-youtube-play","fa-youtube-square"],
			MedicalIcons: ["fa-ambulance","fa-h-square","fa-heart","fa-heart-o","fa-heartbeat","fa-hospital-o","fa-medkit","fa-plus-square","fa-stethoscope","fa-user-md","fa-wheelchair"]
		},
		
		BaseUI: {
			BaseIcon: ["icon-base-info","icon-base-plus","icon-base-telephone_book","icon-base-aid","icon-base-gear","icon-base-back","icon-base-calendar","icon-base-calculator","icon-base-forbid","icon-base-handcart","icon-base-disk","icon-base-report","icon-base-ban","icon-base-fix","icon-base-copy","icon-base-cut","icon-base-symbol","icon-base-file","icon-base-down","icon-base-pencil","icon-base-copy_out","icon-base-speed_ahead","icon-base-heart","icon-base-print","icon-base-flag","icon-base-folder","icon-base-forward","icon-base-card","icon-base-pass","icon-base-user","icon-base-machine","icon-base-question","icon-base-break","icon-base-home","icon-base-picture","icon-base-copy_in","icon-base-computer","icon-base-lock","icon-base-message","icon-base-take_in","icon-base-music","icon-base-add","icon-base-note","icon-base-www","icon-base-take_out","icon-base-webpage","icon-base-tick","icon-base-bruch","icon-base-matters","icon-base-pause","icon-base-fax","icon-base-camera","icon-base-play","icon-base-option","icon-base-printer","icon-base-search","icon-base-arrow_right","icon-base-recover","icon-base-minus","icon-base-speed_back","icon-base-soft_disk_qus","icon-base-soft_disk","icon-base-remind","icon-base-before","icon-base-after","icon-base-computer2","icon-base-stop","icon-base-magnifier","icon-base-forbidden","icon-base-clock","icon-base-box","icon-base-rubbish","icon-base-unlock","icon-base-arrow_left","icon-base-up","icon-base-admin","icon-base-earth","icon-base-plus","icon-base-cap","icon-base-magnify",]
		},

		BlackUI: {
			BlackIcon: ["icon-black-one","icon-black-two","icon-black-three","icon-black-four","icon-black-five","icon-black-six","icon-black-seven","icon-black-eight","icon-black-nine","icon-black-ten","icon-black-first","icon-black-second","icon-black-third","icon-black-fourth","icon-black-fifth","icon-black-sixth","icon-black-seventh","icon-black-eighth","icon-black-ninth","icon-black-tenth","icon-black-quotes_right","icon-black-quotes_left","icon-black-mark1","icon-black-mark2","icon-black-link1","icon-black-link2","icon-black-sark1","icon-black-sark2","icon-black-calendar","icon-black-calendar2","icon-black-calendar3","icon-black-add_file","icon-black-delete_file","icon-black-file","icon-black-copy_file","icon-black-iphone","icon-black-ipad","icon-black-macbook","icon-black-imac","icon-black-ipod","icon-black-TV","icon-black-camera1","icon-black-camera2","icon-black-camera3","icon-black-film1","icon-black-film2","icon-black-film3","icon-black-microphone1","icon-black-microphone2","icon-black-microphone3","icon-black-drink1","icon-black-drink2","icon-black-drink3","icon-black-alcohol","icon-black-coffee","icon-black-beer","icon-black-icecream","icon-black-cake","icon-black-box","icon-black-intobox","icon-black-outofbox","icon-black-box2","icon-black-tick1","icon-black-tick2","icon-black-fork1","icon-black-fork2","icon-black-plus1","icon-black-plus2","icon-black-minus1","icon-black-minus2","icon-black-caution1","icon-black-caution2","icon-black-set","icon-black-set2","icon-black-set3","icon-black-alert","icon-black-aid","icon-black-bag1","icon-black-bag2","icon-black-bag3","icon-black-outofbox","icon-black-box2","icon-black-tick1","icon-black-tick2","icon-black-fork1","icon-black-fork2","icon-black-plus1","icon-black-plus2","icon-black-minus1","icon-black-minus2","icon-black-caution1","icon-black-caution2","icon-black-set","icon-black-set2","icon-black-set3","icon-black-alert","icon-black-aid","icon-black-bag1","icon-black-bag2","icon-black-bag3","icon-black-picture1","icon-black-picture2","icon-black-picture3","icon-black-android","icon-black-marble","icon-black-bean","icon-black-tape","icon-black-clock1","icon-black-clock2","icon-black-clock3","icon-black-clock4","icon-black-clock5","icon-black-clock6","icon-black-headset","icon-black-notebook","icon-black-tick3","icon-black-fork3","icon-black-eye","icon-black-point","icon-black-ponit2","icon-black-relevance1","icon-black-relevance2","icon-black-cloud1","icon-black-cloud2","icon-black-cloud3","icon-black-pie1","icon-black-pie2","icon-black-histogram1","icon-black-histogram2","icon-black-histogram3","icon-black-histogram4","icon-black-basket3","icon-black-document","icon-black-game","icon-black-bell","icon-black-nobell","icon-black-phone1","icon-black-phone2","icon-black-picture","icon-black-open","icon-black-sale","icon-black-roadsign","icon-black-map","icon-black-delete","icon-black-vote","icon-black-graduation","icon-black-chemistry","icon-black-tie","icon-black-rugby","icon-black-billiards","icon-black-bowling1","icon-black-bowling2","icon-black-tennis","icon-black-football","icon-black-glasses","icon-black-TV2","icon-black-refrigerator","icon-black-microwave_oven","icon-black-camera4","icon-black-mouse","icon-black-happy","icon-black-sad","icon-black-quiet","icon-black-hand","icon-black-radar","icon-black-satellite","icon-black-winner1","icon-black-winner2","icon-black-door","icon-black-key","icon-black-plug","icon-black-lock1","icon-black-lock2","icon-black-lock3","icon-black-lock4","icon-black-magnifying_glass","icon-black-zoom_in","icon-black-zoom_out","icon-black-paper1","icon-black-paper2","icon-black-paper3","icon-black-hexagon","icon-black-cross","icon-black-star_moon","icon-black-transformers","icon-black-batman","icon-black-spider","icon-black-skeleton","icon-black-lamp1","icon-black-lamp2","icon-black-umbrella","icon-black-traffic_light","icon-black-bomb","icon-black-books","icon-black-battery3","icon-black-battery2","icon-black-battery1","icon-black-battery","icon-black-battery4","icon-black-loud_speaker1","icon-black-loud_speak2","icon-black-microphone","icon-black-pill","icon-black-needle","icon-black-thermometer","icon-black-bulb1","icon-black-bulb2","icon-black-bulb3","icon-black-box1","icon-black-box2","icon-black-box3","icon-black-diamond","icon-black-money1","icon-black-money2","icon-black-check1","icon-black-check2","icon-black-check3","icon-black-check4","icon-black-ruler","icon-black-set_quare","icon-black-grid1","icon-black-grid2","icon-black-grid3","icon-black-grid4","icon-black-grid5","icon-black-grid6","icon-black-grid7","icon-black-grid8","icon-black-grid9","icon-black-grid1","icon-black-grid11","icon-black-grid12","icon-black-grid13","icon-black-grid14","icon-black-tool1","icon-black-tool2","icon-black-tool3","icon-black-tool4","icon-black-pan1","icon-black-pan2","icon-black-chat1","icon-black-chat2","icon-black-chat3","icon-black-chat4","icon-black-volume1","icon-black-volume2","icon-black-volume3","icon-black-volume_adjust","icon-black-arrow1","icon-black-arrow2","icon-black-arrow3","icon-black-arrow4","icon-black-full_screen","icon-black-download","icon-black-calculator","icon-black-architecture","icon-black-judge","icon-black-balance_scale","icon-black-graph1","icon-black-graph2","icon-black-clip","icon-black-sandglass","icon-black-abacus","icon-black-pencil1","icon-black-pencil2","icon-black-pin1","icon-black-pin2","icon-black-percentage","icon-black-draw","icon-black-scissor","icon-black-ID1","icon-black-ID2","icon-black-ID3","icon-black-spin1","icon-black-spin2","icon-black-spin3","icon-black-spin4","icon-black-repeat1","icon-black-random","icon-black-repeat2","icon-black-clipping","icon-black-rectangle1","icon-black-rectangle2","icon-black-circle","icon-black-dollar","icon-black-dollars1","icon-black-dollars2","icon-black-saving_pot","icon-black-badge","icon-black-notebook1","icon-black-notebook2","icon-black-notebook3","icon-black-strongbox","icon-black-letter1","icon-black-letter2","icon-black-CD","icon-black-music","icon-black-projector","icon-black-boy","icon-black-girl","icon-black-pray","icon-black-heart","icon-black-i","icon-black-information","icon-black-piano","icon-black-rain","icon-black-snow","icon-black-thunder","icon-black-sun","icon-black-moon","icon-black-cloud1","icon-black-cloud2","icon-black-car","icon-black-bike","icon-black-bus1","icon-black-bus2","icon-black-motor","icon-black-plane","icon-black-paperplane","icon-black-rocket","icon-black-book1","icon-black-book2","icon-black-bar_code1","icon-black-bar_code2","icon-black-zoom_in1","icon-black-zoom_out1","icon-black-send","icon-black-receive","icon-black-archery","icon-black-clown","icon-black-badge1","icon-black-ticket","icon-black-admit","icon-black-badge2","icon-black-microphone1","icon-black-roadblock","icon-black-stop1","icon-black-stop2","icon-black-keyboard1","icon-black-keyboard2","icon-black-video","icon-black-printer","icon-black-yes","icon-black-no","icon-black-plus","icon-black-minus","icon-black-attention","icon-black-pictures","icon-black-orbit","icon-black-dropper","icon-black-earth1","icon-black-earth2","icon-black-handcart","icon-black-TaiJi","icon-black-compass","icon-black-zipper1","icon-black-zipper2","icon-black-anchor","icon-black-heartlock","icon-black-magnet","icon-black-rudder","icon-black-sign","icon-black-heartplus","icon-black-heartminus","icon-black-USB","icon-black-list1","icon-black-list2","icon-black-list3","icon-black-switch","icon-black-stationery"]
		},

		BorderUI: {
			BorderIcon: ["icon-border-earth","icon-border-search","icon-border-magnifier","icon-border-folder","icon-border-boss","icon-border-team1","icon-border-team2","icon-border-ballpen","icon-border-gold","icon-border-message","icon-border-woman","icon-border-prohibited","icon-border-pie_chart","icon-border-notepad","icon-border-hook","icon-border-notes","icon-border-globosity","icon-border-information","icon-border-globe","icon-border-television","icon-border-money","icon-border-help","icon-border-email","icon-border-window","icon-border-incandescent","icon-border-prompt","icon-border-house","icon-border-folder2","icon-border-browser","icon-border-staff","icon-border-open","icon-border-move","icon-border-love","icon-border-download","icon-border-file","icon-border-notepad","icon-border-notebook","icon-border-note","icon-border-forbid","icon-border-files","icon-border-fortune","icon-border-ban","icon-border-dollar","icon-border-letter","icon-border-delete","icon-border-add","icon-border-bar_code","icon-border-AI"]
		},

		WhiteUI: {
			WhiteIcon: ["icon-white-search","icon-white-magnifier","icon-white-magnify","icon-white-narrow","icon-white-fork","icon-white-cross","icon-white-positive","icon-white-negative","icon-white-forbid","icon-white-right_folder","icon-white-wrong_folder","icon-white-folder","icon-white-copy","icon-white-log","icon-white-file","icon-white-copy_file","icon-white-book","icon-white-wrong_file","icon-white-right_file","icon-white-add_file","icon-white-delete_file","icon-white-column_chart","icon-white-column","icon-white-download","icon-white-upload","icon-white-link","icon-white-message","icon-white-decrease_volume","icon-white-mute_volume","icon-white-increase_volume","icon-white-mute","icon-white-volume","icon-white-garbage","icon-white-camera","icon-white-microphone","icon-white-mute_microphone","icon-white-dialog_box","icon-white-new_message","icon-white-conversation","icon-white-reply_message","icon-white-picture","icon-white-frameset","icon-white-frameset_right","icon-white-frameset_middle","icon-white-frameset_left","icon-white-dialogue","icon-white-li","icon-white-ending_tag","icon-white-nine","icon-white-cross","icon-white-paragraph_left","icon-white-paragraph_right","icon-white-paragraph_middle","icon-white-paragraph","icon-white-locking","icon-white-brightness","icon-white-lock_up","icon-white-map","icon-white-focus","icon-white-diffuse","icon-white-caution","icon-white-alert","icon-white-close","icon-white-user","icon-white-add_user","icon-white-delete_user","icon-white-users","icon-white-clock_night","icon-white-clock_day","icon-white-recycle","icon-white-full_battery","icon-white-low_battery","icon-white-battery","icon-white-previous","icon-white-next","icon-white-cease","icon-white-stop","icon-white-backward","icon-white-go","icon-white-forward","icon-white-pause","icon-white-lock","icon-white-leave","icon-white-minus","icon-white-wrong","icon-white-right","icon-white-words","icon-white-arrow","icon-white-stuff","icon-white-launch","icon-white-menu","icon-white-print","icon-white-basket","icon-white-star","icon-white-write","icon-white-pen","icon-white-entry","icon-white-share","icon-white-share2","icon-white-right","icon-white-left","icon-white-enter","icon-white-refresh","icon-white-open","icon-white-set","icon-white-empty","icon-white-full","icon-white-northeast"]
		}
	};
	
	var create = function(container, title, baseClass, datas) {
		// 重新排列数据
		var icons = [];
		var temp = [];
		
		for (var i=1; i<=datas.length; i++) {
			temp.push(datas[i - 1]);
		
			// 为了表格，4个数据一行
			if (!(i % 4)) {
				icons.push({
					td: [temp[0], temp[1], temp[2], temp[3]]
				});
				temp.length = 0;
			}
		}
		
		// 最后一次循环没有达到4个
		if (temp.length && temp.length < 4) {
			icons.push({
				td: [temp[0], temp[1], temp[2], temp[3]]
			});
		}
		
		$(container).append(Mustache.render(Template, {
			title: title,
			base: baseClass,
			tr: icons
		}));
	};
	
	return {
		Icons: Icons,
		create: create
	};
});
