/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.controller;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.filter.RequestThreadLocal;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.OptInfo;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.locode.platform.service.ApplicationInfoManager;
import com.centit.metaform.service.MetaFormModelDraftManager;
import com.centit.metaform.service.MetaFormModelManager;
import com.centit.product.metadata.api.MetadataManageService;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.workflow.service.FlowDefine;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"applicationInfo"})
@Api(value="\u5e94\u7528\u7ba1\u7406", tags={"\u5e94\u7528\u7ba1\u7406"})
public class ApplicationInfoController
extends BaseController {
    @Autowired
    private ApplicationInfoManager applicationInfoManager;
    @Autowired
    private MetaFormModelManager metaFormModelManager;
    @Autowired
    private MetaFormModelDraftManager metaFormModelDraftManager;
    @Autowired
    MetadataManageService metadataManageService;
    @Autowired
    private PlatformEnvironment platformEnvironment;
    @Autowired
    private FlowDefine flowDefine;

    @ApiOperation(value="\u65b0\u589e\u5e94\u7528")
    @PostMapping
    @WrapUpResponseBody
    public JSONObject createApplicationInfo(@RequestBody OsInfo osInfo, HttpServletRequest httpServletRequest) {
        if (StringBaseOpt.isNvl((String)osInfo.getTopUnit())) {
            osInfo.setTopUnit(WebOptUtils.getCurrentTopUnit((HttpServletRequest)httpServletRequest));
        }
        return this.applicationInfoManager.createApplicationInfo(osInfo);
    }

    @ApiOperation(value="\u4fee\u6539\u5e94\u7528")
    @PutMapping
    @WrapUpResponseBody
    @Transactional(rollbackFor={Exception.class})
    public OsInfo updateApplicationInfo(@RequestBody OsInfo osInfo) {
        OptInfo optInfo = new OptInfo();
        optInfo.setOptId(osInfo.getOsId());
        optInfo.setOptName(osInfo.getOsName());
        this.platformEnvironment.updateOptInfo(optInfo);
        return this.applicationInfoManager.updateApplicationInfo(osInfo);
    }

    @ApiOperation(value="\u5220\u9664\u5e94\u7528\u6a21\u5757")
    @ApiImplicitParam(name="applicationId", value="\u56fe\u8868ID")
    @DeleteMapping(value={"/{applicationId}"})
    @WrapUpResponseBody
    public OsInfo deleteApplicationInfo(@PathVariable String applicationId) {
        return this.applicationInfoManager.deleteApplicationInfo(applicationId);
    }

    @ApiOperation(value="\u67e5\u8be2\u5e94\u7528\u6a21\u5757")
    @GetMapping(value={"/list"})
    @WrapUpResponseBody
    public JSONArray listApplicationInfo(HttpServletRequest request, HttpServletResponse response) {
        if (!WebOptUtils.isTenantTopUnit((HttpServletRequest)request)) {
            return null;
        }
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        Map parameters = BaseController.collectRequestParameters((HttpServletRequest)request);
        return this.applicationInfoManager.listApplicationInfo(topUnit, parameters);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u5e94\u7528\u6a21\u5757")
    @GetMapping(value={"/{applicationId}"})
    @WrapUpResponseBody
    public JSONObject getApplicationInfo(@PathVariable String applicationId, HttpServletRequest request) {
        if (!WebOptUtils.isTenantTopUnit((HttpServletRequest)request)) {
            return null;
        }
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        return this.applicationInfoManager.getApplicationInfo(applicationId, topUnit, true);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u5e94\u7528\u6a21\u5757")
    @GetMapping(value={"no-auth/{applicationId}"})
    @WrapUpResponseBody
    public JSONObject getApplicationInfoNoAuth(@PathVariable String applicationId) {
        return this.applicationInfoManager.getApplicationInfo(applicationId, "", false);
    }

    @ApiOperation(value="\u4e1a\u52a1\u6a21\u5757\u5220\u9664\u6309\u94ae")
    @DeleteMapping(value={"/businessDelete/{optId}"})
    @WrapUpResponseBody
    public ResponseData businessDelete(@PathVariable String optId, HttpServletRequest request) {
        String loginUser = WebOptUtils.getCurrentUserCode((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest());
        if (StringBaseOpt.isNvl((String)loginUser)) {
            loginUser = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest(), (String[])new String[]{"userCode"});
        }
        if (StringUtils.isBlank((CharSequence)loginUser)) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55\uff0c\u8bf7\u5148\u767b\u5f55\uff01");
        }
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        HashMap<String, String> metaFormParam = new HashMap<String, String>();
        metaFormParam.put("optId", optId);
        metaFormParam.put("isValid", "F");
        JSONArray metaFormModelList = this.metaFormModelManager.listFormModeAsJson(null, metaFormParam, null);
        JSONArray metaFormModelDraftList = this.metaFormModelDraftManager.listFormModeAsJson(null, metaFormParam, null);
        if (!metaFormModelList.isEmpty() || !metaFormModelDraftList.isEmpty()) {
            return ResponseData.makeErrorMessage((String)"\u9875\u9762\u5b58\u5728\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u79fb\u9664\uff01");
        }
        List iOptMethods = this.platformEnvironment.listAllOptMethod(topUnit);
        iOptMethods.removeIf(iOptMethod -> !iOptMethod.getOptId().equals(optId));
        if (iOptMethods.size() > 1) {
            return ResponseData.makeErrorMessage((String)"\u63a5\u53e3\u5b58\u5728\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u79fb\u9664\uff01");
        }
        JSONArray flowInfos = this.flowDefine.listFlowsByOptId(optId);
        if (!flowInfos.isEmpty()) {
            return ResponseData.makeErrorMessage((String)"\u6d41\u7a0b\u5b58\u5728\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u79fb\u9664\uff01");
        }
        this.metadataManageService.deleteMetaOptRelationByOptId(optId);
        boolean result = this.platformEnvironment.deleteOptInfoByOptId(optId);
        return ResponseData.makeSuccessResponse((String)(result + ""));
    }

    @ApiOperation(value="\u67e5\u8be2\u8d44\u6e90\u7684\u8be6\u60c5\u548c\u4f7f\u7528\u60c5\u51b5")
    @GetMapping(value={"/resourceInfo"})
    @WrapUpResponseBody
    public JSONObject resourceInfo(HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isBlank((CharSequence)WebOptUtils.getCurrentUserCode((HttpServletRequest)request))) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55");
        }
        Map parameters = ApplicationInfoController.collectRequestParameters((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)MapUtils.getString((Map)parameters, (Object)"topUnit"))) {
            throw new ObjectException("topUnit\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return this.applicationInfoManager.getResourceInfo(parameters);
    }
}

