/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.controller;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.locode.platform.po.ApplicationResources;
import com.centit.locode.platform.service.ApplicationResourcesService;
import com.centit.product.metadata.service.SourceInfoManager;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5e94\u7528\u8d44\u6e90\u5173\u8054", tags={"\u5e94\u7528\u8d44\u6e90\u5173\u8054"})
@RestController
@RequestMapping(value={"/appResources"})
public class ApplicationResourcesController
extends BaseController {
    @Autowired
    private ApplicationResourcesService applicationResourcesService;
    @Autowired
    private SourceInfoManager databaseInfoMag;

    @ApiOperation(value="\u65b0\u589e\u5173\u8054\u4fe1\u606f")
    @PostMapping
    @WrapUpResponseBody
    public void createApplicationDictionary(@RequestBody JSONObject jsonObject, HttpServletResponse response) {
        String osId = jsonObject.getString("osId");
        JSONArray dataBaseIds = jsonObject.getJSONArray("dataBaseIds");
        String pushUser = jsonObject.getString("pushUser");
        String dataBaseId = jsonObject.getString("dataBaseId");
        if (dataBaseIds != null && !dataBaseIds.isEmpty()) {
            for (int i = 0; i < dataBaseIds.size(); ++i) {
                ApplicationResources app = new ApplicationResources();
                app.setOsId(osId);
                app.setDataBaseId(dataBaseIds.get(i) + "");
                app.setPushUser(pushUser);
                if (dataBaseId != null && !"".equals(dataBaseId) && dataBaseId.equals(dataBaseIds.get(i) + "")) {
                    app.setIsUsed("1");
                } else {
                    app.setIsUsed("0");
                }
                this.applicationResourcesService.createApplicationResources(app);
            }
            JsonResultUtils.writeSingleDataJson((Object)dataBaseIds, (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u5173\u8054\u4fe1\u606f")
    @PutMapping
    @WrapUpResponseBody
    public void update(@RequestBody ApplicationResources applicationResources) {
        List<ApplicationResources> list;
        String osId = applicationResources.getOsId();
        String isUsed = applicationResources.getIsUsed();
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)osId)) {
            propertiesMap.put("osId", osId);
        }
        if (StringUtils.isNotBlank((CharSequence)isUsed)) {
            propertiesMap.put("isUsed", isUsed);
        }
        if (isUsed != null && "1".equals(isUsed) && (list = this.applicationResourcesService.listObjectsByProperty(propertiesMap)) != null && list.size() > 0) {
            for (ApplicationResources app : list) {
                app.setIsUsed("0");
                this.applicationResourcesService.updateApplicationResources(app);
            }
        }
        this.applicationResourcesService.updateApplicationResources(applicationResources);
    }

    @ApiOperation(value="\u5220\u9664\u5173\u8054\u4fe1\u606f")
    @DeleteMapping(value={"/{id}"})
    @WrapUpResponseBody
    public void deleteById(@PathVariable String id) {
        this.applicationResourcesService.deleteApplicationResources(id);
    }

    @ApiOperation(value="\u67e5\u8be2\u5173\u8054\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/list"})
    @WrapUpResponseBody
    public PageQueryResult list(HttpServletRequest request, PageDesc pageDesc) {
        Map propertiesMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        List<ApplicationResources> list = this.applicationResourcesService.listObjectsByProperty(propertiesMap);
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.isNotBlank((CharSequence)topUnit)) {
            propertiesMap.put("topUnit", topUnit);
        }
        propertiesMap.remove("osId");
        if (list != null && list.size() > 0) {
            HashMap<String, String> ids = new HashMap<String, String>();
            list.stream().forEach(applicationResources -> ids.put(applicationResources.getId(), applicationResources.getDataBaseId()));
            List dataBaseCode = list.stream().map(applicationResources -> applicationResources.getDataBaseId()).collect(Collectors.toList());
            propertiesMap.put("databaseCodes", dataBaseCode);
            JSONArray sourceInfos = this.databaseInfoMag.listDatabaseAsJson(propertiesMap, pageDesc);
            JSONArray jsonArray = new JSONArray();
            ids.forEach((key, value) -> sourceInfos.stream().forEach(sourceInfo -> {
                JSONObject jsonObject = (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)sourceInfo), JSONObject.class);
                if (jsonObject.getString("databaseCode").equals(ids.get(key))) {
                    ApplicationResources po = this.applicationResourcesService.getApplicationResources((String)key);
                    jsonObject.put((Object)"id", key);
                    jsonObject.put((Object)"dataBaseId", (Object)jsonObject.getString("databaseCode"));
                    jsonObject.put((Object)"pushUser", (Object)po.getPushUser());
                    jsonObject.put((Object)"pushTime", (Object)po.getPushTime());
                    jsonArray.add((Object)jsonObject);
                }
            }));
            return PageQueryResult.createJSONArrayResult((JSONArray)jsonArray, (PageDesc)pageDesc, (Class[])new Class[]{ApplicationResources.class});
        }
        return PageQueryResult.createResult((Collection)new JSONArray(), (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u5173\u8054\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    @WrapUpResponseBody
    public ApplicationResources getHistory(@PathVariable String id) {
        return this.applicationResourcesService.getApplicationResources(id);
    }

    @ApiOperation(value="\u5220\u9664\u8d44\u6e90\u7ba1\u7406\u4ee5\u53ca\u5173\u8054\u4fe1\u606f")
    @DeleteMapping(value={"/sourceInfo/{id}"})
    @WrapUpResponseBody
    public void deleteSourceInfo(@PathVariable String id) {
        this.applicationResourcesService.deleteSourceInfo(id);
    }
}

