/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.controller;

import com.alibaba.fastjson2.JSONObject;
import com.centit.fileserver.utils.SystemTempFileUtils;
import com.centit.fileserver.utils.UploadDownloadUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.locode.platform.service.ModelExportManager;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.file.FileSystemOpt;
import com.centit.support.file.FileType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"modelExport"})
@Api(value="\u5e94\u7528\u5bfc\u5165\u5bfc\u51fa", tags={"\u6a21\u677f\u5bfc\u5165\u5bfc\u51fa"})
public class ModelExportController
extends BaseController {
    @Value(value="${app.home:./}")
    private String appHome;
    @Autowired
    private ModelExportManager modelExportManager;
    @Autowired
    private PlatformEnvironment platformEnvironment;

    @ApiOperation(value="\u5bfc\u51fa\u5e94\u7528\u8def\u5f84")
    @GetMapping(value={"/downloadModel/{osId}"})
    public Map<String, String> downLoadModel(@PathVariable String osId, HttpServletRequest request) throws FileNotFoundException {
        String fileId;
        CentitUserDetails ud = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        if (ud == null) {
            throw new ObjectException(302, "\u7528\u6237\u6ca1\u6709\u767b\u5f55\uff0c\u6ca1\u6709\u5bf9\u5e94\u7684\u6743\u9650\uff01");
        }
        if (!this.platformEnvironment.loginUserIsExistWorkGroup(osId, ud.getUserCode())) {
            throw new ObjectException(403, "\u7528\u6237\u6ca1\u6709\u6743\u9650\u5bfc\u51fa\u8fd9\u4e2a\u5e94\u7528\uff1a" + osId + "\uff01");
        }
        String fileName = fileId = this.modelExportManager.downModel(osId);
        try {
            fileName = this.platformEnvironment.getOsInfo(osId).getOsName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("fileName", fileName);
        map.put("fileId", fileId);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5bfc\u51fa\u5e94\u7528\u6587\u4ef6")
    @GetMapping(value={"/downloadModelFile"})
    public void downLoadModel(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map parameters = ModelExportController.collectRequestParameters((HttpServletRequest)request);
        String fileName = URLEncoder.encode(StringBaseOpt.objectToString(parameters.get("fileName")), "UTF-8") + ".zip";
        String fileId = StringBaseOpt.objectToString(parameters.get("fileId"));
        String filePath = this.appHome + File.separator + fileId + ".zip";
        response.setContentType(FileType.mapExtNameToMimeType((String)"zip"));
        response.setHeader("Content-disposition", "attachment; filename=" + fileName);
        InputStream in = null;
        try {
            in = Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);
            IOUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                in.close();
                FileSystemOpt.deleteFile((String)filePath);
            }
        }
    }

    @ApiOperation(value="\u5bfc\u5165zip\u83b7\u53d6json")
    @RequestMapping(value={"/updateApp"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public JSONObject upLoadModel(HttpServletRequest request) {
        CentitUserDetails userDetails = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        if (userDetails == null) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55\uff0c\u8bf7\u5148\u767b\u5f55\uff01");
        }
        FileSystemOpt.createDirect((String)SystemTempFileUtils.getTempDirectory());
        String tempFilePath = SystemTempFileUtils.getRandomTempFilePath();
        try {
            InputStream inputStream = (InputStream)UploadDownloadUtils.fetchInputStreamFromMultipartResolver((HttpServletRequest)request).getRight();
            File file = new File(tempFilePath);
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)file);
            JSONObject jSONObject = this.modelExportManager.uploadModel(file);
            return jSONObject;
        }
        catch (Exception e) {
            throw new ObjectException(e.getMessage());
        }
        finally {
            FileSystemOpt.deleteFile((String)tempFilePath);
        }
    }
}

