/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.dde.adapter.DdeDubboTaskRun;
import com.centit.dde.core.DataSet;
import com.centit.dde.dataset.CsvDataSet;
import com.centit.fileserver.common.FileInfoOpt;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.locode.platform.dao.ApplicationTemplateDao;
import com.centit.locode.platform.service.ModelExportManager;
import com.centit.locode.platform.vo.AppTableNames;
import com.centit.locode.platform.vo.JsonAppVo;
import com.centit.product.dbdesign.service.MetaTableManager;
import com.centit.product.metadata.po.PendingMetaColumn;
import com.centit.product.metadata.po.PendingMetaTable;
import com.centit.product.metadata.po.SourceInfo;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.ZipCompressor;
import com.centit.support.common.JavaBeanMetaData;
import com.centit.support.common.ObjectException;
import com.centit.support.file.FileSystemOpt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ModelExportMangerImpl
implements ModelExportManager {
    @Value(value="${app.home:./}")
    private String appHome;
    private static final Logger logger = LoggerFactory.getLogger(ModelExportMangerImpl.class);
    @Autowired
    private ApplicationTemplateDao applicationTemplateDao;
    @Autowired
    private MetaTableManager metaTableManager;
    @Autowired
    private FileInfoOpt fileInfoOpt;
    @Autowired
    private DdeDubboTaskRun ddeDubboTaskRun;
    private final Map<String, String> applicationSql = new HashMap<String, String>(16);
    private final Map<String, String> oldApplicationSql = new HashMap<String, String>(16);
    private final Map<String, String> newDatabaseSql = new HashMap<String, String>(4);
    private final Map<String, String> oldDatabaseSql = new HashMap<String, String>(4);

    @PostConstruct
    void init() {
        this.applicationSql.put(AppTableNames.F_OS_INFO.name(), "select * from f_os_info where os_id=:osId");
        this.applicationSql.put(AppTableNames.FILE_LIBRARY_INFO.name(), "select * from file_library_info where library_id=:osId");
        this.applicationSql.put(AppTableNames.F_OPTINFO.name(), "select * from f_optinfo where top_opt_id=:osId");
        this.applicationSql.put(AppTableNames.F_OPTDEF.name(), "select * from f_optdef where opt_id in (select opt_id from f_optinfo where top_opt_id=:osId)");
        this.applicationSql.put(AppTableNames.F_DATABASE_INFO.name(), "select database_code,top_unit,database_name,database_desc,source_type from f_database_info where database_code in (select DATABASE_ID from m_application_resources where os_id=:osId)");
        this.applicationSql.put(AppTableNames.M_APPLICATION_RESOURCES.name(), "select * from m_application_resources where os_id=:osId");
        this.applicationSql.put(AppTableNames.F_TABLE_OPT_RELATION.name(), "select a.* from f_table_opt_relation a join f_md_table b on a.table_id=b.TABLE_ID where a.os_id=:osId");
        this.applicationSql.put(AppTableNames.M_META_FORM_MODEL.name(), "select * from m_meta_form_model where OS_ID=:osId");
        this.applicationSql.put(AppTableNames.Q_DATA_PACKET.name(), "select * from q_data_packet where OS_ID=:osId ");
        this.applicationSql.put(AppTableNames.Q_DATA_PACKET_PARAM.name(), "select * from q_data_packet_param where packet_id in (select packet_id from q_data_packet where OS_ID=:osId and is_disable='F')");
        this.applicationSql.put(AppTableNames.WF_FLOW_DEFINE.name(), "select * from wf_flow_define where OS_ID=:osId and flow_state in('A','E','B','D')");
        this.applicationSql.put(AppTableNames.WF_NODE.name(), "select * from wf_node where (flow_code,version) in(select flow_code,version from wf_flow_define where OS_ID=:osId and flow_state='B')");
        this.applicationSql.put(AppTableNames.WF_TRANSITION.name(), "select * from wf_transition where (flow_code,version) in(select flow_code,version from wf_flow_define where OS_ID=:osId and flow_state='B')");
        this.applicationSql.put(AppTableNames.WF_FLOW_STAGE.name(), "select * from wf_flow_stage where (flow_code,version) in(select flow_code,version from wf_flow_define where OS_ID=:osId and flow_state='B')");
        this.applicationSql.put(AppTableNames.WF_OPT_TEAM_ROLE.name(), "select * from wf_opt_team_role where opt_id in (select opt_id from f_optinfo where top_opt_id=:osId)");
        this.applicationSql.put(AppTableNames.WF_OPT_VARIABLE_DEFINE.name(), "select * from wf_opt_variable_define where opt_id in (select opt_id from f_optinfo where top_opt_id=:osId)");
        this.applicationSql.put(AppTableNames.F_DATACATALOG.name(), "select * from f_datacatalog where CATALOG_CODE in (select dictionary_id from m_application_dictionary where os_id=:osId)");
        this.applicationSql.put(AppTableNames.F_DATADICTIONARY.name(), "select * from f_datadictionary where CATALOG_CODE in (select dictionary_id from m_application_dictionary where os_id=:osId)");
        this.applicationSql.put(AppTableNames.M_APPLICATION_DICTIONARY.name(), "select * from m_application_dictionary where os_id=:osId");
        this.newDatabaseSql.put(AppTableNames.F_MD_TABLE.name(), "select * from f_md_table where table_id in (select table_id from f_table_opt_relation where OS_ID=:osId) and database_code in (select DATABASE_ID from m_application_resources where os_id=:osId)");
        this.newDatabaseSql.put(AppTableNames.F_MD_COLUMN.name(), "select * from f_md_column where table_id in (select table_id from f_table_opt_relation where OS_ID=:osId)");
        this.newDatabaseSql.put(AppTableNames.F_MD_RELATION.name(), "select * from f_md_relation where parent_table_id in (select table_id from f_table_opt_relation where OS_ID=:osId)");
        this.newDatabaseSql.put(AppTableNames.F_MD_REL_DETAIL.name(), "select * from f_md_rel_detail where relation_id in (select relation_id from f_md_relation where parent_table_id in (select table_id from f_table_opt_relation where OS_ID=:osId))");
        this.oldDatabaseSql.put(AppTableNames.F_MD_TABLE.name(), "select table_id,table_name,DATABASE_CODE from f_md_table where database_code in (select DATABASE_ID from m_application_resources where os_id=:osId)");
        this.oldDatabaseSql.put(AppTableNames.F_MD_RELATION.name(), "select RELATION_ID,PARENT_TABLE_ID,CHILD_TABLE_ID from f_md_relation where parent_table_id in (select table_id from f_md_table where database_code in (select DATABASE_ID from m_application_resources where os_id=:osId))");
        this.oldApplicationSql.put(AppTableNames.F_OS_INFO.name(), "select os_id,os_name,default_database from f_os_info where os_id=:osId");
        this.oldApplicationSql.put(AppTableNames.FILE_LIBRARY_INFO.name(), "select library_name from file_library_info where library_id=:osId");
        this.oldApplicationSql.put(AppTableNames.F_OPTINFO.name(), "select SOURCE_ID,FORM_CODE,OPT_ID,DOC_ID,top_opt_id,opt_name from f_optinfo");
        this.oldApplicationSql.put(AppTableNames.F_OPTDEF.name(), "select a.SOURCE_ID,a.OPT_CODE,b.top_opt_id from f_optdef a join f_optinfo b on a.opt_id=b.opt_id");
        this.oldApplicationSql.put(AppTableNames.F_DATABASE_INFO.name(), "select database_code,database_name from f_database_info where database_code in (select DATABASE_ID from m_application_resources where os_id=:osId)");
        this.oldApplicationSql.put(AppTableNames.M_APPLICATION_RESOURCES.name(), "select id,os_id,database_id from m_application_resources where os_id=:osId");
        this.oldApplicationSql.put(AppTableNames.F_TABLE_OPT_RELATION.name(), "select table_id,opt_id,id from f_table_opt_relation where OS_ID=:osId");
        this.oldApplicationSql.put(AppTableNames.M_META_FORM_MODEL.name(), "select source_id,MODEL_ID,os_id from m_meta_form_model");
        this.oldApplicationSql.put(AppTableNames.Q_DATA_PACKET.name(), "select source_id,packet_id,os_id from q_data_packet");
        this.oldApplicationSql.put(AppTableNames.WF_FLOW_DEFINE.name(), "select SOURCE_ID,FLOW_CODE,os_id from wf_flow_define");
        this.oldApplicationSql.put(AppTableNames.WF_NODE.name(), "select SOURCE_ID,NODE_ID,os_id from wf_node");
        this.oldApplicationSql.put(AppTableNames.WF_TRANSITION.name(), "select FLOW_CODE,START_NODE_ID,END_NODE_ID,TRANS_ID from wf_transition where flow_code in(select flow_code from wf_flow_define where OS_ID=:osId and flow_state<>'D')");
        this.oldApplicationSql.put(AppTableNames.WF_OPT_TEAM_ROLE.name(), "select OPT_TEAM_ROLE_ID,OPT_ID,ROLE_CODE from wf_opt_team_role where opt_id in (select opt_id from f_optinfo where top_opt_id=:osId)");
        this.oldApplicationSql.put(AppTableNames.WF_OPT_VARIABLE_DEFINE.name(), "select VARIABLE_NAME,OPT_ID,OPT_VARIABLE_ID from wf_opt_variable_define where opt_id in (select opt_id from f_optinfo where top_opt_id=:osId)");
        this.oldApplicationSql.put(AppTableNames.F_DATACATALOG.name(), "select a.catalog_code,a.source_id,b.os_id from f_datacatalog a join m_application_dictionary b on a.CATALOG_CODE=b.dictionary_id");
        this.oldApplicationSql.put(AppTableNames.M_APPLICATION_DICTIONARY.name(), "select id,os_id,dictionary_id from m_application_dictionary where os_id=:osId");
    }

    @Override
    public String downModel(String osId) throws FileNotFoundException {
        String fileId = DatetimeOpt.convertDateToString((Date)DatetimeOpt.currentUtilDate(), (String)"YYYYMMddHHmmss");
        String filePath = this.appHome + File.separator + fileId;
        HashMap<String, Object> mapApplication = new HashMap<String, Object>(1);
        mapApplication.put("osId", osId);
        this.updateSourceId(mapApplication);
        for (Map.Entry<String, String> entry : this.applicationSql.entrySet()) {
            this.createFile(mapApplication, entry.getValue(), entry.getKey(), filePath);
        }
        for (Map.Entry<String, String> entry : this.newDatabaseSql.entrySet()) {
            this.createFile(mapApplication, entry.getValue(), entry.getKey(), filePath);
        }
        try {
            this.compressFileInfo(osId, filePath);
        }
        catch (IOException e) {
            throw new ObjectException(e.getMessage());
        }
        ZipCompressor.compress((String)(filePath + ".zip"), (String)filePath);
        FileSystemOpt.deleteDirect((String)filePath);
        return fileId;
    }

    private void updateSourceId(Map<String, Object> map) {
        String updateOptInfo = "update f_optinfo set source_id=opt_id where top_opt_id=:osId and source_id is null";
        DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this.applicationTemplateDao, (String)updateOptInfo, map);
        String updateOptDef = "update f_optdef set source_id=opt_code where opt_id in (select opt_id from f_optinfo where top_opt_id=:osId) and source_id is null";
        DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this.applicationTemplateDao, (String)updateOptDef, map);
        String updateMetaForm = "update m_meta_form_model set source_id=model_id where os_id=:osId and source_id is null";
        DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this.applicationTemplateDao, (String)updateMetaForm, map);
        String updateDataPacket = "update q_data_packet set source_id=packet_id where os_id=:osId and source_id is null";
        DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this.applicationTemplateDao, (String)updateDataPacket, map);
        String updateFlowDefine = "update wf_flow_define set source_id=flow_code where os_id=:osId and source_id is null";
        DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this.applicationTemplateDao, (String)updateFlowDefine, map);
        String updateFlowNode = "update wf_node set source_id=node_id where (flow_code,version) in (select flow_code,version from wf_flow_define where OS_ID=:osId and flow_state='B') and source_id is null";
        DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this.applicationTemplateDao, (String)updateFlowNode, map);
    }

    private void createFile(Map<String, Object> map, String sql, String fileName, String filePath) throws FileNotFoundException {
        File file = new File(filePath);
        if (!file.exists() && !file.mkdirs()) {
            throw new SecurityException();
        }
        JSONArray jsonArray = DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this.applicationTemplateDao, (String)sql, map);
        DataSet simpleDataSet = new DataSet();
        simpleDataSet.setData((Object)jsonArray);
        CsvDataSet csvDataSet = new CsvDataSet();
        csvDataSet.setFilePath(filePath + File.separator + fileName + ".csv");
        csvDataSet.save(simpleDataSet);
    }

    private void compressFileInfo(String osId, String filePath) throws IOException {
        String fileInfoSql = "select file_id,file_name from file_info where library_id=:osId and file_catalog in ('A','B')";
        List objects = DatabaseOptUtils.listObjectsByNamedSql((BaseDaoImpl)this.applicationTemplateDao, (String)fileInfoSql, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"osId", osId}));
        if (objects == null) {
            return;
        }
        String fileInfoPath = filePath + File.separator + "file";
        File file = new File(fileInfoPath);
        if (!file.exists() && !file.mkdirs()) {
            throw new SecurityException();
        }
        for (Object[] object : objects) {
            String fileId = StringBaseOpt.castObjectToString((Object)object[0]);
            InputStream inputStream = this.fileInfoOpt.loadFileStream(fileId);
            String fileIdPath = fileInfoPath + File.separator + "(" + fileId + ")" + StringBaseOpt.castObjectToString((Object)object[1]);
            FileSystemOpt.createFile((InputStream)inputStream, (String)fileIdPath);
        }
        ZipCompressor.compress((String)(fileInfoPath + ".zip"), (String)fileInfoPath);
        FileSystemOpt.deleteDirect((String)fileInfoPath);
    }

    @Override
    public JSONObject uploadModel(File zipFile) throws Exception {
        JSONObject jsonObject = new JSONObject();
        String filePath = this.appHome + File.separator + "u" + DatetimeOpt.convertDateToString((Date)DatetimeOpt.currentUtilDate(), (String)"YYYYMMddHHmmss");
        ZipCompressor.release((File)zipFile, (String)filePath);
        List files = FileSystemOpt.findFiles((String)filePath, (String)"*.csv");
        CsvDataSet csvDataSet = new CsvDataSet();
        for (File file : files) {
            String fileName = FileSystemOpt.extractFileName((String)file.getPath());
            csvDataSet.setInputStream((InputStream)new FileInputStream(file.getPath()));
            jsonObject.put((Object)fileName, (Object)csvDataSet.load(null, null));
        }
        jsonObject.put((Object)"file", (Object)filePath);
        return jsonObject;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer createApp(JSONObject jsonObject, String osId, CentitUserDetails userDetails) {
        try {
            JsonAppVo jsonAppVo = new JsonAppVo(jsonObject, this.getOldApplication(osId), userDetails, this.appHome, this.fileInfoOpt);
            int result = this.createApp(jsonAppVo);
            return result;
        }
        catch (Exception e) {
            OperationLogCenter.log((OperationLog)OperationLog.create().application(osId).content("\u5bfc\u5165\u5e94\u7528\u5931\u8d25").user(userDetails.getUserCode()).topUnit(userDetails.getTopUnitCode()).unit(userDetails.getCurrentUnitCode()).loginIp(userDetails.getLoginIp()).time(new Date()).newObject((Object)e.getMessage()));
            throw new ObjectException(e.getMessage());
        }
    }

    @Override
    public JSONObject prepareApp(JSONObject jsonObject, String osId, CentitUserDetails currentUserDetails) {
        try {
            JsonAppVo jsonAppVo = new JsonAppVo(jsonObject, this.getOldApplication(osId), currentUserDetails, this.appHome, this.fileInfoOpt);
            jsonAppVo.updatePrimary();
            JSONObject returnJson = new JSONObject();
            returnJson.put((Object)"jsonAppVo", (Object)jsonAppVo);
            List<Map<String, Object>> pendingTableList = jsonAppVo.getMapJsonObject().get(AppTableNames.F_MD_TABLE.name());
            List<Map<String, Object>> pendingColumnsList = jsonAppVo.getMapJsonObject().get(AppTableNames.F_MD_COLUMN.name());
            List<Map<String, Object>> databaseList = jsonAppVo.getMapJsonObject().get(AppTableNames.F_DATABASE_INFO.name());
            HashMap<String, List> appSqls = new HashMap<String, List>(2);
            JavaBeanMetaData javaBeanMetaData = JavaBeanMetaData.createBeanMetaDataFromType(PendingMetaTable.class);
            JavaBeanMetaData javaBeanMetaData2 = JavaBeanMetaData.createBeanMetaDataFromType(PendingMetaColumn.class);
            for (Map<String, Object> map : pendingTableList) {
                PendingMetaTable pendingMetaTable = (PendingMetaTable)javaBeanMetaData.createBeanObjectFromMap(map);
                ArrayList<PendingMetaColumn> pendingMetaColumns = new ArrayList<PendingMetaColumn>();
                for (Map<String, Object> mapPendingColumn : pendingColumnsList) {
                    PendingMetaColumn pendingMetaColumn = (PendingMetaColumn)javaBeanMetaData2.createBeanObjectFromMap(mapPendingColumn);
                    pendingMetaColumn.setMaxLength(NumberBaseOpt.castObjectToInteger((Object)mapPendingColumn.get("columnLength")));
                    if (!pendingMetaColumn.getTableId().equals(pendingMetaTable.getTableId())) continue;
                    pendingMetaColumns.add(pendingMetaColumn);
                }
                pendingMetaTable.setMdColumns(pendingMetaColumns);
                List sqls = this.metaTableManager.makeAlterTableSqlList(pendingMetaTable);
                boolean findDatabase = false;
                for (String databaseCode : appSqls.keySet()) {
                    if (!databaseCode.equals(pendingMetaTable.getDatabaseCode())) continue;
                    findDatabase = true;
                    ((List)appSqls.get(databaseCode)).addAll(sqls);
                }
                if (findDatabase) continue;
                appSqls.put(pendingMetaTable.getDatabaseCode(), sqls);
            }
            javaBeanMetaData = JavaBeanMetaData.createBeanMetaDataFromType(SourceInfo.class);
            HashMap DDLs = new HashMap(2);
            for (Map<String, Object> map : databaseList) {
                SourceInfo sourceInfo = (SourceInfo)javaBeanMetaData.createBeanObjectFromMap(map);
                for (String databaseCode : appSqls.keySet()) {
                    if (!sourceInfo.getDatabaseCode().equals(databaseCode)) continue;
                    DDLs.put(sourceInfo.getDatabaseName() + "(" + databaseCode + ")", appSqls.get(databaseCode));
                }
            }
            returnJson.put((Object)"DDL", DDLs);
            returnJson.put((Object)"runDDL", (Object)true);
            return returnJson;
        }
        catch (Exception e) {
            throw new ObjectException(e.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer importApp(JSONObject jsonObject, CentitUserDetails userDetails) throws Exception {
        if (!jsonObject.containsKey("jsonAppVo")) {
            throw new Exception("\u6ca1\u6709\u9700\u8981\u5bfc\u5165\u7684\u5c5e\u6027");
        }
        JsonAppVo jsonAppVo = (JsonAppVo)JSON.parseObject((String)jsonObject.getString("jsonAppVo"), JsonAppVo.class);
        if (jsonAppVo == null) {
            throw new Exception("\u5bfc\u5165\u5c5e\u6027\u5185\u5bb9\u4e3a\u7a7a");
        }
        jsonAppVo.setTopUnit(userDetails);
        jsonAppVo.createAppObject();
        jsonAppVo.setDatabaseName();
        boolean runDDL = BooleanBaseOpt.castObjectToBoolean((Object)jsonObject.get("runDDL"), (Boolean)true);
        int result = 0;
        try {
            if (jsonAppVo.getAppList().size() > 0) {
                if (!runDDL) {
                    for (Object object : jsonAppVo.getAppList()) {
                        if (!(object instanceof PendingMetaTable)) continue;
                        ((PendingMetaTable)object).setTableState("S");
                    }
                }
                result += DatabaseOptUtils.batchMergeObjects((BaseDaoImpl)this.applicationTemplateDao, jsonAppVo.getAppList());
                if (runDDL) {
                    for (String sDatabaseName : jsonAppVo.getListDatabaseName()) {
                        Pair pair = this.metaTableManager.publishDatabase(sDatabaseName, jsonAppVo.getUserCode());
                        if (!GeneralAlgorithm.equals((Object)pair.getLeft(), (Object)-1)) continue;
                        logger.error((String)pair.getRight());
                    }
                }
            }
            if (jsonAppVo.getMetaObject().size() > 0) {
                result += DatabaseOptUtils.batchMergeObjects((BaseDaoImpl)this.applicationTemplateDao, jsonAppVo.getMetaObject());
            }
            jsonAppVo.refreshCache(this.ddeDubboTaskRun);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return result;
    }

    private JSONObject getOldApplication(String osId) {
        JSONArray jsonArray;
        if (StringBaseOpt.isNvl((String)osId)) {
            return new JSONObject();
        }
        HashMap<String, String> mapApplication = new HashMap<String, String>(1);
        mapApplication.put("osId", osId);
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, String> entry : this.oldApplicationSql.entrySet()) {
            jsonArray = DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this.applicationTemplateDao, (String)entry.getValue(), mapApplication);
            if (jsonArray == null) continue;
            jsonObject.put((Object)entry.getKey(), (Object)jsonArray);
        }
        for (Map.Entry<String, String> entry : this.oldDatabaseSql.entrySet()) {
            jsonArray = DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this.applicationTemplateDao, (String)entry.getValue(), mapApplication);
            if (jsonArray == null) continue;
            jsonObject.put((Object)entry.getKey(), (Object)jsonArray);
        }
        return jsonObject;
    }

    private Integer createApp(JsonAppVo jsonAppVo) throws Exception {
        int result = 0;
        jsonAppVo.prepareApp();
        try {
            if (jsonAppVo.getAppList().size() > 0) {
                result += DatabaseOptUtils.batchMergeObjects((BaseDaoImpl)this.applicationTemplateDao, jsonAppVo.getAppList());
                for (String sDatabaseName : jsonAppVo.getListDatabaseName()) {
                    Pair pair = this.metaTableManager.publishDatabase(sDatabaseName, jsonAppVo.getUserCode());
                    if (!GeneralAlgorithm.equals((Object)pair.getLeft(), (Object)-1)) continue;
                    logger.error((String)pair.getRight());
                }
            }
            if (jsonAppVo.getMetaObject().size() > 0) {
                result += DatabaseOptUtils.batchMergeObjects((BaseDaoImpl)this.applicationTemplateDao, jsonAppVo.getMetaObject());
            }
            jsonAppVo.refreshCache(this.ddeDubboTaskRun);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return result;
    }
}

