/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.dde.aync.service.ExchangeService;
import com.centit.dde.po.DataPacket;
import com.centit.dde.po.DataSetColumnDesc;
import com.centit.dde.po.DataSetDefine;
import com.centit.dde.services.DataPacketService;
import com.centit.dde.services.DataSetDefineService;
import com.centit.dde.utils.DataPacketUtil;
import com.centit.dde.vo.DataPacketSchema;
import com.centit.fileserver.common.FileStore;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.ip.service.IntegrationEnvironment;
import com.centit.product.dataopt.core.BizModel;
import com.centit.product.dataopt.core.DataSet;
import com.centit.product.dataopt.core.SimpleBizModel;
import com.centit.product.dataopt.core.SimpleDataSet;
import com.centit.product.dataopt.dataset.CsvDataSet;
import com.centit.product.dataopt.dataset.ExcelDataSet;
import com.centit.product.dataopt.dataset.SQLDataSetReader;
import com.centit.support.database.metadata.IDatabaseInfo;
import com.centit.support.database.utils.DataSourceDescription;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u6570\u636e\u5305", tags={"\u6570\u636e\u5305"})
@RestController
@RequestMapping(value={"packet"})
public class DataPacketController
extends BaseController {
    @Autowired(required=false)
    private FileStore fileStore;
    @Autowired
    private DataPacketService dataPacketService;
    @Autowired
    private DataSetDefineService dataSetDefineService;
    @Autowired
    private IntegrationEnvironment integrationEnvironment;
    @Autowired
    private ExchangeService exchangeService;

    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u5305")
    @PostMapping
    @WrapUpResponseBody
    public void createDataPacket(@RequestBody DataPacket dataPacket, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        dataPacket.setRecorder(userCode);
        dataPacket.setDataOptDescJson(dataPacket.getDataOptDescJson());
        this.dataPacketService.createDataPacket(dataPacket);
    }

    @ApiOperation(value="\u7f16\u8f91\u6570\u636e\u5305")
    @PutMapping(value={"/{packetId}"})
    @WrapUpResponseBody
    public void updateDataPacket(@PathVariable String packetId, @RequestBody DataPacket dataPacket) {
        dataPacket.setPacketId(packetId);
        dataPacket.setDataOptDescJson(dataPacket.getDataOptDescJson());
        for (DataSetDefine setDefine : dataPacket.getDataSetDefines()) {
            for (DataSetColumnDesc columnDesc : setDefine.getColumns()) {
                columnDesc.setPacketId(dataPacket.getPacketId());
                columnDesc.setQueryId(setDefine.getQueryId());
            }
        }
        this.dataPacketService.updateDataPacket(dataPacket);
    }

    @ApiOperation(value="\u7f16\u8f91\u6570\u636e\u5305\u6570\u636e\u5904\u7406\u63cf\u8ff0\u4fe1\u606f")
    @PutMapping(value={"/opt/{packetId}"})
    @WrapUpResponseBody
    public void updateDataPacketOpt(@PathVariable String packetId, @RequestBody String dataOptDescJson) {
        this.dataPacketService.updateDataPacketOptJson(packetId, dataOptDescJson);
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e\u5305")
    @DeleteMapping(value={"/{packetId}"})
    @WrapUpResponseBody
    public void deleteDataPacket(@PathVariable String packetId) {
        this.dataPacketService.deleteDataPacket(packetId);
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5305\u521d\u59cb\u6a21\u5f0f\uff08\u4e0d\u5305\u62ec\u6570\u636e\u9884\u5904\u7406\uff09")
    @GetMapping(value={"/originschema/{packetId}"})
    @WrapUpResponseBody
    public DataPacketSchema getDataPacketOriginSchema(@PathVariable String packetId) {
        return DataPacketSchema.valueOf((DataPacket)this.dataPacketService.getDataPacket(packetId));
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5305\u6a21\u5f0f")
    @GetMapping(value={"/schema/{packetId}"})
    @WrapUpResponseBody
    public DataPacketSchema getDataPacketSchema(@PathVariable String packetId) {
        JSONObject obj;
        DataPacket dataPacket = this.dataPacketService.getDataPacket(packetId);
        DataPacketSchema schema = DataPacketSchema.valueOf((DataPacket)dataPacket);
        if (dataPacket != null && (obj = dataPacket.getDataOptDescJson()) != null) {
            return DataPacketUtil.calcDataPacketSchema((DataPacketSchema)schema, (JSONObject)obj);
        }
        return schema;
    }

    @ApiOperation(value="\u6839\u636e\u989d\u5916\u7684\u64cd\u4f5c\u6b65\u9aa4\u83b7\u53d6\u6570\u636e\u5305\u6a21\u5f0f")
    @PostMapping(value={"/extendschema/{packetId}"})
    @WrapUpResponseBody
    public DataPacketSchema getDataPacketSchemaWithOpt(@PathVariable String packetId, @RequestBody String optsteps) {
        JSONObject obj;
        DataPacket dataPacket = this.dataPacketService.getDataPacket(packetId);
        DataPacketSchema schema = DataPacketSchema.valueOf((DataPacket)dataPacket);
        if (dataPacket != null && (obj = JSON.parseObject((String)optsteps)) != null) {
            return DataPacketUtil.calcDataPacketSchema((DataPacketSchema)schema, (JSONObject)obj);
        }
        return schema;
    }

    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u5305")
    @GetMapping
    @WrapUpResponseBody
    public PageQueryResult<DataPacket> listDataPacket(HttpServletRequest request, PageDesc pageDesc) {
        List list = this.dataPacketService.listDataPacket(BaseController.collectRequestParameters((HttpServletRequest)request), pageDesc);
        return PageQueryResult.createResult((Collection)list, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u6570\u636e\u5305")
    @GetMapping(value={"/{packetId}"})
    @WrapUpResponseBody
    public DataPacket getDataPacket(@PathVariable String packetId) {
        return this.dataPacketService.getDataPacket(packetId);
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5305\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="packetId", value="\u6570\u636e\u5305ID", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="datasets", value="\u9700\u8981\u8fd4\u56de\u7684\u6570\u636e\u96c6\u540d\u79f0\uff0c\u7528\u9017\u53f7\u9694\u5f00\uff0c\u5982\u679c\u4e3a\u7a7a\u8fd4\u56de\u5168\u90e8")})
    @GetMapping(value={"/packet/{packetId}"})
    @WrapUpResponseBody
    public BizModel fetchDataPacketData(@PathVariable String packetId, String datasets, HttpServletRequest request) {
        Map params = BaseController.collectRequestParameters((HttpServletRequest)request);
        BizModel bizModel = this.dataPacketService.fetchDataPacketData(packetId, params);
        BizModel dup = this.getBizModel(datasets, bizModel);
        if (dup != null) {
            return dup;
        }
        return bizModel;
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5305\u6570\u636e\u5e76\u5bf9\u6570\u636e\u8fdb\u884c\u4e1a\u52a1\u5904\u7406")
    @PutMapping(value={"/dataopts/{packetId}/{datasets}"})
    @WrapUpResponseBody
    public BizModel fetchDataPacketDataWithOpt(@PathVariable String packetId, @PathVariable String datasets, @RequestBody JSONObject optsteps, HttpServletRequest request) {
        Map params = BaseController.collectRequestParameters((HttpServletRequest)request);
        BizModel bizModel = null;
        bizModel = optsteps.isEmpty() ? this.dataPacketService.fetchDataPacketData(packetId, params) : this.dataPacketService.fetchDataPacketData(packetId, params, optsteps);
        BizModel dup = this.getBizModel(datasets, bizModel);
        if (dup != null) {
            return dup;
        }
        return bizModel;
    }

    private BizModel getBizModel(String datasets, BizModel bizModel) {
        if (StringUtils.isNotBlank((CharSequence)datasets)) {
            String[] dss = datasets.split(",");
            SimpleBizModel dup = new SimpleBizModel(bizModel.getModelName());
            dup.setModelTag(bizModel.getModelTag());
            HashMap<String, DataSet> dataMap = new HashMap<String, DataSet>(dss.length + 1);
            for (String dsn : dss) {
                DataSet ds = bizModel.fetchDataSetByName(dsn);
                if (ds == null) continue;
                dataMap.put(dsn, ds);
            }
            dup.setBizData(dataMap);
            return dup;
        }
        return null;
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5e93\u67e5\u8be2\u6570\u636e")
    @ApiImplicitParam(name="queryId", value="\u6570\u636e\u67e5\u8be2ID", required=true, paramType="path", dataType="String")
    @GetMapping(value={"/dbquery/{queryId}"})
    @WrapUpResponseBody
    public SimpleDataSet fetchDBQueryData(@PathVariable String queryId, HttpServletRequest request) {
        Map params = DataPacketController.collectRequestParameters((HttpServletRequest)request);
        DataSetDefine query = this.dataSetDefineService.getDbQuery(queryId);
        DataPacket dataPacket = this.dataPacketService.getDataPacket(query.getPacketId());
        Map modelTag = dataPacket.getPacketParamsValue();
        switch (query.getSetType()) {
            case "D": {
                params.put("currentUser", WebOptUtils.getCurrentUserInfo((HttpServletRequest)request));
                params.put("currentUnitCode", WebOptUtils.getCurrentUnitCode((HttpServletRequest)request));
                SQLDataSetReader sqlDSR = new SQLDataSetReader();
                sqlDSR.setDataSource(DataSourceDescription.valueOf((IDatabaseInfo)this.integrationEnvironment.getDatabaseInfo(query.getDatabaseCode())));
                sqlDSR.setSqlSen(query.getQuerySQL());
                if (params != null) {
                    modelTag.putAll(params);
                }
                SimpleDataSet simpleDataSet = sqlDSR.load(modelTag);
                simpleDataSet.setDataSetName(query.getQueryName());
                return simpleDataSet;
            }
            case "E": {
                ExcelDataSet excelDataSet = new ExcelDataSet();
                try {
                    excelDataSet.setFilePath(this.fileStore.getFile(query.getQuerySQL()).getPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return excelDataSet.load(params);
            }
            case "C": {
                CsvDataSet csvDataSet = new CsvDataSet();
                try {
                    csvDataSet.setFilePath(this.fileStore.getFile(query.getQuerySQL()).getPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return csvDataSet.load(params);
            }
        }
        throw new IllegalStateException("Unexpected value: " + query.getSetType());
    }

    @GetMapping(value={"/run/{packetId}"})
    @ApiOperation(value="\u7acb\u5373\u6267\u884c\u4efb\u52a1")
    @WrapUpResponseBody
    public BizModel runTaskExchange(@PathVariable String packetId) {
        return this.exchangeService.runTask(packetId);
    }

    @GetMapping(value={"/exist/{applicationId}/{interfaceName}"})
    @ApiOperation(value="\u63a5\u53e3\u540d\u79f0\u662f\u5426\u5df2\u5b58\u5728")
    @WrapUpResponseBody
    public Boolean isExist(@PathVariable String applicationId, @PathVariable String interfaceName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("interfaceName", interfaceName);
        params.put("applicationId", applicationId);
        List list = this.dataPacketService.listDataPacket(params, new PageDesc());
        if (list.size() > 0) {
            return true;
        }
        return false;
    }

    @GetMapping(value={"/{applicationId}/{interfaceName}/{sourceName}"})
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e")
    @WrapUpResponseBody
    public DataSet getData(@PathVariable String applicationId, @PathVariable String interfaceName, @PathVariable String sourceName, HttpServletRequest request) {
        Map params = BaseController.collectRequestParameters((HttpServletRequest)request);
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("interfaceName", interfaceName);
        params2.put("applicationId", applicationId);
        List list = this.dataPacketService.listDataPacket(params2, new PageDesc());
        if (list.size() > 0) {
            DataPacket taskExchange = (DataPacket)list.get(0);
            BizModel bizModel = this.dataPacketService.fetchDataPacketData(taskExchange.getPacketId(), params, taskExchange.getDataOptDescJson());
            String sourceCode = this.getSourceCode(sourceName, taskExchange.getDataOptDescJson());
            if (StringUtils.isNotBlank((CharSequence)sourceCode)) {
                return bizModel.fetchDataSetByName(sourceCode);
            }
            return bizModel.getMainDataSet();
        }
        return null;
    }

    private String getSourceCode(String sourceName, JSONObject bizOptJson) {
        JSONArray jsonArray = bizOptJson.getJSONArray("steps");
        for (Object step : jsonArray) {
            if (!(step instanceof JSONObject)) continue;
            if ("interface".equals(((JSONObject)step).getString("operation"))) {
                Object mapInfo = ((JSONObject)step).get((Object)"fieldsMap");
                if (!(mapInfo instanceof Map)) continue;
                return (String)((Map)mapInfo).get(sourceName);
            }
            return "";
        }
        return "";
    }
}

