/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.controller;

import com.alibaba.fastjson.JSONArray;
import com.centit.dde.po.DataSetDefine;
import com.centit.dde.services.DataSetDefineService;
import com.centit.dde.vo.ColumnSchema;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u6570\u636e\u96c6\u67e5\u8be2", tags={"\u6570\u636e\u96c6\u67e5\u8be2"})
@RestController
@RequestMapping(value={"query"})
public class DataSetDefineController
extends BaseController {
    @Autowired
    private DataSetDefineService dataSetDefineService;

    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u96c6")
    @PostMapping
    @WrapUpResponseBody
    public void createDbQuery(DataSetDefine dataSetDefine, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        dataSetDefine.setRecorder(userCode);
        this.dataSetDefineService.createDbQuery(dataSetDefine);
    }

    @ApiOperation(value="\u7f16\u8f91\u6570\u636e\u96c6")
    @PutMapping(value={"/{queryId}"})
    @WrapUpResponseBody
    public void updateDbQuery(@PathVariable String queryId, DataSetDefine dataSetDefine) {
        dataSetDefine.setQueryId(queryId);
        this.dataSetDefineService.updateDbQuery(dataSetDefine);
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e\u96c6")
    @DeleteMapping(value={"/{queryId}"})
    @WrapUpResponseBody
    public void deleteDbQuery(@PathVariable String queryId) {
        this.dataSetDefineService.deleteDbQuery(queryId);
    }

    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u96c6")
    @GetMapping
    @WrapUpResponseBody
    public PageQueryResult<DataSetDefine> listDbQuery(PageDesc pageDesc) {
        List list = this.dataSetDefineService.listDbQuery(new HashMap(), pageDesc);
        return PageQueryResult.createResult((Collection)list, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u6570\u636e\u96c6")
    @GetMapping(value={"/{queryId}"})
    @WrapUpResponseBody
    public DataSetDefine getDbQuery(@PathVariable String queryId) {
        return this.dataSetDefineService.getDbQuery(queryId);
    }

    @ApiOperation(value="\u9884\u89c8\u6570\u636e\u503c\u8fd4\u56de\u524d20\u884c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="databaseCode", value="\u6570\u636e\u5e93\u4ee3\u7801", required=true), @ApiImplicitParam(name="sql", value="\u67e5\u8be2SQL", required=true)})
    @RequestMapping(value={"/reviewdata"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public JSONArray queryViewSqlData(String databaseCode, String sql, HttpServletRequest request) {
        Map params = DataSetDefineController.collectRequestParameters((HttpServletRequest)request);
        return this.dataSetDefineService.queryViewSqlData(databaseCode, sql, params);
    }

    @ApiOperation(value="\u751f\u6210\u67e5\u8be2\u5b57\u6bb5\u5217\u8868")
    @ApiImplicitParam(name="sql", value="\u67e5\u8be2SQL", required=true)
    @RequestMapping(value={"/sqlcolumn"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public List<ColumnSchema> generateSqlcolumn(String databaseCode, String sql, String dataType, HttpServletRequest request) {
        sql = StringEscapeUtils.unescapeHtml4((String)sql);
        Map params = DataSetDefineController.collectRequestParameters((HttpServletRequest)request);
        switch (dataType) {
            case "E": {
                params.put("FileId", sql);
                return this.dataSetDefineService.generateExcelFields(params);
            }
            case "C": {
                params.put("FileId", sql);
                return this.dataSetDefineService.generateCsvFields(params);
            }
            case "J": {
                return this.dataSetDefineService.generateJsonFields(params);
            }
            case "D": {
                return this.dataSetDefineService.generateSqlFields(databaseCode, sql, params);
            }
        }
        return null;
    }

    @ApiOperation(value="\u751f\u6210\u53c2\u6570\u540d\u79f0\u5217\u8868")
    @ApiImplicitParam(name="sql", value="\u67e5\u8be2SQL", required=true)
    @RequestMapping(value={"/param"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public Set<String> generateParam(String sql) {
        return this.dataSetDefineService.generateSqlParams(sql);
    }
}

