/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.datamoving.dataopt;

import com.alibaba.fastjson.JSONObject;
import com.centit.framework.ip.po.DatabaseInfo;
import com.centit.framework.ip.service.IntegrationEnvironment;
import com.centit.product.dataopt.bizopt.BuiltInOperation;
import com.centit.product.dataopt.core.BizModel;
import com.centit.product.dataopt.core.DataSet;
import com.centit.product.dataopt.dataset.CsvDataSet;
import com.centit.product.dataopt.dataset.ExcelDataSet;
import com.centit.product.dataopt.dataset.SQLDataSetWriter;
import com.centit.product.metadata.po.MetaTable;
import com.centit.product.metadata.service.MetaDataService;
import com.centit.support.common.ObjectException;
import com.centit.support.database.metadata.IDatabaseInfo;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.transaction.JdbcTransaction;
import com.centit.support.database.utils.DataSourceDescription;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DatabaseBizOperation
extends BuiltInOperation {
    @Value(value="${os.file.base.dir:./file_home/export}")
    private String path;
    private IntegrationEnvironment integrationEnvironment;
    private MetaDataService metaDataService;

    public DatabaseBizOperation() {
    }

    public DatabaseBizOperation(JSONObject bizOptJson) {
        this.bizOptJson = bizOptJson;
    }

    private BizModel runPersistence(BizModel bizModel, JSONObject bizOptJson) throws IOException {
        String dataType;
        switch (dataType = DatabaseBizOperation.getJsonFieldString((JSONObject)bizOptJson, (String)"dataType", (String)"D")) {
            case "E": {
                return this.writeExcelFile(bizModel, bizOptJson);
            }
            case "C": {
                return this.writeCsvFile(bizModel, bizOptJson);
            }
            case "H": {
                return this.runHttpPost(bizModel, bizOptJson);
            }
        }
        return this.writeDatabase(bizModel, bizOptJson);
    }

    @JdbcTransaction
    private BizModel writeDatabase(BizModel bizModel, JSONObject bizOptJson) {
        String sourDSName = DatabaseBizOperation.getJsonFieldString((JSONObject)bizOptJson, (String)"source", (String)bizModel.getModelName());
        String databaseCode = DatabaseBizOperation.getJsonFieldString((JSONObject)bizOptJson, (String)"databaseCode", null);
        String tableId = DatabaseBizOperation.getJsonFieldString((JSONObject)bizOptJson, (String)"tableId", null);
        if (StringUtils.isBlank((CharSequence)tableId)) {
            tableId = DatabaseBizOperation.getJsonFieldString((JSONObject)bizOptJson, (String)"tableName", null);
        }
        String writerType = DatabaseBizOperation.getJsonFieldString((JSONObject)bizOptJson, (String)"writerType", (String)"merge");
        if (databaseCode == null || tableId == null) {
            throw new ObjectException((Object)bizOptJson, 602, "\u5bf9\u5e94\u7684\u5143\u6570\u636e\u4fe1\u606f\u627e\u4e0d\u5230\uff0c\u6570\u636e\u5e93\uff1a" + databaseCode + " \u8868:" + tableId);
        }
        DatabaseInfo databaseInfo = this.integrationEnvironment.getDatabaseInfo(databaseCode);
        if (databaseInfo == null) {
            throw new ObjectException((Object)bizOptJson, 602, "\u6570\u636e\u5e93\u4fe1\u606f\u65e0\u6548\uff1a" + databaseCode);
        }
        this.runMap(bizModel, bizOptJson);
        DataSet dataSet = bizModel.fetchDataSetByName(sourDSName);
        if (dataSet == null) {
            throw new ObjectException((Object)bizOptJson, 602, "\u6570\u636e\u6e90\u4fe1\u606f\u65e0\u6548\uff1a" + sourDSName);
        }
        MetaTable tableInfo = this.metaDataService.getMetaTableWithRelations(tableId);
        if (tableInfo == null) {
            throw new ObjectException((Object)bizOptJson, 602, "\u5bf9\u5e94\u7684\u5143\u6570\u636e\u4fe1\u606f\u627e\u4e0d\u5230\uff0c\u6570\u636e\u5e93\uff1a" + databaseCode + " \u8868:" + tableInfo);
        }
        SQLDataSetWriter dataSetWriter = new SQLDataSetWriter(DataSourceDescription.valueOf((IDatabaseInfo)databaseInfo), (TableInfo)tableInfo);
        switch (writerType) {
            case "append": {
                dataSetWriter.append(dataSet);
                break;
            }
            case "merge": 
            case "update": {
                dataSetWriter.merge(dataSet);
                break;
            }
            default: {
                dataSetWriter.save(dataSet);
            }
        }
        return bizModel;
    }

    protected BizModel writeCsvFile(BizModel bizModel, JSONObject bizOptJson) throws IOException {
        String sourDsName = DatabaseBizOperation.getJsonFieldString((JSONObject)bizOptJson, (String)"source", (String)bizModel.getModelName());
        String fileName = DatabaseBizOperation.getJsonFieldString((JSONObject)bizOptJson, (String)"fileName", null);
        if (this.path == null) {
            throw new ObjectException((Object)bizOptJson, 602, "\u914d\u7f6e\u6587\u4ef6\u6ca1\u6709\u8bbe\u7f6e\u4fdd\u5b58\u6587\u4ef6\u8def\u5f84");
        }
        CsvDataSet dataSetWriter = new CsvDataSet();
        dataSetWriter.setFilePath(this.path + File.separator + fileName);
        dataSetWriter.save((DataSet)this.runAppend(bizModel, bizOptJson).getBizData().get(sourDsName));
        return bizModel;
    }

    protected BizModel writeExcelFile(BizModel bizModel, JSONObject bizOptJson) throws IOException {
        String sourDsName = DatabaseBizOperation.getJsonFieldString((JSONObject)bizOptJson, (String)"source", (String)bizModel.getModelName());
        String fileName = DatabaseBizOperation.getJsonFieldString((JSONObject)bizOptJson, (String)"fileName", null);
        if (this.path == null) {
            throw new ObjectException((Object)bizOptJson, 602, "\u914d\u7f6e\u6587\u4ef6\u6ca1\u6709\u8bbe\u7f6e\u4fdd\u5b58\u6587\u4ef6\u8def\u5f84");
        }
        ExcelDataSet dataSetWriter = new ExcelDataSet();
        dataSetWriter.setFilePath(this.path + File.separator + fileName);
        dataSetWriter.save((DataSet)bizModel.getBizData().get(sourDsName));
        return bizModel;
    }

    protected BizModel runHttpPost(BizModel bizModel, JSONObject bizOptJson) {
        return bizModel;
    }

    public BizModel runOneStep(BizModel bizModel, JSONObject bizOptJson) {
        String sOptType = bizOptJson.getString("operation");
        if (StringUtils.isBlank((CharSequence)sOptType)) {
            return bizModel;
        }
        switch (sOptType) {
            case "map": {
                return this.runMap(bizModel, bizOptJson);
            }
            case "filter": {
                return this.runFilter(bizModel, bizOptJson);
            }
            case "append": {
                return this.runAppend(bizModel, bizOptJson);
            }
            case "stat": {
                return this.runStat(bizModel, bizOptJson);
            }
            case "analyse": {
                return this.runAnalyse(bizModel, bizOptJson);
            }
            case "cross": {
                return this.runCross(bizModel, bizOptJson);
            }
            case "compare": {
                return this.runCompare(bizModel, bizOptJson);
            }
            case "join": {
                return this.runJoin(bizModel, bizOptJson);
            }
            case "sort": {
                return this.runSort(bizModel, bizOptJson);
            }
            case "union": {
                return this.runUnion(bizModel, bizOptJson);
            }
            case "filterExt": {
                return this.runFilterExt(bizModel, bizOptJson);
            }
            case "check": {
                return this.runCheckData(bizModel, bizOptJson);
            }
            case "static": {
                return this.runStaticData(bizModel, bizOptJson);
            }
            case "persistence": {
                try {
                    return this.runPersistence(bizModel, bizOptJson);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return bizModel;
    }

    public void setIntegrationEnvironment(IntegrationEnvironment integrationEnvironment) {
        this.integrationEnvironment = integrationEnvironment;
    }

    public void setMetaDataService(MetaDataService metaDataService) {
        this.metaDataService = metaDataService;
    }
}

