/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.datamoving.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.dde.dao.DataPacketDao;
import com.centit.dde.dao.TaskDetailLogDao;
import com.centit.dde.dao.TaskLogDao;
import com.centit.dde.datamoving.dataopt.DatabaseBizOperation;
import com.centit.dde.po.DataPacket;
import com.centit.dde.po.TaskDetailLog;
import com.centit.dde.po.TaskLog;
import com.centit.dde.services.DBPacketBizSupplier;
import com.centit.fileserver.common.FileStore;
import com.centit.framework.ip.service.IntegrationEnvironment;
import com.centit.product.dataopt.core.BizModel;
import com.centit.product.dataopt.core.DataSet;
import com.centit.product.dataopt.dataset.SQLDataSetWriter;
import com.centit.product.metadata.service.MetaDataService;
import com.centit.support.common.ObjectException;
import com.centit.support.json.JSONOpt;
import java.io.Serializable;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskRun {
    @Autowired
    private TaskLogDao taskLogDao;
    @Autowired
    private TaskDetailLogDao taskDetailLogDao;
    @Autowired
    private DataPacketDao dataPacketDao;
    @Autowired
    private MetaDataService metaDataService;
    @Autowired
    private IntegrationEnvironment integrationEnvironment;
    @Autowired
    private DatabaseBizOperation databaseBizOperation;
    @Autowired(required=false)
    private FileStore fileStore;
    private BizModel bizModel;
    private TaskLog taskLog;
    private Date beginTime;
    private DataPacket dataPacket;

    public BizModel runStep(JSONObject bizOptJson) {
        if (bizOptJson.isEmpty()) {
            return null;
        }
        JSONArray jsonArray = bizOptJson.getJSONArray("steps");
        try {
            for (Object jj : jsonArray) {
                this.databaseBizOperation.runOneStep(this.bizModel, JSONOpt.objectToJSONObject(jj));
                this.saveDetail(JSONOpt.objectToJSONObject(jj));
            }
        }
        catch (ObjectException e) {
            this.saveDetail(JSONOpt.objectToJSONObject((Object)e.getObjectData()), e.getMessage());
        }
        catch (Exception e) {
            this.saveDetail(JSONOpt.objectToJSONObject((Object)jsonArray.get(0)), e.getMessage());
        }
        return this.bizModel;
    }

    private void setBizModel(String packetId) {
        this.dataPacket = (DataPacket)this.dataPacketDao.getObjectWithReferences((Object)packetId);
        DBPacketBizSupplier dbPacketBizSupplier = new DBPacketBizSupplier(this.dataPacket);
        dbPacketBizSupplier.setIntegrationEnvironment(this.integrationEnvironment);
        dbPacketBizSupplier.setFileStore(this.fileStore);
        dbPacketBizSupplier.setQueryParams(this.dataPacket.getPacketParamsValue());
        this.bizModel = dbPacketBizSupplier.get();
        this.databaseBizOperation.setIntegrationEnvironment(this.integrationEnvironment);
        this.databaseBizOperation.setMetaDataService(this.metaDataService);
    }

    private void saveDetail(JSONObject runJSON) {
        TaskDetailLog detailLog = new TaskDetailLog();
        detailLog.setRunBeginTime(this.beginTime);
        detailLog.setTaskId(this.taskLog.getTaskId());
        detailLog.setLogId(this.taskLog.getLogId());
        detailLog.setLogType(runJSON.getString("operation") + ":" + runJSON.getString("source"));
        DataSet dataSet = this.bizModel.fetchDataSetByName(runJSON.getString("source"));
        detailLog.setLogInfo((String)dataSet.getFirstRow().get(SQLDataSetWriter.WRITER_ERROR_TAG));
        if ("ok".equals(detailLog.getLogInfo())) {
            detailLog.setSuccessPieces(Long.valueOf(dataSet.getData().size()));
        } else {
            detailLog.setErrorPieces(Long.valueOf(dataSet.getData().size()));
        }
        detailLog.setRunEndTime(new Date());
        this.taskDetailLogDao.saveNewObject((Serializable)detailLog);
    }

    private void saveDetail(JSONObject runJSON, String error) {
        TaskDetailLog detailLog = new TaskDetailLog();
        detailLog.setRunBeginTime(this.beginTime);
        detailLog.setTaskId(this.taskLog.getTaskId());
        detailLog.setLogId(this.taskLog.getLogId());
        detailLog.setLogType(runJSON.getString("operation") + ":" + runJSON.getString("source"));
        DataSet dataSet = this.bizModel.fetchDataSetByName(runJSON.getString("source"));
        detailLog.setLogInfo(error);
        if ("ok".equals(detailLog.getLogInfo())) {
            detailLog.setSuccessPieces(Long.valueOf(dataSet.getData().size()));
        } else {
            detailLog.setErrorPieces(Long.valueOf(dataSet.getData().size()));
        }
        detailLog.setRunEndTime(new Date());
        this.taskDetailLogDao.saveNewObject((Serializable)detailLog);
    }

    public BizModel runTask(String logId) {
        this.beginTime = new Date();
        this.taskLog = (TaskLog)this.taskLogDao.getObjectById((Object)logId);
        DataPacket dataPacket = (DataPacket)this.dataPacketDao.getObjectById((Object)this.taskLog.getTaskId());
        this.setBizModel(dataPacket.getPacketId());
        this.runStep(dataPacket.getDataOptDescJson());
        this.taskLog.setRunEndTime(new Date());
        this.taskLogDao.updateObject((Serializable)this.taskLog);
        return this.bizModel;
    }
}

