/*
 * Decompiled with CFR 0.152.
 */
package com.centit.pagedesign.controller;

import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.pagedesign.po.PageModel;
import com.centit.pagedesign.service.PageModeService;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"page"})
@Api(value="\u81ea\u5b9a\u4e49\u9875\u9762", tags={"\u81ea\u5b9a\u4e49\u9875\u9762"})
public class PageModeController
extends BaseController {
    @Autowired
    private PageModeService pageService;

    @ApiOperation(value="\u65b0\u589e\u9875\u9762")
    @PostMapping
    @WrapUpResponseBody
    public PageModel createPage(PageModel pageModel, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            userCode = "";
        }
        pageModel.setRecorder(userCode);
        pageModel.setPageDesignJson(StringEscapeUtils.unescapeHtml4((String)pageModel.getPageDesignJson()));
        this.pageService.createPageMode(pageModel);
        return pageModel;
    }

    @ApiOperation(value="\u4fee\u6539\u9875\u9762")
    @ApiImplicitParam(name="pageCode", value="\u9875\u9762\u4ee3\u7801")
    @PutMapping(value={"/{pageCode}"})
    @WrapUpResponseBody
    public void updatePage(@PathVariable String pageCode, @RequestBody PageModel pageModel) {
        pageModel.setPageCode(pageCode);
        pageModel.setPageDesignJson(StringEscapeUtils.unescapeHtml4((String)pageModel.getPageDesignJson()));
        this.pageService.updatePageMode(pageModel);
    }

    @ApiOperation(value="\u5220\u9664\u9875\u9762")
    @ApiImplicitParam(name="pageCode", value="\u9875\u9762\u4ee3\u7801")
    @DeleteMapping(value={"/{pageCode}"})
    @WrapUpResponseBody
    public void deletePage(@PathVariable String pageCode) {
        this.pageService.deletePageMode(pageCode);
    }

    @ApiOperation(value="\u67e5\u8be2\u9875\u9762")
    @GetMapping
    @WrapUpResponseBody
    public PageQueryResult<PageModel> listPage(HttpServletRequest request, PageDesc pageDesc) {
        Map searchColumn = PageModeController.collectRequestParameters((HttpServletRequest)request);
        List<PageModel> list = this.pageService.listPageMode(searchColumn, pageDesc);
        return PageQueryResult.createResult(list, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u9875\u9762")
    @GetMapping(value={"/{pageCode}"})
    @WrapUpResponseBody
    public PageModel getPage(@PathVariable String pageCode) {
        PageModel page = this.pageService.getPageMode(pageCode);
        return page;
    }
}

