/*
 * Decompiled with CFR 0.152.
 */
package com.centit.stat.controller;

import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.stat.po.ChartModel;
import com.centit.stat.service.ChartService;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"chart"})
@Api(value="\u7edf\u8ba1\u56fe\u8868", tags={"\u7edf\u8ba1\u56fe\u8868"})
public class ChartController
extends BaseController {
    @Autowired
    private ChartService chartService;

    @ApiOperation(value="\u65b0\u589e\u56fe\u8868\u6a21\u5757")
    @PostMapping
    @WrapUpResponseBody
    public ChartModel createChart(ChartModel chartModel, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            userCode = "";
        }
        chartModel.setRecorder(userCode);
        chartModel.setChartDesignJson(StringEscapeUtils.unescapeHtml4((String)chartModel.getChartDesignJson()));
        this.chartService.createChartModel(chartModel);
        return chartModel;
    }

    @ApiOperation(value="\u4fee\u6539\u56fe\u8868\u6a21\u5757")
    @ApiImplicitParam(name="chartId", value="\u56fe\u8868ID")
    @PutMapping(value={"/{chartId}"})
    @WrapUpResponseBody
    public void updateChart(@PathVariable String chartId, @RequestBody ChartModel chartModel) {
        chartModel.setChartId(chartId);
        chartModel.setChartDesignJson(StringEscapeUtils.unescapeHtml4((String)chartModel.getChartDesignJson()));
        this.chartService.updateChart(chartModel);
    }

    @ApiOperation(value="\u5220\u9664\u56fe\u8868\u6a21\u5757")
    @ApiImplicitParam(name="chartId", value="\u56fe\u8868ID")
    @DeleteMapping(value={"/{chartId}"})
    @WrapUpResponseBody
    public void deleteChart(@PathVariable String chartId) {
        this.chartService.deleteChart(chartId);
    }

    @ApiOperation(value="\u67e5\u8be2\u56fe\u8868\u6a21\u5757")
    @GetMapping
    @WrapUpResponseBody
    public PageQueryResult<ChartModel> listChart(HttpServletRequest request, PageDesc pageDesc) {
        Map searchColumn = ChartController.collectRequestParameters((HttpServletRequest)request);
        List<ChartModel> list = this.chartService.listChart(searchColumn, pageDesc);
        return PageQueryResult.createResult(list, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u56fe\u8868\u6a21\u5757")
    @GetMapping(value={"/{chartId}"})
    @WrapUpResponseBody
    public ChartModel getChart(@PathVariable String chartId) {
        ChartModel chart = this.chartService.getChart(chartId);
        return chart;
    }
}

