/*
 * Decompiled with CFR 0.152.
 */
package com.centit.stat.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.application.po.ApplicationInfo;
import com.centit.dde.po.DataPacket;
import com.centit.dde.po.DataPacketParam;
import com.centit.dde.po.DataSetColumnDesc;
import com.centit.dde.po.DataSetDefine;
import com.centit.framework.ip.po.DatabaseInfo;
import com.centit.framework.ip.service.IntegrationEnvironment;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.system.po.DataCatalog;
import com.centit.framework.system.po.DataDictionary;
import com.centit.metaform.po.MetaFormModel;
import com.centit.pagedesign.po.PageModel;
import com.centit.product.dataopt.core.DataSet;
import com.centit.product.dataopt.core.SimpleDataSet;
import com.centit.product.dataopt.dataset.CsvDataSet;
import com.centit.product.dbdesign.po.PendingMetaColumn;
import com.centit.product.dbdesign.po.PendingMetaTable;
import com.centit.product.dbdesign.service.MetaTableManager;
import com.centit.product.metadata.po.MetaColumn;
import com.centit.product.metadata.po.MetaRelDetail;
import com.centit.product.metadata.po.MetaRelation;
import com.centit.product.metadata.po.MetaTable;
import com.centit.stat.dao.ReportModelDao;
import com.centit.stat.po.ChartModel;
import com.centit.stat.po.ReportModel;
import com.centit.stat.service.ReportService;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.algorithm.ZipCompressor;
import com.centit.support.common.JavaBeanMetaData;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.file.FileSystemOpt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReportServiceImpl
implements ReportService {
    private Logger logger = LoggerFactory.getLogger((String)"\u62a5\u8868\u6587\u4e66");
    @Autowired
    private ReportModelDao reportDao;
    @Autowired
    private MetaTableManager metaTableManager;
    @Autowired
    private IntegrationEnvironment integrationEnvironment;
    @Value(value="${app.home:./}")
    private String appHome;

    @Override
    public void createReportModel(ReportModel model) {
        this.reportDao.saveNewObject(model);
    }

    @Override
    public ReportModel getReportModel(String reportId) {
        return (ReportModel)this.reportDao.getObjectById(reportId);
    }

    @Override
    public List<ReportModel> listReportModel(Map<String, Object> param, PageDesc pageDesc) {
        return this.reportDao.listObjectsByProperties(param, pageDesc);
    }

    @Override
    public void deleteReportModel(String reportId) {
        this.reportDao.deleteObjectById(reportId);
    }

    @Override
    public void updateReportModel(ReportModel reportModel) {
        this.reportDao.updateObject(reportModel);
    }

    @Override
    public InputStream downModel(String applicationId) throws FileNotFoundException {
        String filePath = this.appHome + File.separator + DatetimeOpt.convertDateToString((Date)DatetimeOpt.currentUtilDate(), (String)"YYYYMMddHHmmss");
        HashMap<String, Object> mapApplicaton = new HashMap<String, Object>();
        mapApplicaton.put("applicationId", applicationId);
        String sql = "select * from m_application_info where APPLICATION_ID=:applicationId";
        this.createFile(mapApplicaton, sql, "m_application_info", filePath);
        JSONArray jsonArrayDatabase = this.createFile(mapApplicaton, sql, "f_database_info", filePath);
        String[] databaseCodes = new String[jsonArrayDatabase.size()];
        for (int i = 0; i < jsonArrayDatabase.size(); ++i) {
            JSONObject jsonObject = jsonArrayDatabase.getJSONObject(i);
            databaseCodes[i] = (String)jsonObject.get((Object)"databaseCode");
        }
        if (databaseCodes.length > 0) {
            HashMap<String, Object> mapDatabase = new HashMap<String, Object>();
            mapDatabase.put("databaseCode", databaseCodes);
            sql = "select * from f_md_table where database_code in (:databaseCode)";
            this.createFile(mapDatabase, sql, "f_md_table", filePath);
            sql = "select * from f_md_column where table_id in (select table_id from f_md_table where database_code in (:databaseCode))";
            this.createFile(mapDatabase, sql, "f_md_column", filePath);
            sql = "select * from f_md_relation where parent_table_id in (select table_id from f_md_table where database_code in (:databaseCode))";
            this.createFile(mapDatabase, sql, "f_md_relation", filePath);
            sql = "select * from f_md_rel_detail where relation_id in (select relation_id from f_md_relation where parent_table_id in (select table_id from f_md_table where database_code in (:databaseCode)))";
            this.createFile(mapDatabase, sql, "f_md_rel_detail", filePath);
        }
        sql = "select * from m_meta_form_model where APPLICATION_ID=:applicationId";
        this.createFile(mapApplicaton, sql, "m_meta_form_model", filePath);
        sql = "select * from f_datacatalog where opt_ID=:applicationId";
        this.createFile(mapApplicaton, sql, "f_datacatalog", filePath);
        sql = "select * from f_datadictionary where catalog_code in (select catalog_code from f_datacatalog where opt_ID=:applicationId)";
        this.createFile(mapApplicaton, sql, "f_datadictionary", filePath);
        sql = "select * from q_chart_model where APPLICATION_ID=:applicationId";
        this.createFile(mapApplicaton, sql, "q_chart_model", filePath);
        sql = "select * from q_data_packet where APPLICATION_ID=:applicationId";
        this.createFile(mapApplicaton, sql, "q_data_packet", filePath);
        sql = "select * from q_data_packet_param where packet_id in (select packet_id from q_data_packet where APPLICATION_ID=:applicationId)";
        this.createFile(mapApplicaton, sql, "q_data_packet_param", filePath);
        sql = "select * from q_dataset_define where packet_id in (select packet_id from q_data_packet where APPLICATION_ID=:applicationId)";
        this.createFile(mapApplicaton, sql, "q_dataset_define", filePath);
        sql = "select * from q_dataset_columndesc where packet_id in (select packet_id from q_data_packet where APPLICATION_ID=:applicationId)";
        this.createFile(mapApplicaton, sql, "q_dataset_columndesc", filePath);
        sql = "select * from m_page_model where APPLICATION_ID=:applicationId";
        this.createFile(mapApplicaton, sql, "m_page_model", filePath);
        ZipCompressor.compress((String)(filePath + ".zip"), (String)filePath);
        FileSystemOpt.deleteDirect((String)filePath);
        FileInputStream in = new FileInputStream(filePath + ".zip");
        FileSystemOpt.deleteFile((String)(filePath + ".zip"));
        return in;
    }

    private List<Object> convertMap(Class type, List<Map<String, Object>> list) throws Exception {
        JavaBeanMetaData javaBeanMetaData = JavaBeanMetaData.createBeanMetaDataFromType((Class)type);
        ArrayList<Object> object = new ArrayList<Object>();
        for (Map<String, Object> map : list) {
            object.add(javaBeanMetaData.createBeanObjectFromMap(map));
        }
        return object;
    }

    private int createApp(JSONObject jsonObject) throws Exception {
        int result = 0;
        ArrayList<Object> object = new ArrayList<Object>();
        ArrayList<Object> metaObject = new ArrayList<Object>();
        ArrayList listDatabaseName = new ArrayList();
        for (String fileName : jsonObject.keySet()) {
            List list = (List)jsonObject.get((Object)fileName);
            switch (fileName) {
                case "m_application_info": {
                    object.addAll(this.convertMap(ApplicationInfo.class, list));
                    break;
                }
                case "f_database_info": {
                    object.addAll(this.convertMap(DatabaseInfo.class, list));
                    list.stream().map(s -> (String)s.get("databaseCode")).forEach(listDatabaseName::add);
                    break;
                }
                case "f_md_table": {
                    metaObject.addAll(this.convertMap(MetaTable.class, list));
                    list.forEach(map -> map.put("tableState", "W"));
                    object.addAll(this.convertMap(PendingMetaTable.class, list));
                    break;
                }
                case "f_md_column": {
                    metaObject.addAll(this.convertMap(MetaColumn.class, list));
                    list.forEach(map -> map.put("maxLength", map.get("columnLength")));
                    object.addAll(this.convertMap(PendingMetaColumn.class, list));
                    break;
                }
                case "f_md_relation": {
                    object.addAll(this.convertMap(MetaRelation.class, list));
                    break;
                }
                case "f_md_rel_detail": {
                    object.addAll(this.convertMap(MetaRelDetail.class, list));
                    break;
                }
                case "m_meta_form_model": {
                    object.addAll(this.convertMap(MetaFormModel.class, list));
                    break;
                }
                case "f_datacatalog": {
                    object.addAll(this.convertMap(DataCatalog.class, list));
                    break;
                }
                case "f_datadictionary": {
                    object.addAll(this.convertMap(DataDictionary.class, list));
                    break;
                }
                case "q_chart_model": {
                    object.addAll(this.convertMap(ChartModel.class, list));
                    break;
                }
                case "q_data_packet": {
                    object.addAll(this.convertMap(DataPacket.class, list));
                    break;
                }
                case "q_data_packet_param": {
                    object.addAll(this.convertMap(DataPacketParam.class, list));
                    break;
                }
                case "q_dataset_define": {
                    object.addAll(this.convertMap(DataSetDefine.class, list));
                    break;
                }
                case "q_dataset_columndesc": {
                    object.addAll(this.convertMap(DataSetColumnDesc.class, list));
                    break;
                }
                case "m_page_model": {
                    object.addAll(this.convertMap(PageModel.class, list));
                    break;
                }
            }
        }
        try {
            if (object.size() > 0) {
                result += DatabaseOptUtils.batchMergeObjects((BaseDaoImpl)this.reportDao, object);
                for (String s2 : listDatabaseName) {
                    Pair pair = this.metaTableManager.publishDatabase(s2, "admin");
                    if (!GeneralAlgorithm.equals((Object)pair.getLeft(), (Object)-1)) continue;
                    throw new Exception((String)pair.getRight());
                }
            }
            if (metaObject.size() > 0) {
                result += DatabaseOptUtils.batchMergeObjects((BaseDaoImpl)this.reportDao, metaObject);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return result;
    }

    private JSONObject updatePrimary(JSONObject jsonObject) {
        List list = (List)jsonObject.get((Object)"m_application_info");
        String applicationId = UuidOpt.getUuidAsString22();
        if (list != null) {
            list.forEach(map -> map.put("applicationId", applicationId));
        }
        HashMap databaseMap = new HashMap();
        list = (List)jsonObject.get((Object)"f_database_info");
        if (list != null) {
            list.forEach(map -> {
                String uuid = UuidOpt.getUuidAsString22();
                databaseMap.put((String)map.get("databaseCode"), uuid);
                map.put("databaseCode", uuid);
                map.put("osId", applicationId);
            });
        }
        HashMap dictionaryMap = new HashMap();
        list = (List)jsonObject.get((Object)"f_datacatalog");
        if (list != null) {
            list.forEach(map -> {
                String uuid = UuidOpt.getUuidAsString22();
                dictionaryMap.put((String)map.get("catalogCode"), uuid);
                map.put("catalogCode", uuid);
                map.put("optId", applicationId);
            });
        }
        if ((list = (List)jsonObject.get((Object)"f_datadictionary")) != null) {
            list.forEach(map -> dictionaryMap.keySet().stream().filter(key -> key.equals(map.get("catalogCode"))).findFirst().ifPresent(key -> map.put("catalogCode", dictionaryMap.get(key))));
        }
        HashMap mdtableMap = new HashMap();
        list = (List)jsonObject.get((Object)"f_md_table");
        if (list != null) {
            list.forEach(map -> {
                String uuid = UuidOpt.getUuidAsString32();
                mdtableMap.put((String)map.get("tableId"), uuid);
                map.put("tableId", uuid);
                databaseMap.keySet().stream().filter(key -> key.equals(map.get("databaseCode"))).findFirst().ifPresent(key -> map.put("databaseCode", databaseMap.get(key)));
            });
        }
        if ((list = (List)jsonObject.get((Object)"f_md_column")) != null) {
            list.forEach(map -> {
                mdtableMap.keySet().stream().filter(key -> key.equals(map.get("tableId"))).findFirst().ifPresent(key -> map.put("tableId", mdtableMap.get(key)));
                dictionaryMap.keySet().stream().filter(key -> key.equals(map.get("referenceData"))).findFirst().ifPresent(key -> map.put("referenceData", dictionaryMap.get(key)));
            });
        }
        HashMap relationMap = new HashMap();
        list = (List)jsonObject.get((Object)"f_md_relation");
        if (list != null) {
            list.forEach(map -> {
                String uuid = UuidOpt.getUuidAsString22();
                relationMap.put((String)map.get("relationId"), uuid);
                map.put("relationId", uuid);
                mdtableMap.keySet().stream().filter(key -> key.equals(map.get("parentTableId"))).findFirst().ifPresent(key -> map.put("parentTableId", mdtableMap.get(key)));
                mdtableMap.keySet().stream().filter(key -> key.equals(map.get("childTableId"))).findFirst().ifPresent(key -> map.put("childTableId", mdtableMap.get(key)));
            });
        }
        if ((list = (List)jsonObject.get((Object)"f_md_rel_detail")) != null) {
            list.forEach(map -> relationMap.keySet().stream().filter(key -> key.equals(map.get("relationId"))).findFirst().ifPresent(key -> map.put("relationId", relationMap.get(key))));
        }
        HashMap datapacketMap = new HashMap();
        list = (List)jsonObject.get((Object)"q_data_packet");
        if (list != null) {
            list.forEach(map -> {
                String uuid = UuidOpt.getUuidAsString22();
                datapacketMap.put((String)map.get("packetId"), uuid);
                map.put("packetId", uuid);
                map.put("applicationId", applicationId);
            });
        }
        if ((list = (List)jsonObject.get((Object)"q_data_packet_param")) != null) {
            list.forEach(map -> datapacketMap.keySet().stream().filter(key -> key.equals(map.get("packetId"))).findFirst().ifPresent(key -> map.put("packetId", datapacketMap.get(key))));
        }
        HashMap datasetdefineMap = new HashMap();
        list = (List)jsonObject.get((Object)"q_dataset_define");
        if (list != null) {
            list.forEach(map -> {
                String uuid = UuidOpt.getUuidAsString22();
                datasetdefineMap.put((String)map.get("queryId"), uuid);
                map.put("queryId", uuid);
                databaseMap.keySet().stream().filter(key -> key.equals(map.get("databaseCode"))).findFirst().ifPresent(key -> map.put("databaseCode", databaseMap.get(key)));
                datapacketMap.keySet().stream().filter(key -> key.equals(map.get("packetId"))).findFirst().ifPresent(key -> map.put("packetId", datapacketMap.get(key)));
            });
        }
        if ((list = (List)jsonObject.get((Object)"q_dataset_columndesc")) != null) {
            list.forEach(map -> {
                datapacketMap.keySet().stream().filter(key -> key.equals(map.get("packetId"))).findFirst().ifPresent(key -> map.put("packetId", datapacketMap.get(key)));
                datasetdefineMap.keySet().stream().filter(key -> key.equals(map.get("queryId"))).findFirst().ifPresent(key -> map.put("queryId", datasetdefineMap.get(key)));
            });
        }
        if ((list = (List)jsonObject.get((Object)"q_data_packet")) != null) {
            list.forEach(map -> {
                String form = (String)map.get("dataOptDescJson");
                for (String key : datasetdefineMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)datasetdefineMap.get(key)));
                }
                map.put("dataOptDescJson", form);
            });
        }
        HashMap chartMap = new HashMap();
        list = (List)jsonObject.get((Object)"q_chart_model");
        if (list != null) {
            list.forEach(map -> {
                String uuid = UuidOpt.getUuidAsString22();
                chartMap.put((String)map.get("chartId"), uuid);
                map.put("chartId", uuid);
                datapacketMap.keySet().stream().filter(key -> key.equals(map.get("packetId"))).findFirst().ifPresent(key -> map.put("packetId", datapacketMap.get(key)));
                datasetdefineMap.keySet().stream().filter(key -> key.equals(map.get("queryId"))).findFirst().ifPresent(key -> map.put("queryId", datasetdefineMap.get(key)));
            });
        }
        list = (List)jsonObject.get((Object)"m_meta_form_model");
        HashMap metaformMap = new HashMap();
        if (list != null) {
            list.forEach(map -> {
                String uuid = UuidOpt.getUuidAsString36();
                metaformMap.put((String)map.get("modelId"), uuid);
                map.put("modelId", uuid);
                map.put("applicationId", applicationId);
                mdtableMap.keySet().stream().filter(key -> key.equals(map.get("tableId"))).findFirst().ifPresent(key -> map.put("tableId", mdtableMap.get(key)));
                databaseMap.keySet().stream().filter(key -> key.equals(map.get("databaseCode"))).findFirst().ifPresent(key -> map.put("databaseCode", databaseMap.get(key)));
            });
            list.forEach(map -> {
                String form = (String)map.get("formTemplate");
                for (String key : metaformMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)metaformMap.get(key)));
                }
                for (String key : mdtableMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)mdtableMap.get(key)));
                }
                for (String key : databaseMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)databaseMap.get(key)));
                }
                for (String key : datapacketMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)datapacketMap.get(key)));
                }
                for (String key : datasetdefineMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)datasetdefineMap.get(key)));
                }
                for (String key : dictionaryMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)dictionaryMap.get(key)));
                }
                map.put("formTemplate", form);
            });
        }
        HashMap pageMap = new HashMap();
        list = (List)jsonObject.get((Object)"m_page_model");
        if (list != null) {
            list.forEach(map -> {
                String uuid = UuidOpt.getUuidAsString22();
                pageMap.put((String)map.get("pageCode"), uuid);
                map.put("pageCode", uuid);
                map.put("applicationId", applicationId);
            });
            list.forEach(map -> {
                String form = (String)map.get("pageDesignJson");
                for (String key : metaformMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)metaformMap.get(key)));
                }
                for (String key : pageMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)pageMap.get(key)));
                }
                for (String key : chartMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)chartMap.get(key)));
                }
                map.put("pageDesignJson", form);
            });
        }
        return jsonObject;
    }

    @Override
    @Transactional
    public JSONObject uploadModel(String zipFile) throws Exception {
        JSONObject jsonObject = new JSONObject();
        String filePath = this.appHome + File.separator + "u" + DatetimeOpt.convertDateToString((Date)DatetimeOpt.currentUtilDate(), (String)"YYYYMMddHHmmss");
        ZipCompressor.release((String)zipFile, (String)filePath);
        List files = FileSystemOpt.findFiles((String)filePath, (String)"*.csv");
        CsvDataSet csvDataSet = new CsvDataSet();
        for (File file : files) {
            String fileName = FileSystemOpt.extractFileName((String)file.getPath());
            csvDataSet.setFilePath(file.getPath());
            jsonObject.put(fileName, (Object)csvDataSet.load(null).getData());
        }
        FileSystemOpt.deleteDirect((String)filePath);
        try {
            int success = this.createApp(this.updatePrimary(jsonObject));
            jsonObject.put("success", (Object)success);
        }
        catch (Exception e) {
            throw new ObjectException(e.getMessage());
        }
        return jsonObject;
    }

    private JSONArray createFile(Map<String, Object> map, String sql, String fileName, String filePath) {
        JSONArray jsonArray = new JSONArray();
        if ("f_database_info".equals(fileName)) {
            for (DatabaseInfo db : this.integrationEnvironment.listDatabaseInfo()) {
                if (!StringUtils.isNotBlank((CharSequence)db.getOsId()) || !db.getOsId().equals(map.get("applicationId"))) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("databaseCode", (Object)db.getDatabaseCode());
                jsonObject.put("osId", (Object)db.getOsId());
                jsonObject.put("databaseName", (Object)db.getDatabaseName());
                jsonObject.put("databaseUrl", (Object)db.getDatabaseUrl());
                jsonObject.put("username", (Object)db.getUsername());
                jsonObject.put("password", (Object)"");
                jsonArray.add((Object)jsonObject);
            }
        } else {
            jsonArray = DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this.reportDao, (String)sql, map);
        }
        SimpleDataSet simpleDataSet = SimpleDataSet.fromJsonArray((JSONArray)jsonArray);
        CsvDataSet csvDataSet = new CsvDataSet();
        File file = new File(filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        csvDataSet.setFilePath(filePath + File.separator + fileName + ".csv");
        csvDataSet.save((DataSet)simpleDataSet);
        return jsonArray;
    }
}

