/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.dao;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import com.centit.workflow.po.FlowInfo;
import com.centit.workflow.po.FlowInfoId;
import com.centit.workflow.po.LastVersionFlowDefine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class FlowInfoDao
extends BaseDaoImpl<FlowInfo, FlowInfoId> {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("flowCode", "flowCode = :flowCode");
        filterField.put("version", "version = :version");
        filterField.put("flowName", "LIKE");
        filterField.put("flowState", "LIKE");
        filterField.put("flowDesc", "LIKE");
        filterField.put("osId", "EQUAL");
        filterField.put("optId", "EQUAL");
        filterField.put("ORDER BY", "version DESC, flowPublishDate DESC, flowCode DESC");
        return filterField;
    }

    @Transactional
    public long getLastVersion(String flowCode) {
        String sql = "select max(t.VERSION) from WF_FLOW_DEFINE t where t.FLOW_CODE = ?";
        return (Long)this.getJdbcTemplate().queryForObject(sql, new Object[]{flowCode}, Long.class);
    }

    @Transactional
    public List<FlowInfo> getAllVersionFlowsByCode(String wfCode, PageDesc pageDesc) {
        return this.listObjectsByFilterAsJson("where FLOW_CODE = ? and FLOW_STATE != 'D' order by version desc", new Object[]{wfCode}, pageDesc).toJavaList(FlowInfo.class, new JSONReader.Feature[0]);
    }

    @Transactional
    public FlowInfo getLastVersionFlowByCode(String flowCode) {
        long lVer = this.getLastVersion(flowCode);
        return (FlowInfo)this.getObjectById(new FlowInfoId(Long.valueOf(lVer), flowCode));
    }

    @Transactional
    public FlowInfo getFlowDefineByID(String flowCode, Long version) {
        return (FlowInfo)super.getObjectWithReferences((Object)new FlowInfoId(version, flowCode));
    }

    @Transactional
    public List<FlowInfo> getFlowsByState(String wfstate) {
        String sql = "SELECT * FROM F_V_LASTVERSIONFLOW WHERE FLOW_STATE = ? ORDER BY VERSION";
        return this.getJdbcTemplate().query(sql, new Object[]{wfstate}, (RowMapper)new BeanPropertyRowMapper(FlowInfo.class));
    }

    @Transactional
    public List<FlowInfo> getFlowsByOsId(String osId, String wfstate) {
        String sql = "SELECT * FROM F_V_LASTVERSIONFLOW WHERE OS_ID = ? AND FLOW_STATE = ? ORDER BY VERSION";
        return this.getJdbcTemplate().query(sql, new Object[]{osId, wfstate}, (RowMapper)new BeanPropertyRowMapper(FlowInfo.class));
    }

    @Transactional
    public Map<String, String> listFlowCodeNameMap() {
        String sql = "SELECT FLOW_CODE, FLOW_NAME FROM F_V_LASTVERSIONFLOW";
        List codeNameData = DatabaseOptUtils.listObjectsBySql((BaseDaoImpl)this, (String)sql);
        HashMap<String, String> codeNameMap = new HashMap<String, String>();
        if (codeNameData != null) {
            for (Object[] codeName : codeNameData) {
                codeNameMap.put(StringBaseOpt.castObjectToString((Object)codeName[0]), StringBaseOpt.castObjectToString((Object)codeName[1]));
            }
        }
        return codeNameMap;
    }

    @Transactional
    public List<FlowInfo> listLastVersionFlowByOptId(String optId) {
        String sql = "SELECT * FROM F_V_LASTVERSIONFLOW WHERE opt_id = ? AND flow_state != 'D'";
        return this.listObjectsBySql(sql, new Object[]{optId});
    }

    @Transactional
    public List<FlowInfo> listLastVersionFlows(Map<String, Object> filterMap, PageDesc pageDesc) {
        String sql = "select VERSION,FLOW_CODE,FLOW_NAME,FLOW_CLASS,FLOW_STATE,FLOW_DESC,FLOW_XML_DESC,FLOW_PUBLISH_DATE,OPT_ID,TIME_LIMIT  from F_V_LASTVERSIONFLOW  where 1=1  [:flowState| and FLOW_STATE = :flowState ]  [:(like)flowName| and FLOW_NAME like :flowName ]  [:flowCode| and FLOW_CODE = :flowCode ] [:osId| and OS_ID = :osId ] [:optId| and OPT_ID = :optId ] order by OPT_ID";
        QueryAndNamedParams queryAndNamedParams = QueryUtils.translateQuery((String)sql, filterMap);
        JSONArray dataList = DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this, (String)queryAndNamedParams.getQuery(), (Map)queryAndNamedParams.getParams(), (PageDesc)pageDesc);
        List ls = new ArrayList();
        if (dataList != null) {
            ls = JSONArray.parseArray((String)dataList.toJSONString(new JSONWriter.Feature[0]), LastVersionFlowDefine.class);
        }
        ArrayList<FlowInfo> all = new ArrayList<FlowInfo>();
        if (ls != null && ls.size() > 0) {
            for (LastVersionFlowDefine s : ls) {
                all.add(s.toWfFlowDefine());
            }
        }
        return all;
    }

    @Transactional
    public void deleteObjectByFlowCode(String flowCode) {
        String sql = "delete from wf_flow_define where flow_code=?";
        this.getJdbcTemplate().update(sql, new Object[]{flowCode});
    }
}

